/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.IDataInterchange;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.IChangeDataRegistry;
import quadbase.datasourcemanager.manager.ICheckPrivilege;
import quadbase.datasourcemanager.manager.IImportQRYFile;
import quadbase.datasourcemanager.manager.ManagerPane;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.SOAPDataSourceNode;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceDataSourceNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.StartupDialog;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTree;

public class Manager
extends JDialog {
    public static String WAIT_TITLE = LanguageEncoder.getText("Please wait...");
    String title = LanguageEncoder.getText("Data Source Manager");
    public ManagerPane managerPane;
    public IDataInterchange interchange;
    String eresDir;
    boolean showBackButton = false;
    boolean showCreateReportButton = false;
    boolean showCreateChartButton = false;
    private boolean showStartupBackButton = true;
    String userName;
    String password;
    String url;
    String driver;
    Vector additionalDb;
    String JNDIName;
    boolean useJNDIDataSource;
    boolean cancelWhenClose = true;
    Hashtable env;
    DefaultMutableTreeNode node;
    private WindowAdapter ManagerWindowAdapter = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            if (Manager.this.cancelWhenClose) {
                Manager.this.interchange.cancel();
            } else {
                Manager.this.setVisible(false);
                Manager.this.dispose();
            }
        }
    };
    boolean showChangeButton = false;
    IChangeDataRegistry changeDataRegistry;
    boolean canModify = true;
    ICheckPrivilege checkPrivilegeObj;
    boolean fromOrganizer = false;
    boolean showDoneButton = false;
    boolean showNextButton = true;
    public static int QUERY = 1;
    public static int DATAVIEW = 2;
    private String[] defaultParamNames = null;
    private boolean defaultValueRequired = false;
    private Vector managerListeners = null;
    private long lastID;
    private long registryID;
    private static IImportQRYFile importQRYFile;

    public Manager(Frame parent, IDataInterchange interchange, boolean showBackButton, boolean showDoneButton, boolean showStartupBackButton, boolean showCreateChartButton, boolean showCreateReportButton, ICheckPrivilege checkPrivilegeObj, boolean canModify, boolean cancelWhenClose, boolean fromOrganizer) {
        super(parent, true);
        this.addWindowListener(this.ManagerWindowAdapter);
        this.interchange = interchange;
        this.showBackButton = showBackButton;
        this.showDoneButton = showDoneButton;
        this.showStartupBackButton = showStartupBackButton;
        this.showCreateChartButton = showCreateChartButton;
        this.showCreateReportButton = showCreateReportButton;
        this.checkPrivilegeObj = checkPrivilegeObj;
        if (showDoneButton) {
            this.showNextButton = false;
        }
        this.canModify = canModify;
        this.cancelWhenClose = cancelWhenClose;
        this.fromOrganizer = fromOrganizer;
    }

    public Manager(JDialog parent, IDataInterchange interchange, boolean showBackButton, boolean showDoneButton, boolean showStartupBackButton, ICheckPrivilege checkPrivilegeObj) {
        this(parent, interchange, showBackButton, showDoneButton, showStartupBackButton, false, false, checkPrivilegeObj, true, true);
    }

    public Manager(JDialog parent, IDataInterchange interchange, boolean showBackButton, boolean showDoneButton, boolean showStartupBackButton, boolean showCreateChartButton, boolean showCreateReportButton, ICheckPrivilege checkPrivilegeObj, boolean canModify, boolean cancelWhenClose) {
        super((Dialog)parent, true);
        this.addWindowListener(this.ManagerWindowAdapter);
        this.interchange = interchange;
        this.showBackButton = showBackButton;
        this.showDoneButton = showDoneButton;
        this.showStartupBackButton = showStartupBackButton;
        this.showCreateChartButton = showCreateChartButton;
        this.showCreateReportButton = showCreateReportButton;
        this.checkPrivilegeObj = checkPrivilegeObj;
        if (showDoneButton) {
            this.showNextButton = false;
        }
        this.canModify = canModify;
        this.cancelWhenClose = cancelWhenClose;
    }

    public Manager(JDialog parent, IDataInterchange interchange, boolean showChangeButton, IChangeDataRegistry changeDataRegistry, boolean canModify) {
        super((Dialog)parent, true);
        this.addWindowListener(this.ManagerWindowAdapter);
        this.interchange = interchange;
        this.showBackButton = false;
        this.showDoneButton = false;
        this.showNextButton = true;
        this.showChangeButton = showChangeButton;
        this.changeDataRegistry = changeDataRegistry;
        this.canModify = canModify;
    }

    public String newDataReg() {
        this.title = LanguageEncoder.getText("New Data Registry");
        this.setTitle(this.title);
        JPanel mPanel = null;
        String selectedFile = null;
        boolean isNewFile = true;
        OpenFileDialog fDialog = new OpenFileDialog(this, this.title, null, new String[]{"XML"}, this.getDataRegistryDirectory(), false, false);
        fDialog.setVisible(true);
        if (fDialog.getSelectedFile() != null) {
            String dataRegDir = this.checkPrivilegeObj.getDataRegistryDir();
            if (!(dataRegDir = dataRegDir.replace('\\', '/')).endsWith("/")) {
                dataRegDir = dataRegDir + File.separator;
            }
            selectedFile = dataRegDir + fDialog.getSelectedFile();
            selectedFile = selectedFile.replace('\\', '/');
            this.setDataRegistryDirectory(fDialog.getCurrentDirectory());
        }
        if (selectedFile != null) {
            String msg = null;
            if (StartupDialog.containInvalidChar(selectedFile)) {
                msg = LanguageEncoder.getText("A filename contains invalid characters");
            } else if (selectedFile.endsWith("/") || selectedFile.endsWith("\\")) {
                msg = LanguageEncoder.getText("Invalid file name!");
            }
            if (msg != null) {
                selectedFile = null;
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return null;
            }
            if (!selectedFile.toUpperCase().endsWith(".XML")) {
                selectedFile = selectedFile + ".xml";
            }
            if (OverWriteDialog.findFile(selectedFile)) {
                if (this.checkPrivilegeObj.canModify(selectedFile)) {
                    if (!OverWriteDialog.continueSave(this, selectedFile)) {
                        return null;
                    }
                } else {
                    String message = LanguageEncoder.getText("File exists. You have no write privilege. Enter another name.");
                    JOptionPane.showMessageDialog(this, message, LanguageEncoder.getText("Warning"), 0);
                    return null;
                }
                new DeleteFile(selectedFile).delete();
            }
        }
        if (selectedFile != null) {
            this.setTitle(this.title + " : " + this.getRelativeFileName(selectedFile));
        }
        if (selectedFile != null) {
            try {
                mPanel = this.getManagerPane(selectedFile, isNewFile, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, LanguageEncoder.getText("Cannot open specified data registry!\n") + ex.toString(), LanguageEncoder.getText("Error"), 0);
                mPanel = null;
            }
        }
        if (mPanel != null) {
            JPanel contentPane = new JPanel();
            contentPane.setName("JFrameContentPane");
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)mPanel, "Center");
            this.setContentPane(contentPane);
            this.setPosition();
        }
        return selectedFile;
    }

    private String getRelativeFileName(String name) {
        int index = name.indexOf("DataRegistry/");
        if (index > -1) {
            return name.substring(index + 13);
        }
        return name;
    }

    public boolean initialize(String dataSource, boolean fromDesigner, Vector invisibleNode) {
        this.setTitle(this.title);
        JPanel mPanel = null;
        boolean isNewFile = false;
        String registryFile = null;
        while (mPanel == null) {
            if (dataSource == null) {
                StartupDialog startupDialog = new StartupDialog(this);
                startupDialog.setVisible(true);
                if (!startupDialog.isModified()) {
                    return false;
                }
                registryFile = startupDialog.getSelectedFile();
                isNewFile = startupDialog.isNewFile();
            } else {
                registryFile = dataSource;
                this.showBackButton = fromDesigner;
            }
            try {
                mPanel = this.getManagerPane(registryFile, isNewFile, invisibleNode);
                dataSource = registryFile;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, LanguageEncoder.getText("Cannot open specified data registry!\n") + QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n"), LanguageEncoder.getText("Error"), 0);
                mPanel = null;
                if (dataSource == null) continue;
                return false;
            }
        }
        if (dataSource != null) {
            this.setTitle(this.title + " : " + dataSource);
        }
        JPanel contentPane = new JPanel();
        contentPane.setName("JFrameContentPane");
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mPanel, "Center");
        this.setContentPane(contentPane);
        this.setPosition();
        return true;
    }

    protected void setPresetDataRegistry(String dataSource) {
        this.interchange.setPresetDataRegistry(dataSource);
    }

    private JPanel getManagerPane(String dataSource, boolean newFile, Vector invisibleNode) throws Exception {
        this.managerPane = new ManagerPane(this, dataSource, newFile, invisibleNode);
        return this.managerPane;
    }

    boolean showBackButton() {
        return this.showBackButton;
    }

    boolean showChangeButton() {
        return this.showChangeButton;
    }

    boolean showStartupBackButton() {
        return this.showStartupBackButton;
    }

    IChangeDataRegistry getChangeDataRegistry() {
        return this.changeDataRegistry;
    }

    public boolean canModify() {
        if (this.managerPane != null) {
            this.managerPane.resetSessionTimeoutInterval();
        }
        return this.canModify;
    }

    public void setCanModify(boolean b) {
        this.canModify = b;
    }

    boolean showCreateReportButton() {
        return this.showCreateReportButton;
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.45);
        dim.width = (int)((double)screenSize.width * 0.35);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    IDataInterchange getInterchangeProcess() {
        return this.interchange;
    }

    boolean updateDataSource() {
        StartupDialog startupDialog = new StartupDialog(this);
        startupDialog.setVisible(true);
        if (!startupDialog.isModified()) {
            return false;
        }
        String dataSource = startupDialog.getSelectedFile();
        boolean success = this.managerPane.updateDataSource(dataSource, startupDialog.isNewFile());
        if (dataSource != null && success) {
            this.setTitle(this.title + " : " + dataSource);
        }
        return dataSource != null && success;
    }

    void setURL(String url) {
        this.url = url;
    }

    void setDriver(String driver) {
        this.driver = driver;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }

    void setPassword(String password) {
        this.password = password;
    }

    void setAdditionalDb(Vector addDb) {
        this.additionalDb = addDb;
    }

    void setJNDIName(String JNDIName) {
        this.JNDIName = JNDIName;
    }

    public void setEresDir(String eresDir) {
        this.eresDir = eresDir;
    }

    void setEnvProperties(Hashtable env) {
        this.env = env;
    }

    void setUseJNDIDataSource(boolean b) {
        this.useJNDIDataSource = b;
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        this.node = node;
    }

    public int getSourceData() {
        if (this.node instanceof QueryNode || this.node instanceof DataViewNode || this.node instanceof DataViewQueryNode) {
            return 1;
        }
        if (this.node instanceof XMLFileNode) {
            return 4;
        }
        if (this.node instanceof XMLQueryNode) {
            return 7;
        }
        if (this.node instanceof EJBNode) {
            return 5;
        }
        if (this.node instanceof ClassFileNode) {
            return 6;
        }
        if (this.node instanceof SOAPViewNode) {
            return 12;
        }
        if (this.node instanceof SalesForceQueryNode) {
            return 11;
        }
        if (this.node instanceof ExcelFileNode) {
            return 13;
        }
        return 2;
    }

    public boolean isXML() {
        return this.node instanceof XMLFileNode;
    }

    public boolean isClass() {
        return this.node instanceof ClassFileNode;
    }

    public String getFileName() {
        if (this.node instanceof TextFileNode) {
            return ((TextFileNode)this.node).getFile();
        }
        if (this.node instanceof XMLFileNode) {
            return ((XMLFileNode)this.node).getFile();
        }
        if (this.node instanceof XMLQueryNode) {
            XMLQueryNode qnode = (XMLQueryNode)this.node;
            if (qnode.getParent() instanceof XMLFileNode) {
                XMLFileNode fnode = (XMLFileNode)qnode.getParent();
                return fnode.getFile();
            }
            return "";
        }
        if (this.node instanceof ClassFileNode) {
            return ((ClassFileNode)this.node).getFile();
        }
        return null;
    }

    public XMLFileQueryInfo getXMLFileQueryInfo() {
        if (this.node instanceof XMLQueryNode) {
            XMLQueryNode qnode = (XMLQueryNode)this.node;
            XMLFileQueryInfo info = null;
            if (qnode.getParent() instanceof XMLFileNode) {
                info = new XMLFileQueryInfo(this.getFileName(), this.getXMLSelectedFields(qnode), this.getXMLConditionStatement(qnode), this.getXMLAllFields(qnode), this.getDTDFileName(qnode), this.isVerify(qnode), qnode.getInSet(), ((XMLFileNode)qnode.getParent()).getDTDTreeFileName());
            }
            return info;
        }
        return null;
    }

    private XMLFieldInfo[] getXMLSelectedFields(XMLQueryNode node) {
        Object[] temp = node.getSelectedFields().toArray();
        XMLFieldInfo[] info = new XMLFieldInfo[temp.length];
        XMLFieldInfo[] fields = this.getXMLAllFields(node);
        for (int i = 0; i < temp.length; ++i) {
            info[i] = (XMLFieldInfo)temp[i];
            boolean found = false;
            for (int j = 0; j < fields.length && !found; ++j) {
                if (!info[i].getDisplayName().equals(fields[j].getDisplayName())) continue;
                if (info[i].getXMLType() == 1) {
                    info[i].setElementDataType(fields[j].getElementDataType());
                    if (fields[j].getElementDataType().equals("date")) {
                        info[i].setDateFormat(fields[j].getDateFormat());
                    }
                } else if (info[i].getXMLType() == 2) {
                    info[i].setAttributeDataType(fields[j].getAttributeDataType());
                    if (fields[j].getAttributeDataType().equals("date")) {
                        info[i].setDateFormat(fields[j].getDateFormat());
                    }
                }
                found = true;
            }
        }
        return info;
    }

    private String getXMLConditionStatement(XMLQueryNode node) {
        return node.getConditionStatement();
    }

    private XMLFieldInfo[] getXMLAllFields(XMLQueryNode node) {
        String dtdTreeFileName = null;
        if (node.getParent() instanceof XMLFileNode) {
            dtdTreeFileName = ((XMLFileNode)node.getParent()).getDTDTreeFileName();
        }
        if (dtdTreeFileName == null) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to open the data type file.\n"));
            return null;
        }
        DefaultMutableTreeNode root = null;
        if (dtdTreeFileName.toLowerCase().endsWith(".ddt")) {
            DTD dtd = DTDUtil.readDTD(dtdTreeFileName);
            DTDElement rootElt = dtd.getRootElement();
            Hashtable<String, DTDElement> elements = dtd.getElements();
            root = DTDUtil.buildTree(rootElt, elements, new DefaultMutableTreeNode(rootElt), true);
        } else {
            try {
                XMLSchemaTree schemaTree = XMLSchemaTree.load(dtdTreeFileName);
                root = (DefaultMutableTreeNode)schemaTree.getModel().getRoot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DTDUtil.getXMLAllFields(root);
    }

    private String getDTDFileName(XMLQueryNode node) {
        return ((XMLFileNode)node.getParent()).getDTD();
    }

    private boolean isVerify(XMLQueryNode node) {
        return ((XMLFileNode)node.getParent()).isVerify();
    }

    public String getLookupName() {
        return this.JNDIName;
    }

    public String getEresDir() {
        return this.eresDir;
    }

    public String getJNDIName() {
        if (this.node instanceof EJBNode) {
            return ((EJBNode)this.node).getJNDIName();
        }
        return null;
    }

    public String getHomeName() {
        if (this.node instanceof EJBNode) {
            return ((EJBNode)this.node).getHomeName();
        }
        return null;
    }

    public String getRemoteName() {
        if (this.node instanceof EJBNode) {
            return ((EJBNode)this.node).getRemoteName();
        }
        return null;
    }

    public String getMethodName() {
        if (this.node instanceof EJBNode) {
            return ((EJBNode)this.node).getSelectedMethod();
        }
        return null;
    }

    public Object[] getParam() {
        String methodName = this.getMethodName();
        if (this.node instanceof EJBNode) {
            return ((EJBNode)this.node).getInputValue(methodName);
        }
        return null;
    }

    public Hashtable getEnvironment() {
        if (this.node instanceof EJBNode) {
            return ((EJBNode)this.node).getEnvironment();
        }
        return null;
    }

    public int getDBSourceType() {
        if (this.node != null && this.node instanceof QueryNode) {
            return QUERY;
        }
        if (this.node != null && (this.node instanceof DataViewNode || this.node instanceof DataViewQueryNode)) {
            return DATAVIEW;
        }
        return -1;
    }

    public byte[][] getFileBytes() {
        if (this.node != null) {
            if (this.node instanceof QueryNode) {
                return ((QueryNode)this.node).getBytes();
            }
            if (this.node instanceof DataViewNode) {
                return ((DataViewNode)this.node).getBytes();
            }
            if (this.node instanceof DataViewQueryNode) {
                return ((DataViewQueryNode)this.node).getBytes();
            }
        }
        return null;
    }

    public String getURL() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Vector getAdditionalDb() {
        return this.additionalDb;
    }

    public String getJNDIDBName() {
        return this.JNDIName;
    }

    public Hashtable getEnvProperties() {
        return this.env;
    }

    public boolean isUseJNDIDataSource() {
        return this.useJNDIDataSource;
    }

    public String getSQL() {
        if (this.node instanceof QueryNode) {
            return ((QueryNode)this.node).getSQL();
        }
        if (this.node instanceof DataViewNode) {
            return ((DataViewNode)this.node).getSQL();
        }
        if (this.node instanceof DataViewQueryNode) {
            return ((DataViewQueryNode)this.node).getSQL();
        }
        return null;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return this.node;
    }

    public QueryInParamSet getInSet() {
        if (this.node instanceof QueryNode) {
            return ((QueryNode)this.node).getInSet();
        }
        if (this.node instanceof DataViewNode) {
            return ((DataViewNode)this.node).getInSet();
        }
        if (this.node instanceof DataViewQueryNode) {
            return ((DataViewQueryNode)this.node).getInSet();
        }
        if (this.node instanceof SalesForceQueryNode) {
            return ((SalesForceQueryNode)this.node).getInSet();
        }
        return null;
    }

    public static void setImportQRYFile(IImportQRYFile f) {
        importQRYFile = f;
    }

    public static IImportQRYFile getImportQRYFile() {
        return importQRYFile;
    }

    public void setDefaultParamNames(String[] names) {
        this.defaultParamNames = names;
    }

    public String[] getDefaultParamNames() {
        return this.defaultParamNames;
    }

    public void setDefaultValueRequiredForParameters(boolean state) {
        this.defaultValueRequired = state;
    }

    public boolean isDefaultValueRequiredForParameters() {
        return this.defaultValueRequired;
    }

    public void setDataSourceManagerListeners(Vector vect) {
        this.managerListeners = vect;
    }

    Vector getDataSourceManagerListeners() {
        return this.managerListeners;
    }

    public void openDataViewQuery() {
        this.managerPane.openDataViewQuery(this.node);
    }

    public void setLastID(String id) {
        try {
            this.lastID = Long.parseLong(id);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getLastID() {
        return Long.toString(this.lastID);
    }

    public String getNextID() {
        return Long.toString(++this.lastID);
    }

    public String getRegistryID() {
        return Long.toString(this.registryID);
    }

    public String newRegistryID() {
        this.registryID = System.currentTimeMillis();
        return Long.toString(this.registryID);
    }

    public void setRegistryID(String registryID) {
        try {
            this.registryID = Long.parseLong(registryID);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getDataRegistryDirectory() {
        BrowseDirectories bd = this.interchange.getBrowseDirectories();
        if (bd != null) {
            return bd.getDataRegistryDirectory();
        }
        return null;
    }

    public void setDataRegistryDirectory(String dir) {
        BrowseDirectories bd = this.interchange.getBrowseDirectories();
        if (bd != null) {
            bd.setDataRegistryDirectory(dir);
        }
    }

    public String getDataSourceXMLDir() {
        BrowseDirectories bd = this.interchange.getBrowseDirectories();
        if (bd != null) {
            return bd.getDataSourceXMLDir();
        }
        return null;
    }

    public void setDataSourceXMLDir(String dir) {
        BrowseDirectories bd = this.interchange.getBrowseDirectories();
        if (bd != null) {
            bd.setDataSourceXMLDir(dir);
        }
    }

    public String getDataSourceTextDir() {
        BrowseDirectories bd = this.interchange.getBrowseDirectories();
        if (bd != null) {
            return bd.getDataSourceTextDir();
        }
        return null;
    }

    public void setDataSourceTextDir(String dir) {
        BrowseDirectories bd = this.interchange.getBrowseDirectories();
        if (bd != null) {
            bd.setDataSourceTextDir(dir);
        }
    }

    public SalesForceQueryFileInfo getSalesForceQueryInfo() {
        SalesForceQueryNode sfQueryNode = (SalesForceQueryNode)this.node;
        SalesForceDataSourceNode sfDataSourceNode = (SalesForceDataSourceNode)this.node.getParent();
        return new SalesForceQueryFileInfo(sfDataSourceNode.getUserName(), sfDataSourceNode.getPassword(), sfQueryNode.getQuery(), sfQueryNode.getInSet());
    }

    public SOAPQueryFileInfo getSOAPQueryFileInfo() {
        SOAPViewNode soapViewNode = (SOAPViewNode)this.node;
        SOAPDataSourceNode soapDataSourceNode = (SOAPDataSourceNode)this.node.getParent();
        return new SOAPQueryFileInfo(soapDataSourceNode.getWsdlURI(), soapViewNode.getServiceName(), soapViewNode.getPortName(), soapViewNode.getOperationName(), soapViewNode.getXmlFieldInfo(), soapViewNode.getParameters());
    }

    public ExcelFileInfo getExcelFileInfo() {
        if (!(this.node instanceof ExcelFileNode)) {
            return null;
        }
        ExcelFileNode excelNode = (ExcelFileNode)this.node;
        ExcelFileInfo ifo = new ExcelFileInfo(excelNode.getFilename(), excelNode.getSheetName(), excelNode.getMinRow(), excelNode.getMinColumn(), excelNode.getMaxRow(), excelNode.getMaxColumn(), excelNode.isIncludeNewData(), excelNode.isHasHeader(), excelNode.isDataAreRows());
        ifo.setDataTypes(excelNode.getDataTypes());
        return ifo;
    }

    public boolean isFromOrganizer() {
        return this.fromOrganizer;
    }
}

