/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.server.datareg.DataRegClient;
import quadbase.common.server.datareg.DataRegResult;
import quadbase.common.server.datareg.XmlNodePath;
import quadbase.common.swing.listeners.MousePopUpAdapter;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.IDataInterchange;
import quadbase.common.util.internal.IDataInterchangeORG;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.BigDataDialog;
import quadbase.datasourcemanager.manager.BigDataNode;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.CopyNodeDialog;
import quadbase.datasourcemanager.manager.DBDialog;
import quadbase.datasourcemanager.manager.DataSourceManagerListener;
import quadbase.datasourcemanager.manager.DataTreeCellRenderer;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.EJBNodeDialog;
import quadbase.datasourcemanager.manager.ExcelDataSourceDialog;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.FileNodeDialog;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.JNDIDialog;
import quadbase.datasourcemanager.manager.LoginDialog;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.PopupMenuForTree;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.ReadXMLTable;
import quadbase.datasourcemanager.manager.SOAPDataSourceNode;
import quadbase.datasourcemanager.manager.SOAPDialog;
import quadbase.datasourcemanager.manager.SOAPViewDialog;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SQLDialog;
import quadbase.datasourcemanager.manager.SalesForceDataSourceDialog;
import quadbase.datasourcemanager.manager.SalesForceDataSourceNode;
import quadbase.datasourcemanager.manager.SalesForceQueryDialog;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.WriteXMLDataSources;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLNodeDialog;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLQueryBuilderDialog;
import quadbase.querybuilder.designer.ConditionDialog;
import quadbase.querybuilder.designer.DataViewDialog;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.UpdateDataView;
import quadbase.reportorganizer.manager.OrganizerClient;

public class ManagerPane
extends JPanel
implements ActionListener {
    public String dataSourceLoc;
    private boolean readOnly = false;
    JTree tree;
    public Manager manager;
    JButton addBut;
    JButton removeBut;
    JButton editBut;
    JButton copyBut;
    JButton backBut;
    JButton cancelBut;
    JButton nextBut;
    JButton changeBut;
    JButton doneBut;
    JButton updateBut;
    JButton createRPTBut;
    PopupMenuForTree popupMenu;
    JMenuItem updateCharts;
    JMenuItem updateReports;
    JMenuItem updateDataview;
    Vector parents = new Vector();
    Vector removedChildren = new Vector();
    Vector invisibleNode = new Vector();
    private DefaultTreeModel treeModel;
    DefaultMutableTreeNode nodeInEdit;
    boolean editMode;
    private static String lastVisitedPath = null;

    public ManagerPane(Manager manager, String dataSourceLoc, boolean newFile, Vector invisibleNode) throws Exception {
        Vector listeners;
        this.manager = manager;
        this.invisibleNode = invisibleNode;
        DefaultMutableTreeNode root = this.getDataSources(dataSourceLoc, newFile, invisibleNode);
        this.tree = new JTree(root);
        this.tree.setCellRenderer(new DataTreeCellRenderer());
        this.treeModel = (DefaultTreeModel)this.tree.getModel();
        this.tree.setShowsRootHandles(true);
        if (newFile) {
            manager.newRegistryID();
        }
        if ((listeners = manager.getDataSourceManagerListeners()) != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                if (!(listeners.elementAt(i) instanceof DataSourceManagerListener)) continue;
                try {
                    this.tree = ((DataSourceManagerListener)listeners.elementAt(i)).modifyDataSourceTree(this.tree);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.tree.setRootVisible(false);
        this.expandAll(this.tree);
        this.selectLastVisitedPath();
        this.popupMenu = new PopupMenuForTree(this);
        this.tree.addMouseListener(new MousePopUpAdapter(){

            @Override
            public void showPopup(MouseEvent e) {
                if (!ManagerPane.this.tree.isSelectionEmpty()) {
                    ManagerPane.this.popupMenu.addMenu((DefaultMutableTreeNode)ManagerPane.this.tree.getSelectionPath().getLastPathComponent());
                    ManagerPane.this.popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){
            private int leftClickMask = 0;

            @Override
            public void mousePressed(MouseEvent e) {
                int mouseMask = e.getModifiers() & 0xFFFFFFEF;
                if (!ManagerPane.this.tree.isSelectionEmpty() && mouseMask == this.leftClickMask) {
                    int selRow = ManagerPane.this.tree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = ManagerPane.this.tree.getPathForLocation(e.getX(), e.getY());
                    lastVisitedPath = ManagerPane.getPathToString(selPath);
                    if (selRow != -1) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                        if (e.getClickCount() >= 2) {
                            ManagerPane.this.doEdit(node);
                        }
                    }
                    return;
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DefaultMutableTreeNode tn = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tn = (DefaultMutableTreeNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                }
                ManagerPane.this.editBut.setEnabled(ManagerPane.this.isEditEnabled(tn));
                ManagerPane.this.copyBut.setEnabled(ManagerPane.this.isCopyEnabled(tn));
                ManagerPane.this.updateDataview.setEnabled(ManagerPane.this.isUpdateEnabled(tn));
                ManagerPane.this.addBut.setEnabled(ManagerPane.this.isAddEnabled(tn));
                ManagerPane.this.removeBut.setEnabled(ManagerPane.this.isRemoveEnabled(tn));
                ManagerPane.this.nextBut.setEnabled(ManagerPane.this.isNextEnabled(tn));
                ManagerPane.this.createRPTBut.setEnabled(ManagerPane.this.isNextEnabled(tn));
            }
        });
        JMenuBar menubar = new JMenuBar();
        JMenu updateMenu = new JMenu("Update");
        menubar.add(updateMenu);
        this.updateCharts = new JMenuItem("Charts");
        updateMenu.add(this.updateCharts);
        this.updateCharts.setEnabled(!manager.getInterchangeProcess().isReport() || manager.getInterchangeProcess().isDataRegistryManager());
        this.updateCharts.addActionListener(this);
        this.updateReports = new JMenuItem("Reports");
        updateMenu.add(this.updateReports);
        this.updateReports.setEnabled(manager.getInterchangeProcess().isReport() || manager.getInterchangeProcess().isDataRegistryManager());
        this.updateReports.addActionListener(this);
        updateMenu.addSeparator();
        this.updateDataview = new JMenuItem("Data View Queries");
        this.updateDataview.addActionListener(this);
        updateMenu.add(this.updateDataview);
        JScrollPane scrollPane = new JScrollPane();
        this.tree.setBorder(new EmptyBorder(3, 3, 3, 3));
        scrollPane.getViewport().add(this.tree);
        this.setLayout(new BorderLayout());
        this.add("North", menubar);
        this.add("Center", scrollPane);
        this.add("East", this.getButtonPanel());
        this.tree.setSelectionRow(0);
        this.saveDataSource();
        manager.setPresetDataRegistry(dataSourceLoc);
        this.selectLastVisitedPath();
    }

    private void removeInvisibleNode(DefaultMutableTreeNode parent, Vector invisibleNode) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (invisibleNode.contains(child)) {
                this.parents.add(parent);
                this.removedChildren.add(child);
                parent.remove(i);
                --i;
                continue;
            }
            this.removeInvisibleNode(child, invisibleNode);
        }
    }

    private void restoreLostNode() {
        for (int i = 0; i < this.parents.size(); ++i) {
            DefaultMutableTreeNode p = (DefaultMutableTreeNode)this.parents.elementAt(i);
            DefaultMutableTreeNode c = (DefaultMutableTreeNode)this.removedChildren.elementAt(i);
            p.add(c);
        }
    }

    private void removeRestoredNode() {
        for (int i = 0; i < this.parents.size(); ++i) {
            DefaultMutableTreeNode p = (DefaultMutableTreeNode)this.parents.elementAt(i);
            DefaultMutableTreeNode c = (DefaultMutableTreeNode)this.removedChildren.elementAt(i);
            p.remove(c);
        }
    }

    public boolean isChildNode(DefaultMutableTreeNode parent, String name) {
        int i;
        int ct = parent.getChildCount();
        for (i = 0; i < ct; ++i) {
            if (!name.equals(((DefaultMutableTreeNode)parent.getChildAt(i)).getUserObject().toString())) continue;
            return true;
        }
        for (i = 0; i < this.parents.size(); ++i) {
            DefaultMutableTreeNode c;
            DefaultMutableTreeNode p = (DefaultMutableTreeNode)this.parents.elementAt(i);
            if (p != parent || !name.equals((c = (DefaultMutableTreeNode)this.removedChildren.elementAt(i)).getUserObject().toString())) continue;
            return true;
        }
        return false;
    }

    private void expandAll(JTree tree) {
        int i;
        int rowCt = tree.getRowCount();
        TreePath[] path = new TreePath[rowCt];
        for (i = 0; i < rowCt; ++i) {
            path[i] = tree.getPathForRow(i);
        }
        for (i = 0; i < rowCt; ++i) {
            tree.expandPath(path[i]);
        }
    }

    private DefaultMutableTreeNode getDataSources(String dataSourceLoc, boolean newFile, Vector invisibleNode) throws Exception {
        this.readOnly = false;
        DefaultMutableTreeNode root = null;
        ReadXMLTable readXML = new ReadXMLTable();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer && newFile) {
            root = ReadXMLTable.getDefaultDataSources();
        } else {
            root = readXML.getDataSources(dataSourceLoc);
            if (root == null) {
                root = ReadXMLTable.getDefaultDataSources();
            }
            if (root instanceof DefaultDataSourceNode) {
                DefaultDataSourceNode node = (DefaultDataSourceNode)root;
                if (node.getLastID() != null) {
                    this.manager.setLastID(node.getLastID());
                }
                if (node.getRegistryID() != null) {
                    this.manager.setRegistryID(node.getRegistryID());
                } else {
                    this.manager.newRegistryID();
                }
                this.updateRegistry(node);
            }
        }
        this.dataSourceLoc = dataSourceLoc;
        this.removeAllInvisibleNode(root, invisibleNode);
        return root;
    }

    private void removeAllInvisibleNode(DefaultMutableTreeNode root, Vector invisibleNode) {
        if (invisibleNode != null && invisibleNode.size() > 0) {
            Vector<DefaultMutableTreeNode> invisiblePath = new Vector<DefaultMutableTreeNode>();
            this.parents = new Vector();
            this.removedChildren = new Vector();
            for (int i = 0; i < invisibleNode.size(); ++i) {
                DefaultMutableTreeNode obj = ManagerPane.getNode(root, invisibleNode.elementAt(i).toString());
                if (obj == null) continue;
                invisiblePath.add(obj);
            }
            this.removeInvisibleNode(root, invisiblePath);
        }
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1, 5, 5));
        this.editBut = new JButton(LanguageEncoder.getText("EDIT"));
        panel.add(this.editBut);
        this.copyBut = new JButton(LanguageEncoder.getText("COPY"));
        panel.add(this.copyBut);
        this.addBut = new JButton(LanguageEncoder.getText("ADD"));
        panel.add(this.addBut);
        this.removeBut = new JButton(LanguageEncoder.getText("REMOVE"));
        panel.add(this.removeBut);
        this.createRPTBut = new JButton(LanguageEncoder.getText("VIEW"));
        if (this.manager.showCreateReportButton()) {
            panel.add(this.createRPTBut);
        }
        this.backBut = new JButton(LanguageEncoder.getText("BACK"));
        if (this.manager.showBackButton() && !this.manager.showChangeButton()) {
            panel.add(this.backBut);
        }
        this.cancelBut = new JButton(LanguageEncoder.getText("CANCEL"));
        panel.add(this.cancelBut);
        this.nextBut = new JButton(LanguageEncoder.getText("NEXT"));
        this.doneBut = new JButton(LanguageEncoder.getText("DONE"));
        this.changeBut = new JButton(LanguageEncoder.getText("CHANGE DATA"));
        if (this.manager.showNextButton) {
            panel.add(this.nextBut);
        }
        if (this.manager.showDoneButton) {
            panel.add(this.doneBut);
        }
        if (this.manager.showChangeButton) {
            panel.add(this.changeBut);
        }
        this.editBut.addActionListener(this);
        this.copyBut.addActionListener(this);
        this.addBut.addActionListener(this);
        this.removeBut.addActionListener(this);
        this.backBut.addActionListener(this);
        this.changeBut.addActionListener(this);
        this.cancelBut.addActionListener(this);
        this.nextBut.addActionListener(this);
        this.createRPTBut.addActionListener(this);
        this.doneBut.addActionListener(this);
        return panel;
    }

    private void updateDataSource(DefaultMutableTreeNode root) {
        try {
            this.removeAllInvisibleNode(root, this.invisibleNode);
            this.tree.setModel(new DefaultTreeModel(root));
            this.treeModel = (DefaultTreeModel)this.tree.getModel();
            this.tree.setSelectionRow(0);
            this.expandAll(this.tree);
            this.selectLastVisitedPath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot update specified data source!"));
        }
    }

    public boolean updateDataSource(String dataSource, boolean newFile) {
        try {
            this.tree.setModel(new DefaultTreeModel(this.getDataSources(dataSource, newFile, null)));
            this.treeModel = (DefaultTreeModel)this.tree.getModel();
            this.saveDataSource();
            this.manager.setPresetDataRegistry(dataSource);
            this.tree.setSelectionRow(0);
            this.expandAll(this.tree);
            this.selectLastVisitedPath();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot open specified data source!"));
            return false;
        }
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.tree.isSelectionEmpty()) {
            return null;
        }
        return (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    public DefaultMutableTreeNode[] getSelectedNodes() {
        if (this.tree.isSelectionEmpty()) {
            return null;
        }
        TreePath[] paths = this.tree.getSelectionPaths();
        DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
        }
        return nodes;
    }

    boolean isAddEnabled(DefaultMutableTreeNode node) {
        return node != null && !this.readOnly && (!(node instanceof XMLFileNode) || node instanceof XMLFileNode && !((XMLFileNode)node).isQBFormat()) && !(node instanceof XMLQueryNode) && !(node instanceof JNDIDataSourceNode) && !(node instanceof TextFileNode) && !(node instanceof ClassFileNode) && !(node instanceof QueryNode) && !(node instanceof BigDataNode) && !(node instanceof DatabaseNode) && !(node instanceof DataViewNode) && !(node instanceof DataViewQueryNode) && !(node instanceof EJBNode) && this.manager.canModify() && node instanceof DefaultDataSourceNode && ((DefaultDataSourceNode)node).isAddEnabled();
    }

    boolean isEditEnabled(DefaultMutableTreeNode node) {
        return (node != null && !this.readOnly && (node instanceof XMLFileNode || node instanceof TextFileNode || node instanceof ClassFileNode || node instanceof XMLQueryNode || node instanceof SOAPDataSourceNode || node instanceof SOAPViewNode || node instanceof JNDIDataSourceNode || node instanceof QueryNode || node instanceof BigDataNode || node instanceof DatabaseNode || node instanceof DataViewNode || node instanceof DataViewQueryNode || node instanceof EJBNode || node instanceof SalesForceDataSourceNode) || node instanceof SalesForceQueryNode || node instanceof ExcelFileNode) && this.manager.canModify() && node instanceof DefaultDataSourceNode && ((DefaultDataSourceNode)node).isEditEnabled();
    }

    private boolean isCopyEnabled(DefaultMutableTreeNode node) {
        return node != null && !this.readOnly && (node instanceof QueryNode || node instanceof DataViewNode || node instanceof DataViewQueryNode || node instanceof DatabaseNode) && this.manager.canModify() && node instanceof DefaultDataSourceNode && ((DefaultDataSourceNode)node).isCopyEnabled();
    }

    private boolean isUpdateEnabled(DefaultMutableTreeNode node) {
        return node != null && !this.readOnly && (node instanceof DataViewNode || node instanceof DataViewQueryNode) && this.manager.canModify() && node instanceof DefaultDataSourceNode && ((DefaultDataSourceNode)node).isUpdateEnabled();
    }

    private boolean isNextEnabled(DefaultMutableTreeNode node) {
        return node != null && (node instanceof XMLFileNode && ((XMLFileNode)node).isQBFormat() || node instanceof XMLQueryNode || node instanceof SOAPViewNode || node instanceof TextFileNode || node instanceof ClassFileNode || node instanceof QueryNode || node instanceof DataViewNode || node instanceof DataViewQueryNode || node instanceof EJBNode || node instanceof SalesForceQueryNode || node instanceof ExcelFileNode) && node instanceof DefaultDataSourceNode && ((DefaultDataSourceNode)node).isNextEnabled() && (!(node instanceof DataViewNode) || this.isEditEnabled(node));
    }

    boolean isRemoveEnabled(DefaultMutableTreeNode node) {
        return this.isEditEnabled(node);
    }

    private void selectButton(DefaultMutableTreeNode node) {
        TreePath treePath = new TreePath(node.getPath());
        this.tree.setSelectionPath(treePath);
        lastVisitedPath = ManagerPane.getPathToString(treePath);
        this.selectLastVisitedPath();
    }

    void doEdit(DefaultMutableTreeNode node) {
        this.editMode = true;
        if (!this.isEditEnabled(node)) {
            return;
        }
        if (!this.requestEditNode(node)) {
            System.out.println("ManagerPane.doEdit()-->fail to obtain the lock");
            return;
        }
        node = this.nodeInEdit;
        if (node instanceof SOAPDataSourceNode) {
            SOAPDialog soapDialog = new SOAPDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), (SOAPDataSourceNode)node);
            soapDialog.setVisible(true);
            if (soapDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof SOAPViewNode) {
            SOAPViewDialog soapViewDialog = new SOAPViewDialog(this.manager, (SOAPDataSourceNode)node.getParent(), (SOAPViewNode)node);
            soapViewDialog.setVisible(true);
            if (soapViewDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof SalesForceDataSourceNode) {
            SalesForceDataSourceDialog sfDialog = new SalesForceDataSourceDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), (SalesForceDataSourceNode)node);
            sfDialog.setVisible(true);
            if (sfDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof ExcelFileNode) {
            ExcelDataSourceDialog eDialog = new ExcelDataSourceDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), (ExcelFileNode)node);
            eDialog.setVisible(true);
            if (eDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof SalesForceQueryNode) {
            SalesForceQueryDialog sfDialog = new SalesForceQueryDialog(this.manager, (SalesForceDataSourceNode)node.getParent(), (SalesForceQueryNode)node);
            sfDialog.setVisible(true);
            if (sfDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof JNDIDataSourceNode) {
            JNDIDialog jndiDialog = new JNDIDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), (JNDIDataSourceNode)node);
            jndiDialog.setVisible(true);
            if (jndiDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof BigDataNode) {
            BigDataDialog bdDialog = new BigDataDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), (BigDataNode)node);
            bdDialog.setVisible(true);
            if (bdDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof DatabaseNode) {
            DBDialog dbDialog = new DBDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), (DatabaseNode)node);
            dbDialog.setVisible(true);
            if (dbDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof EJBNode) {
            EJBNodeDialog ejbDialog = new EJBNodeDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), (EJBNode)node);
            ejbDialog.setVisible(true);
            if (ejbDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof TextFileNode || node instanceof ClassFileNode) {
            FileNodeDialog fDialog = new FileNodeDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), node, node instanceof ClassFileNode);
            fDialog.setVisible(true);
            if (fDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof XMLFileNode) {
            XMLNodeDialog xDialog = new XMLNodeDialog(this.manager, (DefaultMutableTreeNode)node.getParent(), (XMLFileNode)node);
            xDialog.setVisible(true);
            if (xDialog.isModified()) {
                this.treeModel.reload(node);
                if (this.createRPTBut != null) {
                    this.createRPTBut.setEnabled(this.isNextEnabled(xDialog.getNode()));
                }
            }
        } else if (node instanceof XMLQueryNode) {
            XMLQueryBuilderDialog xqDialog = new XMLQueryBuilderDialog(this.manager, (DefaultDataSourceNode)node.getParent(), (XMLQueryNode)node);
            xqDialog.setVisible(true);
            if (xqDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof QueryNode) {
            SQLDialog sDialog = new SQLDialog(this.manager, (DefaultDataSourceNode)node.getParent().getParent(), (QueryNode)node);
            sDialog.setVisible(true);
            if (sDialog.isModified()) {
                this.treeModel.reload(node);
            }
        } else if (node instanceof DataViewNode) {
            DataViewNode dNode = (DataViewNode)node;
            Vector<TreeNode> siblings = new Vector<TreeNode>();
            if (dNode.getParent() != null) {
                for (int i = 0; i < dNode.getParent().getChildCount(); ++i) {
                    TreeNode child = dNode.getParent().getChildAt(i);
                    if (!(child instanceof DataViewNode) || dNode.getUserObject().toString().equals(((DataViewNode)child).getUserObject().toString())) continue;
                    siblings.addElement(child);
                }
            }
            DataViewDialog dDialog = null;
            try {
                boolean autoJoin;
                DefaultDataSourceNode ddsNode = (DefaultDataSourceNode)node.getParent().getParent();
                DatabaseNode dbNode = null;
                JNDIDataSourceNode jndiNode = null;
                boolean isUseJNDIDataSource = false;
                String JNDIName = "";
                String driver = "";
                String url = "";
                String userName = "";
                String password = "";
                Hashtable env = new Hashtable();
                Vector addDb = null;
                if (ddsNode instanceof JNDIDataSourceNode) {
                    isUseJNDIDataSource = true;
                    jndiNode = (JNDIDataSourceNode)ddsNode;
                    JNDIName = jndiNode.getJNDIName();
                    env = jndiNode.getEnvProperties();
                    autoJoin = jndiNode.isAutoJoin();
                } else {
                    dbNode = (DatabaseNode)ddsNode;
                    driver = dbNode.getDriver();
                    url = dbNode.getURL();
                    String[] login = this.login(node);
                    if (login == null) {
                        if (this.manager.isVisible()) {
                            this.closeEditNode();
                        }
                        return;
                    }
                    userName = login[0];
                    password = login[1];
                    autoJoin = dbNode.isAutoJoin();
                    addDb = dbNode.getAdditionalDb();
                }
                dDialog = new DataViewDialog(this.manager, isUseJNDIDataSource, JNDIName, env, driver, url, userName, password, dNode.getUserObject().toString(), QueryMain.QUERYDIR + dNode.getQueryFile() + ".dvw", autoJoin, addDb, false);
                dDialog.setSiblingNodes(siblings.toArray(new DataViewNode[0]));
                dDialog.setVisible(true);
                if (dDialog.isModified()) {
                    dNode.setName(dDialog.getName());
                    dDialog.save(QueryMain.QUERYDIR + dNode.getQueryFile() + ".dvw");
                    this.treeModel.reload(node);
                }
                if (this.manager.isVisible()) {
                    this.closeEditOrAddNode();
                }
                if (dDialog.isModified() && dNode.getChildCount() > 0) {
                    this.doUpdate(dNode);
                }
            }
            catch (Exception ex) {
                if (dDialog == null) {
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to open data view.\n") + QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n"));
                } else {
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to save data view.\n") + ex.toString());
                }
                this.manager.managerPane.closeEditOrAddNode();
            }
        } else if (node instanceof DataViewQueryNode) {
            DataViewQueryNode dNode = (DataViewQueryNode)node;
            try {
                DefaultDataSourceNode ddsNode = (DefaultDataSourceNode)node.getParent().getParent().getParent();
                DatabaseNode dbNode = null;
                JNDIDataSourceNode jndiNode = null;
                boolean isUseJNDIDataSource = false;
                String JNDIName = "";
                String driver = "";
                String url = "";
                String userName = "";
                String password = "";
                Hashtable env = new Hashtable();
                Vector additionalDb = null;
                if (ddsNode instanceof JNDIDataSourceNode) {
                    isUseJNDIDataSource = true;
                    jndiNode = (JNDIDataSourceNode)ddsNode;
                    JNDIName = jndiNode.getJNDIName();
                    env = jndiNode.getEnvProperties();
                } else {
                    dbNode = (DatabaseNode)ddsNode;
                    driver = dbNode.getDriver();
                    url = dbNode.getURL();
                    String[] login = this.login(node);
                    if (login == null) {
                        if (this.manager.isVisible()) {
                            this.closeEditNode();
                        }
                        return;
                    }
                    userName = login[0];
                    password = login[1];
                    additionalDb = ((DatabaseNode)ddsNode).getAdditionalDb();
                }
                ConditionDialog cDialog = new ConditionDialog(this.manager, isUseJNDIDataSource, JNDIName, env, driver, url, userName, password, dNode, false, additionalDb);
                cDialog.setVisible(true);
                if (cDialog.isModified()) {
                    if (!ServerMessage.useServer) {
                        this.treeModel.reload(node);
                    } else {
                        this.updateDataSource(DataRegClient.getRoot());
                    }
                    this.selectButton(dNode);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to open data view query.\n") + QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n"));
            }
        }
        this.validate();
        this.repaint();
        this.addBut.setEnabled(this.isAddEnabled(node));
        this.nextBut.setEnabled(this.isNextEnabled(node));
        if (this.manager.isVisible()) {
            this.closeEditNode();
        }
    }

    private DefaultMutableTreeNode[] getAvailDatabases(DefaultMutableTreeNode db) {
        int count = db.getChildCount();
        Vector<DefaultMutableTreeNode> databasesVEC = new Vector<DefaultMutableTreeNode>();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode tmpNode = (DefaultMutableTreeNode)db.getChildAt(i);
            if (this.containsHiddenDataViewNode(tmpNode)) continue;
            databasesVEC.addElement(tmpNode);
        }
        DefaultMutableTreeNode[] databases = new DefaultMutableTreeNode[databasesVEC.size()];
        for (int i = 0; i < databases.length; ++i) {
            databases[i] = (DefaultMutableTreeNode)databasesVEC.elementAt(i);
        }
        return databases;
    }

    private boolean containsHiddenDataViewNode(DefaultMutableTreeNode dbnode) {
        for (int i = 0; i < this.removedChildren.size(); ++i) {
            DefaultMutableTreeNode parent;
            DefaultMutableTreeNode dvnode = (DefaultMutableTreeNode)this.removedChildren.elementAt(i);
            if (!(dvnode instanceof DataViewNode ? (parent = (DefaultMutableTreeNode)this.parents.elementAt(i)).getParent() == dbnode : dvnode instanceof DefaultDataSourceNode && (parent = (DefaultMutableTreeNode)this.parents.elementAt(i)) == dbnode)) continue;
            return true;
        }
        return false;
    }

    private void doCopy(DefaultMutableTreeNode node) {
        if (node == null || !this.isCopyEnabled(node)) {
            return;
        }
        CopyNodeDialog cDialog = null;
        if (node instanceof QueryNode) {
            cDialog = new CopyNodeDialog(this.manager, (DefaultDataSourceNode)node.getParent().getParent(), (QueryNode)node);
        } else if (node instanceof DataViewNode) {
            DefaultMutableTreeNode db = (DefaultMutableTreeNode)node.getParent().getParent().getParent();
            DefaultMutableTreeNode[] databases = this.getAvailDatabases(db);
            cDialog = new CopyNodeDialog(this.manager, (DefaultDataSourceNode)node.getParent().getParent(), (DataViewNode)node, databases);
        } else if (node instanceof DataViewQueryNode) {
            cDialog = new CopyNodeDialog(this.manager, (DataViewNode)node.getParent(), (DataViewQueryNode)node);
        } else if (node instanceof DatabaseNode) {
            cDialog = new CopyNodeDialog(this.manager, (DefaultDataSourceNode)node.getParent(), (DatabaseNode)node);
        }
        cDialog.setVisible(true);
        if (cDialog.isModified()) {
            if (!ServerMessage.useServer) {
                this.treeModel.reload(node);
            } else {
                this.updateDataSource(DataRegClient.getRoot());
            }
            this.selectButton(cDialog.getNode());
        }
    }

    void doAdd(DefaultMutableTreeNode node) {
        block68: {
            this.editMode = false;
            if (!this.isAddEnabled(node)) {
                return;
            }
            if (!this.requestAddNode(node)) {
                return;
            }
            node = this.nodeInEdit;
            if (node.getUserObject().equals("BigDatas")) {
                BigDataDialog bdDialog = new BigDataDialog(this.manager, node, null);
                bdDialog.setVisible(true);
                if (bdDialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(bdDialog.getNode());
                }
            } else if (node.getUserObject().equals("Databases")) {
                DBDialog dbDialog = new DBDialog(this.manager, node, null);
                dbDialog.setVisible(true);
                if (dbDialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(dbDialog.getNode());
                }
            } else if (node.getUserObject().equals("JNDIDataSources")) {
                JNDIDialog dialog = new JNDIDialog(this.manager, node, null);
                dialog.setVisible(true);
                if (dialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(dialog.getNode());
                }
            } else if (node.getUserObject().equals("EJBs")) {
                EJBNodeDialog ejbDialog = new EJBNodeDialog(this.manager, node, null);
                ejbDialog.setVisible(true);
                if (ejbDialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(ejbDialog.getNode());
                    ejbDialog.getNode().setID(this.manager.getNextID());
                }
            } else if (node.getUserObject().equals("SOAPServices")) {
                SOAPDialog dialog = new SOAPDialog(this.manager, node, null);
                dialog.setVisible(true);
                if (dialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(dialog.getNode());
                    dialog.getNode().setID(this.manager.getNextID());
                }
            } else if (node.getUserObject().equals("Queries")) {
                SQLDialog sDialog = new SQLDialog(this.manager, (DefaultDataSourceNode)node.getParent(), null);
                sDialog.setVisible(true);
                if (sDialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(sDialog.getNode());
                    sDialog.getNode().setID(this.manager.getNextID());
                }
            } else if (node.getUserObject().equals("Data Views")) {
                int tableNameFormat;
                boolean autoJoin;
                DefaultDataSourceNode ddsNode = (DefaultDataSourceNode)node.getParent();
                boolean isUseJNDIDataSource = false;
                String JNDIName = "";
                String driver = "";
                String url = "";
                String userName = "";
                String password = "";
                Hashtable env = new Hashtable();
                Vector additionalDb = null;
                if (ddsNode instanceof JNDIDataSourceNode) {
                    isUseJNDIDataSource = true;
                    JNDIName = ((JNDIDataSourceNode)ddsNode).getJNDIName();
                    env = ((JNDIDataSourceNode)ddsNode).getEnvProperties();
                    autoJoin = ((JNDIDataSourceNode)ddsNode).isAutoJoin();
                    tableNameFormat = ((JNDIDataSourceNode)ddsNode).getTableNameFormat();
                } else {
                    driver = ((DatabaseNode)ddsNode).getDriver();
                    url = ((DatabaseNode)ddsNode).getURL();
                    autoJoin = ((DatabaseNode)ddsNode).isAutoJoin();
                    tableNameFormat = ((DatabaseNode)ddsNode).getTableNameFormat();
                    String[] login = this.login(node);
                    if (login == null) {
                        if (this.manager.isVisible()) {
                            this.closeAddNode();
                        }
                        return;
                    }
                    userName = login[0];
                    password = login[1];
                    additionalDb = ((DatabaseNode)ddsNode).getAdditionalDb();
                }
                String newFileName = "";
                String fileprefix = this.dataSourceLoc;
                fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
                fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
                fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
                fileprefix = fileprefix + "_" + ddsNode.getUserObject() + "_";
                Vector<TreeNode> siblings = new Vector<TreeNode>();
                for (int i = 0; i < node.getChildCount(); ++i) {
                    TreeNode child = node.getChildAt(i);
                    if (!(child instanceof DataViewNode)) continue;
                    siblings.addElement(child);
                }
                DataViewDialog dDialog = null;
                try {
                    dDialog = new DataViewDialog((Dialog)this.manager, isUseJNDIDataSource, JNDIName, env, driver, url, userName, password, autoJoin, tableNameFormat, additionalDb, siblings.toArray(new DataViewNode[0]));
                    if (dDialog.getTables().length == 0) {
                        if (this.manager.isVisible()) {
                            this.closeAddNode();
                        }
                        return;
                    }
                    dDialog.setVisible(true);
                    if (!dDialog.isModified()) break block68;
                    String name = dDialog.getName();
                    newFileName = fileprefix + name;
                    if ((newFileName = QbUtil.getValidFilename(newFileName)).startsWith("_")) {
                        newFileName = "a" + newFileName;
                    }
                    String tmp = newFileName;
                    int ct = 0;
                    try {
                        while (new FileInfo(QueryMain.QUERYDIR + newFileName + ".dvw").exists()) {
                            newFileName = tmp + "_" + ct++;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    DataViewNode dataNode = new DataViewNode(name);
                    dataNode.setQueryFile(newFileName);
                    dDialog.save(QueryMain.QUERYDIR + newFileName + ".dvw");
                    node.add(dataNode);
                    this.treeModel.reload(node);
                }
                catch (Exception ex) {
                    if (dDialog == null) {
                        new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to open data view.\n") + QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n"));
                        break block68;
                    }
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to save data view.\n") + ex.toString());
                }
            } else if (node.getUserObject().equals("XMLFiles")) {
                try {
                    XMLNodeDialog xDialog = new XMLNodeDialog(this.manager, node, null);
                    xDialog.setVisible(true);
                    if (xDialog.isModified()) {
                        this.treeModel.reload(node);
                        this.selectButton(xDialog.getNode());
                        if (this.createRPTBut != null) {
                            this.createRPTBut.setEnabled(this.isNextEnabled(xDialog.getNode()));
                        }
                        xDialog.getNode().setID(this.manager.getNextID());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to parse XML file.\n") + ex.toString());
                }
            } else if (node instanceof SOAPDataSourceNode) {
                try {
                    SOAPViewDialog soapViewDialog = new SOAPViewDialog(this.manager, (SOAPDataSourceNode)node, null);
                    soapViewDialog.setVisible(true);
                    if (soapViewDialog.isModified()) {
                        this.treeModel.reload(node);
                        this.selectButton(soapViewDialog.getNode());
                        soapViewDialog.getNode().setID(this.manager.getNextID());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to parse XML file.\n") + e.toString());
                }
            } else if (node instanceof SOAPViewNode) {
                try {
                    XMLQueryBuilderDialog xqDialog = new XMLQueryBuilderDialog(this.manager, (SOAPViewNode)node, null);
                    xqDialog.setVisible(true);
                    if (xqDialog.isModified()) {
                        this.treeModel.reload(node);
                        this.selectButton(xqDialog.getNode());
                        xqDialog.getNode().setID(this.manager.getNextID());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to parse XML file.\n") + ex.toString());
                }
            } else if (node.getUserObject().equals("SalesForceConnections")) {
                SalesForceDataSourceDialog salesForceDialog = new SalesForceDataSourceDialog(this.manager, node, null);
                salesForceDialog.setVisible(true);
                if (salesForceDialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(salesForceDialog.getNode());
                    salesForceDialog.getNode().setID(this.manager.getNextID());
                }
            } else if (node instanceof SalesForceDataSourceNode) {
                SalesForceQueryDialog sfDialog = new SalesForceQueryDialog(this.manager, (SalesForceDataSourceNode)node, null);
                sfDialog.setVisible(true);
                if (sfDialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(sfDialog.getNode());
                    sfDialog.getNode().setID(this.manager.getNextID());
                }
            } else if (node.getUserObject().equals("ExcelFiles")) {
                ExcelDataSourceDialog excelDialog = new ExcelDataSourceDialog(this.manager, node, null);
                excelDialog.setVisible(true);
                if (excelDialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(excelDialog.getNode());
                    excelDialog.getNode().setID(this.manager.getNextID());
                }
            } else if (node instanceof XMLFileNode) {
                try {
                    XMLQueryBuilderDialog xqDialog = new XMLQueryBuilderDialog(this.manager, (XMLFileNode)node, null);
                    xqDialog.setVisible(true);
                    if (xqDialog.isModified()) {
                        this.treeModel.reload(node);
                        this.selectButton(xqDialog.getNode());
                        xqDialog.getNode().setID(this.manager.getNextID());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to parse XML file.\n") + ex.toString());
                }
            } else {
                FileNodeDialog fDialog = new FileNodeDialog(this.manager, node, null, node.getUserObject().equals("ClassFiles"));
                fDialog.setVisible(true);
                if (fDialog.isModified()) {
                    this.treeModel.reload(node);
                    this.selectButton(fDialog.getNode());
                    ((DefaultDataSourceNode)fDialog.getNode()).setID(this.manager.getNextID());
                }
            }
        }
        if (this.manager.isVisible()) {
            this.closeAddNode();
        }
    }

    private void doRemove() {
        DefaultMutableTreeNode[] nodes = this.getSelectedNodes();
        if (nodes == null || nodes.length <= 0) {
            return;
        }
        String msg = null;
        msg = nodes.length > 1 ? "Are you sure you would like to delete these nodes?" : "Are you sure you would like to delete this node?";
        int n = JOptionPane.showConfirmDialog(this.manager, msg, "Confirmation", 0);
        if (n != 0) {
            return;
        }
        for (int i = 1; i < nodes.length; ++i) {
            this.doRemove(nodes[i], false);
        }
        this.doRemove(nodes[0], true);
    }

    void doRemove(DefaultMutableTreeNode node) {
        this.doRemove(node, true);
    }

    private void doRemove(DefaultMutableTreeNode node, boolean refreshTree) {
        this.doRemove(node, refreshTree, false);
    }

    protected void doRemove(DefaultMutableTreeNode node, boolean refreshTree, boolean ignoreError) {
        String schemaTreeFileName;
        if (!this.isRemoveEnabled(node)) {
            return;
        }
        if (!this.requestRemoveNode(node) && !ignoreError) {
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("The node is currently unavailable (another user is currently modifying it or its sub node, or has removed it)"));
            return;
        }
        if (node instanceof QueryNode) {
            new DeleteFile(QueryMain.QUERYDIR + ((QueryNode)node).getQueryFile() + ".qry").delete();
        } else if (node instanceof DataViewNode) {
            new DeleteFile(QueryMain.QUERYDIR + ((DataViewNode)node).getQueryFile() + ".dvw").delete();
        } else if (node instanceof DataViewQueryNode) {
            new DeleteFile(QueryMain.QUERYDIR + ((DataViewQueryNode)node).getDataViewFile() + ".dvw").delete();
            new DeleteFile(((DataViewQueryNode)node).getQueryFile() + ".dvw").delete();
        } else if (node instanceof XMLFileNode) {
            String dtdTreeFileName = ((XMLFileNode)node).getDTDTreeFileName();
            if (dtdTreeFileName != null && !dtdTreeFileName.equals("")) {
                new DeleteFile(((XMLFileNode)node).getDTDTreeFileName()).delete();
            }
        } else if (node instanceof SOAPViewNode && (schemaTreeFileName = ((SOAPViewNode)node).getSchemaTreeFileName()) != null && !schemaTreeFileName.equals("")) {
            new DeleteFile(schemaTreeFileName).delete();
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        parent.remove(node);
        if (refreshTree) {
            this.treeModel.reload(parent);
            this.selectButton(parent);
        }
    }

    private String[] login(DefaultMutableTreeNode node) {
        String[] defaultLogin = new String[]{"", ""};
        if (!(node.getParent() instanceof DefaultMutableTreeNode)) {
            return defaultLogin;
        }
        DatabaseNode parent = null;
        JNDIDataSourceNode _parent = null;
        DefaultMutableTreeNode p1 = (DefaultMutableTreeNode)node.getParent();
        if (p1 instanceof DatabaseNode) {
            parent = (DatabaseNode)p1;
        } else if (p1.getParent() instanceof DatabaseNode) {
            parent = (DatabaseNode)p1.getParent();
        } else if (p1.getParent() instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)p1.getParent()).getParent() instanceof DatabaseNode) {
            parent = (DatabaseNode)((DefaultMutableTreeNode)p1.getParent()).getParent();
        } else if (p1 instanceof JNDIDataSourceNode) {
            _parent = (JNDIDataSourceNode)p1;
        } else if (p1.getParent() instanceof JNDIDataSourceNode) {
            _parent = (JNDIDataSourceNode)p1.getParent();
        } else if (p1.getParent() instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)p1.getParent()).getParent() instanceof JNDIDataSourceNode) {
            _parent = (JNDIDataSourceNode)((DefaultMutableTreeNode)p1.getParent()).getParent();
        } else {
            return defaultLogin;
        }
        if (parent != null) {
            this.manager.setURL(parent.getURL());
            this.manager.setDriver(parent.getDriver());
            if (parent.isLoginRequired()) {
                if (parent.isPasswordSaved()) {
                    this.manager.setUserName(parent.getUserName());
                    this.manager.setPassword(parent.getPassword());
                    defaultLogin[0] = parent.getUserName();
                    defaultLogin[1] = parent.getPassword();
                } else {
                    LoginDialog loginDialog = new LoginDialog(this.manager);
                    loginDialog.setVisible(true);
                    if (!loginDialog.isModified()) {
                        return null;
                    }
                    this.manager.setUserName(loginDialog.getUserName());
                    this.manager.setPassword(loginDialog.getPassword());
                    defaultLogin[0] = loginDialog.getUserName();
                    defaultLogin[1] = loginDialog.getPassword();
                }
            } else {
                this.manager.setUserName("");
                this.manager.setPassword("");
            }
            this.manager.setUseJNDIDataSource(false);
            this.manager.setAdditionalDb(parent.getAdditionalDb());
        } else if (_parent != null) {
            this.manager.setUseJNDIDataSource(true);
            this.manager.setJNDIName(_parent.getJNDIName());
            this.manager.setEnvProperties(_parent.getEnvProperties());
        }
        return defaultLogin;
    }

    private DataViewQueryNode buildConditions(DataViewNode node) {
        String oldTitle = this.manager.getTitle();
        try {
            this.manager.setTitle(LanguageEncoder.getText("Please wait..."));
            DataViewDialog dvDialog = new DataViewDialog(this.manager, this.manager.isUseJNDIDataSource(), this.manager.getLookupName(), this.manager.getEnvProperties(), this.manager.getDriver(), this.manager.getURL(), this.manager.getUserName(), this.manager.getPassword(), node.getUserObject().toString(), QueryMain.QUERYDIR + node.getQueryFile() + ".dvw", true, this.manager.getAdditionalDb(), false);
            this.manager.setTitle(oldTitle);
            ConditionDialog cDialog = new ConditionDialog(this.manager, dvDialog, node);
            cDialog.setVisible(true);
            if (cDialog.isModified()) {
                DataViewQueryNode qnode = cDialog.getDataViewQueryNode();
                if (qnode != null) {
                    qnode.setJustCreated(true);
                    qnode.setInSet(cDialog.getInSet());
                    qnode.setSQL(cDialog.getQuery());
                }
                return qnode;
            }
            return null;
        }
        catch (Exception ex) {
            if (!"CANCELED".equals(ex.getMessage())) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to build conditions.\n") + QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n"));
            }
            this.manager.setTitle(oldTitle);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.updateReports) {
            this.manager.getInterchangeProcess().setIsReport(true);
            this.manager.getInterchangeProcess().updateReports((DefaultDataSourceNode)this.tree.getModel().getRoot());
        } else if (e.getSource() == this.updateCharts) {
            this.manager.getInterchangeProcess().setIsReport(false);
            this.manager.getInterchangeProcess().updateReports((DefaultDataSourceNode)this.tree.getModel().getRoot());
        }
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node != null) {
            if (e.getSource() == this.editBut) {
                this.doEdit(node);
            } else if (e.getSource() == this.copyBut) {
                this.doCopy(node);
            } else if (e.getSource() == this.addBut) {
                this.doAdd(node);
            } else if (e.getSource() == this.removeBut) {
                this.doRemove();
            }
        }
        try {
            this.saveDataSource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to save data source!"));
        }
        this.manager.setPresetDataRegistry(this.dataSourceLoc);
        IDataInterchange ic = this.manager.getInterchangeProcess();
        if (e.getSource() == this.backBut) {
            String oldDataSourceLoc = this.dataSourceLoc;
            boolean updateSuccessful = this.manager.updateDataSource();
            if (updateSuccessful && !oldDataSourceLoc.equals(this.dataSourceLoc)) {
                try {
                    IOUtil.releaseFileLock(oldDataSourceLoc);
                }
                catch (Exception exception) {}
            }
        } else if (e.getSource() == this.createRPTBut) {
            if (!this.isNextEnabled(node)) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please select a data source!"));
            }
            if (this.login(node) == null) {
                return;
            }
            if (node instanceof DataViewNode) {
                if (!this.requestAddNode(node)) {
                    return;
                }
                node = this.nodeInEdit;
                DataViewQueryNode qnode = this.buildConditions((DataViewNode)node);
                if (qnode == null) {
                    this.closeAddNode(true, null);
                    this.manager.toFront();
                    return;
                }
                this.closeAddNode(qnode);
                node = qnode;
            }
            this.manager.setSelectedNode(node);
            try {
                IOUtil.releaseFileLock(this.dataSourceLoc);
            }
            catch (Exception qnode) {
                // empty catch block
            }
            if (ic instanceof IDataInterchangeORG) {
                IDataInterchangeORG icORG = (IDataInterchangeORG)ic;
                if (LCKey.isDashboardOnly()) {
                    icORG.createChart();
                } else {
                    icORG.createReport();
                }
            }
        } else if (e.getSource() == this.cancelBut) {
            try {
                IOUtil.releaseFileLock(this.dataSourceLoc);
            }
            catch (Exception icORG) {
                // empty catch block
            }
            if (ic != null) {
                ic.cancel();
            } else {
                System.out.println("ManagerPane : CANCEL");
            }
        } else if (e.getSource() == this.doneBut) {
            try {
                IOUtil.releaseFileLock(this.dataSourceLoc);
            }
            catch (Exception icORG) {
                // empty catch block
            }
            if (ic != null) {
                ic.cancel();
            } else {
                System.out.println("ManagerPane : DONE");
            }
        } else if (e.getSource() == this.nextBut) {
            if (!this.isNextEnabled(node)) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please select a data source!"));
            }
            if (this.login(node) == null) {
                return;
            }
            if (node instanceof DataViewNode) {
                if (!this.requestAddNode(node)) {
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("The parent node is currently unavailable (another user is currently modifying it or has removed it)"));
                    return;
                }
                node = this.nodeInEdit;
                DataViewQueryNode qnode = this.buildConditions((DataViewNode)node);
                if (qnode == null) {
                    this.manager.toFront();
                    return;
                }
                this.closeAddNode(qnode);
                node = qnode;
            }
            this.manager.setSelectedNode(node);
            try {
                IOUtil.releaseFileLock(this.dataSourceLoc);
            }
            catch (Exception qnode) {
                // empty catch block
            }
            if (ic != null) {
                ic.next(false, false, null, null);
            } else {
                System.out.println("ManagerPane : NEXT");
            }
        } else if (e.getSource() == this.changeBut) {
            try {
                IOUtil.releaseFileLock(this.dataSourceLoc);
            }
            catch (Exception qnode) {
                // empty catch block
            }
            if (ic != null) {
                this.manager.setVisible(false);
                this.manager.dispose();
                this.manager.changeDataRegistry.getSelectedFile(this.manager, true);
            } else {
                System.out.println("ManagerPane : CHANGE DATA");
            }
        } else if (e.getSource() == this.updateBut || e.getSource() == this.updateDataview) {
            try {
                this.doUpdate(node);
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to update dataview.\n") + ex.toString());
            }
        }
    }

    private void doUpdate(DefaultMutableTreeNode node) throws Exception {
        if (!(node instanceof DataViewNode) && !(node instanceof DataViewQueryNode)) {
            return;
        }
        if (!this.requestEditNode(node)) {
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("The node is currently unavailable (another user is currently modifying it or its sub node, or has removed it)"));
            return;
        }
        node = this.nodeInEdit;
        DefaultDataSourceNode ddsNode = null;
        ddsNode = node instanceof DataViewNode ? (node.getParent().getParent() instanceof JNDIDataSourceNode ? (JNDIDataSourceNode)node.getParent().getParent() : (DatabaseNode)node.getParent().getParent()) : (node.getParent().getParent().getParent() instanceof JNDIDataSourceNode ? (JNDIDataSourceNode)node.getParent().getParent().getParent() : (DatabaseNode)node.getParent().getParent().getParent());
        boolean isUseJNDIDataSource = false;
        String JNDIName = "";
        String driver = "";
        String url = "";
        Hashtable env = new Hashtable();
        String userName = "";
        String password = "";
        if (ddsNode instanceof DatabaseNode) {
            driver = ((DatabaseNode)ddsNode).getDriver();
            url = ((DatabaseNode)ddsNode).getURL();
        } else if (ddsNode instanceof JNDIDataSourceNode) {
            isUseJNDIDataSource = true;
            JNDIName = ((JNDIDataSourceNode)ddsNode).getJNDIName();
            env = ((JNDIDataSourceNode)ddsNode).getEnvProperties();
        }
        String[] login = this.login(node);
        if (login == null) {
            if (this.manager.isVisible()) {
                this.closeEditNode();
            }
            return;
        }
        userName = login[0];
        password = login[1];
        UpdateDataView update = new UpdateDataView(this.manager);
        if (node instanceof DataViewNode) {
            update.update(isUseJNDIDataSource, JNDIName, env, driver, url, userName, password, (DataViewNode)node);
        } else {
            update.update(isUseJNDIDataSource, JNDIName, env, driver, url, userName, password, (DataViewQueryNode)node);
        }
        Thread uThread = new Thread(update);
        uThread.start();
    }

    public void updateTree() {
        this.treeModel.reload();
    }

    public void saveDataSource() throws Exception {
        if (ServerMessage.useServer) {
            return;
        }
        if (!this.manager.canModify() || this.readOnly) {
            return;
        }
        this.restoreLostNode();
        ((DefaultDataSourceNode)this.tree.getModel().getRoot()).setLastID(this.manager.getLastID());
        ((DefaultDataSourceNode)this.tree.getModel().getRoot()).setRegistryID(this.manager.getRegistryID());
        WriteXMLDataSources.writeDataSources(this.dataSourceLoc, this.tree.getModel().getRoot());
        this.removeRestoredNode();
    }

    void openDataViewQuery(DefaultMutableTreeNode node) {
        if (node != null && node instanceof DataViewQueryNode && ((DataViewQueryNode)node).isJustCreated()) {
            DataViewQueryNode qnode = (DataViewQueryNode)node;
            try {
                ConditionDialog cDialog = new ConditionDialog(this.manager, this.manager.isUseJNDIDataSource(), this.manager.getLookupName(), this.manager.getEnvProperties(), this.manager.getDriver(), this.manager.getURL(), this.manager.getUserName(), this.manager.getPassword(), qnode, false, this.manager.getAdditionalDb());
                cDialog.setVisible(true);
                if (!cDialog.isModified()) {
                    qnode.setJustCreated(false);
                    return;
                }
                this.manager.setSelectedNode(node);
                try {
                    IOUtil.releaseFileLock(this.dataSourceLoc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IDataInterchange ic = this.manager.getInterchangeProcess();
                if (ic != null) {
                    ic.next(false, false, null, null);
                } else {
                    System.out.println("ManagerPane : NEXT");
                }
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to build conditions.\n") + QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n"));
            }
        }
    }

    void openDataViewQuery(byte[][] dbFileBytes) {
        try {
            ConditionDialog cDialog = new ConditionDialog((JDialog)this.manager, this.manager.isUseJNDIDataSource(), this.manager.getJNDIName(), (Hashtable<String, String>)this.manager.getEnvProperties(), this.manager.getDriver(), this.manager.getURL(), this.manager.getUserName(), this.manager.getPassword(), dbFileBytes, false);
            cDialog.setVisible(true);
            if (!cDialog.isModified()) {
                return;
            }
            DataViewNode node = new DataViewNode("DataView");
            node.setSQL(cDialog.getQuery());
            node.setInSet(cDialog.getInSet());
            node.setBytes(cDialog.getFileBytes());
            this.manager.setSelectedNode(node);
            try {
                IOUtil.releaseFileLock(this.dataSourceLoc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IDataInterchange ic = this.manager.getInterchangeProcess();
            if (ic != null) {
                ic.next(false, false, null, null);
            } else {
                System.out.println("ManagerPane : NEXT");
            }
        }
        catch (Exception ex) {
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to build conditions.\n") + QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n"));
        }
    }

    private void updateRegistry(DefaultDataSourceNode node) {
        if (node instanceof QueryNode || node instanceof DataViewQueryNode || node instanceof TextFileNode || node instanceof ClassFileNode || node instanceof XMLFileNode || node instanceof XMLQueryNode || node instanceof EJBNode || node instanceof SOAPViewNode || node instanceof SalesForceQueryNode || node instanceof ExcelFileNode) {
            if (node.getID() == null) {
                node.setID(this.manager.getNextID());
            }
        } else {
            int ct = node.getChildCount();
            for (int i = 0; i < ct; ++i) {
                DefaultDataSourceNode tmp = (DefaultDataSourceNode)node.getChildAt(i);
                this.updateRegistry(tmp);
            }
        }
    }

    private static String getPathToString(TreePath lastPath) {
        if (lastPath == null) {
            return null;
        }
        String path = null;
        int ct = lastPath.getPathCount();
        for (int i = 1; i < ct; ++i) {
            path = path == null ? lastPath.getPathComponent(i).toString() : path + "/" + lastPath.getPathComponent(i).toString();
        }
        return path;
    }

    private void selectLastVisitedPath() {
        if (lastVisitedPath != null) {
            TreePath treePath = this.getTreePath(lastVisitedPath);
            this.tree.expandPath(treePath);
            this.tree.setSelectionPath(treePath);
        }
    }

    private TreePath getTreePath(String indexStr) {
        DefaultMutableTreeNode rnode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        if (rnode == null) {
            return null;
        }
        DefaultMutableTreeNode tnode = ManagerPane.getNode((DefaultMutableTreeNode)this.tree.getModel().getRoot(), indexStr);
        if (tnode == null) {
            return null;
        }
        return new TreePath(tnode.getPath());
    }

    public static DefaultMutableTreeNode getNode(DefaultMutableTreeNode rootNode, String indexStr) {
        if (indexStr == null || indexStr.trim().equals("") || indexStr.trim().equals("\\") || indexStr.trim().equals("/")) {
            return null;
        }
        indexStr.replace('\\', '/');
        if (!indexStr.endsWith("/")) {
            indexStr = indexStr + "/";
        }
        int level = 0;
        for (int i = 0; i < indexStr.length(); ++i) {
            if (indexStr.charAt(i) != '/') continue;
            ++level;
        }
        return ManagerPane.getNode(rootNode, level, indexStr);
    }

    private static DefaultMutableTreeNode getNode(DefaultMutableTreeNode rootNode, int level, String indexStr) {
        String[] index = new String[level];
        int b = 0;
        boolean isFound = false;
        for (int i = 0; i < level; ++i) {
            int e = indexStr.indexOf("/", b);
            index[i] = indexStr.substring(b, e);
            b = e + 1;
            isFound = false;
            for (int j = 0; j < rootNode.getChildCount(); ++j) {
                if (!((DefaultMutableTreeNode)rootNode.getChildAt(j)).getUserObject().toString().equals(index[i])) continue;
                rootNode = (DefaultMutableTreeNode)rootNode.getChildAt(j);
                isFound = true;
                break;
            }
            if (isFound) continue;
            return null;
        }
        return rootNode;
    }

    private boolean requestEditNode(DefaultMutableTreeNode node) {
        if (!ServerMessage.useServer) {
            this.nodeInEdit = node;
            return true;
        }
        DataRegClient.setDataRegLoc(this.dataSourceLoc);
        DataRegResult result = DataRegClient.editNode(node);
        if (result.success()) {
            this.nodeInEdit = result.root();
        } else {
            String nodePath = XmlNodePath.valueOf(node).toString();
            String lockedNodePath = result.getLockedNodePath();
            boolean isChildLocked = lockedNodePath != null && !lockedNodePath.equals(nodePath) && lockedNodePath.indexOf(nodePath) == 0;
            boolean isParentLocked = lockedNodePath != null && !lockedNodePath.equals(nodePath) && nodePath.indexOf(lockedNodePath) == 0;
            Hashtable userHostInfo = this.parseUserHostAddr(result.getLockedUserHostAddr());
            String lockedUserName = (String)userHostInfo.get("OrgUserName");
            String lockedFromIP = (String)userHostInfo.get("IPAddress");
            if (!this.isSameUserName(result.getLockedUserHostAddr()) && !this.isAdmin()) {
                new JMessageDialog((Dialog)this.manager, "Info", "The node is locked by " + lockedUserName + " from " + lockedFromIP);
                return false;
            }
            if (isChildLocked) {
                new JMessageDialog((Dialog)this.manager, "Info", "Can not edit the node, because the child node " + result.getLockedNodePath() + "\nis locked by " + lockedUserName + " from " + lockedFromIP + ". \nPlease override the child node first");
                return false;
            }
            if (isParentLocked) {
                new JMessageDialog((Dialog)this.manager, "Info", "Can not edit the node, because the parent node " + result.getLockedNodePath() + "\nis locked by " + lockedUserName + " from " + lockedFromIP + ". \nPlease override the parent node first");
                return false;
            }
            try {
                boolean overrided = this.overrideNodeLock(node);
                if (!overrided) {
                    this.nodeInEdit = node;
                    return false;
                }
                this.nodeInEdit = node;
                this.updateDataSource(DataRegClient.getRoot());
                this.expandToNode(this.nodeInEdit);
                return this.requestEditNode(node);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        this.updateDataSource(DataRegClient.getRoot());
        this.expandToNode(this.nodeInEdit);
        return this.nodeInEdit != null;
    }

    private void closeEditNode() {
        if (!ServerMessage.useServer) {
            return;
        }
        try {
            if (this.manager.isVisible()) {
                String lockOverrideHostAddr = DataRegClient.isNodeLockOverrided(this.nodeInEdit);
                if (!lockOverrideHostAddr.equals("")) {
                    new JMessageDialog((Dialog)this.manager, "Info", "The node lock has been overrided, you have to re-open the node");
                    DataRegClient.clearOverrideLock();
                } else {
                    DataRegClient.closeEditNode();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), "Error occurs when closing Edit node: " + e.getMessage());
        }
    }

    private boolean requestAddNode(DefaultMutableTreeNode node) {
        if (!ServerMessage.useServer) {
            this.nodeInEdit = node;
            return true;
        }
        DataRegClient.setDataRegLoc(this.dataSourceLoc);
        DataRegResult result = DataRegClient.addNode(node);
        if (result.success()) {
            this.nodeInEdit = result.root();
        } else {
            String nodePath = XmlNodePath.valueOf(node).toString();
            String lockedNodePath = result.getLockedNodePath();
            boolean isChildLocked = lockedNodePath != null && !lockedNodePath.equals(nodePath) && lockedNodePath.indexOf(nodePath) == 0;
            boolean isParentLocked = lockedNodePath != null && !lockedNodePath.equals(nodePath) && nodePath.indexOf(lockedNodePath) == 0;
            Hashtable userHostInfo = this.parseUserHostAddr(result.getLockedUserHostAddr());
            String lockedUserName = (String)userHostInfo.get("OrgUserName");
            String lockedFromIP = (String)userHostInfo.get("IPAddress");
            if (!this.isSameUserName(result.getLockedUserHostAddr()) && !this.isAdmin()) {
                new JMessageDialog((Dialog)this.manager, "Info", "The node is locked by " + lockedUserName + " from " + lockedFromIP);
                return false;
            }
            if (isChildLocked) {
                new JMessageDialog((Dialog)this.manager, "Info", "Can not add the node, because the child node " + result.getLockedNodePath() + "\nis locked by " + lockedUserName + " from " + lockedFromIP + ". \nPlease override the child node first");
                return false;
            }
            if (isParentLocked) {
                new JMessageDialog((Dialog)this.manager, "Info", "Can not add the node, because the parent node " + result.getLockedNodePath() + "\nis locked by " + lockedUserName + " from " + lockedFromIP + ". \nPlease override the parent node first");
                return false;
            }
            try {
                boolean overrided = this.overrideNodeLock(node);
                if (!overrided) {
                    this.nodeInEdit = node;
                    return false;
                }
                this.nodeInEdit = node;
                this.updateDataSource(DataRegClient.getRoot());
                this.expandToNode(this.nodeInEdit);
                return this.requestAddNode(this.getSelectedNode());
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        this.updateDataSource(DataRegClient.getRoot());
        this.expandToNode(this.nodeInEdit);
        return this.nodeInEdit != null;
    }

    private void closeAddNode() {
        this.closeAddNode(false, null);
    }

    private void closeAddNode(DefaultMutableTreeNode child) {
        this.closeAddNode(false, child);
    }

    private void closeAddNode(boolean cancel, DefaultMutableTreeNode child) {
        if (!ServerMessage.useServer) {
            return;
        }
        if (!this.manager.canModify() || this.readOnly) {
            return;
        }
        try {
            if (cancel) {
                DataRegClient.closeAddNode(null);
                if (this.nodeInEdit != null && this.nodeInEdit.getChildCount() != 0 && !(this.nodeInEdit instanceof DataViewNode)) {
                    this.nodeInEdit.remove(this.nodeInEdit.getChildCount() - 1);
                }
                this.updateDataSource(DataRegClient.getRoot());
                this.treeModel.reload();
                this.selectButton(this.nodeInEdit);
                return;
            }
            boolean givenChild = false;
            if (child == null) {
                child = this.getSelectedNode();
            } else {
                givenChild = true;
            }
            if (this.nodeInEdit.getChildCount() == 0) {
                DataRegClient.closeAddNode(null);
            } else if (givenChild || child != null && this.nodeInEdit == child.getParent()) {
                DataRegClient.closeAddNode(child);
            } else if (this.nodeInEdit == child) {
                DataRegClient.closeAddNode((DefaultMutableTreeNode)this.nodeInEdit.getLastChild());
            } else {
                DataRegClient.closeAddNode(null);
            }
        }
        catch (Exception e) {
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), e.getMessage());
            e.printStackTrace();
        }
    }

    public void addNodeNoClose(DefaultMutableTreeNode child) {
        if (!ServerMessage.useServer || child == null) {
            return;
        }
        if (!this.manager.canModify() || this.readOnly) {
            return;
        }
        try {
            DataRegClient.addNodeNoClose(child);
            this.updateDataSource(DataRegClient.getRoot());
        }
        catch (Exception e) {
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), e.getMessage());
            e.printStackTrace();
        }
    }

    public void closeEditOrAddNode() {
        this.closeEditOrAddNode(false);
    }

    public void closeEditOrAddNode(boolean cancel) {
        if (this.editMode) {
            this.closeEditNode();
        } else {
            this.closeAddNode(cancel, null);
        }
    }

    private boolean requestRemoveNode(DefaultMutableTreeNode node) {
        if (!ServerMessage.useServer) {
            return true;
        }
        try {
            DataRegClient.setDataRegLoc(this.dataSourceLoc);
            boolean success = DataRegClient.removeNode(node);
            this.updateDataSource(DataRegClient.getRoot());
            return success;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void expandToNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        TreePath treepath = new TreePath(node.getPath());
        this.tree.setSelectionPath(treepath);
        this.tree.expandPath(treepath);
    }

    private boolean overrideNodeLock(DefaultMutableTreeNode node) throws Exception {
        if (!ServerMessage.useServer) {
            return true;
        }
        String nodeLockString = DataRegClient.getNodeLockString(node);
        XmlNodePath xmlNodePath = XmlNodePath.valueOf(node);
        if (nodeLockString == null || nodeLockString.equals("")) {
            return true;
        }
        boolean isMyNodeLock = this.isSameUserName(nodeLockString) && !this.isSameToken(nodeLockString);
        Hashtable lockUserInfo = this.parseUserHostAddr(nodeLockString);
        if (isMyNodeLock) {
            JMessageDialog msgDialog;
            int response;
            int loc = nodeLockString.indexOf(63);
            String fromMachineName = nodeLockString;
            if (loc > 0) {
                fromMachineName = nodeLockString.substring(0, loc);
            }
            if ((response = (msgDialog = new JMessageDialog((Dialog)this.manager, "Question", "The Node is Locked by you on '" + fromMachineName + "',do you want to override the lock?", 2)).getResponse()) != 4) {
                return false;
            }
            DataRegClient.overrideNodeLockOnServer(xmlNodePath);
            return true;
        }
        if (this.isAdmin()) {
            String lockByIP = (String)lockUserInfo.get("IPAddress");
            String lockUserName = (String)lockUserInfo.get("OrgUserName");
            JMessageDialog msgDialog = new JMessageDialog((Dialog)this.manager, "Question", "The Node is Locked by '" + lockUserName + "' at " + lockByIP + ",do you want to override the lock?", 2);
            int response = msgDialog.getResponse();
            if (response != 4) {
                return false;
            }
            DataRegClient.overrideNodeLockOnServer(xmlNodePath);
            return true;
        }
        return true;
    }

    private boolean isSameUserName(String lockHostAddr) {
        int loc = lockHostAddr.indexOf(63);
        if (loc < 0) {
            return lockHostAddr.equals(ServerMessage.getAddress());
        }
        return lockHostAddr.indexOf("OrgUserName=" + ServerMessage.getOrgUserName()) > 0;
    }

    private boolean isAdmin() {
        if (ServerMessage.getOrgUserName() == null || !(this.manager.getInterchangeProcess() instanceof IDataInterchangeORG)) {
            return true;
        }
        IDataInterchangeORG ic = (IDataInterchangeORG)this.manager.getInterchangeProcess();
        return ic.isAdmin(ServerMessage.getOrgUserName());
    }

    private boolean isSameToken(String lockHostAddr) {
        int loc = lockHostAddr.indexOf(63);
        if (loc < 0) {
            return lockHostAddr.equals(ServerMessage.getAddress());
        }
        return lockHostAddr.indexOf("&OrgUserToken=" + ServerMessage.getOrgUserToken()) > 0;
    }

    private Hashtable parseUserHostAddr(String userHostAddr) {
        Hashtable<String, String> kvPair = new Hashtable<String, String>();
        int loc = userHostAddr.indexOf(63);
        if (loc < 0) {
            kvPair.put("IPAddress", userHostAddr);
            return kvPair;
        }
        kvPair.put("IPAddress", userHostAddr.substring(0, loc));
        String kvStr = userHostAddr.substring(loc + 1);
        StringTokenizer st = new StringTokenizer(kvStr, "&");
        while (st.hasMoreTokens()) {
            String pairStr = st.nextToken();
            loc = pairStr.indexOf(61);
            String key = pairStr.substring(0, loc);
            String val = pairStr.substring(loc + 1);
            kvPair.put(key, val);
        }
        return kvPair;
    }

    public boolean isFromOrganizer() {
        return this.manager != null && this.manager.isFromOrganizer();
    }

    public void resetSessionTimeoutInterval() {
        if (this.isFromOrganizer()) {
            OrganizerClient.resetJavaScriptSessionTimeout();
        }
    }
}

