/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.ManagerPane;

class PopupMenuForTree
extends JPopupMenu
implements ActionListener {
    private boolean isReady = false;
    private ManagerPane mgrPane;
    private DefaultMutableTreeNode node;

    public PopupMenuForTree(ManagerPane mgrPane) {
        this.mgrPane = mgrPane;
    }

    public void addMenu(DefaultMutableTreeNode node) {
        this.isReady = false;
        this.removeAll();
        this.node = node;
        if (this.mgrPane.isEditEnabled(node)) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Edit"), "Edit"));
        }
        if (this.mgrPane.isAddEnabled(node)) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Add"), "Add"));
        }
        if (this.mgrPane.isRemoveEnabled(node)) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Remove"), "Remove"));
        }
        this.isReady = true;
    }

    private JMenuItem newMenuItem(String s, String cmd) {
        JMenuItem m = new JMenuItem(s);
        m.setActionCommand(cmd);
        m.addActionListener(this);
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("Edit")) {
            this.mgrPane.doEdit(this.node);
        } else if (cmd.equals("Add")) {
            this.mgrPane.doAdd(this.node);
        } else if (cmd.equals("Remove")) {
            this.mgrPane.doRemove(this.node);
        } else {
            System.out.println("Action = " + cmd);
        }
    }
}

