/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.querybuilder.designer.QueryMain;

public class QueryNode
extends DefaultDataSourceNode {
    boolean useQueryBuilder;
    String sqlStatement;
    String queryFile = null;
    private boolean dictionary = false;
    private QueryInParamSet inSet = null;
    private byte[][] data = null;

    public QueryNode(String name) {
        super(name);
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public void setName(String name) {
        this.setUserObject(name);
    }

    public String getSQL() {
        return this.sqlStatement;
    }

    public void setSQL(String sql) {
        this.sqlStatement = sql;
    }

    public boolean isQueryBuilderUsed() {
        return this.useQueryBuilder;
    }

    public void setQueryBuilderUsed(boolean b) {
        this.useQueryBuilder = b;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public void setQueryFile(String qf) {
        this.queryFile = qf;
    }

    public boolean isDictionaryCompatible() {
        return this.dictionary;
    }

    public void setDictionaryCompatible(boolean d) {
        this.dictionary = d;
    }

    public QueryInParamSet getInSet() {
        return this.inSet;
    }

    public void setInSet(QueryInParamSet s) {
        this.inSet = s;
    }

    public void setBytes(byte[] bytes) {
        if (bytes != null) {
            this.data = new byte[1][];
            this.data[0] = bytes;
        } else {
            this.data = null;
        }
    }

    public byte[][] getBytes() {
        if (this.queryFile == null) {
            return null;
        }
        if (this.data != null) {
            return this.data;
        }
        try {
            ReadDataFile readfile = new ReadDataFile();
            String file = QueryMain.QUERYDIR + this.queryFile;
            if (!file.toUpperCase().endsWith(".qry".toUpperCase())) {
                file = file + ".qry";
            }
            DataInputStream in = readfile.getInputStream(file);
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            int c = in.read();
            while (c != -1) {
                bstream.write(c);
                c = in.read();
            }
            in.close();
            bstream.close();
            byte[] barray = bstream.toByteArray();
            this.data = new byte[1][];
            this.data[0] = barray;
            return this.data;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

