/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLUtil;
import quadbase.datasourcemanager.manager.BigDataNode;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.SOAPDataSourceNode;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceDataSourceNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;

public class ReadXMLDataSources {
    public static final int ELEMENT_TYPE = 1;
    public static final int ATTR_TYPE = 2;
    public static final int TEXT_TYPE = 3;
    public static final int CDATA_TYPE = 4;
    public static final int ENTITYREF_TYPE = 5;
    public static final int ENTITY_TYPE = 6;
    public static final int PROCINSTR_TYPE = 7;
    public static final int COMMENT_TYPE = 8;
    public static final int DOCUMENT_TYPE = 9;
    public static final int DOCTYPE_TYPE = 10;
    public static final int DOCFRAG_TYPE = 11;
    public static final int NOTATION_TYPE = 12;
    public static final String DATASOURCES = "DataSources";
    public static final String DATABASES = "Databases";
    public static final String BIGDATAS = "BigDatas";
    public static final String XMLFILES = "XMLFiles";
    public static final String TXTFILES = "TXTFiles";
    public static final String CLASSFILES = "ClassFiles";
    public static final String EJBS = "EJBs";
    public static final String JNDIDATASOURCES = "JNDIDataSources";
    public static final String SOAPSERVICES = "SOAPServices";
    public static final String SALESFORCECONNECTIONS = "SalesForceConnections";
    public static final String EXCELFILES = "ExcelFiles";
    public static final String DATABASE = "Database";
    public static final String BIGDATA = "BigData";
    public static final String XMLFILE = "XMLFile";
    public static final String XMLQUERY = "XMLQuery";
    public static final String TXTFILE = "TXTFile";
    public static final String CLASSFILE = "ClassFile";
    public static final String JNDIDATASOURCE = "JNDIDataSource";
    public static final String SOAPSERVICE = "SOAPService";
    public static final String SOAPVIEW = "SOAPView";
    public static final String SALESFORCECONNECTION = "SalesForceConnection";
    public static final String SALESFORCEQUERY = "SalesForceQuery";
    public static final String SOQLQUERY = "SOQLQuery";
    public static final String EXCELFILE = "ExcelFile";
    public static final String QUERY = "Query";
    public static final String DATAVIEW = "DataView";
    public static final String EJB = "EJB";
    public static final String SQLSTATEMENT = "SQLStatement";
    public static final String DATAVIEWQUERY = "DataViewQuery";
    public static final String PARAMETER = "Parameter";
    public static final String FIELD = "SelectedField";
    public static final String CONDITION = "ConditionStatement";
    public static final String METHOD = "Method";
    public static final String PARAMTYPE = "ParamType";
    public static final String PARAMVALUE = "paramValue";
    public static final String RETURNTYPE = "ReturnType";
    public static final String SELECTED = "Selected";
    public static final String ENVIRONMENT = "Environment";
    public static final String DESCRIPTION = "Description";
    Document document;

    public ReadXMLDataSources(String uri) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(uri);
    }

    public ReadXMLDataSources(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(file);
    }

    public DefaultMutableTreeNode readTree() throws Exception {
        return this.readTree(this.document);
    }

    private DefaultMutableTreeNode readTree(Node domNode) throws Exception {
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1 && node.getNodeName().equalsIgnoreCase(DATASOURCES)) {
                return this.parseDataSource(node);
            }
            DefaultMutableTreeNode vec = this.readTree(node);
            if (vec == null) continue;
            return vec;
        }
        return null;
    }

    private DefaultMutableTreeNode getJNDIDataSources(Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(JNDIDATASOURCES);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(JNDIDATASOURCE);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            JNDIDataSourceNode subNode = new JNDIDataSourceNode(baseName);
            subNode.setJNDIName(this.getAttribute(node, "JNDIName"));
            subNode.setContextFactory(this.getAttribute(node, "Context_Factory"));
            subNode.setProviderURL(this.getAttribute(node, "Provider_URL"));
            String autoJoin = this.getAttribute(node, "autoJoin");
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            if (autoJoin != null) {
                subNode.setAutoJoin(Boolean.valueOf(autoJoin));
            }
            try {
                subNode.setTableNameFormat(Integer.parseInt(this.getAttribute(node, "tableNameFormat")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            DefaultDataSourceNode header = new DefaultDataSourceNode("Queries");
            subNode.add(this.getQueries(header, node));
            header = new DefaultDataSourceNode("Data Views");
            subNode.add(this.getDataViews(header, node));
            root.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(JNDIDATASOURCE), "name")).equals(firstSet));
        return root;
    }

    private DefaultMutableTreeNode getDatabase(Node domNode, boolean isDB) throws Exception {
        String baseName;
        DefaultDataSourceNode root = null;
        root = isDB ? new DefaultDataSourceNode(DATABASES) : new DefaultDataSourceNode(BIGDATAS);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = null;
        node = isDB ? xmlNode.getNextElement(DATABASE) : xmlNode.getNextElement(BIGDATA);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            String autoJoin;
            DatabaseNode subNode = isDB ? new DatabaseNode(baseName) : new BigDataNode(baseName);
            subNode.setURL(this.getAttribute(node, "url"));
            subNode.setDriver(this.getAttribute(node, "driver"));
            subNode.setLoginRequired(this.getBooleanAttribute(node, "requireLogin"));
            if (subNode.isLoginRequired()) {
                subNode.setUserName(this.getAttribute(node, "userName"));
                String enPass = this.getAttribute(node, "encryptedPassword");
                if (enPass != null) {
                    subNode.setPassword(Coder.decode(enPass));
                } else {
                    subNode.setPassword(this.getAttribute(node, "password"));
                }
            }
            if ((autoJoin = this.getAttribute(node, "autoJoin")) != null) {
                subNode.setAutoJoin(Boolean.valueOf(autoJoin));
            }
            try {
                subNode.setTableNameFormat(Integer.parseInt(this.getAttribute(node, "tableNameFormat")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            subNode.setAdditionalDb(this.getAttribute(node, "additionalDb"));
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            DefaultDataSourceNode header = new DefaultDataSourceNode("Queries");
            subNode.add(this.getQueries(header, node));
            header = new DefaultDataSourceNode("Data Views");
            subNode.add(this.getDataViews(header, node));
            root.add(subNode);
        } while (!(baseName = this.getAttribute(node = isDB ? xmlNode.getNextElement(DATABASE) : xmlNode.getNextElement(BIGDATA), "name")).equals(firstSet));
        return root;
    }

    private DefaultMutableTreeNode getQueries(DefaultMutableTreeNode qNode, Node domNode) throws Exception {
        String baseName;
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(QUERY);
        if (node == null) {
            return qNode;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            XMLNode sqlNode;
            Node tmp;
            QueryNode subNode = new QueryNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            subNode.setQueryBuilderUsed(this.getBooleanAttribute(node, "useQueryBuilder"));
            if (subNode.isQueryBuilderUsed()) {
                String queryfile = this.getAttribute(node, "queryFile");
                if (queryfile == null) {
                    queryfile = baseName;
                }
                subNode.setQueryFile(queryfile);
                subNode.setDictionaryCompatible(this.getBooleanAttribute(node, "dictionary"));
            }
            if ((tmp = (sqlNode = new XMLNode(node)).getNextElement(SQLSTATEMENT)) != null) {
                subNode.setSQL(ReadXMLDataSources.getData(tmp));
            }
            subNode.setInSet(this.getQueryParamSet(node));
            qNode.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(QUERY), "name")).equals(firstSet));
        return qNode;
    }

    private DefaultMutableTreeNode getDataViews(DefaultMutableTreeNode qNode, Node domNode) throws Exception {
        String baseName;
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(DATAVIEW);
        if (node == null) {
            return qNode;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            DataViewNode subNode = new DataViewNode(baseName);
            subNode.setQueryFile(this.getAttribute(node, "queryFile"));
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            qNode.add(this.getDataViewQueries(subNode, node));
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(DATAVIEW), "name")).equals(firstSet));
        return qNode;
    }

    private DefaultMutableTreeNode getDataViewQueries(DefaultMutableTreeNode qNode, Node domNode) throws Exception {
        String baseName;
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(DATAVIEWQUERY);
        if (node == null) {
            return qNode;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            DataViewQueryNode subNode = new DataViewQueryNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            String queryfile = this.getAttribute(node, "queryFile");
            if (queryfile == null) {
                queryfile = baseName;
            }
            subNode.setQueryFile(queryfile);
            queryfile = this.getAttribute(node, "dataviewFile");
            if (queryfile == null) {
                queryfile = baseName;
            }
            subNode.setDataViewFile(queryfile);
            XMLNode sqlNode = new XMLNode(node);
            Node tmp = sqlNode.getNextElement(SQLSTATEMENT);
            if (tmp != null) {
                subNode.setSQL(ReadXMLDataSources.getData(tmp));
            }
            qNode.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(DATAVIEWQUERY), "name")).equals(firstSet));
        return qNode;
    }

    private DefaultMutableTreeNode getXMLFiles(Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(XMLFILES);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(XMLFILE);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            XMLFileNode subNode = new XMLFileNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            subNode.setFile(this.getAttribute(node, "location"));
            subNode.setQBFormat(this.getBooleanAttribute(node, "isQBFormat"));
            subNode.setVerify(this.getBooleanAttribute(node, "verify"));
            subNode.setDTD(this.getAttribute(node, "dtd"));
            subNode.setDTDTreeFileName(this.getAttribute(node, "dtdTreeFileName"));
            this.addXMLQueries(subNode, node);
            root.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(XMLFILE), "name")).equals(firstSet));
        return root;
    }

    private void addXMLQueries(DefaultMutableTreeNode qNode, Node domNode) throws Exception {
        String baseName;
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(XMLQUERY);
        if (node == null) {
            return;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            Node tmp;
            XMLQueryNode subNode = new XMLQueryNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            int count = Integer.parseInt(this.getAttribute(node, "fieldCt"));
            Vector<XMLFieldInfo> fields = new Vector<XMLFieldInfo>();
            XMLNode fieldNode = new XMLNode(node);
            for (int i = 0; i < count; ++i) {
                tmp = fieldNode.getNextElement(FIELD);
                if (tmp == null) continue;
                XMLFieldInfo field = new XMLFieldInfo();
                String pathStr = this.getAttribute(tmp, "path");
                String[] path = XMLFieldInfo.createPathFromString(pathStr);
                int xmlType = Integer.parseInt(this.getAttribute(tmp, "xmltype"));
                boolean isExpandable = this.getBooleanAttribute(tmp, "isExpandable");
                boolean isRequired = this.getBooleanAttribute(tmp, "isRequired");
                String alias = this.getAttribute(tmp, "alias");
                if (alias.trim().equals("")) {
                    alias = null;
                }
                field.setPath(path);
                field.setXMLType(xmlType);
                field.setIsExpandable(isExpandable);
                field.setIsRequired(isRequired);
                field.setAlias(alias);
                if (xmlType == 1) {
                    String eltDataType = this.getAttribute(tmp, "eltDataType");
                    field.setElementDataType(eltDataType);
                    String dateFormat = this.getAttribute(tmp, "dateFormat");
                    if (dateFormat == null || dateFormat.trim().equals("")) {
                        field.setDateFormat(null);
                    } else {
                        field.setDateFormat(dateFormat);
                    }
                    field.setAttributeDataType(null);
                } else if (xmlType == 2) {
                    String attrName = this.getAttribute(tmp, "attrName");
                    String attrDataType = this.getAttribute(tmp, "attrDataType");
                    field.setAttributeName(attrName);
                    field.setAttributeDataType(attrDataType);
                    String dateFormat = this.getAttribute(tmp, "dateFormat");
                    if (dateFormat == null || dateFormat.trim().equals("")) {
                        field.setDateFormat(null);
                    } else {
                        field.setDateFormat(dateFormat);
                    }
                    field.setElementDataType(null);
                }
                fields.addElement(field);
            }
            XMLNode queryNode = new XMLNode(node);
            tmp = queryNode.getNextElement(CONDITION);
            if (tmp != null) {
                subNode.setConditionStatement(ReadXMLDataSources.getData(tmp));
            }
            subNode.setSelectedFields(fields);
            subNode.setInSet(this.getQueryParamSet(node));
            qNode.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(XMLQUERY), "name")).equals(firstSet));
    }

    private DefaultMutableTreeNode getTXTFiles(Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(TXTFILES);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(TXTFILE);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            TextFileNode subNode = new TextFileNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            subNode.setFile(this.getAttribute(node, "location"));
            root.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(TXTFILE), "name")).equals(firstSet));
        return root;
    }

    private DefaultMutableTreeNode getExcelFiles(Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(EXCELFILES);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(EXCELFILE);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            ExcelFileNode subNode = new ExcelFileNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            String filename = this.getAttribute(node, "filename");
            String sheetName = this.getAttribute(node, "sheetName");
            int minRow = 0;
            int minColumn = 0;
            int maxRow = -1;
            int maxColumn = -1;
            boolean includeNewData = false;
            if (this.getAttribute(node, "minRow") != null) {
                minRow = Integer.parseInt(this.getAttribute(node, "minRow"));
                minColumn = Integer.parseInt(this.getAttribute(node, "minColumn"));
                maxRow = Integer.parseInt(this.getAttribute(node, "maxRow"));
                maxColumn = Integer.parseInt(this.getAttribute(node, "maxColumn"));
                includeNewData = Boolean.valueOf(this.getAttribute(node, "includeNewData"));
            }
            boolean hasHeader = Boolean.valueOf(this.getAttribute(node, "hasHeader"));
            boolean dataAreRows = Boolean.valueOf(this.getAttribute(node, "dataAreRows"));
            int[] dataTypes = null;
            NodeList typeList = ((Element)node).getElementsByTagName("DATATYPE");
            if (typeList != null && typeList.getLength() > 0) {
                dataTypes = new int[typeList.getLength()];
                for (int i = 0; i < typeList.getLength(); ++i) {
                    dataTypes[i] = Integer.parseInt(XMLUtil.readCDATA(typeList.item(i)));
                }
            }
            subNode.setFilename(filename);
            subNode.setSheetName(sheetName);
            subNode.setMinRow(minRow);
            subNode.setMinColumn(minColumn);
            subNode.setMaxRow(maxRow);
            subNode.setMaxColumn(maxColumn);
            subNode.setIncludeNewData(includeNewData);
            subNode.setHasHeader(hasHeader);
            subNode.setDataAreRows(dataAreRows);
            subNode.setDataTypes(dataTypes);
            root.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(EXCELFILE), "name")).equals(firstSet));
        return root;
    }

    private DefaultMutableTreeNode getSOAPServices(Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(SOAPSERVICES);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(SOAPSERVICE);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            SOAPDataSourceNode subNode = new SOAPDataSourceNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            String wsdlUri = this.getAttribute(node, "wsdlUri");
            if (wsdlUri == null) continue;
            subNode.setWsdlURI(wsdlUri);
            this.addSOAPView(subNode, node);
            root.add(subNode);
            node = xmlNode.getNextElement(SOAPSERVICE);
            baseName = this.getAttribute(node, "name");
        } while (!baseName.equals(firstSet));
        return root;
    }

    private DefaultMutableTreeNode addSOAPView(DefaultMutableTreeNode qNode, Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(SOAPVIEW);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(SOAPVIEW);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            SOAPViewNode subNode = new SOAPViewNode(baseName);
            String id = this.getAttribute(node, "id");
            subNode.setID(id);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            String serviceNameNamespace = this.getAttribute(node, "serviceNameNamespace");
            String serviceNameLocalName = this.getAttribute(node, "serviceNameLocalName");
            subNode.setServiceName(new QName(serviceNameNamespace, serviceNameLocalName));
            subNode.setPortName(this.getAttribute(node, "portName"));
            subNode.setOperationName(this.getAttribute(node, "operationName"));
            subNode.setSchemaTreeFileName(this.getAttribute(node, "schemaTreeFileName"));
            subNode.setReturnParamName(this.getAttribute(node, "returnParamName"));
            subNode.setParameters(SOAPParam.readArrayXML(node));
            qNode.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(SOAPVIEW), "name")).equals(firstSet));
        return root;
    }

    private DefaultMutableTreeNode getClassFiles(Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(CLASSFILES);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(CLASSFILE);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            ClassFileNode subNode = new ClassFileNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            subNode.setFile(this.getAttribute(node, "location"));
            root.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(CLASSFILE), "name")).equals(firstSet));
        return root;
    }

    private DefaultMutableTreeNode getSalesForceConnections(Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(SALESFORCECONNECTIONS);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(SALESFORCECONNECTION);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            SalesForceDataSourceNode subNode = new SalesForceDataSourceNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            subNode.setUserName(this.getAttribute(node, "username"));
            String enPass = this.getAttribute(node, "encryptedPassword");
            if (enPass != null) {
                subNode.setPassword(Coder.decode(enPass));
            } else {
                subNode.setPassword(this.getAttribute(node, "password"));
            }
            root.add(subNode);
            this.addSalesForceQueries(subNode, node);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(SALESFORCECONNECTION), "name")).equals(firstSet));
        return root;
    }

    private void addSalesForceQueries(DefaultMutableTreeNode qNode, Node domNode) throws Exception {
        String baseName;
        if (domNode == null) {
            return;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(SALESFORCEQUERY);
        if (node == null) {
            return;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            SalesForceQueryNode subNode = new SalesForceQueryNode(baseName);
            String id = this.getAttribute(node, "id");
            subNode.setID(id);
            XMLNode queryNode = new XMLNode(node);
            Node soqlQuery = queryNode.getNextElement(SOQLQUERY);
            if (soqlQuery != null) {
                subNode.setQuery(ReadXMLDataSources.getData(soqlQuery));
            }
            qNode.add(subNode);
            Node params = queryNode.getNextElement("QUERY_PARAMETER_SET");
            if (params == null) continue;
            subNode.setInSet(QueryInParamSet.readXML(params, 361));
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(SALESFORCEQUERY), "name")).equals(firstSet));
    }

    private DefaultMutableTreeNode getEJBs(Node domNode) throws Exception {
        String baseName;
        DefaultDataSourceNode root = new DefaultDataSourceNode(EJBS);
        if (domNode == null) {
            return root;
        }
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(EJB);
        if (node == null) {
            return root;
        }
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            String methodname;
            Node tmp;
            int i;
            EJBNode subNode = new EJBNode(baseName);
            String ID = this.getAttribute(node, "id");
            subNode.setID(ID);
            String descr = ReadXMLDataSources.getNodeDescription(node);
            subNode.setDescription(descr);
            subNode.setJNDIName(this.getAttribute(node, "jndiname"));
            subNode.setHomeName(this.getAttribute(node, "homename"));
            subNode.setRemoteName(this.getAttribute(node, "remotename"));
            int count = Integer.parseInt(this.getAttribute(node, "size"));
            String envSizeStr = this.getAttribute(node, "envsize");
            int envsize = 0;
            if (envSizeStr != null) {
                envsize = Integer.parseInt(envSizeStr);
            }
            String[] methods = new String[count];
            Hashtable<String, Class[]> paramTable = new Hashtable<String, Class[]>();
            Hashtable retTable = new Hashtable();
            Hashtable<String, Object[]> valueTable = new Hashtable<String, Object[]>();
            XMLNode methodNode = new XMLNode(node);
            for (i = 0; i < count; ++i) {
                tmp = methodNode.getNextElement(METHOD);
                if (tmp == null) continue;
                methods[i] = this.getAttribute(tmp, "name");
            }
            methodNode = new XMLNode(node);
            for (i = 0; i < count; ++i) {
                tmp = methodNode.getNextElement(PARAMTYPE);
                if (tmp == null) continue;
                methodname = this.getAttribute(tmp, "methodname");
                int paramSize = Integer.parseInt(this.getAttribute(tmp, "size"));
                Class[] param = new Class[paramSize];
                for (int j = 0; j < paramSize; ++j) {
                    String paramType = this.getAttribute(tmp, "param" + (j + 1));
                    param[j] = EJBUtil.mapTypeToClass(paramType);
                }
                paramTable.put(methodname, param);
            }
            methodNode = new XMLNode(node);
            for (i = 0; i < count; ++i) {
                tmp = methodNode.getNextElement(RETURNTYPE);
                if (tmp == null) continue;
                methodname = this.getAttribute(tmp, "methodname");
                String returnType = this.getAttribute(tmp, "returntype");
                Class<?> retType = Class.forName(returnType);
                retTable.put(methodname, retType);
            }
            methodNode = new XMLNode(node);
            for (i = 0; i < count; ++i) {
                tmp = methodNode.getNextElement("ParamValue");
                if (tmp == null) continue;
                methodname = this.getAttribute(tmp, "methodname");
                int valueSize = Integer.parseInt(this.getAttribute(tmp, "size"));
                Object[] values = new Object[valueSize];
                XMLNode valueNode = new XMLNode(tmp);
                for (int j = 0; j < valueSize; ++j) {
                    Node tmpNode = valueNode.getNextElement("Value");
                    String valueType = this.getAttribute(tmpNode, "type");
                    String value = this.getAttribute(tmpNode, "value");
                    values[j] = EJBUtil.getRuntimeInputValue(valueType, value);
                }
                valueTable.put(methodname, values);
            }
            methodNode = new XMLNode(node);
            Node tmp2 = methodNode.getNextElement(SELECTED);
            String methodname2 = this.getAttribute(tmp2, "name");
            methodNode = new XMLNode(node);
            Hashtable<String, String> env = null;
            if (envsize > 0) {
                env = new Hashtable<String, String>();
                for (int i2 = 0; i2 < envsize; ++i2) {
                    Node tmp22 = methodNode.getNextElement(ENVIRONMENT);
                    if (tmp22 == null) continue;
                    String key = this.getAttribute(tmp22, "name");
                    String val = this.getAttribute(tmp22, "value");
                    env.put(key, val);
                }
            }
            subNode.setMethods(methods);
            subNode.setParamTable(paramTable);
            subNode.setRetTable(retTable);
            subNode.setValueTable(valueTable);
            subNode.setSelectedMethod(methodname2);
            subNode.setEnvironment(env);
            root.add(subNode);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(EJB), "name")).equals(firstSet));
        return root;
    }

    private QueryInParamSet getQueryParamSet(Node domNode) throws Exception {
        String baseName;
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(PARAMETER);
        if (node == null) {
            node = xmlNode.getNextElement("QUERY_PARAMETER_SET");
            if (node != null) {
                try {
                    return QueryInParamSet.readXML(node, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        Vector<QueryInParam> vect = new Vector<QueryInParam>();
        String firstSet = baseName = this.getAttribute(node, "name");
        do {
            Node indexNode;
            String prompt = this.getAttribute(node, "prompt");
            boolean mapToColumn = this.getBooleanAttribute(node, "mapToColumn");
            String table = this.getAttribute(node, "table");
            String column = this.getAttribute(node, "column");
            int sqlType = Integer.parseInt(this.getAttribute(node, "sqlType"));
            boolean isMultiValue = this.getBooleanAttribute(node, "multiValue");
            XMLNode paramNode = new XMLNode(node);
            Node defaultNode = paramNode.getNextElement("Default");
            Object defaultValue = null;
            if (defaultNode != null) {
                defaultValue = DataType.read(ReadXMLDataSources.getData(defaultNode));
            }
            if ((indexNode = paramNode.getNextElement("Index")) == null) continue;
            Integer firstInt = Integer.valueOf(ReadXMLDataSources.getData(indexNode));
            Integer index = (int)firstInt;
            Vector<Integer> indices = new Vector<Integer>();
            do {
                indices.addElement(index);
                indexNode = paramNode.getNextElement("Index");
                if (indexNode == null) continue;
                index = Integer.valueOf(ReadXMLDataSources.getData(indexNode));
            } while (indexNode != null && !firstInt.equals(index));
            int[] paramMap = new int[indices.size()];
            for (int i = 0; i < indices.size(); ++i) {
                paramMap[i] = (Integer)indices.elementAt(i);
            }
            QueryInParam param = null;
            param = !isMultiValue ? new QueryInParam(paramMap, baseName, prompt, mapToColumn, table, column, sqlType, defaultValue, null) : new QueryMultiValueInParam(paramMap, baseName, prompt, mapToColumn, table, column, sqlType, defaultValue, (Object)null, null);
            vect.addElement(param);
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement(PARAMETER), "name")).equals(firstSet));
        QueryInParam[] ps = vect.toArray(new QueryInParam[0]);
        return new QueryInParamSet(ps);
    }

    private DefaultMutableTreeNode parseDataSource(Node domNode) throws Exception {
        DefaultDataSourceNode root = new DefaultDataSourceNode(DATASOURCES);
        String lastID = this.getAttribute(domNode, "lastID");
        String registryID = this.getAttribute(domNode, "registryID");
        root.setLastID(lastID);
        root.setRegistryID(registryID);
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(DATABASES);
        root.add(this.getDatabase(node, true));
        node = xmlNode.getNextElement(BIGDATAS);
        root.add(this.getDatabase(node, false));
        node = xmlNode.getNextElement(JNDIDATASOURCES);
        root.add(this.getJNDIDataSources(node));
        node = xmlNode.getNextElement(XMLFILES);
        root.add(this.getXMLFiles(node));
        node = xmlNode.getNextElement(TXTFILES);
        root.add(this.getTXTFiles(node));
        node = xmlNode.getNextElement(CLASSFILES);
        root.add(this.getClassFiles(node));
        node = xmlNode.getNextElement(EJBS);
        root.add(this.getEJBs(node));
        node = xmlNode.getNextElement(SOAPSERVICES);
        root.add(this.getSOAPServices(node));
        node = xmlNode.getNextElement(SALESFORCECONNECTIONS);
        root.add(this.getSalesForceConnections(node));
        node = xmlNode.getNextElement(EXCELFILES);
        root.add(this.getExcelFiles(node));
        return root;
    }

    private String getAttribute(Node domNode, String attr) {
        NamedNodeMap nodeMap = domNode.getAttributes();
        Node node = nodeMap.getNamedItem(attr);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private boolean getBooleanAttribute(Node domNode, String str) {
        return Boolean.valueOf(this.getAttribute(domNode, str));
    }

    public static String getData(Node domNode) {
        if (domNode == null) {
            return "";
        }
        NodeList nodeList = domNode.getChildNodes();
        String s = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                s = s + ReadXMLDataSources.getData(node);
                continue;
            }
            if (type == 3) {
                s = s + node.getNodeValue();
                continue;
            }
            if (type == 5) {
                s = s + ReadXMLDataSources.getData(node);
                continue;
            }
            if (type != 4) continue;
            s = s + node.getNodeValue();
        }
        return s;
    }

    private static String getNodeDescription(Node domNode) {
        if (!domNode.hasChildNodes()) {
            return "";
        }
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(DESCRIPTION)) continue;
            return ReadXMLDataSources.getData(child);
        }
        return "";
    }

    public Document getDocument() {
        return this.document;
    }
}

