/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.namespace.QName;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.FixedVersionDataOutput;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.datasourcemanager.manager.BigDataNode;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.ReadXMLDataSources;
import quadbase.datasourcemanager.manager.SOAPDataSourceNode;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceDataSourceNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;

public class ReadXMLTable {
    public static final String DATASOURCES = "DataSources";
    public static final String DATABASES = "Databases";
    public static final String BIGDATAS = "BigDatas";
    public static final String JNDIDATASOURCES = "JNDIDataSources";
    public static final String XMLFILES = "XMLFiles";
    public static final String TXTFILES = "TXTFiles";
    public static final String CLASSFILES = "ClassFiles";
    public static final String EJBS = "EJBs";
    public static final String SOAPSERVICES = "SOAPServices";
    public static final String SALESFORCECONNECTIONS = "SalesForceConnections";
    public static final String EXCELFILES = "ExcelFiles";
    public static final String DATABASE = "Database";
    public static final String BIGDATA = "BigData";
    public static final String JNDIDATASOURCE = "JNDIDataSource";
    public static final String XMLFILE = "XMLFile";
    public static final String XMLQUERY = "XMLQuery";
    public static final String TXTFILE = "TXTFile";
    public static final String CLASSFILE = "ClassFile";
    public static final String QUERY = "Query";
    public static final String QUERIES = "Queries";
    public static final String DATAVIEWS = "Data Views";
    public static final String EJB = "EJB";
    public static final String SOAPSERVICE = "SOAPService";
    public static final String SOAPVIEW = "SOAPView";
    public static final String SALESFORCECONNECTION = "SalesForceConnection";
    public static final String FIELD = "SelectedField";
    public static final String CONDITION = "ConditionStatement";
    public static final String METHOD = "Method";
    public static final String PARAMTYPE = "ParamType";
    public static final String PARAMVALUE = "ParamValue";
    public static final String RETURNTYPE = "ReturnType";
    public static final String SELECTED = "Selected";
    public static final String ENVIRONMENT = "Environment";
    private static final int DATABASENODE = 1;
    private static final int QUERYNODE = 2;
    private static final int TEXTFILENODE = 3;
    private static final int XMLFILENODE = 4;
    private static final int DATAVIEWNODE = 5;
    private static final int DATAVIEWQUERYNODE = 6;
    private static final int EJBNODE = 7;
    private static final int CLASSFILENODE = 8;
    private static final int OTHER = 0;
    private static final int XMLQUERYNODE = 9;
    private static final int JNDIDATASOURCENODE = 10;
    private static final int PARAMQUERYNODE = 100;
    private static final int SOAPDATASOURCENODE = 11;
    private static final int SOAPVIEWNODE = 12;
    private static final int SALESFORCECONNECTIONNODE = 13;
    private static final int SALESFORCEQUERYNODE = 14;
    private static final int EXCELFILENODE = 15;
    private static final int BIGDATANODE = 16;
    private String readOnly = null;

    public static void writeNode(DefaultMutableTreeNode tnode, DataOutputStream dout) throws Exception {
        int i;
        DefaultDataSourceNode node;
        if (tnode instanceof BigDataNode) {
            dout.writeInt(16);
            node = (BigDataNode)tnode;
            IOUtil.writeString(dout, ((DatabaseNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((DatabaseNode)node).getDriver());
            IOUtil.writeString(dout, ((DatabaseNode)node).getURL());
            dout.writeBoolean(((DatabaseNode)node).isLoginRequired());
            dout.writeBoolean(((DatabaseNode)node).isPasswordSaved());
            if (((DatabaseNode)node).isPasswordSaved()) {
                IOUtil.writeString(dout, ((DatabaseNode)node).getUserName());
                IOUtil.writeString(dout, ((DatabaseNode)node).getPassword());
            }
            dout.writeBoolean(((DatabaseNode)node).isAutoJoin());
            dout.writeInt(((DatabaseNode)node).getTableNameFormat());
            dout.writeInt(((DatabaseNode)node).getAdditionalDbSize());
            for (int i2 = 0; i2 < ((DatabaseNode)node).getAdditionalDbSize(); ++i2) {
                IOUtil.writeString(dout, (String)((DatabaseNode)node).getAdditionalDb().get(i2));
            }
        } else if (tnode instanceof DatabaseNode) {
            dout.writeInt(1);
            node = (DatabaseNode)tnode;
            IOUtil.writeString(dout, ((DatabaseNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((DatabaseNode)node).getDriver());
            IOUtil.writeString(dout, ((DatabaseNode)node).getURL());
            dout.writeBoolean(((DatabaseNode)node).isLoginRequired());
            dout.writeBoolean(((DatabaseNode)node).isPasswordSaved());
            if (((DatabaseNode)node).isPasswordSaved()) {
                IOUtil.writeString(dout, ((DatabaseNode)node).getUserName());
                IOUtil.writeString(dout, ((DatabaseNode)node).getPassword());
            }
            dout.writeBoolean(((DatabaseNode)node).isAutoJoin());
            dout.writeInt(((DatabaseNode)node).getTableNameFormat());
            dout.writeInt(((DatabaseNode)node).getAdditionalDbSize());
            for (int i3 = 0; i3 < ((DatabaseNode)node).getAdditionalDbSize(); ++i3) {
                IOUtil.writeString(dout, (String)((DatabaseNode)node).getAdditionalDb().get(i3));
            }
        } else if (tnode instanceof SOAPDataSourceNode) {
            dout.writeInt(11);
            node = (SOAPDataSourceNode)tnode;
            IOUtil.writeString(dout, ((SOAPDataSourceNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((SOAPDataSourceNode)node).getWsdlURI());
        } else if (tnode instanceof SOAPViewNode) {
            dout.writeInt(12);
            node = (SOAPViewNode)tnode;
            IOUtil.writeString(dout, node.getUserObject().toString());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((SOAPViewNode)node).getServiceName().getNamespaceURI());
            IOUtil.writeString(dout, ((SOAPViewNode)node).getServiceName().getLocalPart());
            IOUtil.writeString(dout, ((SOAPViewNode)node).getPortName());
            IOUtil.writeString(dout, ((SOAPViewNode)node).getOperationName());
            IOUtil.writeStr(dout, ((SOAPViewNode)node).getSchemaTreeFileName());
            IOUtil.writeStr(dout, ((SOAPViewNode)node).getReturnParamName());
            SOAPParam.writeArray(new FixedVersionDataOutput(dout, 6612), ((SOAPViewNode)node).getParameters());
        } else if (tnode instanceof JNDIDataSourceNode) {
            dout.writeInt(10);
            node = (JNDIDataSourceNode)tnode;
            IOUtil.writeString(dout, ((JNDIDataSourceNode)node).getName());
            IOUtil.writeString(dout, ((JNDIDataSourceNode)node).getJNDIName());
            IOUtil.writeString(dout, ((JNDIDataSourceNode)node).getContextFactory());
            IOUtil.writeString(dout, ((JNDIDataSourceNode)node).getProviderURL());
            dout.writeBoolean(((JNDIDataSourceNode)node).isAutoJoin());
            dout.writeInt(((JNDIDataSourceNode)node).getTableNameFormat());
        } else if (tnode instanceof QueryNode) {
            dout.writeInt(100);
            dout.writeInt(6612);
            node = (QueryNode)tnode;
            IOUtil.writeString(dout, ((QueryNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeLongString(dout, ((QueryNode)node).getSQL());
            dout.writeBoolean(((QueryNode)node).isQueryBuilderUsed());
            if (((QueryNode)node).isQueryBuilderUsed()) {
                IOUtil.writeString(dout, ((QueryNode)node).getQueryFile());
                dout.writeBoolean(((QueryNode)node).isDictionaryCompatible());
            }
            if (((QueryNode)node).getInSet() == null) {
                dout.writeInt(0);
            } else {
                ((QueryNode)node).getInSet().write(dout);
            }
        } else if (tnode instanceof TextFileNode) {
            dout.writeInt(3);
            node = (TextFileNode)tnode;
            IOUtil.writeString(dout, ((TextFileNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((TextFileNode)node).getFile());
        } else if (tnode instanceof XMLFileNode) {
            dout.writeInt(4);
            dout.writeInt(1);
            node = (XMLFileNode)tnode;
            IOUtil.writeString(dout, ((XMLFileNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((XMLFileNode)node).getFile());
            dout.writeBoolean(((XMLFileNode)node).isQBFormat());
            dout.writeBoolean(((XMLFileNode)node).isVerify());
            if (!((XMLFileNode)node).isQBFormat()) {
                IOUtil.writeString(dout, ((XMLFileNode)node).getDTD());
                IOUtil.writeString(dout, ((XMLFileNode)node).getDTDTreeFileName());
            }
        } else if (tnode instanceof XMLQueryNode) {
            dout.writeInt(9);
            dout.writeInt(3);
            dout.writeInt(2);
            dout.writeInt(6612);
            node = (XMLQueryNode)tnode;
            IOUtil.writeString(dout, ((XMLQueryNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            int count = ((XMLQueryNode)node).getSelectedFieldCt();
            dout.writeInt(count);
            for (i = 0; i < count; ++i) {
                XMLFieldInfo field = ((XMLQueryNode)node).getSelectedFieldInfo(i);
                field.write(dout);
            }
            if (((XMLQueryNode)node).getConditionStatement() != null) {
                dout.writeBoolean(true);
                IOUtil.writeString(dout, ((XMLQueryNode)node).getConditionStatement());
                dout.writeBoolean(((XMLQueryNode)node).hasInSet());
                if (((XMLQueryNode)node).hasInSet()) {
                    ((XMLQueryNode)node).getInSet().write(dout);
                }
            } else {
                dout.writeBoolean(false);
            }
        } else if (tnode instanceof DataViewNode) {
            dout.writeInt(5);
            node = (DataViewNode)tnode;
            IOUtil.writeString(dout, ((DataViewNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((DataViewNode)node).getQueryFile());
        } else if (tnode instanceof DataViewQueryNode) {
            dout.writeInt(6);
            node = (DataViewQueryNode)tnode;
            IOUtil.writeString(dout, ((DataViewQueryNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((DataViewQueryNode)node).getQueryFile());
            IOUtil.writeString(dout, ((DataViewQueryNode)node).getDataViewFile());
            IOUtil.writeLongString(dout, ((DataViewQueryNode)node).getSQL());
        } else if (tnode instanceof EJBNode) {
            dout.writeInt(7);
            dout.writeInt(2);
            node = (EJBNode)tnode;
            IOUtil.writeString(dout, ((EJBNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((EJBNode)node).getJNDIName());
            IOUtil.writeString(dout, ((EJBNode)node).getHomeName());
            IOUtil.writeString(dout, ((EJBNode)node).getRemoteName());
            int count = ((EJBNode)node).getMethodCount();
            dout.writeInt(count);
            for (i = 0; i < count; ++i) {
                IOUtil.writeString(dout, ((EJBNode)node).getMethod(i));
            }
            for (i = 0; i < count; ++i) {
                IOUtil.writeString(dout, ((EJBNode)node).getMethod(i));
                Class[] paramTypes = ((EJBNode)node).getParam(i);
                dout.writeInt(paramTypes.length);
                for (Class paramType2 : paramTypes) {
                    IOUtil.writeString(dout, paramType2.getName());
                }
            }
            for (i = 0; i < count; ++i) {
                IOUtil.writeString(dout, ((EJBNode)node).getMethod(i));
                Class retType = ((EJBNode)node).getReturnType(i);
                IOUtil.writeString(dout, retType.getName());
            }
            for (i = 0; i < count; ++i) {
                IOUtil.writeString(dout, ((EJBNode)node).getMethod(i));
                Object[] values = ((EJBNode)node).getInputValue(i);
                dout.writeInt(values.length);
                for (Object value : values) {
                    IOUtil.writeString(dout, value.getClass().getName());
                    IOUtil.writeString(dout, value.toString());
                }
            }
            IOUtil.writeString(dout, ((EJBNode)node).getSelectedMethod());
            int envsize = ((EJBNode)node).getEnvironmentSize();
            dout.writeInt(envsize);
            Hashtable env = ((EJBNode)node).getEnvironment();
            if (env != null && envsize > 0) {
                Enumeration e = env.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    IOUtil.writeString(dout, (String)key);
                    IOUtil.writeString(dout, (String)env.get(key));
                }
            }
        } else if (tnode instanceof ClassFileNode) {
            dout.writeInt(8);
            node = (ClassFileNode)tnode;
            IOUtil.writeString(dout, ((ClassFileNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((ClassFileNode)node).getFile());
        } else if (tnode instanceof SalesForceDataSourceNode) {
            dout.writeInt(13);
            node = (SalesForceDataSourceNode)tnode;
            IOUtil.writeString(dout, ((SalesForceDataSourceNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((SalesForceDataSourceNode)node).getUserName());
            IOUtil.writeString(dout, ((SalesForceDataSourceNode)node).getPassword());
        } else if (tnode instanceof SalesForceQueryNode) {
            dout.writeInt(14);
            node = (SalesForceQueryNode)tnode;
            IOUtil.writeString(dout, ((SalesForceQueryNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((SalesForceQueryNode)node).getQuery());
            if (((SalesForceQueryNode)node).getInSet() != null) {
                dout.writeBoolean(true);
                ((SalesForceQueryNode)node).getInSet().write(dout);
            } else {
                dout.writeBoolean(false);
            }
        } else if (tnode instanceof ExcelFileNode) {
            dout.writeInt(15);
            node = (ExcelFileNode)tnode;
            IOUtil.writeString(dout, ((ExcelFileNode)node).getName());
            IOUtil.writeString(dout, node.getID());
            IOUtil.writeString(dout, ((ExcelFileNode)node).getFilename());
            IOUtil.writeString(dout, ((ExcelFileNode)node).getSheetName());
            dout.writeInt(((ExcelFileNode)node).getMinRow());
            dout.writeInt(((ExcelFileNode)node).getMinColumn());
            dout.writeInt(((ExcelFileNode)node).getMaxRow());
            dout.writeInt(((ExcelFileNode)node).getMaxColumn());
            dout.writeBoolean(((ExcelFileNode)node).isIncludeNewData());
            dout.writeBoolean(((ExcelFileNode)node).isHasHeader());
            dout.writeBoolean(((ExcelFileNode)node).isDataAreRows());
            int[] dataTypes = ((ExcelFileNode)node).getDataTypes();
            if (dataTypes == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(dataTypes.length);
                IOUtil.writeInts(dout, dataTypes, dataTypes.length);
            }
        } else {
            dout.writeInt(0);
            IOUtil.writeString(dout, (String)tnode.getUserObject());
        }
        if (((String)tnode.getUserObject()).equals(DATASOURCES)) {
            IOUtil.writeString(dout, ((DefaultDataSourceNode)tnode).getRegistryID());
            IOUtil.writeString(dout, ((DefaultDataSourceNode)tnode).getLastID());
        }
        int tmp = tnode.getChildCount();
        dout.writeInt(tmp);
        for (int i4 = 0; i4 < tmp; ++i4) {
            ReadXMLTable.writeNode((DefaultMutableTreeNode)tnode.getChildAt(i4), dout);
        }
    }

    public DefaultMutableTreeNode readNode(DataInputStream in) throws Exception {
        int type = in.readInt();
        DefaultDataSourceNode tnode = null;
        if (type == 1) {
            DatabaseNode node = new DatabaseNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setDriver(IOUtil.readString(in, true));
            node.setURL(IOUtil.readString(in, true));
            node.setLoginRequired(in.readBoolean());
            boolean isPasswordSaved = in.readBoolean();
            if (isPasswordSaved) {
                node.setUserName(IOUtil.readString(in, true));
                node.setPassword(IOUtil.readString(in, true));
            }
            node.setAutoJoin(in.readBoolean());
            node.setTableNameFormat(in.readInt());
            Vector<String> addDb = null;
            int addDbSize = in.readInt();
            if (addDbSize > 0) {
                addDb = new Vector<String>();
                for (int i = 0; i < addDbSize; ++i) {
                    addDb.add(IOUtil.readString(in, true));
                }
            }
            node.setAdditionalDb(addDb);
            tnode = node;
        } else if (type == 16) {
            BigDataNode node = new BigDataNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setDriver(IOUtil.readString(in, true));
            node.setURL(IOUtil.readString(in, true));
            node.setLoginRequired(in.readBoolean());
            boolean isPasswordSaved = in.readBoolean();
            if (isPasswordSaved) {
                node.setUserName(IOUtil.readString(in, true));
                node.setPassword(IOUtil.readString(in, true));
            }
            node.setAutoJoin(in.readBoolean());
            node.setTableNameFormat(in.readInt());
            Vector<String> addDb = null;
            int addDbSize = in.readInt();
            if (addDbSize > 0) {
                addDb = new Vector<String>();
                for (int i = 0; i < addDbSize; ++i) {
                    addDb.add(IOUtil.readString(in, true));
                }
            }
            node.setAdditionalDb(addDb);
            tnode = node;
        } else if (type == 11) {
            SOAPDataSourceNode node = new SOAPDataSourceNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setWsdlURI(IOUtil.readString(in, true));
            tnode = node;
        } else if (type == 12) {
            SOAPViewNode node = new SOAPViewNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            String serviceNamespace = IOUtil.readString(in, true);
            String serviceLocalName = IOUtil.readString(in, true);
            node.setServiceName(new QName(serviceNamespace, serviceLocalName));
            node.setPortName(IOUtil.readString(in, true));
            node.setOperationName(IOUtil.readString(in, true));
            node.setSchemaTreeFileName(IOUtil.readStr(in));
            node.setReturnParamName(IOUtil.readStr(in));
            node.setParameters(SOAPParam.readArray(new VersioningDataInput(in, 6612)));
            tnode = node;
        } else if (type == 10) {
            JNDIDataSourceNode node = new JNDIDataSourceNode(IOUtil.readString(in, true));
            node.setJNDIName(IOUtil.readString(in, true));
            node.setContextFactory(IOUtil.readString(in, true));
            node.setProviderURL(IOUtil.readString(in, true));
            node.setAutoJoin(in.readBoolean());
            node.setTableNameFormat(in.readInt());
            tnode = node;
        } else if (type == 2) {
            QueryNode node = new QueryNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setSQL(IOUtil.readLongString(in));
            node.setQueryBuilderUsed(in.readBoolean());
            if (node.isQueryBuilderUsed()) {
                node.setQueryFile(IOUtil.readString(in, true));
                node.setDictionaryCompatible(in.readBoolean());
            }
            node.setInSet(QueryInParamSet.read(in, 0));
            tnode = node;
        } else if (type == 100) {
            int chart_version = in.readInt();
            QueryNode node = new QueryNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setSQL(IOUtil.readLongString(in));
            node.setQueryBuilderUsed(in.readBoolean());
            if (node.isQueryBuilderUsed()) {
                node.setQueryFile(IOUtil.readString(in, true));
                node.setDictionaryCompatible(in.readBoolean());
            }
            node.setInSet(QueryInParamSet.read(in, chart_version));
            tnode = node;
        } else if (type == 3) {
            TextFileNode node = new TextFileNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setFile(IOUtil.readString(in, true));
            tnode = node;
        } else if (type == 4) {
            int xmlfilenodeVersion = in.readInt();
            XMLFileNode node = new XMLFileNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setFile(IOUtil.readString(in, true));
            boolean isQBFormat = in.readBoolean();
            boolean verify = in.readBoolean();
            node.setQBFormat(isQBFormat);
            if (!isQBFormat) {
                node.setDTD(IOUtil.readString(in, true));
                node.setDTDTreeFileName(IOUtil.readString(in, true));
            }
            tnode = node;
        } else if (type == 9) {
            int xmlquerynodeVersion = in.readInt();
            int xmlfieldinfoVersion = in.readInt();
            int chart_version = 0;
            if (xmlquerynodeVersion >= 3) {
                chart_version = in.readInt();
            }
            XMLQueryNode node = new XMLQueryNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            int count = in.readInt();
            Vector<XMLFieldInfo> fields = new Vector<XMLFieldInfo>();
            String condition = null;
            QueryInParamSet inSet = null;
            for (int i = 0; i < count; ++i) {
                XMLFieldInfo field = XMLFieldInfo.createXMLFieldInfo(in, xmlfieldinfoVersion);
                fields.addElement(field);
            }
            if (in.readBoolean()) {
                condition = IOUtil.readString(in, true);
            }
            if (xmlquerynodeVersion >= 2 && in.readBoolean()) {
                inSet = QueryInParamSet.read(in, chart_version);
            }
            node.setSelectedFields(fields);
            node.setConditionStatement(condition);
            node.setInSet(inSet);
            tnode = node;
        } else if (type == 5) {
            DataViewNode node = new DataViewNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setQueryFile(IOUtil.readString(in, true));
            tnode = node;
        } else if (type == 6) {
            DataViewQueryNode node = new DataViewQueryNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setQueryFile(IOUtil.readString(in, true));
            node.setDataViewFile(IOUtil.readString(in, true));
            node.setSQL(IOUtil.readLongString(in));
            tnode = node;
        } else if (type == 7) {
            int version = in.readInt();
            EJBNode node = new EJBNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setJNDIName(IOUtil.readString(in, true));
            node.setHomeName(IOUtil.readString(in, true));
            node.setRemoteName(IOUtil.readString(in, true));
            int count = in.readInt();
            String[] methods = new String[count];
            for (int i = 0; i < count; ++i) {
                methods[i] = IOUtil.readString(in, true);
            }
            Hashtable<String, Class[]> paramTable = new Hashtable<String, Class[]>();
            for (int i = 0; i < count; ++i) {
                String name = IOUtil.readString(in, true);
                int paramCount = in.readInt();
                Class[] param = new Class[paramCount];
                for (int j = 0; j < paramCount; ++j) {
                    param[j] = EJBUtil.mapTypeToClass(IOUtil.readString(in, true));
                }
                paramTable.put(name, param);
            }
            Hashtable retTable = new Hashtable();
            for (int i = 0; i < count; ++i) {
                String name = IOUtil.readString(in, true);
                String ret = IOUtil.readString(in, true);
                Class<?> retType = Class.forName(ret);
                retTable.put(name, retType);
            }
            Hashtable<String, Object[]> valueTable = new Hashtable<String, Object[]>();
            for (int i = 0; i < count; ++i) {
                String name = IOUtil.readString(in, true);
                int valueCount = in.readInt();
                Object[] values = new Object[valueCount];
                for (int j = 0; j < valueCount; ++j) {
                    String paramType = IOUtil.readString(in, true);
                    String val = IOUtil.readString(in, true);
                    values[j] = EJBUtil.getRuntimeInputValue(paramType, val);
                }
                valueTable.put(name, values);
            }
            String selectedMethod = IOUtil.readString(in, true);
            Hashtable<String, String> env = null;
            if (version >= 2) {
                int envsize = in.readInt();
                if (envsize > 0) {
                    env = new Hashtable<String, String>();
                }
                for (int i = 0; i < envsize; ++i) {
                    String key = IOUtil.readString(in, true);
                    String val = IOUtil.readString(in, true);
                    env.put(key, val);
                }
                node.setEnvironment(env);
            }
            node.setMethods(methods);
            node.setParamTable(paramTable);
            node.setRetTable(retTable);
            node.setValueTable(valueTable);
            node.setSelectedMethod(selectedMethod);
            tnode = node;
        } else if (type == 8) {
            ClassFileNode node = new ClassFileNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setFile(IOUtil.readString(in, true));
            tnode = node;
        } else if (type == 13) {
            SalesForceDataSourceNode node = new SalesForceDataSourceNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setUserName(IOUtil.readString(in, true));
            node.setPassword(IOUtil.readString(in, true));
            tnode = node;
        } else if (type == 14) {
            SalesForceQueryNode node = new SalesForceQueryNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setQuery(IOUtil.readString(in, true));
            if (in.readBoolean()) {
                node.setInSet(QueryInParamSet.read(in, 361));
            }
            tnode = node;
        } else if (type == 15) {
            ExcelFileNode node = new ExcelFileNode(IOUtil.readString(in, true));
            node.setID(IOUtil.readString(in, true));
            node.setFilename(IOUtil.readString(in, true));
            node.setSheetName(IOUtil.readString(in, true));
            node.setMinRow(in.readInt());
            node.setMinColumn(in.readInt());
            node.setMaxRow(in.readInt());
            node.setMaxColumn(in.readInt());
            node.setIncludeNewData(in.readBoolean());
            node.setHasHeader(in.readBoolean());
            node.setDataAreRows(in.readBoolean());
            int size = in.readInt();
            if (size > 0) {
                node.setDataTypes(IOUtil.readInts(in, size));
            }
            tnode = node;
        } else if (type == 0) {
            tnode = new DefaultDataSourceNode(IOUtil.readString(in, true));
        }
        if (((String)tnode.getUserObject()).equals(DATASOURCES)) {
            ((DefaultDataSourceNode)tnode).setRegistryID(IOUtil.readString(in, true));
            ((DefaultDataSourceNode)tnode).setLastID(IOUtil.readString(in, true));
        }
        int tmp = in.readInt();
        for (int i = 0; i < tmp; ++i) {
            tnode.add(this.readNode(in));
        }
        return tnode;
    }

    public static DefaultMutableTreeNode getDefaultDataSources() {
        DefaultDataSourceNode root = new DefaultDataSourceNode(DATASOURCES);
        root.add(new DefaultDataSourceNode(DATABASES));
        root.add(new DefaultDataSourceNode(BIGDATAS));
        root.add(new DefaultDataSourceNode(JNDIDATASOURCES));
        root.add(new DefaultDataSourceNode(XMLFILES));
        root.add(new DefaultDataSourceNode(TXTFILES));
        root.add(new DefaultDataSourceNode(CLASSFILES));
        root.add(new DefaultDataSourceNode(EJBS));
        root.add(new DefaultDataSourceNode(SOAPSERVICES));
        root.add(new DefaultDataSourceNode(SALESFORCECONNECTIONS));
        root.add(new DefaultDataSourceNode(EXCELFILES));
        return root;
    }

    public DefaultMutableTreeNode getDataSources(String filename) throws Exception {
        return this.getDataSources(filename, false);
    }

    public DefaultMutableTreeNode getDataSources(String filename, boolean fromLoadBalancer) throws Exception {
        if (filename == null || filename.trim().equals("")) {
            return ReadXMLTable.getDefaultDataSources();
        }
        Applet applet = ServerMessage.getApplet();
        filename = filename.replace('\\', '/');
        if (!ServerMessage.useServer && (ServerMessage.isLoadBalancer || fromLoadBalancer)) {
            if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                if (applet != null) {
                    return new ReadXMLDataSources(IOUtil.getCodeBase(applet) + filename).readTree();
                }
                return new ReadXMLDataSources(IOUtil.createFile(filename)).readTree();
            }
            return new ReadXMLDataSources(new File(filename)).readTree();
        }
        return this.getFromServer(filename);
    }

    private DefaultMutableTreeNode getFromServer(String file) throws Exception {
        DefaultMutableTreeNode tNode;
        file = file.replace('\\', '/');
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(23801);
        dout.writeBoolean(false);
        IOUtil.writeString(dout, file);
        dout.writeShort(100);
        IOUtil.writeString(dout, ServerMessage.xmlEncoding);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            this.readOnly = IOUtil.readStr(dstream);
            tNode = this.readNode(dstream);
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
        return tNode;
    }

    public static final String getErrorString(int code) {
        String scode;
        if (code == 0) {
            return null;
        }
        switch (code) {
            case 1: {
                scode = LanguageEncoder.getText("Unable to read data from database !");
                break;
            }
            case 2: {
                scode = LanguageEncoder.getText("Server out of memory.\nPlease try again later.");
                break;
            }
            case 3: {
                scode = LanguageEncoder.getText("Failed to write the file to disk !");
                break;
            }
            case 4: {
                scode = LanguageEncoder.getText("Too many users are currently logged onto the server.\n Please try again later.");
                break;
            }
            case 7: {
                scode = LanguageEncoder.getText("Unable to import EJB component !");
                break;
            }
            default: {
                scode = LanguageEncoder.getText("Unknown error code") + " " + code + "!";
            }
        }
        return scode;
    }

    public String isReadOnly() {
        return this.readOnly;
    }
}

