/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.SOAPUtil;
import quadbase.common.util.internal.soap.SimpleSOAPDefinition;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.SOAPDataSourceNode;

public class SOAPDialog
extends JDialog
implements ActionListener {
    JTextField nameField;
    JTextField wsdlUriField;
    JButton okButton;
    JButton cancelButton;
    JButton testButton;
    DefaultMutableTreeNode parent;
    SOAPDataSourceNode node;
    Manager manager;
    boolean isModified = false;

    public SOAPDialog(Manager frame, DefaultMutableTreeNode parent, SOAPDataSourceNode node) {
        super(frame, LanguageEncoder.getText("Setup SOAP service..."), true);
        this.manager = frame;
        this.parent = parent;
        this.node = node;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        upperPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Data Source Information")));
        JPanel p1 = new JPanel();
        JPanel labelPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        JPanel textPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Name :") + " "));
        labelPanel.add(new JLabel(LanguageEncoder.getText("WSDL file URI:") + " "));
        this.nameField = new JTextField(40);
        textPanel.add(this.nameField);
        this.wsdlUriField = new JTextField(40);
        textPanel.add(this.wsdlUriField);
        this.nameField.addActionListener(this);
        this.wsdlUriField.addActionListener(this);
        p1.setLayout(new BorderLayout());
        p1.add("West", labelPanel);
        p1.add("Center", textPanel);
        upperPanel.add("North", p1);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.testButton = new JButton(LanguageEncoder.getText("Test"));
        this.testButton.addActionListener(this);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new FlowLayout(1));
        lowerPanel.add(this.okButton);
        lowerPanel.add(this.cancelButton);
        lowerPanel.add(this.testButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", upperPanel);
        contentPane.add("South", lowerPanel);
        this.pack();
        this.setValues();
    }

    void setValues() {
        if (this.node != null) {
            this.nameField.setText(this.node.getName());
            this.wsdlUriField.setText(this.node.getWsdlURI());
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public SOAPDataSourceNode getNode() {
        return this.node;
    }

    private void cancel() {
        this.isModified = false;
        this.setVisible(false);
        this.manager.managerPane.closeEditOrAddNode();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String msg = null;
        if (e.getSource() == this.okButton || e.getSource() == this.nameField || e.getSource() == this.wsdlUriField) {
            String nodeName = this.nameField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter data source name!");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.node == null) {
                this.node = new SOAPDataSourceNode(nodeName);
                this.parent.add(this.node);
            } else {
                this.node.setUserObject(nodeName);
            }
            this.node.setWsdlURI(this.wsdlUriField.getText().trim());
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.cancel();
        } else if (e.getSource() == this.testButton) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SimpleSOAPDefinition def = SOAPUtil.parseWSDL(this.wsdlUriField.getText().trim());
                if (!def.hasServices()) {
                    throw new Exception(LanguageEncoder.getText("The WSDL does not contain any supported SOAP service."));
                }
            }
            catch (Exception ex) {
                this.setCursor(Cursor.getDefaultCursor());
                new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("WSDL file parsing failed because of the following exception:") + "\n" + ex.getLocalizedMessage());
                return;
            }
            this.setCursor(Cursor.getDefaultCursor());
            new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("The WSDL was parsed successfully."));
        }
    }
}

