/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.paramquery.SOAPParamEnumeration;
import quadbase.common.util.internal.DataType;
import quadbase.datasourcemanager.manager.SOAPParametersTableModel;

public class SOAPParametersTable
extends JTable {
    public SOAPParametersTable(SOAPParam[] soapParam) {
        super(new SOAPParametersTableModel(soapParam));
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 3) {
            SOAPParam param = this.getParameters()[row];
            if (param instanceof SOAPParamEnumeration) {
                Vector values = ((SOAPParamEnumeration)this.getParameters()[row]).getSelectionChoices();
                return new DefaultCellEditor(new JComboBox<Object>(values.toArray()));
            }
            if (DataType.mapType(param.getSqlType()) == 0) {
                return new DefaultCellEditor(new JComboBox<Boolean>(new Boolean[]{Boolean.FALSE, Boolean.TRUE}));
            }
        }
        return super.getCellEditor(row, column);
    }

    public void stopEditing() {
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
    }

    public String checkDefaultParameterValues() {
        return ((SOAPParametersTableModel)this.getModel()).checkDefaultParameterValues();
    }

    public SOAPParam[] getParameters() {
        return ((SOAPParametersTableModel)this.getModel()).getParameters();
    }
}

