/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import javax.swing.table.AbstractTableModel;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.util.internal.DataType;

public class SOAPParametersTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Parameter Name", "Data Type", "Parameter Prompt", "Default Value", "Always Use Default"};
    private SOAPParam[] parameters;

    public SOAPParametersTableModel(SOAPParam[] parameters) {
        this.parameters = parameters;
    }

    public SOAPParam[] getParameters() {
        return this.parameters;
    }

    public String checkDefaultParameterValues() {
        if (this.parameters == null || this.parameters.length == 0) {
            return null;
        }
        for (SOAPParam parameter : this.parameters) {
            try {
                Object o = parameter.getDefaultValue();
                String defaultValue = "";
                if (o != null) {
                    defaultValue = o.toString();
                }
                Object newDefault = DataType.createObject(defaultValue, DataType.mapType(parameter.getSqlType()));
                parameter.setDefaultValue(newDefault);
            }
            catch (Exception e) {
                return "Default value of parameter '" + parameter.getParamName() + "' should be " + DataType.getTypeName(parameter.getSqlType());
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.parameters[rowIndex].getParamName();
            }
            case 1: {
                return DataType.getTypeName(this.parameters[rowIndex].getSqlType());
            }
            case 2: {
                return this.parameters[rowIndex].getPromptName();
            }
            case 3: {
                return this.parameters[rowIndex].getDefaultValue();
            }
            case 4: {
                return this.parameters[rowIndex].isAlwaysUseDefault();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                this.parameters[rowIndex].setPromptName((String)value);
                break;
            }
            case 3: {
                this.parameters[rowIndex].setDefaultValue(value);
                break;
            }
            case 4: {
                this.parameters[rowIndex].setAlwaysUseDefault((Boolean)value);
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 1;
    }
}

