/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.InputStream;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import quadbase.chart.SOAPAccess;
import quadbase.common.client.FileInfo;
import quadbase.common.paramquery.EnterInParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.SOAPUtil;
import quadbase.common.util.internal.soap.SimpleSOAPDefinition;
import quadbase.common.util.internal.soap.SimpleSOAPItemBase;
import quadbase.common.util.internal.soap.SimpleSOAPOperation;
import quadbase.common.util.internal.soap.SimpleSOAPPort;
import quadbase.common.util.internal.soap.SimpleSOAPService;
import quadbase.datasourcemanager.manager.DTDTreeBuilderDialog;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.SOAPDataSourceNode;
import quadbase.datasourcemanager.manager.SOAPParametersTable;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SOAPViewPreview;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTreeBuilderDialog;
import quadbase.querybuilder.designer.QueryMain;

public class SOAPViewDialog
extends JDialog
implements ActionListener,
ItemListener {
    private SimpleSOAPDefinition soapDefinition;
    SOAPDataSourceNode parent;
    Manager manager;
    SOAPViewNode node;
    boolean modified = false;
    private JTextField nameField;
    private JComboBox servicesCombo;
    private JComboBox portsCombo;
    private JComboBox operationsCombo;
    private JPanel parametersPanel;
    private SOAPParametersTable parametersTable;
    private JButton okButton;
    private JButton cancelButton;
    private JButton previewButton;
    private JButton dataTypesButton;
    private String tempSchemaTreeFileName = null;
    private QueryInParam[] tempInSet = null;

    public SOAPViewDialog(Manager frame, SOAPDataSourceNode parent, SOAPViewNode node) {
        super(frame, LanguageEncoder.getText("Setup SOAP View..."), true);
        this.manager = frame;
        this.parent = parent;
        this.node = node;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isModified() {
        return this.modified;
    }

    public SOAPViewNode getNode() {
        return this.node;
    }

    private void setValue() {
        try {
            SimpleSOAPDefinition newDefinition = SOAPUtil.parseWSDL(this.parent.getWsdlURI());
            if (!newDefinition.hasServices()) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("The WSDL file does not contain any supported SOAP operation."));
                this.cancel();
                return;
            }
            this.soapDefinition = newDefinition;
            this.fillServicesCombo();
        }
        catch (Exception e) {
            e.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Error reading WSDL.") + "\n" + e.getLocalizedMessage());
            this.cancel();
            return;
        }
        if (this.node != null) {
            SOAPParam[] readParams;
            this.nameField.setText(this.node.getName());
            this.selectSOAPItem(this.servicesCombo, this.node.getServiceName().toString());
            this.selectSOAPItem(this.portsCombo, this.node.getPortName());
            this.selectSOAPItem(this.operationsCombo, this.node.getOperationName());
            this.fillParametersTable();
            SOAPParam[] actualParams = this.parametersTable.getParameters();
            for (SOAPParam readParam : readParams = this.node.getParameters()) {
                for (SOAPParam actualParam : actualParams) {
                    if (!readParam.getParamName().equals(actualParam.getParamName())) continue;
                    actualParam.setPromptName(readParam.getPromptName());
                    actualParam.setDefaultValue(readParam.getDefaultValue());
                    actualParam.setValue(readParam.getValue());
                    actualParam.setAlwaysUseDefault(readParam.isAlwaysUseDefault());
                }
            }
        }
    }

    private void selectSOAPItem(JComboBox combo, String itemName) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            SimpleSOAPItemBase s = (SimpleSOAPItemBase)combo.getItemAt(i);
            if (!s.getName().equals(itemName)) continue;
            combo.setSelectedIndex(i);
            break;
        }
    }

    private void init() {
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel upperPanel = new JPanel(new BorderLayout(5, 5));
        JPanel westPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        westPanel.add(new JLabel(LanguageEncoder.getText("Name:") + " "));
        westPanel.add(new JLabel(LanguageEncoder.getText("Available services:") + " "));
        westPanel.add(new JLabel(LanguageEncoder.getText("Available ports:") + " "));
        westPanel.add(new JLabel(LanguageEncoder.getText("Available operations:") + " "));
        JPanel centerPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        this.nameField = new JTextField(25);
        centerPanel.add(this.nameField);
        this.servicesCombo = new JComboBox();
        centerPanel.add(this.servicesCombo);
        this.servicesCombo.addItemListener(this);
        this.portsCombo = new JComboBox();
        centerPanel.add(this.portsCombo);
        this.portsCombo.addItemListener(this);
        this.operationsCombo = new JComboBox();
        centerPanel.add(this.operationsCombo);
        this.operationsCombo.addItemListener(this);
        upperPanel.add((Component)westPanel, "West");
        upperPanel.add((Component)centerPanel, "Center");
        JPanel borderPanel = new JPanel(new BorderLayout(5, 5));
        borderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(LanguageEncoder.getText("Operation parameters")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.parametersPanel = new JPanel(new BorderLayout(5, 5));
        this.parametersPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.parametersPanel.setMaximumSize(new Dimension(800, 600));
        borderPanel.add((Component)this.parametersPanel, "Center");
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.previewButton = new JButton(LanguageEncoder.getText("Preview Result"));
        buttonPanel.add(this.previewButton);
        this.previewButton.addActionListener(this);
        this.dataTypesButton = new JButton(LanguageEncoder.getText("Setup Data Types"));
        buttonPanel.add(this.dataTypesButton);
        this.dataTypesButton.addActionListener(this);
        if (this.node == null) {
            this.dataTypesButton.setEnabled(false);
        }
        p.add((Component)upperPanel, "North");
        p.add((Component)borderPanel, "Center");
        p.add((Component)buttonPanel, "South");
        this.setContentPane(p);
        this.setValue();
        this.pack();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (e.getStateChange() != 1) {
            return;
        }
        if (source.equals(this.servicesCombo)) {
            this.fillPortsCombo();
        } else if (source.equals(this.portsCombo)) {
            this.fillOperationsCombo();
        } else if (source.equals(this.operationsCombo)) {
            this.fillParametersTable();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String msg = null;
        if (e.getSource() == this.okButton || e.getSource() == this.previewButton) {
            boolean isNewNode;
            String nodeName = this.nameField.getText().trim();
            if (e.getSource() == this.okButton) {
                if (nodeName == null || nodeName.trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter SOAP View name!");
                } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                    msg = nodeName + " " + LanguageEncoder.getText("already exists!");
                }
            }
            if (this.operationsCombo.getSelectedItem() == null) {
                msg = "No operation selected";
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            this.parametersTable.stopEditing();
            msg = this.parametersTable.checkDefaultParameterValues();
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            boolean bl = isNewNode = this.node == null;
            if (isNewNode) {
                this.node = new SOAPViewNode(nodeName);
                this.node.setSchemaTreeFileName(this.tempSchemaTreeFileName);
            } else {
                this.node.setUserObject(nodeName);
            }
            if (!(this.node.getSchemaTreeFileName() != null && OverWriteDialog.findFile(this.node.getSchemaTreeFileName()) || this.openTreeWindow(this.node.getSchemaTreeFileName()))) {
                if (isNewNode) {
                    this.node = null;
                }
                return;
            }
            SimpleSOAPService service = (SimpleSOAPService)this.servicesCombo.getSelectedItem();
            SimpleSOAPPort port = (SimpleSOAPPort)this.portsCombo.getSelectedItem();
            SimpleSOAPOperation operation = (SimpleSOAPOperation)this.operationsCombo.getSelectedItem();
            SOAPParam[] parameters = this.parametersTable.getParameters();
            String returnParamName = operation.getReturnParamName();
            this.node.setServiceName(service.getQName());
            this.node.setPortName(port.getName());
            this.node.setOperationName(operation.getName());
            this.node.setParameters(parameters);
            this.node.setReturnParamName(returnParamName);
            if (e.getSource() == this.okButton) {
                if (isNewNode) {
                    this.parent.add(this.node);
                }
                this.modified = true;
                this.setVisible(false);
                this.dispose();
            } else {
                this.setCursor(Cursor.getPredefinedCursor(3));
                SOAPQueryFileInfo soapInfo = new SOAPQueryFileInfo(this.parent.getWsdlURI(), service.getQName(), port.getName(), operation.getName(), this.node.getXmlFieldInfo(), parameters);
                if (this.tempInSet != null && soapInfo.getInSet() != null) {
                    soapInfo.getInSet().setParameter(this.tempInSet);
                    this.tempInSet = null;
                } else if (!this.showParameterPrompt(soapInfo)) {
                    if (isNewNode) {
                        this.node = null;
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                SOAPViewPreview preview = new SOAPViewPreview(this, soapInfo);
                this.setCursor(Cursor.getDefaultCursor());
                if (!preview.isCanceled()) {
                    preview.setVisible(true);
                }
                if (isNewNode) {
                    this.tempSchemaTreeFileName = this.node.getSchemaTreeFileName();
                    this.node = null;
                }
            }
        } else if (e.getSource() == this.cancelButton) {
            this.cancel();
        } else if (e.getSource() == this.dataTypesButton) {
            this.openTreeWindow(this.node.getSchemaTreeFileName());
        }
    }

    private boolean openTreeWindow(String schemaFileLocation) {
        SimpleSOAPService service = (SimpleSOAPService)this.servicesCombo.getSelectedItem();
        SimpleSOAPPort port = (SimpleSOAPPort)this.portsCombo.getSelectedItem();
        SimpleSOAPOperation operation = (SimpleSOAPOperation)this.operationsCombo.getSelectedItem();
        SOAPParam[] parameters = this.parametersTable.getParameters();
        String returnParamName = operation.getReturnParamName();
        if (schemaFileLocation == null) {
            SOAPQueryFileInfo soapInfo = new SOAPQueryFileInfo(this.parent.getWsdlURI(), service.getQName(), port.getName(), operation.getName(), null, parameters);
            if (!this.showParameterPrompt(soapInfo)) {
                return false;
            }
            InputStream xsdSchemaStream = null;
            if (!SOAPUtil.containsEncodedXML(soapInfo)) {
                xsdSchemaStream = this.soapDefinition.getSchemaStream();
            }
            if (xsdSchemaStream != null) {
                return this.openTreeWindowForNewXMLSchema(xsdSchemaStream, this.node);
            }
            Exception lastException = null;
            InputStream dtdSchemaStream = null;
            try {
                dtdSchemaStream = SOAPAccess.getDTDSchema(soapInfo);
            }
            catch (Exception ex) {
                lastException = ex;
            }
            if (dtdSchemaStream != null) {
                return this.openTreeWindowForNewDTD(dtdSchemaStream, this.node);
            }
            String message = LanguageEncoder.getText("Failed to obtain or generate XML schema.");
            if (lastException != null) {
                message = message + "\n" + lastException.toString();
            }
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), message);
            return false;
        }
        if (schemaFileLocation.endsWith(".xst")) {
            return this.openTreeWindowForExistingXMLSchema(schemaFileLocation, returnParamName);
        }
        return this.openTreeWindowForExistingDTD(schemaFileLocation);
    }

    private boolean openTreeWindowForExistingXMLSchema(String xstFileName, String filter) {
        try {
            XMLSchemaTreeBuilderDialog builderDialog = new XMLSchemaTreeBuilderDialog(this, xstFileName);
            SOAPViewDialog.doFilter((DefaultMutableTreeNode)builderDialog.getTree().getModel().getRoot(), filter);
            ((DefaultTreeModel)builderDialog.getTree().getModel()).reload();
            builderDialog.getTree().expandRow(0);
            builderDialog.setVisible(true);
            if (builderDialog.isModified()) {
                builderDialog.save(xstFileName);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
        }
        return false;
    }

    private boolean openTreeWindowForExistingDTD(String ddtFileName) {
        DTDTreeBuilderDialog dtdBuilderDialog = new DTDTreeBuilderDialog((JDialog)this, (DefaultMutableTreeNode)this.parent, (DefaultMutableTreeNode)this.node, ddtFileName);
        dtdBuilderDialog.setVisible(true);
        if (dtdBuilderDialog.isModified()) {
            DTDUtil.writeDTDTreeFile(dtdBuilderDialog.getDTD(), ddtFileName, 2);
            return true;
        }
        return false;
    }

    private boolean openTreeWindowForNewXMLSchema(InputStream schemaStream, SOAPViewNode soapNode) {
        try {
            String xstFileName = this.createSchemaFileName(soapNode.getName(), ".xst");
            XMLSchemaTreeBuilderDialog builderDialog = new XMLSchemaTreeBuilderDialog(this, schemaStream, xstFileName);
            ((DefaultTreeModel)builderDialog.getTree().getModel()).reload();
            builderDialog.getTree().expandRow(0);
            builderDialog.setVisible(true);
            if (builderDialog.isModified()) {
                builderDialog.save(xstFileName);
                soapNode.setSchemaTreeFileName(xstFileName);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
        }
        return false;
    }

    private boolean openTreeWindowForNewDTD(InputStream schemaStream, SOAPViewNode soapNode) {
        try {
            String ddtFileName = this.createSchemaFileName(soapNode.getName(), ".ddt");
            DTD dtdTree = DTDUtil.getDTDFromParser(schemaStream);
            DTDTreeBuilderDialog dtdBuilderDialog = new DTDTreeBuilderDialog((JDialog)this, (DefaultMutableTreeNode)this.parent, (DefaultMutableTreeNode)this.node, dtdTree);
            dtdBuilderDialog.setVisible(true);
            if (dtdBuilderDialog.isModified()) {
                DTDUtil.writeDTDTreeFile(dtdBuilderDialog.getDTD(), ddtFileName, 2);
                soapNode.setSchemaTreeFileName(ddtFileName);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
        }
        return false;
    }

    static void doFilter(DefaultMutableTreeNode root, String filter) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)root.getChildAt(i);
            DefaultMutableTreeNode leaf = null;
            leaf = tnode.getChildCount() == 0 ? tnode : tnode.getFirstLeaf();
            TreeNode[] path = leaf.getPath();
            boolean found = false;
            for (TreeNode element : path) {
                if (!element.toString().equals(filter)) continue;
                found = true;
                break;
            }
            if (found) continue;
            tnode.removeFromParent();
            --i;
        }
    }

    private String createSchemaFileName(String nodeName, String extension) throws Exception {
        String newFileName = "";
        String fileprefix = this.manager.managerPane.dataSourceLoc;
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
        fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
        newFileName = fileprefix + "_" + nodeName;
        String tmp = newFileName = newFileName.replace(' ', '_');
        int ct = 0;
        while (new FileInfo(QueryMain.QUERYDIR + newFileName + extension).exists()) {
            newFileName = tmp + "_" + ct++;
        }
        return QueryMain.QUERYDIR + newFileName + extension;
    }

    private void cancel() {
        if (this.tempSchemaTreeFileName != null) {
            new DeleteFile(this.tempSchemaTreeFileName).delete();
        }
        this.tempSchemaTreeFileName = null;
        this.modified = false;
        this.setVisible(false);
        this.manager.managerPane.closeEditOrAddNode();
        this.dispose();
    }

    private void fillServicesCombo() {
        this.servicesCombo.removeAllItems();
        if (this.soapDefinition == null || !this.soapDefinition.hasServices()) {
            this.servicesCombo.addItem("no services available");
            this.servicesCombo.setEnabled(false);
        } else {
            Iterator it = this.soapDefinition.getAllServices().iterator();
            while (it.hasNext()) {
                this.servicesCombo.addItem(it.next());
            }
            this.servicesCombo.setEnabled(true);
        }
    }

    private void fillPortsCombo() {
        SimpleSOAPService simpleService = (SimpleSOAPService)this.servicesCombo.getSelectedItem();
        this.servicesCombo.setToolTipText(simpleService.getDocumentation());
        this.portsCombo.removeAllItems();
        Iterator it = simpleService.getAllPorts().iterator();
        while (it.hasNext()) {
            this.portsCombo.addItem(it.next());
        }
        this.portsCombo.setEnabled(true);
    }

    private void fillOperationsCombo() {
        SimpleSOAPPort simplePort = (SimpleSOAPPort)this.portsCombo.getSelectedItem();
        this.portsCombo.setToolTipText(simplePort.getDocumentation());
        this.operationsCombo.removeAllItems();
        Iterator it = simplePort.getAllOperations().iterator();
        while (it.hasNext()) {
            this.operationsCombo.addItem(it.next());
        }
        this.operationsCombo.setEnabled(true);
    }

    private void fillParametersTable() {
        SimpleSOAPOperation simpleOperation = (SimpleSOAPOperation)this.operationsCombo.getSelectedItem();
        this.operationsCombo.setToolTipText(simpleOperation.getDocumentation());
        this.parametersPanel.removeAll();
        this.parametersTable = new SOAPParametersTable(simpleOperation.getSOAPParams());
        this.parametersPanel.add(new JScrollPane(this.parametersTable, 20, 30));
        this.parametersPanel.repaint();
        Container par = this.parametersPanel.getTopLevelAncestor();
        if (par instanceof Window) {
            ((Window)par).pack();
        }
        if (this.tempSchemaTreeFileName != null) {
            new DeleteFile(this.tempSchemaTreeFileName).delete();
        }
        this.tempSchemaTreeFileName = null;
        this.tempInSet = null;
    }

    private boolean showParameterPrompt(SOAPQueryFileInfo soapInfo) {
        if (soapInfo.isParameterized()) {
            try {
                EnterInParamDialog enterDialog = new EnterInParamDialog((Frame)null, (QueryFileInfo)soapInfo, true);
                enterDialog.show();
                if (enterDialog.isCancelled()) {
                    return false;
                }
                this.tempInSet = enterDialog.getInParamValue();
                soapInfo.getInSet().setParameter(this.tempInSet);
            }
            catch (Exception e) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to generate parameter prompt."));
                return false;
            }
        }
        return true;
    }
}

