/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.namespace.QName;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.SOAPViewDialog;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTree;

public class SOAPViewNode
extends DefaultDataSourceNode {
    private QName serviceName;
    private String portName;
    private String operationName;
    private SOAPParam[] parameters;
    private String schemaTreeFileName;
    private String returnParamName;

    public SOAPViewNode(String name) {
        super(name);
        this.setAddEnabled(false);
    }

    public void setName(String name) {
        this.setUserObject(name);
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public SOAPParam[] getParameters() {
        return this.parameters;
    }

    public void setParameters(SOAPParam[] parameters) {
        this.parameters = parameters;
    }

    public XMLFieldInfo[] getXmlFieldInfo() {
        DefaultMutableTreeNode root = null;
        if (this.schemaTreeFileName.toLowerCase().endsWith(".ddt")) {
            DTD dtd = DTDUtil.readDTD(this.schemaTreeFileName);
            DTDElement rootElt = dtd.getRootElement();
            Hashtable<String, DTDElement> elements = dtd.getElements();
            root = DTDUtil.buildTree(rootElt, elements, new DefaultMutableTreeNode(rootElt), true);
        } else {
            try {
                XMLSchemaTree xsdTree = XMLSchemaTree.load(this.schemaTreeFileName);
                root = (DefaultMutableTreeNode)xsdTree.getModel().getRoot();
                SOAPViewDialog.doFilter(root, this.returnParamName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DTDUtil.getXMLAllFields(root);
    }

    public String getSchemaTreeFileName() {
        return this.schemaTreeFileName;
    }

    public void setSchemaTreeFileName(String schemaTreeFileName) {
        this.schemaTreeFileName = schemaTreeFileName;
    }

    public String getReturnParamName() {
        return this.returnParamName;
    }

    public void setReturnParamName(String returnParamName) {
        this.returnParamName = returnParamName;
    }
}

