/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import quadbase.chart.designer.ChartWizard;
import quadbase.common.client.FileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EnterSQLDialog;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.LoginDialog;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.QueryBuilderProcess;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.querybuilder.designer.QueryMain;

public class SQLDialog
extends JDialog
implements ActionListener {
    JTextField baseField;
    JButton cancelButton;
    JButton okButton;
    JRadioButton buildcb;
    JRadioButton statcb;
    boolean isModified = false;
    DefaultDataSourceNode parent;
    QueryNode node;
    Manager manager;
    boolean newFile;

    public SQLDialog(Manager manager, DefaultDataSourceNode parent, QueryNode node) {
        super(manager, LanguageEncoder.getText("Setup SQL..."), true);
        this.manager = manager;
        this.parent = parent;
        this.node = node;
        this.newFile = node == null;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.setLayout(new BorderLayout());
        JPanel namepanel = new JPanel();
        namepanel.setLayout(new BorderLayout());
        namepanel.setBorder(new TitledBorder(LanguageEncoder.getText("SQL Name")));
        this.baseField = new JTextField();
        namepanel.add("North", this.baseField);
        this.baseField.addActionListener(this);
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new GridLayout(2, 1));
        gridpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please select an option")));
        this.buildcb = new JRadioButton(LanguageEncoder.getText("Open query builder"));
        this.buildcb.setSelected(true);
        this.statcb = new JRadioButton(LanguageEncoder.getText("Enter SQL statement"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buildcb);
        buttonGroup.add(this.statcb);
        gridpanel.add(this.buildcb);
        gridpanel.add(this.statcb);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        okpanel.add(this.okButton);
        okpanel.add(this.cancelButton);
        if (this.node == null) {
            bpanel.add("North", namepanel);
            bpanel.add("Center", gridpanel);
        } else {
            bpanel.add("Center", namepanel);
            this.setValues(this.node);
        }
        bpanel.add("South", okpanel);
    }

    private void setValues(QueryNode node) {
        this.baseField.setText(node.getName());
        if (node.isQueryBuilderUsed()) {
            this.buildcb.setSelected(true);
        } else {
            this.statcb.setSelected(true);
        }
    }

    boolean isModified() {
        return this.isModified;
    }

    private void setSQLStatement() {
        block21: {
            EnterSQLDialog sqlDialog;
            block22: {
                QueryInParamSet paramSet;
                QueryBuilderProcess ic = new QueryBuilderProcess(this.manager.managerPane, this.node, this.newFile);
                boolean autoJoin = true;
                if (this.parent instanceof DatabaseNode) {
                    autoJoin = ((DatabaseNode)this.parent).isAutoJoin();
                } else if (this.parent instanceof JNDIDataSourceNode) {
                    autoJoin = ((JNDIDataSourceNode)this.parent).isAutoJoin();
                }
                QueryMain queryMain = new QueryMain(this.manager, ic, autoJoin);
                queryMain.setBrowseDirectories(this.manager.interchange.getBrowseDirectories());
                queryMain.setDefaultParamNames(this.manager.getDefaultParamNames());
                queryMain.setDefaultValueRequiredForParameters(this.manager.isDefaultValueRequiredForParameters());
                int tableNameFormat = 0;
                if (this.parent instanceof DatabaseNode) {
                    tableNameFormat = ((DatabaseNode)this.parent).getTableNameFormat();
                } else if (this.parent instanceof JNDIDataSourceNode) {
                    tableNameFormat = ((JNDIDataSourceNode)this.parent).getTableNameFormat();
                }
                queryMain.setTableNameFormat(tableNameFormat);
                queryMain.setQueryFile(this.node.getQueryFile() != null ? this.node.getQueryFile() : null);
                queryMain.setInSet(this.node.getInSet());
                ic.setQueryBuilder(queryMain);
                String userName = "";
                String password = "";
                if (this.parent instanceof DatabaseNode && ((DatabaseNode)this.parent).isLoginRequired()) {
                    if (((DatabaseNode)this.parent).isPasswordSaved()) {
                        userName = ((DatabaseNode)this.parent).getUserName();
                        password = ((DatabaseNode)this.parent).getPassword();
                    } else {
                        LoginDialog login = new LoginDialog(this.manager);
                        login.setVisible(true);
                        userName = login.getUserName();
                        password = login.getPassword();
                    }
                }
                DBInfoBasic dbInfo = null;
                dbInfo = this.parent instanceof JNDIDataSourceNode ? new DBInfoBasic(((JNDIDataSourceNode)this.parent).getJNDIName(), this.node.getSQL(), ((JNDIDataSourceNode)this.parent).getEnvProperties()) : new DBInfoBasic(((DatabaseNode)this.parent).getURL(), ((DatabaseNode)this.parent).getDriver(), userName, password, this.node.getSQL(), ((DatabaseNode)this.parent).getAdditionalDb());
                sqlDialog = new EnterSQLDialog(this.manager, queryMain, dbInfo, this.node.getSQL(), this.node.getInSet());
                while (true) {
                    sqlDialog.setVisible(true);
                    if (!sqlDialog.isModified()) break block21;
                    String query = sqlDialog.getSQLStatement();
                    this.node.setInSet(sqlDialog.getInSet());
                    if (!QueryParser.hasParameters(query)) break block22;
                    userName = "";
                    password = "";
                    if (this.parent instanceof DatabaseNode && ((DatabaseNode)this.parent).isLoginRequired()) {
                        if (((DatabaseNode)this.parent).isPasswordSaved()) {
                            userName = ((DatabaseNode)this.parent).getUserName();
                            password = ((DatabaseNode)this.parent).getPassword();
                        } else {
                            LoginDialog login = new LoginDialog(this.manager);
                            login.setVisible(true);
                            if (!login.isModified()) continue;
                            userName = login.getUserName();
                            password = login.getPassword();
                        }
                    }
                    paramSet = this.node.getInSet();
                    boolean initializationRequired = QueryParser.initializationRequired(paramSet = QueryParser.filterParameters(query, paramSet));
                    if (!initializationRequired) break;
                    try {
                        dbInfo = this.parent instanceof JNDIDataSourceNode ? new DBInfoBasic(((JNDIDataSourceNode)this.parent).getJNDIName(), query, ((JNDIDataSourceNode)this.parent).getEnvProperties()) : new DBInfoBasic(((DatabaseNode)this.parent).getURL(), ((DatabaseNode)this.parent).getDriver(), userName, password, query);
                        QueryFileInfo qInfo = new QueryFileInfo("", 0, dbInfo, paramSet);
                        boolean showPromptSequence = true;
                        if (this.manager.interchange instanceof ChartWizard) {
                            showPromptSequence = false;
                        }
                        int format = 0;
                        if (this.parent instanceof DatabaseNode) {
                            format = ((DatabaseNode)this.parent).getTableNameFormat();
                        } else if (this.parent instanceof JNDIDataSourceNode) {
                            format = ((JNDIDataSourceNode)this.parent).getTableNameFormat();
                        }
                        INParametersDialog pDialog = new INParametersDialog(this.manager, qInfo, showPromptSequence, format);
                        pDialog.setDefaultValueRequired(this.manager.isDefaultValueRequiredForParameters());
                        pDialog.setVisible(true);
                        if (!pDialog.isModified()) continue;
                        paramSet = pDialog.getQueryInParamSet();
                        if (paramSet != null) {
                            this.node.setInSet(paramSet);
                            this.node.setSQL(sqlDialog.getSQLStatement());
                            return;
                        }
                        throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                    }
                    catch (Exception ex) {
                        new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
                        continue;
                    }
                    break;
                }
                this.node.setInSet(paramSet);
                this.node.setSQL(sqlDialog.getSQLStatement());
                return;
            }
            this.node.setInSet(null);
            this.node.setSQL(sqlDialog.getSQLStatement());
            return;
        }
        if (this.newFile) {
            this.manager.managerPane.closeEditOrAddNode(true);
            return;
        }
    }

    private boolean openQueryBuilder(String nodeName, String queryFile) {
        boolean state;
        String userName = "";
        String password = "";
        if (this.parent instanceof DatabaseNode && ((DatabaseNode)this.parent).isLoginRequired()) {
            if (((DatabaseNode)this.parent).isPasswordSaved()) {
                userName = ((DatabaseNode)this.parent).getUserName();
                password = ((DatabaseNode)this.parent).getPassword();
            } else {
                LoginDialog login = new LoginDialog(this.manager);
                login.setVisible(true);
                if (!login.isModified()) {
                    return false;
                }
                userName = login.getUserName();
                password = login.getPassword();
            }
        }
        Vector<String[]> dictionaries = new Vector<String[]>();
        int ct = this.parent.getChildCount();
        for (int i = 0; i < ct; ++i) {
            TreeNode subNode = this.parent.getChildAt(i);
            for (int j = 0; j < subNode.getChildCount(); ++j) {
                TreeNode qNode = subNode.getChildAt(j);
                if (!(qNode instanceof QueryNode) || !((QueryNode)qNode).isDictionaryCompatible()) continue;
                String[] nameFilePair = new String[]{(String)((QueryNode)qNode).getUserObject(), ((QueryNode)qNode).getQueryFile()};
                dictionaries.addElement(nameFilePair);
            }
        }
        QueryBuilderProcess ic = new QueryBuilderProcess(this.manager.managerPane, this.node, this.newFile);
        boolean autoJoin = true;
        if (this.parent instanceof DatabaseNode) {
            autoJoin = ((DatabaseNode)this.parent).isAutoJoin();
        } else if (this.parent instanceof JNDIDataSourceNode) {
            autoJoin = ((JNDIDataSourceNode)this.parent).isAutoJoin();
        }
        QueryMain queryMain = new QueryMain(this.manager, ic, autoJoin);
        queryMain.setBrowseDirectories(this.manager.interchange.getBrowseDirectories());
        queryMain.setDefaultParamNames(this.manager.getDefaultParamNames());
        queryMain.setDefaultValueRequiredForParameters(this.manager.isDefaultValueRequiredForParameters());
        int tableNameFormat = 0;
        if (this.parent instanceof DatabaseNode) {
            tableNameFormat = ((DatabaseNode)this.parent).getTableNameFormat();
        } else if (this.parent instanceof JNDIDataSourceNode) {
            tableNameFormat = ((JNDIDataSourceNode)this.parent).getTableNameFormat();
        }
        queryMain.setTableNameFormat(tableNameFormat);
        queryMain.setDictionaries(dictionaries);
        queryMain.setQueryFile(queryFile);
        queryMain.setInSet(this.node.getInSet());
        ic.setQueryBuilder(queryMain);
        boolean useJNDIDataSource = false;
        String JNDIName = "";
        String driver = "";
        String url = "";
        Hashtable env = new Hashtable();
        if (this.parent instanceof DatabaseNode) {
            driver = ((DatabaseNode)this.parent).getDriver();
            url = ((DatabaseNode)this.parent).getURL();
        } else {
            useJNDIDataSource = true;
            JNDIName = ((JNDIDataSourceNode)this.parent).getJNDIName();
            env = ((JNDIDataSourceNode)this.parent).getEnvProperties();
        }
        Vector addDb = null;
        if (this.parent instanceof DatabaseNode) {
            tableNameFormat = ((DatabaseNode)this.parent).getTableNameFormat();
            addDb = ((DatabaseNode)this.parent).getAdditionalDb();
        }
        if (!(state = this.newFile ? queryMain.newQuery(nodeName, useJNDIDataSource, JNDIName, env, driver, url, userName, password, addDb) : queryMain.openQuery(nodeName, useJNDIDataSource, JNDIName, env, driver, url, userName, password, this.node.getSQL(), addDb))) {
            if (this.newFile) {
                this.manager.managerPane.doRemove(this.node, true, true);
            }
            queryMain.dispose();
            queryMain = null;
        } else {
            queryMain.setVisible(true);
        }
        return state;
    }

    QueryNode getNode() {
        return this.node;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean queryBuilderOpened = false;
        if (e.getSource() == this.cancelButton) {
            this.manager.managerPane.closeEditOrAddNode();
        }
        if (e.getSource() == this.okButton || e.getSource() == this.baseField) {
            DefaultMutableTreeNode queryNode;
            String msg = null;
            String nodeName = this.baseField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter query name!");
            } else if (nodeName.length() > 25) {
                msg = LanguageEncoder.getText("Query name can not be longer than 25 characters.");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(queryNode = this.parent instanceof DatabaseNode ? ((DatabaseNode)this.parent).getQueryNode() : ((JNDIDataSourceNode)this.parent).getQueryNode(), nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            String newFileName = "";
            if (this.node == null) {
                String fileprefix = this.manager.managerPane.dataSourceLoc;
                fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
                fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
                fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
                fileprefix = fileprefix + "_" + this.parent.getUserObject() + "_";
                newFileName = fileprefix + nodeName;
                String tmp = newFileName = QbUtil.getValidFilename(newFileName);
                int ct = 0;
                try {
                    while (new FileInfo(QueryMain.QUERYDIR + newFileName + ".qry").exists()) {
                        newFileName = tmp + "_" + ct++;
                    }
                }
                catch (Exception exception) {}
            } else if (this.node.isQueryBuilderUsed()) {
                newFileName = this.node.getQueryFile();
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            DefaultMutableTreeNode queryNode2 = this.parent instanceof DatabaseNode ? ((DatabaseNode)this.parent).getQueryNode() : ((JNDIDataSourceNode)this.parent).getQueryNode();
            if (this.node == null) {
                this.node = new QueryNode(nodeName);
                queryNode2.add(this.node);
            } else {
                this.node.setUserObject(nodeName);
            }
            if (this.buildcb.isSelected()) {
                this.node.setQueryFile(newFileName);
            } else {
                this.node.setQueryFile(null);
            }
            this.node.setQueryBuilderUsed(this.buildcb.isSelected());
            if (this.buildcb.isSelected()) {
                this.setVisible(false);
                queryBuilderOpened = this.openQueryBuilder(nodeName, newFileName);
            } else {
                this.setSQLStatement();
            }
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }
}

