/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.chart.IOUtil2;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.SalesForceConnection;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.SalesForceDataSourceNode;

public class SalesForceDataSourceDialog
extends JDialog
implements ActionListener {
    JTextField nameField;
    JTextField usernameField;
    JTextField passwordField;
    JButton okButton;
    JButton cancelButton;
    JButton testButton;
    DefaultMutableTreeNode parent;
    SalesForceDataSourceNode node;
    Manager manager;
    boolean isModified = false;

    public SalesForceDataSourceDialog(Manager frame, DefaultMutableTreeNode parent, SalesForceDataSourceNode node) {
        super(frame, LanguageEncoder.getText("Setup SalesForce data source..."), true);
        this.manager = frame;
        this.parent = parent;
        this.node = node;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        upperPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Data Source Information")));
        JPanel p1 = new JPanel();
        JPanel labelPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        JPanel textPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Name:") + " "));
        labelPanel.add(new JLabel(LanguageEncoder.getText("SalesForce User Name:") + " "));
        labelPanel.add(new JLabel(LanguageEncoder.getText("SalesForce Password:")));
        this.nameField = new JTextField(25);
        textPanel.add(this.nameField);
        this.usernameField = new JTextField(25);
        textPanel.add(this.usernameField);
        this.passwordField = new JPasswordField(25);
        textPanel.add(this.passwordField);
        this.nameField.addActionListener(this);
        this.usernameField.addActionListener(this);
        this.passwordField.addActionListener(this);
        p1.setLayout(new BorderLayout());
        p1.add("West", labelPanel);
        p1.add("Center", textPanel);
        upperPanel.add("North", p1);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.testButton = new JButton(LanguageEncoder.getText("Test Connection"));
        this.testButton.addActionListener(this);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new FlowLayout(1));
        lowerPanel.add(this.okButton);
        lowerPanel.add(this.cancelButton);
        lowerPanel.add(this.testButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", upperPanel);
        contentPane.add("South", lowerPanel);
        this.pack();
        this.setValues();
    }

    private void setValues() {
        if (this.node != null) {
            this.nameField.setText(this.node.getName());
            this.usernameField.setText(this.node.getUserName());
            this.passwordField.setText(this.node.getPassword());
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public SalesForceDataSourceNode getNode() {
        return this.node;
    }

    private void cancel() {
        this.isModified = false;
        this.setVisible(false);
        this.manager.managerPane.closeEditOrAddNode();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String msg = null;
        if (e.getSource() == this.okButton || e.getSource() == this.nameField || e.getSource() == this.usernameField || e.getSource() == this.passwordField) {
            String nodeName = this.nameField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter data source name!");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.node == null) {
                this.node = new SalesForceDataSourceNode(nodeName);
                this.parent.add(this.node);
            } else {
                this.node.setUserObject(nodeName);
            }
            this.node.setUserName(this.usernameField.getText());
            this.node.setPassword(this.passwordField.getText());
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.cancel();
        } else if (e.getSource() == this.testButton) {
            this.testConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (ServerMessage.useServer) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            IConnection socket = null;
            try {
                int messageType = 11001;
                dout.writeShort(messageType);
                IOUtil.writeString(dout, this.usernameField.getText());
                IOUtil.writeString(dout, this.passwordField.getText());
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                this.setCursor(Cursor.getDefaultCursor());
                new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Failed to contact EspressReport server at") + " " + ServerMessage.getServerInfo() + " " + ex.getMessage());
                return;
            }
            try {
                DataInputStream instream = new DataInputStream(socket.getInputStream());
                int code = instream.readInt();
                if (code != 0) {
                    throw new Exception(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                }
                this.setCursor(Cursor.getDefaultCursor());
                new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("SalesForce connection successful."));
                instream.close();
                socket.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.setCursor(Cursor.getDefaultCursor());
                new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("SalesForce connection failed because of the following exception:") + "\n" + t.toString());
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception code) {}
            }
        } else {
            try {
                SalesForceConnection.getSalesForceConnection(this.usernameField.getText(), this.passwordField.getText(), null);
            }
            catch (Exception ex) {
                this.setCursor(Cursor.getDefaultCursor());
                new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("SalesForce connection failed because of the following exception:") + "\n" + ex.getLocalizedMessage());
                return;
            }
            this.setCursor(Cursor.getDefaultCursor());
            new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("SalesForce connection successful."));
        }
    }
}

