/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.formula.DateFormulaParser;
import quadbase.common.formula.Formula;
import quadbase.common.paramquery.AvailColumn;
import quadbase.common.paramquery.DateVariableDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryParser;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.datasourcemanager.manager.CustomSelectionDialog;

public class SalesForceParametersDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final int[] choiceMapToType = new int[]{12, 4, 8, 16, 91, 93};
    private SalesForceQueryFileInfo queryInfo;
    QueryInParam[] queryInParam = null;
    int[][] inParamMap;
    protected JPanel mainPanel;
    JPanel subPanel1b;
    JPanel subPanel2a;
    JCheckBox mapDBcheckbox;
    JCheckBox useCustomSelection;
    JCheckBox dateFormatCheckbox;
    JComboBox paramChoice;
    JComboBox columnChoice;
    JComboBox typeChoice;
    JComboBox defaultChoice;
    JButton prevParamButton;
    JButton nextParamButton;
    JButton prevPanelButton;
    JButton cancelButton;
    JButton nextPanelButton;
    JButton setupSelection;
    JButton dateVariableButton;
    JTextField promptText;
    JTextField defaultText;
    JTextField dateFormatText;
    Vector availColumn = null;
    Vector distinctValue;
    boolean showingDefaultText;
    boolean[] isParamInitialized;
    boolean[] isMultiValue;
    int nParam;
    int prevParamIndex = 0;
    private boolean modified = false;
    private boolean defaultValueRequired = false;
    private Vector customSelection = null;
    private int customSelectionDataType = 12;
    private Window container = this;
    private boolean isCancel = false;

    public SalesForceParametersDialog(JDialog parent, SalesForceQueryFileInfo queryInfo) throws Exception {
        super((Dialog)parent, true);
        parent.setCursor(Cursor.getPredefinedCursor(3));
        this.queryInfo = queryInfo;
        this.init();
        this.setPosition();
        parent.setCursor(Cursor.getDefaultCursor());
    }

    public SalesForceParametersDialog(JFrame parent, SalesForceQueryFileInfo queryInfo) throws Exception {
        super((Frame)parent, true);
        parent.setCursor(Cursor.getPredefinedCursor(3));
        this.queryInfo = queryInfo;
        this.init();
        this.setPosition();
        parent.setCursor(Cursor.getDefaultCursor());
    }

    protected void init() throws Exception {
        this.inParamMap = QueryInParamSet.makeParamMap(this.queryInfo.getQuery());
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Initialize Parameters"));
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.setLayout(new BorderLayout());
        this.makeMainPanel();
        if (this.queryInfo.getInSet() != null) {
            this.queryInParam = this.queryInfo.getInSet().getParameter();
            boolean displayDefaults = false;
            for (int i = 0; i < this.nParam; ++i) {
                if (this.queryInParam[i] == null) continue;
                this.isParamInitialized[i] = true;
                if (i != 0) continue;
                displayDefaults = true;
            }
            if (displayDefaults) {
                this.resetAttributePanel();
            }
        }
        JPanel okPanel = new JPanel(new FlowLayout(2));
        this.nextPanelButton = new JButton(LanguageEncoder.getText("OK"));
        okPanel.add(this.nextPanelButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        okPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.nextPanelButton.addActionListener(this);
        bpanel.add((Component)this.mainPanel, "Center");
        bpanel.add((Component)okPanel, "South");
    }

    protected void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected void makeMainPanel() throws Exception {
        int i;
        String query = this.queryInfo.getQuery();
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("IN Parameters")));
        this.mainPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane();
        JTextArea sqlText = new JTextArea(query, 4, 50);
        scroll.getViewport().add(sqlText);
        sqlText.setEditable(false);
        Dimension d = scroll.getPreferredSize();
        if (d.getHeight() > 150.0) {
            scroll.setPreferredSize(new Dimension((int)d.getWidth(), 150));
        }
        topPanel.add("North", scroll);
        JPanel paramPanel = new JPanel();
        this.paramChoice = new JComboBox();
        String[] paramName = SalesForceQueryParser.getAllParameters(query);
        String[] multiValueParamName = SalesForceQueryParser.getMultiValueParameters(query);
        this.nParam = paramName.length;
        for (i = 0; i < this.nParam; ++i) {
            this.paramChoice.addItem(paramName[i]);
        }
        this.isParamInitialized = new boolean[this.nParam];
        this.isMultiValue = new boolean[this.nParam];
        for (i = 0; i < this.nParam; ++i) {
            this.isMultiValue[i] = false;
            if (multiValueParamName != null) {
                for (int j = 0; j < multiValueParamName.length; ++j) {
                    if (!paramName[i].equals(multiValueParamName[j])) continue;
                    this.isMultiValue[i] = true;
                    j = multiValueParamName.length;
                }
            }
            this.isParamInitialized[i] = false;
        }
        this.queryInParam = new QueryInParam[this.nParam];
        paramPanel.setLayout(new FlowLayout(0));
        paramPanel.add(new JLabel(LanguageEncoder.getText("Parameter")));
        paramPanel.add(this.paramChoice);
        this.paramChoice.addItemListener(this);
        topPanel.add("South", paramPanel);
        JPanel attributePanel = new JPanel();
        attributePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Attributes")));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        attributePanel.setLayout(gbl);
        JPanel subPanel1 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel subPanel1a = new JPanel();
        this.mapDBcheckbox = new JCheckBox(LanguageEncoder.getText("Map to field"));
        subPanel1a.add(this.mapDBcheckbox);
        this.mapDBcheckbox.addItemListener(this);
        this.columnChoice = new JComboBox();
        try {
            this.availColumn = this.createAvailColumnList((String)this.paramChoice.getItemAt(0));
        }
        catch (Exception ex) {
            this.availColumn = new Vector();
        }
        this.mapDBcheckbox.setEnabled(this.availColumn.size() > 0);
        this.subPanel1b = new JPanel();
        this.subPanel1b.add(this.columnChoice);
        this.setupColumnChoice();
        this.columnChoice.addItemListener(this);
        subPanel1.add(subPanel1a);
        subPanel1.add(this.subPanel1b);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbl.setConstraints(subPanel1, gbc);
        attributePanel.add(subPanel1);
        JPanel subPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel subPanel3a = new JPanel();
        this.useCustomSelection = new JCheckBox(LanguageEncoder.getText("Use custom selection choices"));
        subPanel3a.add(this.useCustomSelection);
        this.useCustomSelection.addItemListener(this);
        this.setupSelection = new JButton(LanguageEncoder.getText("Setup Choices"));
        JPanel subPanel3b = new JPanel();
        subPanel3b.add(this.setupSelection);
        this.setupSelection.setEnabled(false);
        this.setupSelection.addActionListener(this);
        subPanel3.add(subPanel3a);
        subPanel3.add(subPanel3b);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbl.setConstraints(subPanel3, gbc);
        attributePanel.add(subPanel3);
        JPanel subPanel2 = new JPanel(new BorderLayout());
        this.subPanel2a = new JPanel(new FlowLayout());
        this.subPanel2a.add(new JLabel(LanguageEncoder.getText("Default Value")));
        this.defaultText = new JTextField(10);
        this.subPanel2a.add(this.defaultText);
        this.dateVariableButton = new JButton(LanguageEncoder.getText("Date Variable"));
        this.subPanel2a.add(this.dateVariableButton);
        this.dateVariableButton.addActionListener(this);
        this.showingDefaultText = true;
        this.defaultChoice = new JComboBox();
        JPanel subPanel2b = new JPanel(new FlowLayout());
        subPanel2b.add(new JLabel(LanguageEncoder.getText("Data Type")));
        this.typeChoice = new JComboBox();
        subPanel2b.add(this.typeChoice);
        this.addAllTypes(this.typeChoice);
        subPanel2.add("West", this.subPanel2a);
        subPanel2.add("East", subPanel2b);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbl.setConstraints(subPanel2, gbc);
        attributePanel.add(subPanel2);
        JPanel subPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel subPanel4a = new JPanel();
        this.dateFormatCheckbox = new JCheckBox(LanguageEncoder.getText("Custom date format"));
        subPanel4a.add(this.dateFormatCheckbox);
        this.dateFormatCheckbox.addItemListener(this);
        this.dateFormatText = new JTextField(10);
        this.dateFormatText.setEnabled(false);
        JPanel subPanel4b = new JPanel();
        subPanel4b.add(this.dateFormatText);
        subPanel4.add(subPanel4a);
        subPanel4.add(subPanel4b);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbl.setConstraints(subPanel4, gbc);
        attributePanel.add(subPanel4);
        JPanel UIpanel = new JPanel(new FlowLayout(0));
        UIpanel.setBorder(new TitledBorder(LanguageEncoder.getText("User Interface")));
        UIpanel.add(new JLabel(LanguageEncoder.getText("Prompt Name:")));
        this.promptText = new JTextField((String)this.paramChoice.getItemAt(0), 20);
        UIpanel.add(this.promptText);
        JPanel bodyPanel = new JPanel(new BorderLayout());
        bodyPanel.add("North", attributePanel);
        bodyPanel.add("Center", UIpanel);
        JPanel flowPanel = new JPanel(new FlowLayout(2));
        this.prevParamButton = new JButton(LanguageEncoder.getText("Previous Parameter"));
        flowPanel.add(this.prevParamButton);
        this.nextParamButton = new JButton(LanguageEncoder.getText("Next Parameter"));
        flowPanel.add(this.nextParamButton);
        this.prevParamButton.addActionListener(this);
        this.nextParamButton.addActionListener(this);
        this.setFlowButtons();
        this.mainPanel.add("North", topPanel);
        this.mainPanel.add("Center", bodyPanel);
        this.mainPanel.add("South", flowPanel);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.paramChoice && this.prevParamIndex != this.paramChoice.getSelectedIndex()) {
            if (this.makeQueryInParam(this.prevParamIndex)) {
                this.prevParamIndex = this.paramChoice.getSelectedIndex();
                this.resetAttributePanel();
            }
        } else if (source == this.mapDBcheckbox) {
            if (this.mapDBcheckbox.isSelected() && this.useCustomSelection.isSelected()) {
                this.useCustomSelection.setSelected(false);
            }
            this.typeChoice.setEnabled(!this.mapDBcheckbox.isSelected());
            this.selectColumnChoice();
            this.setDefaultValueUI();
            if (this.mapDBcheckbox.isSelected()) {
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatCheckbox.setEnabled(false);
            } else {
                this.dateFormatCheckbox.setEnabled(true);
            }
        } else if (source == this.columnChoice) {
            this.setTypeChoice();
            this.setDefaultValueUI();
        } else if (source == this.useCustomSelection) {
            if (this.mapDBcheckbox.isSelected() && this.useCustomSelection.isSelected()) {
                this.mapDBcheckbox.setSelected(false);
            }
            this.setupSelection.setEnabled(this.useCustomSelection.isSelected());
            this.typeChoice.setEnabled(!this.useCustomSelection.isSelected());
            this.setTypeChoice();
            this.setDefaultValueUI();
            if (this.useCustomSelection.isSelected()) {
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatCheckbox.setEnabled(false);
            } else {
                this.dateFormatCheckbox.setEnabled(true);
            }
        } else if (source == this.dateFormatCheckbox) {
            if (this.dateFormatCheckbox.isSelected()) {
                this.dateFormatText.setEnabled(true);
            } else {
                this.dateFormatText.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.isCancel = false;
        Object source = e.getSource();
        int index = this.paramChoice.getSelectedIndex();
        if (source == this.prevParamButton || source == this.nextParamButton) {
            if (this.makeQueryInParam(index)) {
                this.isParamInitialized[index] = true;
                if (e.getSource() == this.prevParamButton && index > 0) {
                    this.paramChoice.setSelectedIndex(--index);
                } else if (e.getSource() == this.nextParamButton && index < this.nParam - 1) {
                    this.paramChoice.setSelectedIndex(++index);
                }
            }
        } else if (source == this.nextPanelButton) {
            if (this.makeQueryInParam(index)) {
                QueryInParamSet set = this.getQueryInParamSet();
                if (set == null) {
                    String paramString = "";
                    int count = 0;
                    for (int i = 0; i < this.isParamInitialized.length; ++i) {
                        if (this.isParamInitialized[i]) continue;
                        paramString = paramString + (String)this.paramChoice.getItemAt(i) + ", ";
                        ++count;
                    }
                    paramString = paramString.substring(0, paramString.length() - 2);
                    String message = count == 1 ? LanguageEncoder.getText("Parameter:") + " " + paramString + " " + LanguageEncoder.getText("is not initialized") : LanguageEncoder.getText("Parameters:") + " " + paramString + " " + LanguageEncoder.getText("are not initialized");
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), message);
                } else {
                    this.modified = true;
                    this.setVisible(false);
                    this.dispose();
                }
            }
        } else if (source == this.cancelButton) {
            this.isCancel = true;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.setupSelection) {
            CustomSelectionDialog cDialog = new CustomSelectionDialog((JDialog)this, this.queryInfo, this.availColumn, choiceMapToType[this.typeChoice.getSelectedIndex()], this.customSelection);
            cDialog.setVisible(true);
            if (cDialog.isModified()) {
                this.customSelection = cDialog.getSelectedValues();
                this.customSelectionDataType = cDialog.getSQLType();
            }
            this.setTypeChoice();
            this.setDefaultValueUI();
        } else if (source == this.dateVariableButton) {
            DateVariableDialog dialog = new DateVariableDialog(this, this.defaultText.getText());
            dialog.setVisible(true);
            if (dialog.isModified() && dialog.getText() != null) {
                this.defaultText.setText(dialog.getText());
                if (dialog.getText().toLowerCase().indexOf("currentdatetime") > -1) {
                    this.typeChoice.setSelectedItem(DataType.getTypeName(93));
                } else if (dialog.getText().toLowerCase().indexOf("currentdate") > -1) {
                    this.typeChoice.setSelectedItem(DataType.getTypeName(91));
                } else if (dialog.getText().toLowerCase().indexOf("currenttime") > -1) {
                    this.typeChoice.setSelectedItem(DataType.getTypeName(92));
                }
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    private void setTypeChoice() {
        boolean mapState = this.mapDBcheckbox.isSelected() || this.useCustomSelection.isSelected();
        this.typeChoice.setEnabled(!mapState);
        boolean typeFound = false;
        if (this.mapDBcheckbox.isSelected()) {
            int index = this.columnChoice.getSelectedIndex();
            if (mapState && index == 0) {
                ++index;
                this.selectColumnChoice();
            }
            for (int i = 0; i < choiceMapToType.length; ++i) {
                if (index <= 0 || this.getAvailColumn(index - 1).getSqlType() != choiceMapToType[i]) continue;
                this.typeChoice.setSelectedIndex(i);
                typeFound = true;
                break;
            }
        } else if (this.useCustomSelection.isSelected()) {
            for (int i = 0; i < choiceMapToType.length; ++i) {
                if (this.customSelectionDataType != choiceMapToType[i]) continue;
                this.typeChoice.setSelectedIndex(i);
                typeFound = true;
                break;
            }
        }
        if (!typeFound) {
            this.typeChoice.setSelectedIndex(0);
        }
    }

    private void addAllTypes(JComboBox choice) {
        for (int element : choiceMapToType) {
            choice.addItem(DataType.getTypeName(element));
        }
        if (this.mapDBcheckbox.isSelected() && this.availColumn.size() > 0) {
            int target = this.getAvailColumn(0).getSqlType();
            for (int i = 0; i < choiceMapToType.length; ++i) {
                if (target != choiceMapToType[i]) continue;
                choice.setSelectedIndex(i);
            }
        }
    }

    private void setFlowButtons() {
        int nParameter = this.paramChoice.getItemCount();
        int index = this.paramChoice.getSelectedIndex();
        this.prevParamButton.setEnabled(index > 0);
        this.nextParamButton.setEnabled(index < nParameter - 1);
    }

    private void setDefaultValueUI() {
        if (!(this.mapDBcheckbox.isSelected() || this.useCustomSelection.isSelected() || this.showingDefaultText)) {
            this.removeDefaultChoice();
        } else if (this.mapDBcheckbox.isSelected() || this.useCustomSelection.isSelected()) {
            this.resetDefaultChoice();
        }
    }

    private void removeDefaultChoice() {
        boolean saveState = this.mapDBcheckbox.isEnabled();
        this.setEnableState(false);
        this.showingDefaultText = true;
        this.subPanel2a.remove(this.defaultChoice);
        this.defaultText.setText("");
        this.subPanel2a.add(this.defaultText);
        this.subPanel2a.add(this.dateVariableButton);
        this.container.pack();
        this.container.validate();
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(saveState);
    }

    private void resetDefaultChoice() {
        Object defaultValue;
        QueryInParam currParam;
        boolean saveState = this.mapDBcheckbox.isEnabled();
        this.setEnableState(false);
        if (this.showingDefaultText) {
            this.subPanel2a.remove(this.defaultText);
            this.subPanel2a.remove(this.dateVariableButton);
            this.showingDefaultText = false;
        } else {
            this.subPanel2a.remove(this.defaultChoice);
        }
        this.defaultChoice.removeItemListener(this);
        this.defaultChoice = new JComboBox();
        if (this.useCustomSelection.isSelected()) {
            if (this.customSelection == null) {
                this.customSelection = new Vector();
            }
            for (int i = 0; i < this.customSelection.size(); ++i) {
                if (this.customSelection.elementAt(i) == null) continue;
                this.defaultChoice.addItem(this.customSelection.elementAt(i).toString());
            }
        } else if (this.columnChoice.getSelectedIndex() > 0) {
            AvailColumn temp = this.getAvailColumn(this.columnChoice.getSelectedIndex() - 1);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.distinctValue = this.queryInfo.getDistinctValues(temp.getTableName(), temp.getColumnName());
            this.setCursor(Cursor.getDefaultCursor());
            int size = this.distinctValue.size();
            for (int i = 0; i < size; ++i) {
                if (this.distinctValue.elementAt(i) == null) continue;
                this.defaultChoice.addItem(this.distinctValue.elementAt(i).toString());
            }
        }
        if ((currParam = this.queryInParam[this.paramChoice.getSelectedIndex()]) != null && (defaultValue = currParam.getDefaultValue()) != null) {
            String defaultString = defaultValue.toString();
            for (int i = 0; i < this.defaultChoice.getItemCount(); ++i) {
                if (!((String)this.defaultChoice.getItemAt(i)).equals(defaultString)) continue;
                this.defaultChoice.setSelectedIndex(i);
                break;
            }
        }
        this.subPanel2a.add(this.defaultChoice);
        this.container.pack();
        this.container.validate();
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(saveState);
    }

    private boolean areAllInitialized() {
        for (int i = 0; i < this.isParamInitialized.length; ++i) {
            if (this.isParamInitialized[i]) continue;
            return false;
        }
        return true;
    }

    private Object makeDefaultValue() {
        if (this.showingDefaultText) {
            try {
                return this.makeDefaultValueFromText();
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return this.makeDefaultValueFromChoice();
    }

    private Object makeDefaultValueFromChoice() {
        if (this.useCustomSelection.isSelected()) {
            return this.customSelection.elementAt(this.defaultChoice.getSelectedIndex());
        }
        return this.distinctValue.elementAt(this.defaultChoice.getSelectedIndex());
    }

    private Object makeDefaultValueFromText() throws IllegalArgumentException, NumberFormatException, ParseException {
        String error;
        String text = this.defaultText.getText();
        text = text.trim();
        int dataType = DataType.mapType(choiceMapToType[this.typeChoice.getSelectedIndex()]);
        if (this.defaultValueRequired && text.equals("")) {
            throw new IllegalArgumentException("Missing default value.");
        }
        String dateformat = null;
        if (this.dateFormatCheckbox.isSelected() && this.dateFormatText.getText() != null && !this.dateFormatText.getText().trim().equals("") && (error = QbDateFormat.checkDateFormat(dateformat = this.dateFormatText.getText())) != null) {
            throw new IllegalArgumentException(error);
        }
        if (text.toLowerCase().startsWith("currentdate") && dataType == 8 || text.toLowerCase().startsWith("currentTime") && dataType == 9 || text.toLowerCase().startsWith("currentdatetime") && dataType == 10) {
            try {
                Formula formula = new Formula(null, text);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse());
                return formula;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if (text.equals("") && dataType != 7) {
            return null;
        }
        return DataType.createObject(text, dataType, dateformat);
    }

    public QueryFileInfo getQueryFileInfo() {
        if (!this.areAllInitialized()) {
            return null;
        }
        QueryInParamSet inSet = new QueryInParamSet(this.queryInParam, this.queryInfo.getQuery());
        this.queryInfo.setInSet(inSet);
        return this.queryInfo;
    }

    public QueryInParamSet getQueryInParamSet() {
        if (!this.areAllInitialized()) {
            return null;
        }
        return new QueryInParamSet(this.queryInParam, this.queryInfo.getQuery());
    }

    public boolean makeCurrParam() {
        return this.makeQueryInParam(this.paramChoice.getSelectedIndex());
    }

    private boolean makeQueryInParam(int paramIndex) {
        Object defaultValue;
        String columnName;
        String tableName;
        boolean mapToColumn;
        String paramName = (String)this.paramChoice.getItemAt(paramIndex);
        String promptName = this.promptText.getText();
        String dateformat = null;
        if (this.dateFormatCheckbox.isSelected() && this.dateFormatText.getText() != null && !this.dateFormatText.getText().trim().equals("")) {
            dateformat = this.dateFormatText.getText();
        }
        if (mapToColumn = this.mapDBcheckbox.isSelected()) {
            int columnIndex = this.columnChoice.getSelectedIndex() - 1;
            tableName = this.getAvailColumn(columnIndex).getTableName();
            columnName = this.getAvailColumn(columnIndex).getColumnName();
        } else {
            tableName = "";
            columnName = "";
        }
        int sqlType = choiceMapToType[this.typeChoice.getSelectedIndex()];
        try {
            defaultValue = this.makeDefaultValue();
        }
        catch (Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().equals("Missing default value.")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please specify a default value for this parameter."));
            } else if (ex.getMessage() != null && ex.getMessage().endsWith("is invalid symbol for date format!")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Default value doesn't match data type."));
            }
            this.isParamInitialized[paramIndex] = false;
            return false;
        }
        this.queryInParam[paramIndex] = !this.isMultiValue[paramIndex] ? new QueryInParam(this.inParamMap[paramIndex], paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, null) : new QueryMultiValueInParam(this.inParamMap[paramIndex], paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, (Object)null, null);
        this.queryInParam[paramIndex].setDateFormat(dateformat);
        if (this.useCustomSelection.isSelected()) {
            this.queryInParam[paramIndex].setSelectionChoices(this.customSelection);
        }
        this.isParamInitialized[paramIndex] = true;
        return true;
    }

    private void resetAttributePanel() {
        this.setFlowButtons();
        int paramIndex = this.paramChoice.getSelectedIndex();
        this.resetColumnChoice(paramIndex);
        if (this.isParamInitialized[paramIndex]) {
            int choiceSize;
            QueryInParam currParam = this.queryInParam[paramIndex];
            this.promptText.setText(currParam.getPromptName());
            boolean mapToColState = currParam.isMapToColumnOnly();
            String dateformat = currParam.getDateFormat();
            if (dateformat != null) {
                this.dateFormatCheckbox.setSelected(true);
                this.dateFormatText.setText(dateformat);
            } else {
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatText.setText("");
            }
            this.mapDBcheckbox.setSelected(mapToColState);
            if (mapToColState) {
                int i;
                this.selectColumnChoice();
                choiceSize = this.columnChoice.getItemCount() - 1;
                boolean mapColumnFound = false;
                for (i = 0; i < choiceSize; ++i) {
                    if (!currParam.getCompleteName().equals(this.columnChoice.getItemAt(i + 1))) continue;
                    this.columnChoice.setSelectedIndex(i + 1);
                    mapColumnFound = true;
                }
                if (!mapColumnFound) {
                    if (this.availColumn != null) {
                        for (i = 0; i < this.availColumn.size(); ++i) {
                            if (!((AvailColumn)this.availColumn.get(i)).isDefaultColumn()) continue;
                            this.columnChoice.setSelectedIndex(i + 1);
                            mapColumnFound = true;
                        }
                    }
                    mapToColState = mapColumnFound;
                }
            } else {
                this.mapDBcheckbox.setSelected(mapToColState);
                this.columnChoice.setSelectedIndex(0);
            }
            this.columnChoice.setEnabled(mapToColState);
            if (currParam.getSelectionChoices() != null) {
                this.customSelectionDataType = currParam.getSqlType();
                this.customSelection = currParam.getSelectionChoices();
                this.useCustomSelection.setSelected(true);
            } else {
                this.customSelectionDataType = 12;
                this.customSelection = null;
                this.useCustomSelection.setSelected(false);
            }
            choiceSize = choiceMapToType.length;
            for (int i = 0; i < choiceSize; ++i) {
                if (choiceMapToType[i] != currParam.getSqlType()) continue;
                this.typeChoice.setSelectedIndex(i);
                break;
            }
            this.typeChoice.setEnabled(!mapToColState && !this.useCustomSelection.isSelected());
            this.setDefaultValueUI();
            Object defaultValue = currParam.getDefaultValue();
            Formula defaultValueVariable = currParam.getDefaultValueVariable();
            if (defaultValueVariable != null) {
                this.defaultText.setText(defaultValueVariable.getText());
            } else if (defaultValue != null) {
                this.defaultText.setText(DataType.toString(defaultValue, dateformat));
            }
        } else {
            this.promptText.setText((String)this.paramChoice.getItemAt(paramIndex));
            this.mapDBcheckbox.setSelected(false);
            this.useCustomSelection.setSelected(false);
            this.customSelectionDataType = 12;
            this.customSelection = null;
            if (this.availColumn.size() > 0) {
                int target = this.getAvailColumn(0).getSqlType();
                for (int i = 0; i < choiceMapToType.length; ++i) {
                    if (target != choiceMapToType[i]) continue;
                    this.typeChoice.setSelectedIndex(i);
                    break;
                }
            }
            this.setDefaultValueUI();
            this.defaultText.setText("");
            this.dateFormatCheckbox.setSelected(false);
            this.dateFormatText.setText("");
        }
    }

    private void resetColumnChoice(int paramIndex) {
        this.setEnableState(false);
        this.subPanel1b.remove(this.columnChoice);
        this.columnChoice.removeItemListener(this);
        this.columnChoice = new JComboBox();
        try {
            this.availColumn = this.createAvailColumnList((String)this.paramChoice.getItemAt(paramIndex));
        }
        catch (Exception ex) {
            this.availColumn = new Vector();
        }
        this.mapDBcheckbox.setEnabled(this.availColumn.size() > 0);
        this.typeChoice.setEnabled(!this.mapDBcheckbox.isSelected());
        this.setupColumnChoice();
        this.columnChoice.setSelectedIndex(0);
        this.columnChoice.setEnabled(false);
        this.columnChoice.addItemListener(this);
        this.subPanel1b.add(this.columnChoice);
        this.container.pack();
        this.container.validate();
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(this.availColumn.size() > 0);
    }

    private void setupColumnChoice() {
        int size = this.availColumn.size();
        this.columnChoice.addItem(LanguageEncoder.getText("Not Applicable"));
        for (int i = 0; i < size; ++i) {
            this.columnChoice.addItem(this.getAvailColumn(i).getCompleteName());
        }
        this.selectColumnChoice();
    }

    private void selectColumnChoice() {
        boolean mapState = this.mapDBcheckbox.isSelected();
        this.columnChoice.setEnabled(mapState);
        if (!mapState) {
            this.columnChoice.setSelectedIndex(0);
            return;
        }
        boolean findColumn = false;
        int size = this.availColumn.size();
        for (int i = 0; i < size; ++i) {
            if (!this.getAvailColumn(i).isDefaultColumn()) continue;
            this.columnChoice.setSelectedIndex(i + 1);
            if (this.typeChoice != null) {
                this.setTypeChoice();
            }
            findColumn = true;
            break;
        }
        if (!findColumn) {
            if (this.columnChoice.getItemCount() == 1) {
                this.columnChoice.setSelectedIndex(0);
            } else {
                this.columnChoice.setSelectedIndex(1);
                if (this.typeChoice != null) {
                    this.setTypeChoice();
                }
            }
        }
    }

    private void setEnableState(boolean state) {
        this.mapDBcheckbox.setEnabled(state);
        if (this.prevPanelButton != null) {
            this.prevPanelButton.setEnabled(state);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(state);
        }
        if (this.nextPanelButton != null) {
            this.nextPanelButton.setEnabled(state);
        }
    }

    protected Vector createAvailColumnList(String paramName) throws Exception {
        QueryInParamSet tmp = this.queryInfo.getInSet();
        this.queryInfo.setInSet(null);
        Vector result = AvailColumn.makeArray(this.queryInfo, paramName);
        this.queryInfo.setInSet(tmp);
        return result;
    }

    protected AvailColumn getAvailColumn(int index) {
        return (AvailColumn)this.availColumn.elementAt(index);
    }

    public void setDefaultValueRequired(boolean state) {
        this.defaultValueRequired = state;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

