/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryParser;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.SalesForceDataSourceNode;
import quadbase.datasourcemanager.manager.SalesForceParametersDialog;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.SalesForceQueryPreview;

public class SalesForceQueryDialog
extends JDialog
implements ActionListener {
    private JTextField nameField;
    private UndoTextArea queryArea;
    private JButton okButton;
    private JButton cancelButton;
    private JButton initializeButton;
    private JButton previewButton;
    private SalesForceDataSourceNode parent;
    private SalesForceQueryNode node;
    private Manager manager;
    boolean isModified = false;
    private QueryInParamSet inSet = null;

    public SalesForceQueryDialog(Manager frame, SalesForceDataSourceNode parent, SalesForceQueryNode node) {
        super(frame, LanguageEncoder.getText("Setup SalesForce query..."), true);
        this.manager = frame;
        this.parent = parent;
        this.node = node;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        upperPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel namePanel = new JPanel();
        namePanel.add(new JLabel(LanguageEncoder.getText("Name:") + " "));
        this.nameField = new JTextField(25);
        namePanel.add(this.nameField);
        this.queryArea = new UndoTextArea(6, 60);
        JScrollPane textPane = new JScrollPane(this.queryArea);
        textPane.setBorder(new TitledBorder("SOQL Query"));
        this.queryArea.setLineWrap(true);
        this.queryArea.setWrapStyleWord(true);
        upperPanel.add("North", namePanel);
        upperPanel.add("Center", textPane);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.initializeButton = new JButton(LanguageEncoder.getText("Initialize Parameters"));
        this.initializeButton.addActionListener(this);
        this.previewButton = new JButton(LanguageEncoder.getText("Preview Result"));
        this.previewButton.addActionListener(this);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new FlowLayout(1));
        lowerPanel.add(this.okButton);
        lowerPanel.add(this.cancelButton);
        lowerPanel.add(this.initializeButton);
        lowerPanel.add(this.previewButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", upperPanel);
        contentPane.add("South", lowerPanel);
        this.setValues();
    }

    private void setValues() {
        if (this.node != null) {
            this.nameField.setText(this.node.getName());
            this.queryArea.setText(this.node.getQuery());
            this.inSet = this.node.getInSet();
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public SalesForceQueryNode getNode() {
        return this.node;
    }

    private void cancel() {
        this.isModified = false;
        this.setVisible(false);
        this.manager.managerPane.closeEditOrAddNode();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String msg = null;
        if (e.getSource() == this.okButton) {
            String nodeName = this.nameField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter SalesForce query name!");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            String newQuery = this.queryArea.getText();
            if (SalesForceQueryParser.hasParameters(newQuery)) {
                this.inSet = SalesForceQueryParser.filterParameters(newQuery, this.inSet);
                if (SalesForceQueryParser.initializationRequired(this.inSet) && !this.showParameters(null)) {
                    return;
                }
            } else {
                this.inSet = null;
            }
            if (this.node == null) {
                this.node = new SalesForceQueryNode(nodeName);
                this.parent.add(this.node);
            } else {
                this.node.setUserObject(nodeName);
            }
            this.node.setQuery(newQuery);
            this.node.setInSet(this.inSet);
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.cancel();
        } else if (e.getSource() == this.initializeButton) {
            String newQuery = this.queryArea.getText();
            if (!SalesForceQueryParser.hasParameters(newQuery)) {
                new JMessageDialog((Dialog)this, "Information", LanguageEncoder.getText("This query does not contain parameters."));
            } else {
                this.inSet = SalesForceQueryParser.filterParameters(newQuery, this.inSet);
                this.showParameters(null);
            }
        } else if (e.getSource() == this.previewButton) {
            String newQuery = this.queryArea.getText();
            if (SalesForceQueryParser.hasParameters(newQuery)) {
                this.inSet = SalesForceQueryParser.filterParameters(newQuery, this.inSet);
                if (SalesForceQueryParser.initializationRequired(this.inSet) && !this.showParameters(null)) {
                    return;
                }
            } else {
                this.inSet = null;
            }
            SalesForceQueryFileInfo qfi = new SalesForceQueryFileInfo(this.parent.getUserName(), this.parent.getPassword(), newQuery, this.inSet);
            this.setCursor(Cursor.getPredefinedCursor(3));
            SalesForceQueryPreview preview = new SalesForceQueryPreview(this, qfi);
            this.setCursor(Cursor.getDefaultCursor());
            if (!preview.isCanceled()) {
                preview.setVisible(true);
            }
        }
    }

    private boolean showParameters(SalesForceQueryFileInfo qfi) {
        if (qfi == null) {
            qfi = new SalesForceQueryFileInfo(this.parent.getUserName(), this.parent.getPassword(), this.queryArea.getText(), this.inSet);
        }
        try {
            SalesForceParametersDialog d = new SalesForceParametersDialog(this, qfi);
            d.setVisible(true);
            if (d.isCancel()) {
                return false;
            }
            this.inSet = d.getQueryInParamSet();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to obtain column info from SalesForce.\n") + ex.getLocalizedMessage());
            return false;
        }
    }
}

