/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import quadbase.chart.ColData;
import quadbase.chart.SalesForceAccess;
import quadbase.common.paramquery.EnterInParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;

public class SalesForceQueryPreview
extends JDialog {
    private static final int DISPLAY_ROW = 20;
    private SalesForceQueryFileInfo sfQueryInfo;
    private JDialog parent;
    private boolean canceled = false;

    public SalesForceQueryPreview(JDialog parent, SalesForceQueryFileInfo sfQueryInfo) {
        super(parent, LanguageEncoder.getText("Query Result Preview"), true);
        this.parent = parent;
        this.sfQueryInfo = sfQueryInfo;
        this.init();
        this.setPosition();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        Container c = this.getContentPane();
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(2);
        c.setLayout(new BorderLayout());
        JButton okButton = new JButton(LanguageEncoder.getText("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SalesForceQueryPreview.this.dispose();
            }
        });
        c.add("South", okButton);
        try {
            ColData[] colData;
            if (this.sfQueryInfo.isParameterized()) {
                EnterInParamDialog enterDialog = new EnterInParamDialog((Frame)null, (QueryFileInfo)this.sfQueryInfo, true);
                enterDialog.show();
                if (enterDialog.isCancelled()) {
                    this.canceled = true;
                    return;
                }
                this.sfQueryInfo.getInSet().setParameter(enterDialog.getInParamValue());
            }
            if ((colData = SalesForceAccess.getColData(this.sfQueryInfo)) == null || colData.length == 0) {
                throw new Exception(LanguageEncoder.getText("Cannot obtain data"));
            }
            c.add("Center", new JScrollPane(this.createTable(colData), 20, 30));
        }
        catch (Exception ex) {
            JTextArea text = new JTextArea(LanguageEncoder.getText("Failed to retrieve data") + "\n" + ex.toString(), 10, 50);
            text.setEditable(false);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            c.add("Center", text);
        }
    }

    private Component createTable(ColData[] colData) {
        JTable table = new JTable(this.getRowData(colData), this.getColumnNames(colData));
        table.setGridColor(Color.lightGray);
        table.getTableHeader().setReorderingAllowed(false);
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        DefaultCellEditor noEditor = new DefaultCellEditor(notEditableField);
        table.setCellEditor(noEditor);
        table.setAutoResizeMode(0);
        return table;
    }

    private String[] getColumnNames(ColData[] colData) {
        String[] result = new String[colData.length - 1];
        for (int i = 0; i < colData.length - 1; ++i) {
            result[i] = colData[i].getName() + " (" + DataType.getTypeName(colData[i].getOriginalDataType()) + ")";
        }
        return result;
    }

    private Object[][] getRowData(ColData[] colData) {
        int rowCount = colData[0].getSize() > 20 ? 20 : colData[0].getSize();
        Object[][] result = new Object[rowCount][colData.length - 1];
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colData.length - 1; ++j) {
                result[i][j] = colData[j].getData(i);
            }
        }
        return result;
    }
}

