/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.ChooseDatabaseNodeDialog;
import quadbase.datasourcemanager.manager.ChooseJNDIDataSourceNodeDialog;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.IChangeDataRegistry;
import quadbase.datasourcemanager.manager.IChangeDataRegistryPlus;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;

public class SimpleDbJndiDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SimpleDbJndiDialog.class.getName());
    private JButton okButton;
    private JButton cancelButton;
    private JButton selectButton;
    private JRadioButton databaseRadioButton;
    private JRadioButton jndiRadioButton;
    private String[] ext;
    private boolean isModified = false;
    private JFrame parent;
    private DBInfoBasic dbInfo;
    private JFileChooser fileChooser;
    private BrowseDialog browseDialog;
    private IChangeDataRegistry changeDataRegistry;
    private IChangeDataRegistryPlus changeDataRegistryPlus;
    private BrowseDirectories browseDir;
    private JLabel url_jndiLookupName;
    private JTextField url_jndiLookupNameTextField;
    private JLabel driver_initialContextFactory;
    private JTextField driver_initialContextFactoryTextField;
    private JLabel username_providerUrl;
    private JTextField username_providerUrlTextField;
    private JLabel password;
    private JTextField passwordTextField;
    private static final int TEXTFIELD_LENGTH = 40;

    public SimpleDbJndiDialog(JFrame parent, DBInfoBasic dbInfo, IChangeDataRegistry changeDataRegistry, IChangeDataRegistryPlus plus) {
        super(parent, LanguageEncoder.getText("Setup Database / JNDI"), true);
        this.parent = parent;
        this.dbInfo = dbInfo;
        this.changeDataRegistry = changeDataRegistry;
        this.changeDataRegistryPlus = plus;
        this.ext = new String[]{"XML"};
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setMinimumSize(new Dimension(450, 210));
        JPanel bpanel = new JPanel(new BorderLayout());
        bpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Database Information")));
        this.databaseRadioButton = new JRadioButton(LanguageEncoder.getText("Database"), !this.dbInfo.isUseJNDIDataSource());
        this.databaseRadioButton.addItemListener(this);
        this.jndiRadioButton = new JRadioButton(LanguageEncoder.getText("JNDI"), this.dbInfo.isUseJNDIDataSource());
        this.jndiRadioButton.addItemListener(this);
        this.url_jndiLookupNameTextField = new JTextField(40);
        this.driver_initialContextFactoryTextField = new JTextField(40);
        this.username_providerUrlTextField = new JTextField(40);
        this.passwordTextField = new JPasswordField(40);
        JPanel dbJndiPanel = new JPanel(new BorderLayout());
        dbJndiPanel.add((Component)this.databaseRadioButton, "West");
        dbJndiPanel.add((Component)this.jndiRadioButton, "Center");
        bpanel.add((Component)dbJndiPanel, "North");
        JPanel gridBagPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gridBagPanel.setLayout(gbl);
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.insets = new Insets(5, 10, 0, 5);
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.url_jndiLookupName = new JLabel(LanguageEncoder.getText("URL:"));
        gbl.setConstraints(this.url_jndiLookupName, gbc);
        gridBagPanel.add(this.url_jndiLookupName);
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 10, 0, 5);
        this.driver_initialContextFactory = new JLabel(LanguageEncoder.getText("Driver:"));
        gbl.setConstraints(this.driver_initialContextFactory, gbc);
        gridBagPanel.add(this.driver_initialContextFactory);
        gbc.gridy = 2;
        this.username_providerUrl = new JLabel(LanguageEncoder.getText("User Name:"));
        gbl.setConstraints(this.username_providerUrl, gbc);
        gridBagPanel.add(this.username_providerUrl);
        gbc.gridy = 3;
        this.password = new JLabel(LanguageEncoder.getText("Password:"));
        gbl.setConstraints(this.password, gbc);
        gridBagPanel.add(this.password);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 0, 0, 10);
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        gbl.setConstraints(this.url_jndiLookupNameTextField, gbc);
        gridBagPanel.add(this.url_jndiLookupNameTextField);
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 10);
        gbl.setConstraints(this.driver_initialContextFactoryTextField, gbc);
        gridBagPanel.add(this.driver_initialContextFactoryTextField);
        gbc.gridy = 2;
        gbl.setConstraints(this.username_providerUrlTextField, gbc);
        gridBagPanel.add(this.username_providerUrlTextField);
        gbc.gridy = 3;
        gbl.setConstraints(this.passwordTextField, gbc);
        gridBagPanel.add(this.passwordTextField);
        bpanel.add((Component)gridBagPanel, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)bpanel, "Center");
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.selectButton = new JButton(LanguageEncoder.getText("Select"));
        this.selectButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.selectButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.switchDbToJndi(this.dbInfo.isUseJNDIDataSource());
    }

    private void switchDbToJndi(boolean toJndi) {
        this.url_jndiLookupName.setText(LanguageEncoder.getText(toJndi ? "JNDI Lookup Name" : "URL") + ":");
        this.url_jndiLookupNameTextField.setText(SimpleDbJndiDialog.nullToEmptyString(toJndi ? this.dbInfo.getJNDIName() : this.dbInfo.getURLString()));
        this.driver_initialContextFactory.setText(LanguageEncoder.getText(toJndi ? "Initial Context Factory" : "Driver") + ":");
        this.driver_initialContextFactoryTextField.setText(SimpleDbJndiDialog.nullToEmptyString(toJndi ? this.dbInfo.getContextFactory() : this.dbInfo.getDriverName()));
        this.username_providerUrl.setText(LanguageEncoder.getText(toJndi ? "Provider URL" : "Username") + ":");
        this.username_providerUrlTextField.setText(SimpleDbJndiDialog.nullToEmptyString(toJndi ? this.dbInfo.getProviderURL() : this.dbInfo.getUserID()));
        this.password.setVisible(!toJndi);
        this.passwordTextField.setText(SimpleDbJndiDialog.nullToEmptyString(toJndi ? "" : this.dbInfo.getPassword()));
        this.passwordTextField.setVisible(!toJndi);
    }

    private static String nullToEmptyString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isModified() {
        return this.isModified;
    }

    public DBInfoBasic getDBInfo() {
        DBInfoBasic tempDbInfo;
        if (this.databaseRadioButton.isSelected()) {
            tempDbInfo = new DBInfoBasic((IDatabaseInfo)this.dbInfo);
            tempDbInfo.setDriverName(this.driver_initialContextFactoryTextField.getText().trim());
            tempDbInfo.setURLString(this.url_jndiLookupNameTextField.getText().trim());
            tempDbInfo.setUserID(this.username_providerUrlTextField.getText().trim());
            tempDbInfo.setPassword(this.passwordTextField.getText().trim());
            tempDbInfo.setJNDIName(null);
        } else {
            tempDbInfo = new DBInfoBasic((IJNDIDatabaseInfo)this.dbInfo);
            tempDbInfo.setJNDIName(this.url_jndiLookupNameTextField.getText().trim());
            Hashtable<String, String> env = new Hashtable<String, String>();
            String ctxFactory = this.driver_initialContextFactoryTextField.getText().trim();
            String providerUrl = this.username_providerUrl.getText().trim();
            if (!ctxFactory.equals("")) {
                env.put("INITIAL_CONTEXT_FACTORY", ctxFactory);
            }
            if (!providerUrl.equals("")) {
                env.put("PROVIDER_URL", providerUrl);
            }
            tempDbInfo.setEnvProperties(env);
        }
        tempDbInfo.setUseJNDIDataSource(!this.databaseRadioButton.isSelected());
        return tempDbInfo;
    }

    private String loadFile() {
        String currentDir = this.browseDir.getDataRegistryDirectory();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                ExtensionFilter fileFilter = new ExtensionFilter(this.ext);
                this.fileChooser.addChoosableFileFilter(fileFilter);
                this.fileChooser.setCurrentDirectory(new File(currentDir));
            }
            this.fileChooser.showDialog(this.parent, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            this.browseDir.setDataRegistryDirectory(this.fileChooser.getCurrentDirectory().getAbsolutePath());
            return this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        if (this.browseDialog == null) {
            this.browseDialog = BrowseDialog.create(this.parent, currentDir, this.ext);
        }
        this.browseDialog.setVisible(true);
        if (this.browseDialog.getSelectedFile() != null) {
            this.browseDir.setDataRegistryDirectory(this.browseDialog.getCurrentDirectory());
        }
        return this.browseDialog.getSelectedFile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.isModified = true;
        } else if (source == this.selectButton) {
            DatabaseNode selectedNode;
            String fileName = null;
            fileName = this.changeDataRegistry != null ? this.changeDataRegistry.getSelectedFile(this, false) : this.loadFile();
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            String message = LanguageEncoder.getText("Cannot open specified data registry!\n");
            if (this.jndiRadioButton.isSelected()) {
                JNDIDataSourceNode selectedNode2;
                ChooseJNDIDataSourceNodeDialog chooseJndiDialog = null;
                try {
                    chooseJndiDialog = new ChooseJNDIDataSourceNodeDialog(this.parent, fileName, this.changeDataRegistryPlus);
                }
                catch (Exception e1) {
                    LOGGER.log(Level.WARNING, "Cannot open specified data registry!\n", e1);
                    JOptionPane.showMessageDialog(this, message + e1.getMessage(), LanguageEncoder.getText("Error"), 0);
                    return;
                }
                if (chooseJndiDialog.getRoot().getChildCount() <= 0) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("No JNDI data source entries. Please select another data registry file.\n"));
                    return;
                }
                chooseJndiDialog.setVisible(true);
                if (!chooseJndiDialog.isModified()) {
                    return;
                }
                JNDIDataSourceNode node = selectedNode2 = chooseJndiDialog.getSelectedNode();
                this.url_jndiLookupNameTextField.setText(node.getJNDIName());
                this.driver_initialContextFactoryTextField.setText(node.getContextFactory());
                this.username_providerUrlTextField.setText(node.getProviderURL());
                this.passwordTextField.setText("");
                return;
            }
            ChooseDatabaseNodeDialog chooseDBDialog = null;
            try {
                chooseDBDialog = new ChooseDatabaseNodeDialog(this.parent, fileName, this.changeDataRegistryPlus);
                if (chooseDBDialog.getRoot().getChildCount() <= 0) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("No database entries. Please select another data registry file.\n"));
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, message, ex);
                JOptionPane.showMessageDialog(this, message + ex.getMessage(), LanguageEncoder.getText("Error"), 0);
                return;
            }
            chooseDBDialog.setVisible(true);
            if (!chooseDBDialog.isModified()) {
                return;
            }
            DatabaseNode node = selectedNode = chooseDBDialog.getSelectedNode();
            this.driver_initialContextFactoryTextField.setText(node.getDriver());
            this.url_jndiLookupNameTextField.setText(node.getURL());
            this.username_providerUrlTextField.setText(node.getUserName());
            this.passwordTextField.setText(node.getPassword());
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    public void setBrowseDirectories(BrowseDirectories browseDir) {
        this.browseDir = browseDir;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object srcObj = e.getSource();
        if (e.getStateChange() == 1 && srcObj instanceof JRadioButton) {
            if (srcObj.equals(this.databaseRadioButton)) {
                this.jndiRadioButton.setSelected(false);
                this.switchDbToJndi(false);
            } else if (srcObj.equals(this.jndiRadioButton)) {
                this.databaseRadioButton.setSelected(false);
                this.switchDbToJndi(true);
            }
        }
    }
}

