/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.IDataInterchange;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.datasourcemanager.manager.Manager;

public class StartupDialog
extends JDialog
implements ActionListener {
    public static String[] invalidChar = new String[]{"*", "?", "\"", "<", ">", "|"};
    Manager manager;
    JButton cancelButton;
    JButton nextButton;
    JButton backButton;
    JRadioButton newcb;
    JRadioButton opencb;
    String selectedFile = null;
    boolean isModified = false;
    boolean isNewFile = false;

    public StartupDialog(Manager manager) {
        super(manager, LanguageEncoder.getText("Select Data Registry"), true);
        this.manager = manager;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel bpanel = new JPanel();
        bpanel.setLayout(new BorderLayout());
        this.newcb = new JRadioButton(LanguageEncoder.getText("Start a new data registry"));
        this.opencb = new JRadioButton(LanguageEncoder.getText("Open an existing data registry"));
        this.opencb.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.newcb);
        buttonGroup.add(this.opencb);
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new GridLayout(2, 1));
        gridpanel.add(this.newcb);
        gridpanel.add(this.opencb);
        bpanel.add("Center", gridpanel);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.backButton = new JButton(LanguageEncoder.getText("<< Back"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.nextButton = new JButton(LanguageEncoder.getText("Next >>"));
        this.backButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        if (this.manager.showBackButton() && this.manager.showStartupBackButton()) {
            okpanel.add(this.backButton);
        }
        okpanel.add(this.cancelButton);
        okpanel.add(this.nextButton);
        this.opencb.requestFocus();
        bpanel.add("South", okpanel);
        JPanel contentPane = (JPanel)this.getContentPane();
        this.setBackground(Color.lightGray);
        contentPane.setBorder(new TitledBorder(LanguageEncoder.getText("Please select an option")));
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", bpanel);
    }

    public boolean isNewFile() {
        return this.isNewFile;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXMLDataRegistry(String url) throws Exception {
        boolean bl;
        InputStreamReader iReader = null;
        DataInputStream instream = null;
        BufferedReader buffer = null;
        try {
            instream = new ReadDataFile().getInputStream(url);
            iReader = new InputStreamReader(instream);
            buffer = new BufferedReader(iReader);
            String tmp = null;
            while ((tmp = buffer.readLine()) != null) {
                if (tmp.toUpperCase().indexOf("<DATASOURCES") < 0) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            CloseUtils.close(buffer);
            CloseUtils.close(iReader);
            CloseUtils.close(instream);
            throw throwable;
        }
        {
            CloseUtils.close(buffer);
            CloseUtils.close(iReader);
            CloseUtils.close(instream);
            return bl;
        }
        boolean bl2 = false;
        CloseUtils.close(buffer);
        CloseUtils.close(iReader);
        CloseUtils.close(instream);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block22: {
            IDataInterchange ic;
            block23: {
                ic = this.manager.getInterchangeProcess();
                if (e.getSource() != this.nextButton) break block23;
                String title = LanguageEncoder.getText("Open Data Registry");
                this.isNewFile = this.newcb.isSelected();
                if (this.isNewFile) {
                    this.isNewFile = true;
                    title = LanguageEncoder.getText("New Data Registry");
                }
                this.setVisible(false);
                this.dispose();
                OpenFileDialog fDialog = new OpenFileDialog(this.manager, title, null, new String[]{"XML"}, this.manager.getDataRegistryDirectory(), true);
                fDialog.setVisible(true);
                this.selectedFile = fDialog.getSelectedFile();
                this.manager.setDataRegistryDirectory(fDialog.getCurrentDirectory());
                if (this.selectedFile == null) break block22;
                String msg = null;
                if (StartupDialog.containInvalidChar(this.selectedFile)) {
                    msg = LanguageEncoder.getText("A filename contains invalid characters");
                } else if (this.selectedFile.length() > 100) {
                    msg = LanguageEncoder.getText("Invalid file name!");
                } else if (this.isNewFile && (this.selectedFile.endsWith("/") || this.selectedFile.endsWith("\\"))) {
                    msg = LanguageEncoder.getText("Invalid file name!");
                }
                if (msg != null) {
                    this.selectedFile = null;
                    new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                if (!this.selectedFile.toUpperCase().endsWith(".XML")) {
                    this.selectedFile = this.selectedFile + ".xml";
                }
                if (this.isNewFile && OverWriteDialog.continueSave(this.manager, this.selectedFile) || !this.isNewFile && OverWriteDialog.isFileExisted(this.manager, this.selectedFile)) {
                    if (!this.isNewFile) {
                        try {
                            if (!StartupDialog.isXMLDataRegistry(this.selectedFile)) {
                                msg = LanguageEncoder.getText("It is not data registry file");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (msg != null) {
                            this.selectedFile = null;
                            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                            return;
                        }
                    }
                    this.isModified = true;
                    break block22;
                } else {
                    this.selectedFile = null;
                    return;
                }
            }
            if (e.getSource() == this.backButton) {
                if (ic != null) {
                    ic.back();
                } else {
                    System.out.println("StartupDialog : BACK");
                }
            } else if (e.getSource() == this.backButton) {
                if (ic != null) {
                    ic.back();
                } else {
                    System.out.println("StartupDialog : BACK");
                }
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public static boolean containInvalidChar(String str) {
        for (String element : invalidChar) {
            if (str.indexOf(element) < 0) continue;
            return true;
        }
        return false;
    }
}

