/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ReadURL;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.Manager;

public class UpdateDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JComboBox dirCombo;
    private JButton addDir;
    private JButton addFile;
    private JButton removeFile;
    private JButton okButton;
    private JButton cancelButton;
    private JList availList;
    private JList selectedList;
    private JCheckBox connectionCheck;
    private Vector<File> files = new Vector();
    private Vector<String> fileNames = new Vector();
    private Vector<String> selectedNames = new Vector();
    private boolean connectionOnly;
    private boolean isReport;
    Manager manager;
    private String currentDir;
    public boolean isCancelled = false;

    public UpdateDialog(Manager manager) {
        super(manager, "Update data sources of reports", true);
        this.manager = manager;
        this.isReport = true;
        this.init();
        this.setPosition();
    }

    public UpdateDialog(Manager manager, boolean isReport) {
        super(manager, isReport ? "Update data sources of reports" : "Update data sources of charts", true);
        this.manager = manager;
        this.isReport = isReport;
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        if (this.isReport) {
            topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please select the reports you want to update data source of")));
        } else {
            topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please select the charts you want to update data source of")));
        }
        topPanel.setLayout(new BorderLayout());
        JPanel dirPanel = new JPanel();
        dirPanel.setLayout(new BorderLayout());
        dirPanel.add("West", new JLabel(LanguageEncoder.getText("Directory")));
        this.dirCombo = new JComboBox();
        dirPanel.add("Center", this.dirCombo);
        this.dirCombo.addItemListener(this);
        this.addDir = new JButton(LanguageEncoder.getText("Add"));
        dirPanel.add("East", this.addDir);
        this.addDir.addActionListener(this);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new GridLayout(1, 2, 5, 5));
        if (this.isReport) {
            titlePanel.add(new JLabel(LanguageEncoder.getText("reports in the directory")));
            titlePanel.add(new JLabel(LanguageEncoder.getText("selected reports")));
        } else {
            titlePanel.add(new JLabel(LanguageEncoder.getText("charts in the directory")));
            titlePanel.add(new JLabel(LanguageEncoder.getText("selected charts")));
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(8, 1, 5, 5));
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(new JLabel(""));
        this.addFile = new JButton(LanguageEncoder.getText("Add"));
        buttonPanel.add(this.addFile);
        this.addFile.addActionListener(this);
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(new JLabel(""));
        this.removeFile = new JButton(LanguageEncoder.getText("Remove"));
        buttonPanel.add(this.removeFile);
        this.removeFile.addActionListener(this);
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(new JLabel(""));
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.availList = new JList();
        selectPanel.add(new JScrollPane(this.availList));
        selectPanel.add(buttonPanel);
        MouseAdapter addListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String dir = (String)UpdateDialog.this.dirCombo.getSelectedItem();
                    if (!dir.endsWith("\\")) {
                        dir = dir + "\\";
                    }
                    boolean exists = false;
                    for (int i = 0; i < UpdateDialog.this.selectedNames.size(); ++i) {
                        if (!((String)UpdateDialog.this.selectedNames.elementAt(i)).equals(dir + (String)UpdateDialog.this.availList.getSelectedValue())) continue;
                        exists = true;
                    }
                    if (!exists) {
                        UpdateDialog.this.selectedNames.addElement(dir + (String)UpdateDialog.this.availList.getSelectedValue());
                        UpdateDialog.this.selectedList.setListData(UpdateDialog.this.selectedNames);
                    }
                }
            }
        };
        this.availList.addMouseListener(addListener);
        JPanel resultPanel = new JPanel();
        resultPanel.setLayout(new GridLayout(1, 1, 5, 5));
        this.selectedList = new JList();
        resultPanel.add(new JScrollPane(this.selectedList));
        MouseAdapter removeListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int idx = UpdateDialog.this.availList.locationToIndex(e.getPoint());
                    UpdateDialog.this.selectedNames.removeElementAt(idx);
                    UpdateDialog.this.selectedList.setListData(UpdateDialog.this.selectedNames);
                }
            }
        };
        this.selectedList.addMouseListener(removeListener);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new GridLayout(1, 2, 5, 5));
        listPanel.add(selectPanel);
        listPanel.add(resultPanel);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add("North", titlePanel);
        mainPanel.add("Center", listPanel);
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new FlowLayout(0));
        this.connectionCheck = new JCheckBox(LanguageEncoder.getText("connection info only"));
        checkPanel.add(this.connectionCheck);
        topPanel.add("North", dirPanel);
        topPanel.add("Center", mainPanel);
        topPanel.add("South", checkPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        bottomPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        bottomPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        panel.add("Center", topPanel);
        panel.add("South", bottomPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UpdateDialog.this.isCancelled = true;
            }
        });
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.width = (int)((double)screenSize.width * 0.5);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.addDir) {
            String directory;
            if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                JFileChooser fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                fileChooser.setFileSelectionMode(1);
                fileChooser.setCurrentDirectory(new File(this.currentDir));
                fileChooser.showDialog(this.manager, null);
                if (fileChooser.getSelectedFile() == null) {
                    return;
                }
                directory = fileChooser.getSelectedFile().getAbsolutePath();
                this.currentDir = fileChooser.getCurrentDirectory().getAbsolutePath();
            } else {
                BrowseDialog browseDialog = null;
                browseDialog = BrowseDialog.create(this.manager, this.currentDir, new String[]{"*"});
                browseDialog.setVisible(true);
                directory = this.currentDir = browseDialog.getCurrentDirectory();
            }
            boolean exists = false;
            for (int i = 0; i < this.dirCombo.getItemCount(); ++i) {
                String item;
                if (this.dirCombo.getItemAt(i) == null || !(item = this.dirCombo.getItemAt(i).toString()).equals(directory)) continue;
                exists = true;
            }
            if (!exists) {
                this.dirCombo.addItem(directory);
                this.dirCombo.setSelectedItem(directory);
            }
        } else if (target == this.addFile) {
            String dir = (String)this.dirCombo.getSelectedItem();
            if (dir == null) {
                return;
            }
            if (!dir.endsWith("\\")) {
                dir = dir + "\\";
            }
            for (int i = 0; i < this.availList.getSelectedValues().length; ++i) {
                boolean exists = false;
                for (int j = 0; j < this.selectedNames.size(); ++j) {
                    if (!this.selectedNames.elementAt(j).equals(dir + (String)this.availList.getSelectedValues()[i])) continue;
                    exists = true;
                }
                if (exists) continue;
                this.selectedNames.addElement(dir + this.availList.getSelectedValues()[i]);
            }
            this.selectedList.setListData(this.selectedNames);
        } else if (target == this.removeFile) {
            int len = this.selectedList.getSelectedIndices().length;
            for (int i = len - 1; i >= 0; --i) {
                this.selectedNames.removeElementAt(this.selectedList.getSelectedIndices()[i]);
            }
            this.selectedList.setListData(this.selectedNames);
        } else if (target == this.okButton) {
            if (this.selectedNames == null || this.selectedNames.size() == 0) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select at least one report/chart!"));
                return;
            }
            this.connectionOnly = this.connectionCheck.isSelected();
            this.setVisible(false);
            this.dispose();
        } else if (target == this.cancelButton) {
            this.isCancelled = true;
            this.selectedNames = null;
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.dirCombo) {
            String directory = (String)this.dirCombo.getSelectedItem();
            String[] validExtension = this.isReport ? new String[]{"RPT", "XML", "PAK"} : new String[]{"CHT", "TPL", "QCH", "PAC"};
            if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                File dir = new File(directory);
                File[] fileList = dir.listFiles();
                this.files = new Vector();
                this.fileNames = new Vector();
                for (int i = 0; fileList != null && i < fileList.length; ++i) {
                    if (!fileList[i].isFile() || !this.hasValidExtension(fileList[i].getName(), validExtension)) continue;
                    this.files.addElement(fileList[i]);
                    this.fileNames.addElement(fileList[i].getName());
                }
                this.availList.setListData(this.fileNames);
            } else {
                String[] filenameList;
                try {
                    filenameList = ReadURL.getFilename(directory, validExtension, "", false, false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                this.availList.setListData(filenameList);
            }
        }
    }

    private boolean hasValidExtension(String filename, String[] extension) {
        for (String element : extension) {
            if (!filename.toUpperCase().endsWith(element)) continue;
            return true;
        }
        return false;
    }

    public Vector<String> getSelectedNames() {
        return this.selectedNames;
    }

    public boolean isConnectionOnly() {
        return this.connectionOnly;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDir = dir;
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }
}

