/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLUtil;
import quadbase.datasourcemanager.manager.BigDataNode;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.SOAPDataSourceNode;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceDataSourceNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;

public class WriteXMLDataSources {
    Writer out;
    int index = -1;
    DefaultMutableTreeNode root;
    String encoding = ServerMessage.xmlEncoding;

    public static void writeDataSources(String xmlFile, Object root) throws Exception {
        WriteXMLDataSources.writeDataSources(xmlFile, root, true, null, false);
    }

    public static void writeDataSources(String xmlFile, Object root, boolean rename, String encoding, boolean fromLoadBalancer) throws Exception {
        if (xmlFile == null || xmlFile.trim().equals("")) {
            throw new IOException("No file name provided!");
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        WriteXMLDataSources writer = new WriteXMLDataSources((DefaultMutableTreeNode)root);
        writer.encoding = ServerMessage.xmlEncoding;
        if (encoding != null && !encoding.equals("ISO-8859-1")) {
            writer.setEncoding(encoding);
        }
        writer.saveToOutputStream(fstream);
        try {
            WriteDataFile wdfile = new WriteDataFile();
            if (rename && !xmlFile.endsWith(".xml")) {
                xmlFile = xmlFile + ".xml";
            }
            wdfile.output(fstream.toByteArray(), xmlFile, false, fromLoadBalancer);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            fstream.close();
        }
    }

    public WriteXMLDataSources(DefaultMutableTreeNode root) {
        this.root = root;
        this.encoding = ServerMessage.xmlEncoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void saveToOutputStream(OutputStream sout) throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter(sout, this.encoding));
        this.saveToDataOutput();
        this.out.flush();
        this.out.close();
    }

    private void tab() throws IOException {
        for (int i = 0; i < this.index; ++i) {
            this.out.write("  ");
        }
    }

    private void printElt(DefaultMutableTreeNode node) throws IOException {
        String elt = node.getUserObject().toString();
        if (elt.equalsIgnoreCase("DataSources")) {
            String[] attr = new String[]{"registryID", "lastID"};
            String[] vals = new String[]{((DefaultDataSourceNode)node).getRegistryID(), ((DefaultDataSourceNode)node).getLastID()};
            this.openElt(elt, attr, vals);
        } else {
            this.openElt(elt);
        }
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            TreeNode tmp = node.getChildAt(i);
            if (tmp instanceof BigDataNode) {
                this.printElt((BigDataNode)tmp, false);
                continue;
            }
            if (tmp instanceof DatabaseNode) {
                this.printElt((DatabaseNode)tmp, true);
                continue;
            }
            if (tmp instanceof JNDIDataSourceNode) {
                this.printElt((JNDIDataSourceNode)tmp);
                continue;
            }
            if (tmp instanceof XMLFileNode) {
                this.printElt((XMLFileNode)tmp);
                continue;
            }
            if (tmp instanceof TextFileNode) {
                this.printElt((TextFileNode)tmp);
                continue;
            }
            if (tmp instanceof ClassFileNode) {
                this.printElt((ClassFileNode)tmp);
                continue;
            }
            if (tmp instanceof EJBNode) {
                this.printElt((EJBNode)tmp);
                continue;
            }
            if (tmp instanceof SOAPDataSourceNode) {
                this.printElt((SOAPDataSourceNode)tmp);
                continue;
            }
            if (tmp instanceof SOAPViewNode) {
                this.printElt((SOAPViewNode)tmp);
                continue;
            }
            if (tmp instanceof SalesForceDataSourceNode) {
                this.printElt((SalesForceDataSourceNode)tmp);
                continue;
            }
            if (tmp instanceof ExcelFileNode) {
                this.printElt((ExcelFileNode)tmp);
                continue;
            }
            this.printElt((DefaultMutableTreeNode)tmp);
        }
        this.closeElt(elt);
    }

    private void printElt(JNDIDataSourceNode node) throws IOException {
        String[] attr = new String[]{"name", "JNDIName", "Context_Factory", "Provider_URL", "autoJoin", "tableNameFormat"};
        String[] vals = new String[]{node.getName(), node.getJNDIName(), node.getContextFactory(), node.getProviderURL(), node.isAutoJoin() + "", node.getTableNameFormat() + ""};
        this.openElt("JNDIDataSource", attr, vals);
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            TreeNode subNode = node.getChildAt(i);
            for (int j = 0; j < subNode.getChildCount(); ++j) {
                if (subNode.getChildAt(j) instanceof QueryNode) {
                    this.printElt((QueryNode)subNode.getChildAt(j));
                    continue;
                }
                this.printElt((DataViewNode)subNode.getChildAt(j));
            }
        }
        this.closeElt("JNDIDataSource");
    }

    private void printElt(DatabaseNode node, boolean isDB) throws IOException {
        String[] vals;
        String[] attr;
        String addDb = "";
        Vector dbs = node.getAdditionalDb();
        if (dbs != null) {
            for (int i = 0; i < dbs.size(); ++i) {
                addDb = addDb + dbs.get(i);
                if (i >= dbs.size() - 1) continue;
                addDb = addDb + "_&_";
            }
        }
        if (node.isPasswordSaved()) {
            attr = new String[]{"name", "url", "driver", "requireLogin", "userName", "encryptedPassword", "autoJoin", "tableNameFormat", "additionalDb"};
            vals = new String[]{node.getName(), node.getURL(), node.getDriver(), node.isLoginRequired() + "", node.getUserName(), Coder.encode(node.getPassword()), node.isAutoJoin() + "", node.getTableNameFormat() + "", addDb};
        } else {
            attr = new String[]{"name", "url", "driver", "requireLogin", "autoJoin", "tableNameFormat", "additionalDb"};
            vals = new String[]{node.getName(), node.getURL(), node.getDriver(), node.isLoginRequired() + "", node.isAutoJoin() + "", node.getTableNameFormat() + "", addDb};
        }
        if (isDB) {
            this.openElt("Database", attr, vals);
        } else {
            this.openElt("BigData", attr, vals);
        }
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            TreeNode subNode = node.getChildAt(i);
            for (int j = 0; j < subNode.getChildCount(); ++j) {
                if (subNode.getChildAt(j) instanceof QueryNode) {
                    this.printElt((QueryNode)subNode.getChildAt(j));
                    continue;
                }
                this.printElt((DataViewNode)subNode.getChildAt(j));
            }
        }
        if (isDB) {
            this.closeElt("Database");
        } else {
            this.closeElt("BigData");
        }
    }

    private void printElt(QueryNode node) throws IOException {
        String[] vals;
        String[] attr;
        if (node.isQueryBuilderUsed()) {
            attr = new String[]{"id", "name", "useQueryBuilder", "queryFile", "dictionary"};
            vals = new String[]{node.getID(), node.getName(), node.isQueryBuilderUsed() + "", node.getQueryFile(), node.isDictionaryCompatible() + ""};
        } else {
            attr = new String[]{"id", "name", "useQueryBuilder"};
            vals = new String[]{node.getID(), node.getName(), node.isQueryBuilderUsed() + ""};
        }
        this.openElt("Query", attr, vals);
        if (node.getInSet() != null) {
            this.printElt(node.getInSet());
        }
        this.printElt("SQLStatement", node.getSQL());
        this.closeElt("Query");
    }

    private void printElt(DataViewNode node) throws IOException {
        String[] attr = new String[]{"name", "queryFile"};
        String[] vals = new String[]{node.getName(), node.getQueryFile()};
        this.openElt("DataView", attr, vals);
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            TreeNode subNode = node.getChildAt(i);
            if (!(subNode instanceof DataViewQueryNode)) continue;
            this.printElt((DataViewQueryNode)subNode);
        }
        this.closeElt("DataView");
    }

    private void printElt(DataViewQueryNode node) throws IOException {
        String[] attr = new String[]{"id", "name", "queryFile", "dataviewFile"};
        String[] vals = new String[]{node.getID(), node.getName(), node.getQueryFile(), node.getDataViewFile()};
        this.openElt("DataViewQuery", attr, vals);
        this.printElt("SQLStatement", node.getSQL());
        this.closeElt("DataViewQuery");
    }

    private void printElt(XMLFileNode node) throws IOException {
        String dtdTreeFileName;
        String[] attr = new String[]{"id", "name", "location", "isQBFormat", "verify", "dtd", "dtdTreeFileName"};
        String dtd = node.getDTD();
        if (dtd == null) {
            dtd = "";
        }
        if ((dtdTreeFileName = node.getDTDTreeFileName()) == null) {
            dtdTreeFileName = "";
        }
        String[] vals = new String[]{node.getID(), node.getName(), node.getFile(), node.isQBFormat() + "", node.isVerify() + "", dtd, dtdTreeFileName};
        this.openElt("XMLFile", attr, vals);
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            TreeNode subNode = node.getChildAt(i);
            if (!(subNode instanceof XMLQueryNode)) continue;
            this.printElt((XMLQueryNode)subNode);
        }
        this.closeElt("XMLFile");
    }

    private void printElt(XMLQueryNode node) throws IOException {
        int ct = node.getSelectedFieldCt();
        String[] attr = new String[]{"id", "name", "fieldCt"};
        String[] vals = new String[]{node.getID(), node.getName(), ct + ""};
        this.openElt("XMLQuery", attr, vals);
        for (int i = 0; i < ct; ++i) {
            String[] fieldname;
            String[] tagname;
            XMLFieldInfo field = node.getSelectedFieldInfo(i);
            int xmlType = field.getXMLType();
            String alias = null;
            alias = field.getAlias() == null ? "" : field.getAlias();
            String dateFormat = null;
            dateFormat = field.getDateFormat() == null ? "" : field.getDateFormat();
            if (xmlType == 1) {
                tagname = new String[]{"path", "xmltype", "eltDataType", "dateFormat", "isExpandable", "isRequired", "alias"};
                fieldname = new String[]{field.getPathToString(), xmlType + "", field.getElementDataType(), dateFormat, field.isExpandable() + "", field.isRequired() + "", alias};
                this.printElt("SelectedField", null, tagname, fieldname);
                continue;
            }
            if (xmlType != 2) continue;
            tagname = new String[]{"path", "xmltype", "attrName", "attrDataType", "dateFormat", "isExpandable", "isRequired", "alias"};
            fieldname = new String[]{field.getPathToString(), xmlType + "", field.getAttributeName(), field.getAttributeDataType(), dateFormat, field.isExpandable() + "", field.isRequired() + "", alias};
            this.printElt("SelectedField", null, tagname, fieldname);
        }
        String condition = node.getConditionStatement();
        if (condition == null) {
            condition = "";
        }
        this.printElt("ConditionStatement", condition);
        if (node.getInSet() != null) {
            this.printElt(node.getInSet());
        }
        this.closeElt("XMLQuery");
    }

    private void printElt(TextFileNode node) throws IOException {
        String[] attr = new String[]{"id", "name", "location"};
        String[] vals = new String[]{node.getID(), node.getName(), node.getFile()};
        this.printElt("TXTFile", null, attr, vals);
    }

    private void printElt(SOAPDataSourceNode node) throws IOException {
        String[] attr = new String[]{"id", "name", "wsdlUri"};
        String[] vals = new String[]{node.getID(), node.getName(), node.getWsdlURI()};
        this.openElt("SOAPService", attr, vals);
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            TreeNode subNode = node.getChildAt(i);
            if (!(subNode instanceof SOAPViewNode)) continue;
            this.printElt((SOAPViewNode)subNode);
        }
        this.closeElt("SOAPService");
    }

    private void printElt(SOAPViewNode node) throws IOException {
        String[] attr = new String[]{"id", "name", "serviceNameNamespace", "serviceNameLocalName", "portName", "operationName", "schemaTreeFileName", "returnParamName"};
        String[] vals = new String[]{node.getID(), node.getName(), node.getServiceName().getNamespaceURI(), node.getServiceName().getLocalPart(), node.getPortName(), node.getOperationName(), node.getSchemaTreeFileName(), node.getReturnParamName()};
        this.openElt("SOAPView", attr, vals);
        try {
            SOAPParam.writeArrayXML(this.out, node.getParameters());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.closeElt("SOAPView");
    }

    private void printElt(SalesForceDataSourceNode node) throws IOException {
        String[] attr = new String[]{"id", "name", "username", "encryptedPassword"};
        String[] vals = new String[]{node.getID(), node.getName(), node.getUserName(), Coder.encode(node.getPassword())};
        this.openElt("SalesForceConnection", attr, vals);
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            TreeNode subNode = node.getChildAt(i);
            if (!(subNode instanceof SalesForceQueryNode)) continue;
            this.printElt((SalesForceQueryNode)subNode);
        }
        this.closeElt("SalesForceConnection");
    }

    private void printElt(SalesForceQueryNode node) throws IOException {
        String[] attr = new String[]{"id", "name"};
        String[] vals = new String[]{node.getID(), node.getName()};
        this.openElt("SalesForceQuery", attr, vals);
        this.printElt("SOQLQuery", node.getQuery());
        try {
            if (node.getInSet() != null) {
                node.getInSet().writeXML(this.out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.closeElt("SalesForceQuery");
    }

    private void printElt(ExcelFileNode node) throws IOException {
        String[] attr = new String[]{"id", "name", "filename", "sheetName", "minRow", "minColumn", "maxRow", "maxColumn", "includeNewData", "hasHeader", "dataAreRows"};
        String[] vals = new String[]{node.getID(), node.getName(), node.getFilename(), node.getSheetName(), node.getMinRow() + "", node.getMinColumn() + "", node.getMaxRow() + "", node.getMaxColumn() + "", node.isIncludeNewData() + "", node.isHasHeader() + "", node.isDataAreRows() + ""};
        this.openElt("ExcelFile", attr, vals);
        int[] dataTypes = node.getDataTypes();
        if (dataTypes != null) {
            for (int dataType : dataTypes) {
                this.printElt("DATATYPE", dataType + "", null, null);
            }
        }
        this.closeElt("ExcelFile");
    }

    private void printElt(ClassFileNode node) throws IOException {
        String[] attr = new String[]{"id", "name", "location"};
        String[] vals = new String[]{node.getID(), node.getName(), node.getFile()};
        this.printElt("ClassFile", null, attr, vals);
    }

    private void printElt(EJBNode node) throws IOException {
        int j;
        int i;
        int ct = node.getMethodCount();
        Hashtable env = node.getEnvironment();
        int envsize = 0;
        if (env != null) {
            envsize = env.size();
        }
        String[] attr = new String[]{"id", "name", "jndiname", "homename", "remotename", "size", "envsize"};
        String[] vals = new String[]{node.getID(), node.getName(), node.getJNDIName(), node.getHomeName(), node.getRemoteName(), Integer.valueOf(ct).toString(), Integer.valueOf(envsize).toString()};
        this.openElt("EJB", attr, vals);
        for (i = 0; i < ct; ++i) {
            String[] methodAttr = new String[]{"name"};
            String[] methodVals = new String[]{node.getMethod(i)};
            this.printElt("Method", null, methodAttr, methodVals);
        }
        for (i = 0; i < ct; ++i) {
            Class[] param = node.getParam(i);
            int size = param.length;
            String[] paramAttr = this.getEJBAttr("param", size);
            String[] paramVals = new String[size + 2];
            for (j = 0; j < size; ++j) {
                paramVals[j] = param[j].getName();
            }
            paramVals[size] = node.getMethod(i);
            paramVals[size + 1] = Integer.valueOf(size).toString();
            this.printElt("ParamType", null, paramAttr, paramVals);
        }
        for (i = 0; i < ct; ++i) {
            Class retClass = node.getReturnType(i);
            String[] retAttr = new String[]{"methodname", "returntype"};
            String[] retVals = new String[]{node.getMethod(i), retClass.getName()};
            this.printElt("ReturnType", null, retAttr, retVals);
        }
        for (i = 0; i < ct; ++i) {
            Object[] values = node.getInputValue(i);
            int size = values.length;
            String[] paramValueAttr = new String[]{"methodname", "size"};
            String[] paramValueVals = new String[]{node.getMethod(i), Integer.valueOf(size).toString()};
            this.openElt("ParamValue", paramValueAttr, paramValueVals);
            for (j = 0; j < size; ++j) {
                String[] valueAttr = new String[]{"type", "value"};
                String[] valueVal = new String[]{values[j].getClass().getName(), values[j].toString()};
                this.printElt("Value", null, valueAttr, valueVal);
            }
            this.closeElt("ParamValue");
        }
        String[] selectedAttr = new String[]{"name"};
        String[] selectedVals = new String[]{node.getSelectedMethod()};
        this.printElt("Selected", null, selectedAttr, selectedVals);
        if (env != null) {
            Enumeration e = env.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                String[] envAttr = new String[]{"name", "value"};
                String[] envVals = new String[]{(String)key, (String)env.get(key)};
                this.printElt("Environment", null, envAttr, envVals);
            }
        }
        this.closeElt("EJB");
    }

    private String[] getEJBAttr(String prefix, int size) {
        String[] temp = new String[size + 2];
        for (int i = 0; i < size; ++i) {
            temp[i] = prefix + (i + 1);
        }
        temp[size] = "methodname";
        temp[size + 1] = "size";
        return temp;
    }

    private void printElt(String elt, String obj) throws IOException {
        ++this.index;
        this.tab();
        if (obj == null || obj.equals("")) {
            this.out.write("<" + elt + "/>\n");
        } else {
            this.out.write("<" + elt + ">" + XMLUtil.encodeCDATA(obj) + "</" + elt + ">\n");
        }
        --this.index;
    }

    private void printElt(String elt, String obj, String[] attr, String[] vals) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt);
        if (attr != null) {
            for (int i = 0; i < attr.length; ++i) {
                this.out.write(" " + attr[i] + "=\"" + XMLUtil.encodeXML(vals[i]) + "\"");
            }
        }
        this.out.write(">");
        if (obj != null && !obj.equals("")) {
            this.out.write(XMLUtil.encodeCDATA(obj));
        }
        this.out.write("</" + elt + ">\n");
        --this.index;
    }

    private void openElt(String elt) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt + ">\n");
    }

    private void openElt(String elt, String[] attr, String[] vals) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt);
        if (attr != null) {
            for (int i = 0; i < attr.length; ++i) {
                this.out.write(" " + attr[i] + "=\"" + XMLUtil.encodeXML(vals[i]) + "\"");
            }
        }
        this.out.write(">\n");
    }

    private void closeElt(String elt) throws IOException {
        this.tab();
        this.out.write("</" + elt + ">\n");
        --this.index;
    }

    private void printElt(QueryInParamSet inSet) {
        try {
            inSet.writeXML(this.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveToDataOutput() throws IOException {
        this.out.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
        this.printElt(this.root);
    }
}

