/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDAttribute;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.dtd.elements.XSObjectWrapper;
import quadbase.common.util.dtd.parser.ParseException;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLVerifier;
import quadbase.datasourcemanager.manager.DTDTreeBuilderDialog;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTree;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTreeBuilderDialog;
import quadbase.querybuilder.designer.QueryMain;

public class XMLNodeDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JTextField baseField;
    private JTextField xmlLocField;
    private JTextField dtdLocField;
    private JCheckBox isQBFormat;
    private JCheckBox verifyCheckBox;
    private JCheckBox refreshSchemaCheckBox;
    private JButton browseXMLButton;
    private JButton browseDTDButton;
    private JButton okButton;
    private JButton cancelButton;
    private JFileChooser fileChooser;
    private BrowseDialog browseDialog;
    private DefaultMutableTreeNode parent;
    private XMLFileNode node;
    private Manager manager;
    private boolean isModified = false;
    public static final int VERSION = 2;

    public XMLNodeDialog(Manager manager, DefaultMutableTreeNode parent, XMLFileNode node) {
        super(manager, LanguageEncoder.getText("Setup XML File..."), true);
        this.manager = manager;
        this.parent = parent;
        this.node = node;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel labelPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        JPanel textPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        JPanel browsePanel = new JPanel(new GridLayout(3, 1, 5, 5));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Name:") + " "));
        labelPanel.add(new JLabel(LanguageEncoder.getText("XML Instance File:") + " "));
        labelPanel.add(new JLabel(LanguageEncoder.getText("DTD/XML Schema File:") + " "));
        this.baseField = new JTextField(25);
        textPanel.add(this.baseField);
        this.xmlLocField = new JTextField(25);
        textPanel.add(this.xmlLocField);
        this.dtdLocField = new JTextField(25);
        textPanel.add(this.dtdLocField);
        browsePanel.add(new JLabel(""));
        this.browseXMLButton = new JButton(LanguageEncoder.getText("Browse XML..."));
        browsePanel.add(this.browseXMLButton);
        this.browseDTDButton = new JButton(LanguageEncoder.getText("Browse DTD/XSD..."));
        browsePanel.add(this.browseDTDButton);
        this.browseXMLButton.addActionListener(this);
        this.browseDTDButton.addActionListener(this);
        this.baseField.addActionListener(this);
        this.xmlLocField.addActionListener(this);
        this.dtdLocField.addActionListener(this);
        int numCheckboxes = this.newNode() ? 2 : 3;
        JPanel checkBoxPanel = new JPanel(new GridLayout(1, numCheckboxes, 5, 5));
        this.isQBFormat = new JCheckBox(LanguageEncoder.getText("Quadbase Format"));
        checkBoxPanel.add(this.isQBFormat);
        this.verifyCheckBox = new JCheckBox(LanguageEncoder.getText("Verify XML Against DTD/XML Schema"));
        checkBoxPanel.add(this.verifyCheckBox);
        if (!this.newNode()) {
            this.refreshSchemaCheckBox = new JCheckBox(LanguageEncoder.getText("Refresh Schema"));
            checkBoxPanel.add(this.refreshSchemaCheckBox);
        }
        this.isQBFormat.addItemListener(this);
        this.verifyCheckBox.addItemListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add("West", labelPanel);
        p1.add("Center", textPanel);
        p1.add("East", browsePanel);
        p1.add("South", checkBoxPanel);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(new TitledBorder(LanguageEncoder.getText("Data Source Information")));
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
        this.setValues();
    }

    private void setValues() {
        if (this.node != null) {
            XMLFileNode xmlNode = this.node;
            this.baseField.setText(xmlNode.getName());
            this.xmlLocField.setText(xmlNode.getFile());
            this.isQBFormat.setSelected(xmlNode.isQBFormat());
            this.verifyCheckBox.setSelected(xmlNode.isVerify());
            if (!this.isQBFormat.isSelected() && xmlNode.getDTD() != null) {
                this.dtdLocField.setText(xmlNode.getDTD());
            } else {
                this.dtdLocField.setText("");
                this.dtdLocField.setEnabled(false);
            }
        } else {
            this.xmlLocField.setText(this.manager.getDataSourceXMLDir());
            this.dtdLocField.setText(this.manager.getDataSourceXMLDir());
        }
        this.enableButtons();
    }

    private String loadFile(String[] ext) {
        int index;
        String xmlFileName = this.xmlLocField.getText().trim();
        String xmlDir = null;
        if (xmlFileName != null && !xmlFileName.equals("") && xmlFileName.toUpperCase().endsWith(".XML") && (index = (xmlFileName = xmlFileName.replace('\\', '/')).lastIndexOf(47)) != -1) {
            xmlDir = xmlFileName.substring(0, index);
            try {
                if (xmlDir != null && !new FileInfo(xmlDir).isDirectory()) {
                    xmlDir = null;
                }
            }
            catch (Exception e) {
                xmlDir = null;
            }
        }
        xmlDir = this.manager.getDataSourceXMLDir();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
            ExtensionFilter fileFilter = new ExtensionFilter(ext);
            this.fileChooser.addChoosableFileFilter(fileFilter);
            this.fileChooser.setCurrentDirectory(new File(xmlDir));
            this.fileChooser.showDialog(this.manager, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            this.manager.setDataSourceXMLDir(this.fileChooser.getCurrentDirectory().getAbsolutePath());
            return this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        this.browseDialog = BrowseDialog.create(this.manager, xmlDir, ext);
        this.browseDialog.setVisible(true);
        this.manager.setDataSourceXMLDir(this.browseDialog.getCurrentDirectory());
        return this.browseDialog.getSelectedFile();
    }

    boolean isModified() {
        return this.isModified;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableButtons();
    }

    private void enableButtons() {
        this.browseDTDButton.setEnabled(!this.isQBFormat.isSelected());
        this.dtdLocField.setEnabled(!this.isQBFormat.isSelected());
        this.verifyCheckBox.setVisible(!this.isQBFormat.isSelected());
        if (this.refreshSchemaCheckBox != null) {
            this.refreshSchemaCheckBox.setVisible(!this.isQBFormat.isSelected());
        }
    }

    XMLFileNode getNode() {
        return this.node;
    }

    private String doVerify(String xmlFile, String externalFile) {
        String msg = null;
        if (externalFile != null && !externalFile.equals("")) {
            int type = 0;
            if (externalFile.toUpperCase().endsWith("DTD")) {
                type = 0;
            } else if (externalFile.toUpperCase().endsWith("XSD")) {
                type = 1;
            }
            XMLVerifier verifier = new XMLVerifier(xmlFile, type, externalFile);
            msg = verifier.verify();
        }
        return msg;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String xmlname = this.xmlLocField.getText().trim();
        String dtdname = this.dtdLocField.getText().trim();
        String msg = null;
        if (e.getSource() == this.browseXMLButton) {
            String xmFileName = this.loadFile(new String[]{"XML", "XBRL"});
            if (xmFileName != null) {
                this.xmlLocField.setText(xmFileName);
            }
            return;
        }
        if (e.getSource() == this.browseDTDButton) {
            String dtdFileName = this.loadFile(new String[]{"DTD", "XSD"});
            if (dtdFileName != null) {
                this.dtdLocField.setText(dtdFileName);
            }
            return;
        }
        if (e.getSource() == this.cancelButton) {
            this.cancel();
        }
        if (e.getSource() == this.okButton || e.getSource() == this.xmlLocField || e.getSource() == this.dtdLocField || e.getSource() == this.baseField) {
            String nodeName = this.baseField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter data source name");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (xmlname == null || xmlname.equals("")) {
                msg = LanguageEncoder.getText("Please input a XML Instance file name");
            } else if ((dtdname == null || dtdname.equals("")) && !this.isQBFormat.isSelected()) {
                msg = LanguageEncoder.getText("Please input a DTD/XML Schema file name");
            }
            if (!xmlname.equals("") && !OverWriteDialog.isFileExisted(this.manager, xmlname)) {
                return;
            }
            if (!(dtdname == null || dtdname.equals("") || this.isQBFormat.isSelected() || OverWriteDialog.isFileExisted(this.manager, dtdname))) {
                return;
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            boolean refreshSchema = this.needRefreshSchema();
            XMLFileNode xmlNode = this.node;
            boolean newNode = false;
            if (xmlNode == null) {
                newNode = true;
                xmlNode = new XMLFileNode(nodeName);
            } else {
                xmlNode.setUserObject(nodeName);
            }
            xmlNode.setFile(xmlname);
            xmlNode.setQBFormat(this.isQBFormat.isSelected());
            xmlNode.setVerify(this.verifyCheckBox.isSelected());
            if (this.isQBFormat.isSelected()) {
                xmlNode.setDTD(null);
                xmlNode.setVerify(false);
            } else {
                xmlNode.setDTD(dtdname);
            }
            if (e.getSource() == this.okButton && xmlNode.isQBFormat()) {
                if (xmlNode.getChildCount() > 0) {
                    String message = LanguageEncoder.getText("This will delete any XML queries under this node. Are you sure you want to proceed?");
                    JMessageDialog dialog = new JMessageDialog((Dialog)new JDialog(), LanguageEncoder.getText("Delete XML Query Warning"), message, 2);
                    int response = dialog.getResponse();
                    if (response == 4) {
                        xmlNode.removeAllChildren();
                    } else if (response == 5) {
                        this.cancel();
                        return;
                    }
                }
                if (xmlNode.getDTDTreeFileName() != null && !xmlNode.getDTDTreeFileName().equals("")) {
                    new DeleteFile(this.node.getDTDTreeFileName()).delete();
                }
                xmlNode.setDTDTreeFileName(null);
                if (newNode) {
                    this.parent.add(xmlNode);
                }
                this.node = xmlNode;
                this.isModified = true;
                this.setVisible(false);
                this.dispose();
                return;
            }
            if (e.getSource() == this.okButton && !xmlNode.isQBFormat()) {
                boolean ok;
                String message;
                if (this.verifyCheckBox.isSelected() && (message = this.doVerify(xmlname, dtdname)) != null) {
                    message = message + LanguageEncoder.getText("\n\nPress Ignore to proceed or Quit to quit the process.\nPlease modify the XML file or the DTD/XSD file later.");
                    JMessageDialog dialog = new JMessageDialog((Dialog)this, LanguageEncoder.getText("XML Verification Warning"), message, 8);
                    int response = dialog.getResponse();
                    if (response == 7) {
                        this.cancel();
                        return;
                    }
                }
                if (this.newNode()) {
                    boolean ok2;
                    if (dtdname.toUpperCase().endsWith(".DTD")) {
                        this.openTreeWindowForNewDTD(dtdname, nodeName, xmlNode);
                    } else if (dtdname.toUpperCase().endsWith(".XSD") && !(ok2 = this.openTreeWindowForNewXMLSchema(dtdname, nodeName, xmlNode))) {
                        return;
                    }
                } else if (refreshSchema) {
                    boolean ok3 = false;
                    if (dtdname.toUpperCase().endsWith(".DTD")) {
                        ok3 = this.openTreeWindowForMergedDTD(dtdname, nodeName, xmlNode);
                    } else if (dtdname.toUpperCase().endsWith(".XSD") && !(ok3 = this.openTreeWindowForMergedXMLSchema(dtdname, nodeName, xmlNode))) {
                        return;
                    }
                } else if (this.node.getDTDTreeFileName().toUpperCase().endsWith(".DDT")) {
                    this.openTreeWindowForExistingDTD();
                } else if (this.node.getDTDTreeFileName().toUpperCase().endsWith(".XST") && !(ok = this.openTreeWindowForExistingXMLSchema())) {
                    return;
                }
            }
            if (newNode) {
                this.parent.add(xmlNode);
            }
            this.node = xmlNode;
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    private void cancel() {
        this.isModified = false;
        this.setVisible(false);
        this.manager.managerPane.closeEditOrAddNode();
        this.dispose();
    }

    private void openTreeWindowForNewDTD(String dtdname, String nodeName, XMLFileNode xmlNode) {
        DTD dtdTree = null;
        try {
            dtdTree = DTDUtil.getDTDFromParser(dtdname);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            this.cancel();
            return;
        }
        catch (Exception ec) {
            ec.printStackTrace();
            this.cancel();
            return;
        }
        this.openTreeWindowForNewDTD(dtdTree, nodeName, xmlNode);
    }

    private void openTreeWindowForNewDTD(DTD dtdTree, String nodeName, XMLFileNode xmlNode) {
        if (dtdTree != null) {
            String newFileName = "";
            String fileprefix = this.manager.managerPane.dataSourceLoc;
            fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
            fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
            fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
            newFileName = fileprefix + "_" + nodeName;
            String tmp = newFileName = newFileName.replace(' ', '_');
            int ct = 0;
            try {
                while (new FileInfo(QueryMain.QUERYDIR + newFileName + ".ddt").exists()) {
                    newFileName = tmp + "_" + ct++;
                }
                String ddtFileName = QueryMain.QUERYDIR + newFileName + ".ddt";
                DTDUtil.writeDTDTreeFile(dtdTree, ddtFileName, 2);
                xmlNode.setDTDTreeFileName(ddtFileName);
                DTDTreeBuilderDialog dtdBuilderDialog = new DTDTreeBuilderDialog((JDialog)this, this.parent, (DefaultMutableTreeNode)this.node, dtdTree);
                dtdBuilderDialog.setVisible(true);
                if (dtdBuilderDialog.isModified()) {
                    DTDUtil.writeDTDTreeFile(dtdBuilderDialog.getDTD(), ddtFileName, 2);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean openTreeWindowForMergedDTD(String dtdname, String nodeName, XMLFileNode xmlNode) {
        if (!this.node.getDTDTreeFileName().toUpperCase().endsWith(".DDT")) {
            String message = LanguageEncoder.getText("You have chosen to refresh the Schema.  This will replace the previous modified Schema and its changed attributes (elements data types).  Are you sure you want to proceed?");
            JMessageDialog dialog = new JMessageDialog((Dialog)new JDialog(), LanguageEncoder.getText("Replace modified Schema Warning"), message, 2);
            int response = dialog.getResponse();
            if (response == 5) {
                return false;
            }
            this.openTreeWindowForNewDTD(dtdname, nodeName, xmlNode);
            return true;
        }
        String dtdTreeLoc = this.node.getDTDTreeFileName();
        DTD orgDTD = DTDUtil.readDTD(dtdTreeLoc);
        DTDElement orgRootElt = orgDTD.getRootElement();
        DefaultMutableTreeNode orgRoot = new DefaultDataSourceNode(orgRootElt);
        orgRoot = DTDUtil.buildTree(orgRootElt, orgDTD.getElements(), orgRoot, true);
        DTD newDTD = null;
        try {
            newDTD = DTDUtil.getDTDFromParser(dtdname);
            DTDElement newRootElt = newDTD.getRootElement();
            DefaultMutableTreeNode newRoot = new DefaultDataSourceNode(newRootElt);
            newRoot = DTDUtil.buildTree(newRootElt, newDTD.getElements(), newRoot, true);
            this.merge(newRoot, orgRoot);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            this.cancel();
            return false;
        }
        catch (Exception ec) {
            ec.printStackTrace();
            this.cancel();
            return false;
        }
        this.openTreeWindowForNewDTD(newDTD, nodeName, xmlNode);
        return true;
    }

    private boolean merge(DefaultMutableTreeNode newNode, DefaultMutableTreeNode orgNode) {
        Object newUserObj = newNode.getUserObject();
        Object orgUserObj = orgNode.getUserObject();
        if (newUserObj instanceof DTDElement) {
            if (!((DTDElement)newUserObj).equalsWOFormat(orgUserObj)) {
                return false;
            }
            ((DTDElement)newUserObj).merge(orgUserObj);
        } else if (newUserObj instanceof DTDAttribute) {
            if (!((DTDAttribute)newUserObj).equalsWOFormat(orgUserObj)) {
                return false;
            }
            ((DTDAttribute)newUserObj).merge(orgUserObj);
        } else if (newUserObj instanceof XSObjectWrapper) {
            if (!(orgUserObj instanceof XSObjectWrapper)) {
                return false;
            }
            if (!newUserObj.toString().equals(orgUserObj.toString())) {
                return false;
            }
            ((XSObjectWrapper)newUserObj).merge(orgUserObj);
        } else if (!newUserObj.toString().equals(orgUserObj.toString())) {
            return false;
        }
        for (int i = 0; i < newNode.getChildCount(); ++i) {
            DefaultMutableTreeNode orgChild;
            DefaultMutableTreeNode newChild = (DefaultMutableTreeNode)newNode.getChildAt(i);
            for (int j = 0; j < orgNode.getChildCount() && !this.merge(newChild, orgChild = (DefaultMutableTreeNode)orgNode.getChildAt(j)); ++j) {
            }
        }
        return true;
    }

    private void openTreeWindowForExistingDTD() {
        String dtdTreeLoc = this.node.getDTDTreeFileName();
        DTDTreeBuilderDialog dtdBuilderDialog = new DTDTreeBuilderDialog((JDialog)this, this.parent, (DefaultMutableTreeNode)this.node, dtdTreeLoc);
        dtdBuilderDialog.setVisible(true);
        if (dtdBuilderDialog.isModified()) {
            DTDUtil.writeDTDTreeFile(dtdBuilderDialog.getDTD(), dtdTreeLoc, 2);
        }
    }

    private String createXSTFileName(String nodeName) throws Exception {
        String newFileName = "";
        String fileprefix = this.manager.managerPane.dataSourceLoc;
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
        fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
        newFileName = fileprefix + "_" + nodeName;
        String tmp = newFileName = newFileName.replace(' ', '_');
        int ct = 0;
        while (new FileInfo(QueryMain.QUERYDIR + newFileName + ".xst").exists()) {
            newFileName = tmp + "_" + ct++;
        }
        return QueryMain.QUERYDIR + newFileName + ".xst";
    }

    private boolean openTreeWindowForNewXMLSchema(String schemaname, String nodeName, XMLFileNode xmlNode) {
        try {
            String xstFileName = this.createXSTFileName(nodeName);
            XMLSchemaTreeBuilderDialog builderDialog = new XMLSchemaTreeBuilderDialog(this, schemaname, xmlNode.fileLocation, xstFileName);
            builderDialog.setVisible(true);
            if (builderDialog.isModified()) {
                builderDialog.save(xstFileName);
            }
            xmlNode.setDTDTreeFileName(xstFileName);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
            return false;
        }
    }

    private boolean openTreeWindowForMergedXMLSchema(String schemaname, String nodeName, XMLFileNode xmlNode) {
        if (!this.node.getDTDTreeFileName().toUpperCase().endsWith(".XST")) {
            String message = LanguageEncoder.getText("You have chosen to refresh the Schema.  This will replace the previous modified Schema and its changed attributes (elements data types).  Are you sure you want to proceed?");
            JMessageDialog dialog = new JMessageDialog((Dialog)new JDialog(), LanguageEncoder.getText("Replace modified Schema Warning"), message, 2);
            int response = dialog.getResponse();
            if (response == 5) {
                return false;
            }
            return this.openTreeWindowForNewXMLSchema(schemaname, nodeName, xmlNode);
        }
        DefaultMutableTreeNode orgRoot = null;
        DefaultMutableTreeNode newRoot = null;
        try {
            String xsdTreeLoc = this.node.getDTDTreeFileName();
            XMLSchemaTree schemaTree = XMLSchemaTree.load(xsdTreeLoc);
            orgRoot = (DefaultMutableTreeNode)schemaTree.getModel().getRoot();
        }
        catch (Exception ex) {
            return this.openTreeWindowForNewXMLSchema(schemaname, nodeName, xmlNode);
        }
        try {
            XMLSchemaTree schemaTree = new XMLSchemaTree(schemaname, xmlNode.fileLocation);
            newRoot = (DefaultMutableTreeNode)schemaTree.getModel().getRoot();
            this.merge(newRoot, orgRoot);
            return this.openTreeWindowForNewXMLSchema(schemaname, nodeName, xmlNode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
            return false;
        }
    }

    private boolean openTreeWindowForExistingXMLSchema() {
        try {
            String xsdTreeLoc = this.node.getDTDTreeFileName();
            XMLSchemaTreeBuilderDialog builderDialog = new XMLSchemaTreeBuilderDialog(this, xsdTreeLoc);
            builderDialog.setVisible(true);
            if (builderDialog.isModified()) {
                builderDialog.save(xsdTreeLoc);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
            return false;
        }
    }

    private boolean newNode() {
        return this.node == null || this.node.getDTDTreeFileName() == null || this.node.getDTDTreeFileName().trim().equals("");
    }

    private boolean needRefreshSchema() {
        return !this.isQBFormat.isSelected() && this.refreshSchemaCheckBox != null && this.refreshSchemaCheckBox.isSelected();
    }
}

