/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlbuilder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.XMLDataSheetProc;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTree;

public class ReadXMLData {
    XMLFileQueryInfo xmlInfo;
    String condition;
    Vector selectedFields;
    QueryInParam[] parameters;

    public ReadXMLData(XMLFileQueryInfo xmlInfo) {
        this.xmlInfo = xmlInfo.getFileName() != null ? new XMLFileQueryInfo(xmlInfo.getFileName(), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getDTDName(), xmlInfo.isVerify(), xmlInfo.getInSet(), xmlInfo.getDTDTreeFileName()) : (xmlInfo.getFileName() == null && xmlInfo.getDTDName() != null ? new XMLFileQueryInfo(new ByteArrayInputStream(xmlInfo.getData()), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getDTDName(), xmlInfo.isVerify(), xmlInfo.getInSet(), xmlInfo.getDTDTreeFileName()) : new XMLFileQueryInfo((InputStream)new ByteArrayInputStream(xmlInfo.getData()), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), new ByteArrayInputStream(xmlInfo.getDTD()), xmlInfo.isVerify(), xmlInfo.getInSet(), xmlInfo.getDTDTreeFileName()));
    }

    public ReadXMLData(DefaultDataSourceNode parent, String condition, Vector selectedFields, QueryInParamSet paramSet) {
        this.xmlInfo = new XMLFileQueryInfo(((XMLFileNode)parent).getFile(), this.getXMLSelectedFields(selectedFields), condition, this.getXMLAllFields(parent), ((XMLFileNode)parent).getDTD(), ((XMLFileNode)parent).isVerify(), paramSet, ((XMLFileNode)parent).getDTDTreeFileName());
        this.condition = condition;
        this.selectedFields = selectedFields;
        if (paramSet != null) {
            this.parameters = paramSet.getParameter();
        }
    }

    private XMLFieldInfo[] getXMLSelectedFields(Vector selectedFields) {
        XMLFieldInfo[] info = new XMLFieldInfo[selectedFields.size()];
        for (int i = 0; i < info.length; ++i) {
            info[i] = (XMLFieldInfo)selectedFields.elementAt(i);
        }
        return info;
    }

    private XMLFieldInfo[] getXMLAllFields(DefaultDataSourceNode node) {
        DefaultMutableTreeNode root = null;
        String dtdTreeFileName = null;
        dtdTreeFileName = ((XMLFileNode)node).getDTDTreeFileName();
        if (dtdTreeFileName.toLowerCase().endsWith(".ddt")) {
            DTD dtd = DTDUtil.readDTD(dtdTreeFileName);
            DTDElement rootElt = dtd.getRootElement();
            Hashtable<String, DTDElement> elements = dtd.getElements();
            root = DTDUtil.buildTree(rootElt, elements, new DefaultMutableTreeNode(rootElt), true);
        } else {
            try {
                XMLSchemaTree schemaTree = XMLSchemaTree.load(dtdTreeFileName);
                root = (DefaultMutableTreeNode)schemaTree.getModel().getRoot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DTDUtil.getXMLAllFields(root);
    }

    public Vector executeQuery(String condition, Vector selectedFields, QueryInParamSet inSet, int startIndex, int displayRow) {
        if (this.xmlInfo != null && selectedFields.size() > 0) {
            this.xmlInfo.setCondition(condition);
            this.xmlInfo.setFieldInfo(this.getXMLSelectedFields(selectedFields));
            this.xmlInfo.setInSet(inSet);
            return new XMLDataSheetProc().executeQuery(this.xmlInfo, startIndex, displayRow);
        }
        return new Vector();
    }
}

