/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlbuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.paramquery.EnterInParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDAttribute;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.dtd.elements.XSObjectWrapper;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLDefaultTreeNode;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.common.util.xmlcondition.ConditionParser;
import quadbase.common.util.xmlcondition.ParseException;
import quadbase.datasourcemanager.manager.DTDTreeCellRenderer;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLParametersDialog;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLQueryBuilderDialog;

public class XMLConditionBuilderDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    JButton insertButton;
    JButton testButton;
    JButton resetButton;
    JButton initParamButton;
    UndoTextArea conditionText;
    String condition;
    QueryInParamSet inSet = null;
    boolean isModified = false;
    private JDialog parent = null;
    private JTree dtdTree = null;
    private DTD dtd = null;
    private DTDElement rootElt;
    private Hashtable elements;
    private DefaultDataSourceNode parentNode;
    private XMLQueryNode xmlQueryNode;
    private JPanel mainPanel;
    private boolean isCancel = false;

    public XMLConditionBuilderDialog(JDialog parent, DefaultDataSourceNode parentNode, XMLQueryNode xmlQueryNode, String condition, DTD dtd) {
        super(parent, LanguageEncoder.getText("XML Condition Builder..."), true);
        this.parent = parent;
        this.parentNode = parentNode;
        this.xmlQueryNode = xmlQueryNode;
        this.condition = condition;
        if (xmlQueryNode != null) {
            this.inSet = xmlQueryNode.getInSet();
        }
        this.dtd = dtd;
        this.init();
        this.setPosition();
    }

    public XMLConditionBuilderDialog(JDialog parent, DefaultDataSourceNode parentNode, XMLQueryNode xmlQueryNode, String condition, JTree tree) {
        super(parent, LanguageEncoder.getText("XML Condition Builder..."), true);
        this.parent = parent;
        this.parentNode = parentNode;
        this.xmlQueryNode = xmlQueryNode;
        this.condition = condition;
        if (xmlQueryNode != null) {
            this.inSet = xmlQueryNode.getInSet();
        }
        this.dtdTree = tree;
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.conditionText = new UndoTextArea();
        if (this.condition != null) {
            this.conditionText.setText(this.condition);
        }
        this.conditionText.setLineWrap(true);
        scrollPane.getViewport().add(this.conditionText);
        JScrollPane treePane = null;
        treePane = this.getDTDTreePane();
        JSplitPane splitPane = new JSplitPane(1, false);
        Dimension d = scrollPane.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(400, (int)d.getHeight()));
        splitPane.setRightComponent(scrollPane);
        splitPane.setLeftComponent(treePane);
        panel.setBorder(new BevelBorder(1));
        panel.add((Component)splitPane, "Center");
        panel.add((Component)this.getToolBar(), "South");
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel okPanel = new JPanel();
        okPanel.setLayout(new FlowLayout(1));
        okPanel.add(this.okButton);
        okPanel.add(this.cancelButton);
        this.mainPanel = panel;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", panel);
        contentPane.add("South", okPanel);
    }

    private void setPosition() {
        if (this.dtd != null) {
            this.expandAll(this.dtdTree);
        }
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if (dim.getWidth() > screensize.getWidth() * 7.0 / 8.0) {
            dim = new Dimension((int)(screensize.getWidth() * 7.0 / 8.0), (int)dim.getHeight());
        }
        if (dim.getHeight() > screensize.getHeight() * 2.0 / 3.0) {
            dim = new Dimension((int)dim.getWidth(), (int)(screensize.getHeight() * 2.0 / 3.0));
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    private JScrollPane getDTDTreePane() {
        if (this.dtd != null) {
            this.elements = this.dtd.getElements();
            this.rootElt = this.dtd.getRootElement();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.rootElt);
            this.dtdTree = new JTree(DTDUtil.buildTree(this.rootElt, this.elements, root, true));
            this.dtdTree.getSelectionModel().setSelectionMode(1);
            this.dtdTree.setCellRenderer(new DTDTreeCellRenderer());
            this.dtdTree.setRootVisible(true);
            this.expandAll(this.dtdTree);
        }
        this.dtdTree.setVisibleRowCount(20);
        TreeSelectionListener slistener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DefaultMutableTreeNode tnode = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tnode = (DefaultMutableTreeNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                }
                if (XMLConditionBuilderDialog.this.dtd != null && XMLConditionBuilderDialog.this.buildSubTree(tnode)) {
                    tnode.add(DTDUtil.buildTree(XMLConditionBuilderDialog.this.rootElt, XMLConditionBuilderDialog.this.elements, tnode, true));
                    XMLConditionBuilderDialog.this.expandAll(XMLConditionBuilderDialog.this.dtdTree);
                }
            }
        };
        this.dtdTree.addTreeSelectionListener(slistener);
        this.dtdTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = XMLConditionBuilderDialog.this.dtdTree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() >= 2) {
                    XMLConditionBuilderDialog.this.insertText(XMLConditionBuilderDialog.this.getSelectedText());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.dtdTree);
        Dimension d = scrollPane.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(200, (int)d.getHeight()));
        return scrollPane;
    }

    private boolean buildSubTree(DefaultMutableTreeNode tnode) {
        Object userObj = tnode.getUserObject();
        if (userObj instanceof DTDElement) {
            DTDElement elt = (DTDElement)userObj;
            if (tnode.isLeaf() && !elt.isExpand()) {
                return true;
            }
        }
        return false;
    }

    private JPanel getToolBar() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(1));
        panel1.add(this.newJButton(" = "));
        panel1.add(this.newJButton(" <> "));
        panel1.add(this.newJButton(" > "));
        panel1.add(this.newJButton(" < "));
        panel1.add(this.newJButton(" <= "));
        panel1.add(this.newJButton(" >= "));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(1));
        panel2.add(this.newJButton(" ( "));
        panel2.add(this.newJButton(" ) "));
        panel2.add(this.newJButton(" AND "));
        panel2.add(this.newJButton(" OR "));
        this.insertButton = this.newJButton(" INSERT ");
        panel2.add(this.insertButton);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout(1));
        this.testButton = this.newJButton(" Test ");
        panel3.add(this.testButton);
        this.resetButton = this.newJButton(" Clear ");
        panel3.add(this.resetButton);
        this.initParamButton = this.newJButton("Initialize parameter");
        panel3.add(this.initParamButton);
        panel.add(panel1);
        panel.add(panel2);
        panel.add(panel3);
        return panel;
    }

    private JButton newJButton(String str) {
        JButton tmp = new JButton(str);
        tmp.addActionListener(this);
        return tmp;
    }

    private void insertText(String newStr) {
        if (newStr == null) {
            return;
        }
        this.conditionText.replaceSelection(newStr);
    }

    private void expandAll(JTree tree) {
        int i;
        int rowCt = tree.getRowCount();
        TreePath[] path = new TreePath[rowCt];
        for (i = 0; i < rowCt; ++i) {
            path[i] = tree.getPathForRow(i);
        }
        for (i = 0; i < rowCt; ++i) {
            tree.expandPath(path[i]);
        }
    }

    boolean isModified() {
        return this.isModified;
    }

    String getCondition() {
        return this.conditionText.getText();
    }

    QueryInParamSet getInSet() {
        return this.inSet;
    }

    QueryInParamSet getParamSet() {
        try {
            if (QueryParser.hasParameters(this.getCondition())) {
                QueryInParamSet tempParamSet = QueryParser.filterParameters(this.getCondition(), this.inSet);
                XMLFieldInfo[] fields = DTDUtil.getXMLAllFields((DefaultMutableTreeNode)this.dtdTree.getModel().getRoot());
                XMLFileQueryInfo info = null;
                info = new XMLFileQueryInfo(((XMLFileNode)this.parentNode).getFile(), ((XMLQueryBuilderDialog)this.parent).getSelectedFieldInfo(), this.getCondition(), fields, ((XMLFileNode)this.parentNode).getDTD(), ((XMLFileNode)this.parentNode).isVerify(), tempParamSet, ((XMLFileNode)this.parentNode).getDTDTreeFileName());
                QueryXMLFileInfo qxfi = new QueryXMLFileInfo(info);
                EnterInParamDialog eDialog = new EnterInParamDialog(this, (QueryFileInfo)qxfi, true, 0, null, null);
                eDialog.setVisible(true);
                QueryInParam[] param = eDialog.getInParamValue();
                return new QueryInParamSet(param);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    String testSyntax(String text) {
        try {
            if (text != null && !text.equals("")) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                ConditionParser parser = new ConditionParser(inputStreamReader);
                XMLFieldInfo[] fields = DTDUtil.getXMLAllFields((DefaultMutableTreeNode)this.dtdTree.getModel().getRoot());
                Vector<QueryInParam> paramVec = new Vector<QueryInParam>();
                for (int i = 0; this.inSet != null && i < this.inSet.getParameter().length; ++i) {
                    paramVec.addElement(this.inSet.getParameter()[i]);
                }
                parser.parse(fields, paramVec);
                return null;
            }
        }
        catch (ParseException ex) {
            return this.formatErrorMessage(text, ex.toString());
        }
        catch (Throwable t) {
            return this.formatErrorMessage(text, t.toString());
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block24: {
            this.isCancel = false;
            if (e.getSource() == this.insertButton) {
                this.insertText(this.getSelectedText());
            } else if (e.getSource() == this.okButton) {
                String condit = this.conditionText.getText();
                String err = this.testSyntax(condit);
                if (err != null) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Syntax Error"), err);
                    return;
                }
                this.condition = condit;
                this.isModified = true;
                this.parent.repaint();
            } else if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.dispose();
                this.parent.repaint();
            } else if (e.getSource() == this.resetButton) {
                this.conditionText.setText("");
            } else if (e.getSource() == this.testButton) {
                String text = this.conditionText.getText();
                String err = this.testSyntax(text);
                if (err == null) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Parsing result"), LanguageEncoder.getText("The condition is syntactically correct!"));
                } else {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Syntax Error"), err);
                }
            } else if (e.getSource() == this.initParamButton) {
                String text = this.conditionText.getText();
                try {
                    if (text == null || text.equals("")) break block24;
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    ConditionParser parser = new ConditionParser(inputStreamReader);
                    XMLFieldInfo[] fields = DTDUtil.getXMLAllFields((DefaultMutableTreeNode)this.dtdTree.getModel().getRoot());
                    Vector<QueryInParam> paramVec = new Vector<QueryInParam>();
                    for (int i = 0; this.inSet != null && i < this.inSet.getParameter().length; ++i) {
                        paramVec.addElement(this.inSet.getParameter()[i]);
                    }
                    XMLDefaultTreeNode conditionRoot = parser.parse(fields, paramVec);
                    if (QueryParser.hasParameters(text)) {
                        QueryInParamSet tempParamSet = QueryParser.filterParameters(text, this.inSet);
                        XMLFileQueryInfo info = null;
                        info = new XMLFileQueryInfo(((XMLFileNode)this.parentNode).getFile(), ((XMLQueryBuilderDialog)this.parent).getSelectedFieldInfo(), text, fields, ((XMLFileNode)this.parentNode).getDTD(), ((XMLFileNode)this.parentNode).isVerify(), tempParamSet, ((XMLFileNode)this.parentNode).getDTDTreeFileName());
                        boolean showPromptSequence = !((XMLQueryBuilderDialog)this.parent).forChart();
                        XMLParametersDialog dialog = new XMLParametersDialog(this, info, conditionRoot, showPromptSequence);
                        dialog.setVisible(true);
                        if (dialog.isCancel()) {
                            this.isCancel = true;
                            return;
                        }
                        if (dialog.isModified()) {
                            tempParamSet = dialog.getQueryInParamSet();
                            if (tempParamSet == null) {
                                throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                            }
                            this.inSet = tempParamSet;
                            if (this.xmlQueryNode != null) {
                                this.xmlQueryNode.setInSet(this.inSet);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Syntax error"), this.formatErrorMessage(text, ex.toString()));
                }
            } else if (e.getSource() instanceof JButton) {
                this.insertText(((JButton)e.getSource()).getText());
            }
        }
    }

    private String getSelectedText() {
        if (this.dtdTree.isSelectionEmpty()) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.dtdTree.getSelectionPath().getLastPathComponent();
        XMLFieldInfo field = DTDUtil.getXMLFieldInfo(node);
        if (this.isAddEnabled(node) && field != null) {
            return field.getDisplayName();
        }
        return "";
    }

    private boolean isAddEnabled(DefaultMutableTreeNode tnode) {
        Object userObj = tnode.getUserObject();
        if (userObj instanceof DTDElement) {
            if (tnode.isLeaf() || ((DTDElement)userObj).isMixedLeaf()) {
                return true;
            }
        } else {
            if (userObj instanceof DTDAttribute) {
                return true;
            }
            if (userObj instanceof XSObjectWrapper) {
                XSObjectWrapper wrapper = (XSObjectWrapper)userObj;
                return wrapper.isLeaf() || wrapper.isSelectable();
            }
        }
        return false;
    }

    JPanel getMainPanel() {
        return this.mainPanel;
    }

    private String formatErrorMessage(String formulaStr, String exceptionStr) {
        try {
            StringBuffer errMsg = new StringBuffer("Syntax Error:\n");
            int lineIndex = exceptionStr.indexOf("line") + 5;
            int lineIndex2 = exceptionStr.indexOf(",", lineIndex);
            int line = Integer.parseInt(exceptionStr.substring(lineIndex, lineIndex2));
            int columnIndex = exceptionStr.indexOf("column") + 7;
            int columnIndex2 = exceptionStr.indexOf(".", columnIndex);
            int column = Integer.parseInt(exceptionStr.substring(columnIndex, columnIndex2));
            int startIndex = 0;
            int endIndex = -1;
            for (int i = 0; i < line; ++i) {
                startIndex = endIndex + 1;
                endIndex = formulaStr.indexOf("\n", startIndex);
            }
            String lineString = endIndex == -1 ? formulaStr.substring(startIndex) : formulaStr.substring(startIndex, endIndex);
            errMsg.append(lineString).append("\n");
            FontMetrics fm = this.getFontMetrics(new JLabel().getFont());
            int error = lineString.length() - 1 >= column ? column : lineString.length() - 1;
            int strlen = fm.stringWidth(lineString.substring(0, error));
            int spacelen = fm.charWidth(' ');
            int numberOfSpaces = strlen / spacelen;
            for (int i = 0; i < numberOfSpaces; ++i) {
                errMsg.append(' ');
            }
            errMsg.append("^");
            return errMsg.toString();
        }
        catch (Exception e) {
            return exceptionStr;
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

