/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlbuilder;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLDataSheetView;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLNumericDialog;

public class XMLDataSheetToolBar
extends JToolBar
implements ActionListener {
    private XMLDataSheetView dataSheet;
    private JButton firstButton;
    private JButton prevButton;
    private JButton nextButton;
    private JButton lastButton;

    public XMLDataSheetToolBar(XMLDataSheetView dataSheet) {
        this.setFloatable(false);
        this.dataSheet = dataSheet;
        this.setBorder(new TitledBorder(""));
        this.firstButton = new JButton();
        this.addNewButton(LanguageEncoder.getText("First Page"), LanguageEncoder.getText("FIRST"), "first.gif", this.firstButton);
        this.addSeparator();
        this.prevButton = new JButton();
        this.addNewButton(LanguageEncoder.getText("Previous Page"), LanguageEncoder.getText("PREVIOUS"), "rewind.gif", this.prevButton);
        this.addNewButton(LanguageEncoder.getText("Go To ..."), LanguageEncoder.getText("GOTO"), "goto.gif");
        this.nextButton = new JButton();
        this.addNewButton(LanguageEncoder.getText("Next Page"), LanguageEncoder.getText("NEXT"), "forward.gif", this.nextButton);
        this.addSeparator();
        this.lastButton = new JButton();
        this.addNewButton(LanguageEncoder.getText("Last Page"), LanguageEncoder.getText("LAST"), "last.gif", this.lastButton);
        this.addSeparator();
        this.addNewButton(LanguageEncoder.getText("Display Rows"), LanguageEncoder.getText("DISPLAYROWS"), "rownum.gif");
        this.setEnabled();
    }

    private void addNewButton(String tip, String command, String img) {
        this.addNewButton(tip, command, img, new JButton());
    }

    private void addNewButton(String tip, String command, String img, JButton newBtn) {
        img = ServerMessage.reportImagesPath + img;
        newBtn.setIcon(IOUtil.getImageIcon(img));
        this.add(newBtn);
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
    }

    public void setEnabled() {
        this.setEnabled(this.dataSheet != null);
        if (this.dataSheet == null) {
            return;
        }
        this.firstButton.setEnabled(!this.dataSheet.isFirstPage());
        this.prevButton.setEnabled(!this.dataSheet.isFirstPage());
        this.nextButton.setEnabled(!this.dataSheet.isLastPage());
        this.lastButton.setEnabled(!this.dataSheet.isLastPage());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        try {
            if (command.equals(LanguageEncoder.getText("FIRST"))) {
                this.dataSheet.goToFirstPage();
            } else if (command.equals(LanguageEncoder.getText("PREVIOUS"))) {
                this.dataSheet.goToPreviousPage();
            } else if (command.equals(LanguageEncoder.getText("NEXT"))) {
                this.dataSheet.goToNextPage();
            } else if (command.equals(LanguageEncoder.getText("LAST"))) {
                this.dataSheet.goToLastPage();
            } else if (command.equals(LanguageEncoder.getText("GOTO"))) {
                XMLNumericDialog dialog = null;
                dialog = new XMLNumericDialog(this.dataSheet.dialog, this.dataSheet.getSelectedRow(), LanguageEncoder.getText("Go To ..."), LanguageEncoder.getText("Row Index :"));
                dialog.setVisible(true);
                if (dialog.isModified()) {
                    this.dataSheet.goTo(dialog.getValue());
                }
            } else if (command.equals(LanguageEncoder.getText("DISPLAYROWS"))) {
                XMLNumericDialog dialog = null;
                dialog = new XMLNumericDialog(this.dataSheet.dialog, this.dataSheet.getDisplayRow(), LanguageEncoder.getText("Set Display Row ..."), LanguageEncoder.getText("Number Of Display Row :"));
                dialog.setVisible(true);
                if (dialog.isModified()) {
                    this.dataSheet.setDisplayRow(dialog.getValue());
                }
            } else {
                System.out.println("PreviewToolBar command : " + command);
            }
            this.setEnabled();
        }
        catch (Exception ex) {
            JMessageDialog.errorDialog(this.dataSheet.dialog, ex.toString());
        }
    }
}

