/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlbuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.xmlbuilder.ReadXMLData;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLDataSheetToolBar;

public class XMLDataSheetView
extends JPanel {
    Dialog dialog;
    private DefaultDataSourceNode parent;
    private JTable table;
    private JScrollPane scrollPane;
    private DefaultCellEditor noEditor;
    private XMLDataSheetToolBar toolBar;
    private String condition = "";
    private Vector selectedFields;
    private QueryInParamSet paramSet;
    private int startIndex = 0;
    private int displayRow = 30;
    private Vector data;

    public XMLDataSheetView(Dialog dialog, DefaultDataSourceNode parentNode, String condition, Vector selectedFields, QueryInParamSet paramSet) {
        this.dialog = dialog;
        this.parent = parentNode;
        this.condition = condition;
        this.selectedFields = selectedFields;
        this.paramSet = paramSet;
        this.data = new Vector();
        this.init();
    }

    private void init() {
        Vector columnNames = this.getColumnNames(this.selectedFields);
        this.setBackground(Color.white);
        this.scrollPane = new JScrollPane();
        this.toolBar = new XMLDataSheetToolBar(this);
        this.table = new JTable(this.displayRow, columnNames.size() <= 0 ? 5 : columnNames.size());
        this.table.setGridColor(Color.lightGray);
        this.table.getTableHeader().setReorderingAllowed(false);
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        this.noEditor = new DefaultCellEditor(notEditableField);
        this.table.setCellEditor(this.noEditor);
        this.table.setAutoResizeMode(0);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane);
        this.add("South", this.toolBar);
    }

    private void readXML() {
        ReadXMLData readXMLData = new ReadXMLData(this.parent, this.condition, this.selectedFields, this.paramSet);
        this.data = readXMLData.executeQuery(this.condition, this.selectedFields, this.paramSet, 0, -1);
    }

    void setQuery(String condition, Vector selectedFields, QueryInParamSet paramSet) {
        this.condition = condition;
        this.selectedFields = selectedFields;
        this.paramSet = paramSet;
        this.scrollPane.getViewport().removeAll();
        try {
            if (selectedFields.size() > 0) {
                this.condition = condition;
                this.selectedFields = selectedFields;
                this.readXML();
                this.setValue(0, this.displayRow);
                this.scrollPane.getViewport().add(this.table);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setValue(int startIndex, int displayRow) throws Exception {
        int endIndex;
        String oldtitle = "Title";
        try {
            oldtitle = this.dialog.getTitle();
            this.dialog.setTitle("Please wait");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        this.startIndex = startIndex;
        Vector columnNames = this.getColumnNames(this.selectedFields);
        if (columnNames.size() <= 0) {
            this.dialog.setCursor(Cursor.getPredefinedCursor(0));
            try {
                this.dialog.setTitle(oldtitle);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (this.startIndex < 0) {
            int rowCT = this.data.size();
            this.startIndex = rowCT % displayRow == 0 ? rowCT - displayRow : (int)(Math.floor((double)rowCT / (double)displayRow) * (double)displayRow);
        }
        if ((endIndex = this.startIndex + displayRow) > this.data.size()) {
            endIndex = this.data.size();
        }
        Vector vec = new Vector(this.data.subList(this.startIndex, endIndex));
        try {
            Vector row = (Vector)vec.elementAt(0);
            if (row.size() != columnNames.size()) {
                int i = 0;
                for (i = 0; i < row.size(); ++i) {
                    if (i >= row.size() || i < columnNames.size()) continue;
                    columnNames.add(i + 1 + "");
                }
                while (i < columnNames.size()) {
                    columnNames.removeElementAt(i);
                }
            }
        }
        catch (Exception row) {
            // empty catch block
        }
        ((DefaultTableModel)this.table.getModel()).setDataVector(vec, columnNames);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellEditor(this.noEditor);
        }
        this.toolBar.setEnabled();
        this.dialog.setCursor(Cursor.getPredefinedCursor(0));
        try {
            this.dialog.setTitle(oldtitle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Vector getColumnNames(Vector fields) {
        if (fields == null) {
            return new Vector();
        }
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < fields.size(); ++i) {
            XMLFieldInfo field = (XMLFieldInfo)fields.elementAt(i);
            vec.addElement(field.getAlias());
        }
        return vec;
    }

    boolean isLastPage() {
        if (this.selectedFields.size() > 0) {
            int totalRows = this.data.size();
            if (totalRows == 0) {
                return false;
            }
            return totalRows - this.startIndex <= this.displayRow;
        }
        return true;
    }

    boolean isFirstPage() {
        return this.startIndex < this.displayRow;
    }

    void goToFirstPage() throws Exception {
        this.setValue(0, this.displayRow);
    }

    void goToPreviousPage() throws Exception {
        if (this.isFirstPage()) {
            return;
        }
        this.setValue(this.startIndex - this.displayRow, this.displayRow);
    }

    void goToNextPage() throws Exception {
        if (this.isLastPage()) {
            return;
        }
        this.setValue(this.startIndex + this.displayRow, this.displayRow);
    }

    void goToLastPage() throws Exception {
        this.setValue(-1, this.displayRow);
    }

    void goTo(int rowIndex) throws Exception {
        int tmp = (int)(Math.floor((rowIndex - 1) / this.displayRow) * (double)this.displayRow);
        this.setValue(tmp, this.displayRow);
        int tmp2 = (rowIndex - 1) % this.displayRow;
        try {
            this.table.setRowSelectionInterval(tmp2, tmp2);
        }
        catch (Exception ex) {
            JMessageDialog.errorDialog(this.dialog, ex.getMessage());
            return;
        }
    }

    void setDisplayRow(int rowCt) throws Exception {
        this.setValue(0, rowCt);
        this.displayRow = rowCt;
    }

    int getDisplayRow() {
        return this.displayRow;
    }

    int getSelectedRow() {
        int tmp = this.table.getSelectedRow();
        if (tmp < 0) {
            return -1;
        }
        return tmp + this.startIndex;
    }
}

