/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlbuilder;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLDataSheetView;

public class XMLNumericDialog
extends JDialog
implements ActionListener {
    JTextField rowField;
    JButton okButton;
    JButton cancelButton;
    XMLDataSheetView dataSheet;
    String label;
    int value;
    boolean isModified = false;

    public XMLNumericDialog(Dialog dialog, int value, String title, String label) {
        super(dialog, title, true);
        this.label = label;
        this.value = value;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new JLabel(this.label));
        if (this.value > 0) {
            this.rowField = new JTextField(this.value + "", 5);
            p1.add(this.rowField);
        } else {
            this.rowField = new JTextField("", 5);
            p1.add(this.rowField);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    boolean isModified() {
        return this.isModified;
    }

    int getValue() {
        return this.value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String msg = null;
            try {
                int rowIndex = Integer.parseInt(this.rowField.getText());
                if (rowIndex < 0) {
                    rowIndex = 0;
                }
                this.value = rowIndex;
                this.isModified = true;
            }
            catch (Exception ex) {
                msg = LanguageEncoder.getText("Row Index Field : Integer Only!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }
}

