/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlbuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import quadbase.chart.designer.ChartWizard;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDAttribute;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.dtd.elements.XSObjectWrapper;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.datasourcemanager.manager.DTDTreeCellRenderer;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLConditionBuilderDialog;
import quadbase.datasourcemanager.manager.xmlbuilder.XMLDataSheetView;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTree;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTreeBuilderDialog;

public class XMLQueryBuilderDialog
extends JDialog
implements ActionListener,
MouseListener,
CellEditorListener,
ChangeListener,
WindowListener {
    private JTextField nameField = null;
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private JButton okButton;
    private JButton cancelButton;
    private JTree dtdTree;
    private JTable fieldTable;
    private DefaultTableModel tableModel;
    private DefaultCellEditor editor;
    private DefaultCellEditor notEditor;
    private static String[] header = new String[]{LanguageEncoder.getText("Selected field"), LanguageEncoder.getText("Alias")};
    private DTD dtd;
    private DTDElement rootElt;
    private Hashtable elements;
    private XMLConditionBuilderDialog conditionDialog = null;
    private XMLDataSheetView dataSheetView = null;
    private Manager manager;
    private DefaultDataSourceNode parent;
    private XMLQueryNode node;
    private Vector selectedFields = new Vector();
    private boolean modified = false;
    private final int ALIASCOL = 1;
    private JTabbedPane tabbedPane;
    private int lastTabIndex = 0;
    private boolean modifyQuery = false;

    public XMLQueryBuilderDialog(Manager manager, DefaultDataSourceNode parent, XMLQueryNode node) {
        super((Dialog)manager, true);
        this.manager = manager;
        this.parent = parent;
        this.node = node;
        XMLSchemaTree conditionTree = null;
        String DTDTreeFileName = null;
        DTDTreeFileName = ((XMLFileNode)parent).getDTDTreeFileName();
        if (DTDTreeFileName.toLowerCase().endsWith(".ddt")) {
            this.dtd = DTDUtil.readDTD(DTDTreeFileName);
        } else {
            try {
                XMLSchemaTreeBuilderDialog bDialog = new XMLSchemaTreeBuilderDialog(this, DTDTreeFileName);
                this.dtdTree = bDialog.getTree();
                this.dtdTree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        int selRow = XMLQueryBuilderDialog.this.dtdTree.getRowForLocation(e.getX(), e.getY());
                        if (selRow != -1 && e.getClickCount() >= 2) {
                            XMLQueryBuilderDialog.this.doAdd(XMLQueryBuilderDialog.this.getSelectedNode());
                        }
                    }
                });
                conditionTree = new XMLSchemaTree(this.dtdTree);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
        this.init(conditionTree);
        this.setPosition();
    }

    private void init(JTree conditionTree) {
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(0);
        this.setTitle(LanguageEncoder.getText("Build XML Query"));
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        JPanel buildpanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        buildpanel.setLayout(gridbag);
        buildpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Field Selection")));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 0, 10, 0);
        JLabel comp = new JLabel(LanguageEncoder.getText("Name :") + " ");
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 0, 10, 0);
        this.nameField = new JTextField("", 15);
        this.nameField.addActionListener(this);
        gridbag.setConstraints(this.nameField, gbc);
        buildpanel.add(this.nameField);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 10;
        gbc.fill = 1;
        comp = new JLabel(LanguageEncoder.getText("Available Fields"));
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        gbc.gridx = 2;
        gbc.gridy = 1;
        comp = new JLabel(LanguageEncoder.getText("Selected Fields"));
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        this.addButton = new JButton(LanguageEncoder.getText("ADD ->"));
        this.addAllButton = new JButton(LanguageEncoder.getText("Add All ->"));
        this.removeButton = new JButton(LanguageEncoder.getText("<- REMOVE"));
        this.removeAllButton = new JButton(LanguageEncoder.getText("<- Remove All"));
        this.addButton.addActionListener(this);
        this.addAllButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.removeAllButton.addActionListener(this);
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gridbag.setConstraints(this.addButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gridbag.setConstraints(this.addAllButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gridbag.setConstraints(this.removeButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gridbag.setConstraints(this.removeAllButton, gbc);
        buildpanel.add(this.addButton);
        buildpanel.add(this.addAllButton);
        buildpanel.add(this.removeButton);
        buildpanel.add(this.removeAllButton);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 9;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        if (this.dtd != null) {
            this.elements = this.dtd.getElements();
            this.rootElt = this.dtd.getRootElement();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.rootElt);
            this.dtdTree = new JTree(DTDUtil.buildTree(this.rootElt, this.elements, root, true));
            this.dtdTree.setCellRenderer(new DTDTreeCellRenderer());
            this.dtdTree.setRootVisible(true);
            this.expandAll(this.dtdTree);
        } else {
            this.dtdTree.getSelectionModel().setSelectionMode(4);
        }
        this.dtdTree.setVisibleRowCount(20);
        this.dtdTree.addMouseListener(this);
        FocusAdapter flistener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                Component tempComponent = event.getComponent();
                if (tempComponent instanceof JTree) {
                    if (tempComponent == XMLQueryBuilderDialog.this.dtdTree) {
                        XMLQueryBuilderDialog.this.fieldTable.clearSelection();
                    }
                    if (((JTree)tempComponent).getSelectionPath() != null) {
                        XMLQueryBuilderDialog.this.setButtonState((DefaultMutableTreeNode)((JTree)tempComponent).getSelectionPath().getLastPathComponent(), false);
                    }
                } else if (tempComponent instanceof JTable && tempComponent == XMLQueryBuilderDialog.this.fieldTable) {
                    XMLQueryBuilderDialog.this.dtdTree.clearSelection();
                    XMLQueryBuilderDialog.this.setButtonState(null, true);
                }
            }
        };
        TreeSelectionListener slistener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DefaultMutableTreeNode tnode = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tnode = (DefaultMutableTreeNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                }
                if (XMLQueryBuilderDialog.this.dtd != null && XMLQueryBuilderDialog.this.buildSubTree(tnode)) {
                    try {
                        tnode.add(DTDUtil.buildTree(XMLQueryBuilderDialog.this.rootElt, XMLQueryBuilderDialog.this.elements, tnode, true));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    XMLQueryBuilderDialog.this.expandAll(XMLQueryBuilderDialog.this.dtdTree);
                }
                XMLQueryBuilderDialog.this.setButtonState(tnode, false);
            }
        };
        this.dtdTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = XMLQueryBuilderDialog.this.dtdTree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() >= 2 && XMLQueryBuilderDialog.this.dtd != null) {
                    XMLQueryBuilderDialog.this.doAdd(XMLQueryBuilderDialog.this.getSelectedNode());
                }
            }
        });
        this.dtdTree.addFocusListener(flistener);
        this.dtdTree.addTreeSelectionListener(slistener);
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.dtdTree);
        Dimension d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(200, (int)d.getHeight()));
        gridbag.setConstraints(scroll, gbc);
        buildpanel.add(scroll);
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.tableModel = new DefaultTableModel(header, 0);
        this.fieldTable = this.getFieldTable();
        this.fieldTable.addFocusListener(flistener);
        if (this.node != null) {
            this.nameField.setText(this.node.getName());
            this.selectedFields = this.node.getSelectedFields();
            this.setTable();
        }
        scroll = new JScrollPane();
        scroll.getViewport().setView(this.fieldTable);
        scroll.setBackground(this.fieldTable.getBackground());
        d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(400, (int)d.getHeight()));
        gridbag.setConstraints(scroll, gbc);
        buildpanel.add(scroll);
        String condition = "";
        if (this.node != null && this.node.getConditionStatement() != null) {
            condition = this.node.getConditionStatement();
        }
        try {
            this.conditionDialog = this.dtd != null ? new XMLConditionBuilderDialog((JDialog)this, this.parent, this.node, condition, this.dtd) : new XMLConditionBuilderDialog((JDialog)this, this.parent, this.node, condition, conditionTree);
        }
        catch (Exception exception) {
            // empty catch block
        }
        QueryInParamSet inSet = null;
        if (this.node != null) {
            inSet = this.node.getInSet();
        }
        this.dataSheetView = new XMLDataSheetView(this.manager, this.parent, condition, this.selectedFields, inSet);
        this.tabbedPane.addTab(LanguageEncoder.getText("Fields"), buildpanel);
        this.tabbedPane.addTab(LanguageEncoder.getText("Conditions"), this.conditionDialog.getMainPanel());
        this.tabbedPane.addTab(LanguageEncoder.getText("DataSheet"), this.dataSheetView);
        this.tabbedPane.addChangeListener(this);
        bpanel.add("Center", this.tabbedPane);
        bpanel.add("South", this.getokPanel());
        this.addWindowListener(this);
    }

    private JTable getFieldTable() {
        JTable table = new JTable(this.tableModel);
        table.setGridColor(Color.lightGray);
        table.setCellSelectionEnabled(true);
        table.setSelectionMode(2);
        table.getTableHeader().setReorderingAllowed(false);
        table.setShowGrid(true);
        TableColumnModel colModel = table.getColumnModel();
        MyRenderer myRenderer = new MyRenderer();
        for (int i = 0; i < 2; ++i) {
            table.getColumnModel().getColumn(i).setCellRenderer(myRenderer);
        }
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(0);
        this.notEditor = new DefaultCellEditor(notEditableField);
        this.notEditor.setClickCountToStart(15);
        table.clearSelection();
        colModel.getColumn(0).setCellEditor(this.notEditor);
        JTextField editableField = new JTextField();
        editableField.setEditable(true);
        editableField.setHorizontalAlignment(0);
        this.editor = new DefaultCellEditor(editableField);
        this.editor.addCellEditorListener(this);
        table.clearSelection();
        colModel.getColumn(1).setCellEditor(this.editor);
        return table;
    }

    private JPanel getokPanel() {
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        okpanel.add(this.okButton);
        okpanel.add(this.cancelButton);
        return okpanel;
    }

    private void setPosition() {
        if (this.dtd != null) {
            this.expandAll(this.dtdTree);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private String getCondition() {
        if (this.conditionDialog != null) {
            return this.conditionDialog.getCondition();
        }
        return "";
    }

    private QueryInParamSet getParamSet() {
        if (this.conditionDialog != null) {
            return this.conditionDialog.getParamSet();
        }
        return null;
    }

    private QueryInParamSet getInSet() {
        if (this.conditionDialog != null) {
            return this.conditionDialog.getInSet();
        }
        return null;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.modified = true;
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        Object value = this.tableModel.getValueAt(row, col);
        String val = (String)value;
        if (this.aliasExists(val, row)) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "This alias exists!");
            XMLFieldInfo info = (XMLFieldInfo)this.selectedFields.elementAt(row);
            this.tableModel.setValueAt(info.getAlias(), row, 1);
            return;
        }
        this.tableModel.setValueAt(value, row, 1);
        XMLFieldInfo field = (XMLFieldInfo)this.selectedFields.elementAt(row);
        field.setAlias((String)value);
        this.selectedFields.setElementAt(field, row);
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setPanel(this.tabbedPane.getSelectedIndex());
        this.lastTabIndex = this.tabbedPane.getSelectedIndex();
    }

    private void setPanel(int selectedIndex) {
        this.manager.setCursor(Cursor.getPredefinedCursor(3));
        if (selectedIndex == 2) {
            this.updateDataSheet(this.getCondition(), this.selectedFields, this.getParamSet());
        }
        this.manager.setCursor(null);
    }

    private void updateDataSheet(String condition, Vector selectedFields, QueryInParamSet paramSet) {
        if (QueryParser.hasParameters(this.getCondition()) && paramSet == null) {
            this.conditionDialog.actionPerformed(new ActionEvent(this.conditionDialog.initParamButton, 0, ""));
            if (paramSet == null && this.conditionDialog.isCancel()) {
                this.tabbedPane.setSelectedIndex(this.lastTabIndex);
                return;
            }
        }
        if (paramSet != null) {
            this.dataSheetView.setQuery(condition, selectedFields, paramSet);
        } else {
            this.dataSheetView.setQuery(condition, selectedFields, this.getParamSet());
        }
    }

    private void setTable() {
        this.modified = false;
        if (this.selectedFields == null || this.selectedFields.size() == 0) {
            return;
        }
        XMLFieldInfo[] fields = DTDUtil.getXMLAllFields((DefaultMutableTreeNode)this.dtdTree.getModel().getRoot());
        for (int i = 0; i < this.selectedFields.size(); ++i) {
            XMLFieldInfo info = (XMLFieldInfo)this.selectedFields.elementAt(i);
            boolean found = false;
            for (int j = 0; j < fields.length && !found; ++j) {
                if (!info.getDisplayName().equals(fields[j].getDisplayName())) continue;
                if (info.getXMLType() == 1) {
                    info.setElementDataType(fields[j].getElementDataType());
                    if (fields[j].getElementDataType().equals("date") || fields[j].getElementDataType().equals("time") || fields[j].getElementDataType().equals("timestamp")) {
                        info.setDateFormat(fields[j].getDateFormat());
                    }
                } else if (info.getXMLType() == 2) {
                    info.setAttributeDataType(fields[j].getAttributeDataType());
                    if (fields[j].getAttributeDataType().equals("date") || fields[j].getAttributeDataType().equals("time") || fields[j].getAttributeDataType().equals("timestamp")) {
                        info.setDateFormat(fields[j].getDateFormat());
                    }
                }
                this.selectedFields.setElementAt(info, i);
                found = true;
            }
            Object[] row = new Object[]{info.getDisplayName(), info.getAlias(), info.isExpandable()};
            this.tableModel.addRow(row);
        }
    }

    private void expandAll(JTree tree) {
        this.expandEntireTree(tree, (DefaultMutableTreeNode)tree.getModel().getRoot());
    }

    private void expandEntireTree(JTree tree, DefaultMutableTreeNode tNode) {
        TreePath tp = new TreePath(tNode.getPath());
        tree.expandPath(tp);
        for (int i = 0; i < tNode.getChildCount(); ++i) {
            this.expandEntireTree(tree, (DefaultMutableTreeNode)tNode.getChildAt(i));
        }
    }

    private void setButtonState(DefaultMutableTreeNode tnode, boolean tableSelected) {
        this.addButton.setEnabled(true);
        this.addAllButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.removeAllButton.setEnabled(true);
        if (tnode != null) {
            this.addButton.setEnabled(this.isAddEnabled(tnode));
            this.addAllButton.setEnabled(this.isAddEnabled(tnode));
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        } else if (tableSelected) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
            this.removeButton.setEnabled(true);
            this.removeAllButton.setEnabled(true);
        }
    }

    private boolean isAddEnabled(DefaultMutableTreeNode tnode) {
        Object userObj = tnode.getUserObject();
        Object[] nodes = tnode.getPath();
        TreePath path = new TreePath(nodes);
        if (!this.dtdTree.isVisible(path)) {
            return false;
        }
        if (userObj instanceof DTDElement) {
            DTDElement elt = (DTDElement)userObj;
            if (tnode.isLeaf() && elt.isExpand() || elt.isMixedLeaf()) {
                return true;
            }
        } else {
            XSObjectWrapper wrapper;
            if (userObj instanceof DTDAttribute) {
                return true;
            }
            if (userObj instanceof XSObjectWrapper && ((wrapper = (XSObjectWrapper)userObj).isLeaf() || wrapper.isSelectable())) {
                return true;
            }
        }
        return false;
    }

    private boolean buildSubTree(DefaultMutableTreeNode tnode) {
        if (tnode == null) {
            return false;
        }
        Object userObj = tnode.getUserObject();
        if (userObj instanceof DTDElement) {
            DTDElement elt = (DTDElement)userObj;
            if (tnode.isLeaf() && !elt.isExpand()) {
                return true;
            }
        }
        return false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public XMLQueryNode getNode() {
        return this.node;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.dtdTree.isSelectionEmpty()) {
            return null;
        }
        return (DefaultMutableTreeNode)this.dtdTree.getSelectionPath().getLastPathComponent();
    }

    public DefaultMutableTreeNode[] getSelectedNodes() {
        if (this.dtdTree.isSelectionEmpty()) {
            return null;
        }
        int ct = this.dtdTree.getSelectionCount();
        DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[ct];
        TreePath[] paths = this.dtdTree.getSelectionPaths();
        for (int i = 0; i < ct; ++i) {
            nodes[i] = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
        }
        return nodes;
    }

    private void doAdd(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (!this.isAddEnabled(node)) {
            return;
        }
        XMLFieldInfo field = DTDUtil.getXMLFieldInfo(node);
        if (field != null && !this.containsPath(field.getPath(), field.getAttributeName())) {
            this.addField(field);
            Object[] data = new Object[]{field.getDisplayName(), field.getAlias(), Boolean.FALSE};
            this.tableModel.addRow(data);
            this.fieldTable.validate();
            this.fieldTable.repaint();
        }
    }

    private void doAddAll(DefaultMutableTreeNode node) {
        if (!node.isLeaf()) {
            Object userObj = node.getUserObject();
            if (userObj instanceof DTDElement && ((DTDElement)userObj).isMixedLeaf()) {
                this.doAdd(node);
            } else if (userObj instanceof XSObjectWrapper && ((XSObjectWrapper)userObj).isSelectable()) {
                this.doAdd(node);
            }
            int childCt = node.getChildCount();
            for (int i = 0; i < childCt; ++i) {
                DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.doAddAll(tnode);
            }
        } else {
            this.doAdd(node);
        }
    }

    private void doRemove(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            this.tableModel.removeRow(indices[i]);
            this.selectedFields.removeElementAt(indices[i]);
        }
        this.editor.cancelCellEditing();
        this.notEditor.cancelCellEditing();
        this.tableModel.fireTableDataChanged();
    }

    private void doRemoveAll() {
        this.selectedFields = new Vector();
        this.cleanTable();
        this.editor.cancelCellEditing();
        this.notEditor.cancelCellEditing();
        this.tableModel.fireTableDataChanged();
    }

    private void cleanTable() {
        int count = this.tableModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.tableModel.removeRow(0);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.modified = false;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.modified = false;
            this.setVisible(false);
            if (this.manager.managerPane != null) {
                this.manager.managerPane.closeEditOrAddNode();
            }
            this.dispose();
        } else if (e.getSource() == this.addButton) {
            DefaultMutableTreeNode[] nodes = this.getSelectedNodes();
            if (nodes != null) {
                for (DefaultMutableTreeNode node2 : nodes) {
                    this.doAdd(node2);
                }
            }
        } else if (e.getSource() == this.addAllButton) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.dtdTree.getModel().getRoot();
            this.fieldTable.clearSelection();
            this.selectedFields = new Vector();
            this.cleanTable();
            this.doAddAll(root);
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
        } else if (e.getSource() == this.removeButton) {
            int[] indices = this.fieldTable.getSelectedRows();
            this.doRemove(indices);
        } else if (e.getSource() == this.removeAllButton) {
            this.doRemoveAll();
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        } else if (e.getSource() == this.nameField || e.getSource() == this.okButton) {
            XMLQueryNode xqNode;
            String nodeName = this.nameField.getText().trim();
            String msg = this.conditionDialog.testSyntax(this.conditionDialog.getCondition());
            if (!this.modifyQuery) {
                if (nodeName == null || nodeName.trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter a query node name.");
                } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                    msg = nodeName + " " + LanguageEncoder.getText("already exists!");
                }
            }
            if (this.selectedFields == null || this.selectedFields.size() <= 0 && msg == null) {
                msg = LanguageEncoder.getText("Please select fields from the left.");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (QueryParser.hasParameters(this.getCondition()) && this.getInSet() == null) {
                this.conditionDialog.actionPerformed(new ActionEvent(this.conditionDialog.initParamButton, 0, ""));
            }
            if ((xqNode = this.node) == null) {
                xqNode = new XMLQueryNode(nodeName);
                this.parent.add(xqNode);
            } else {
                xqNode.setUserObject(nodeName);
            }
            xqNode.setSelectedFields(this.selectedFields);
            xqNode.setConditionStatement(this.getCondition());
            xqNode.setInSet(this.getInSet());
            this.node = xqNode;
            this.setVisible(false);
            this.dispose();
            this.modified = true;
        }
    }

    private boolean aliasExists(String alias, int excludeRowNumber) {
        for (int i = 0; i < this.tableModel.getRowCount() && i != excludeRowNumber; ++i) {
            String str = (String)this.tableModel.getValueAt(i, 1);
            if (!alias.equals(str)) continue;
            return true;
        }
        return false;
    }

    private void addField(XMLFieldInfo field) {
        if (this.selectedFields == null) {
            this.selectedFields = new Vector();
        }
        if (!this.containsPath(field.getPath(), field.getAttributeName())) {
            this.selectedFields.addElement(field);
        }
    }

    private boolean containsPath(String[] path, String attrName) {
        if (this.selectedFields == null || this.selectedFields.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.selectedFields.size(); ++i) {
            XMLFieldInfo field = (XMLFieldInfo)this.selectedFields.elementAt(i);
            if (!DTDUtil.getXMLFieldFullName(path, attrName).equals(field.getDisplayName())) continue;
            return true;
        }
        return false;
    }

    XMLFieldInfo[] getSelectedFieldInfo() {
        XMLFieldInfo[] fieldInfo = new XMLFieldInfo[this.selectedFields.size()];
        for (int i = 0; i < this.selectedFields.size(); ++i) {
            fieldInfo[i] = (XMLFieldInfo)this.selectedFields.elementAt(i);
        }
        return fieldInfo;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public boolean forChart() {
        return this.manager.interchange instanceof ChartWizard;
    }

    public boolean isModifyQuery() {
        return this.modifyQuery;
    }

    public void setModifyQuery(boolean b) {
        this.modifyQuery = b;
    }

    private class MyRenderer
    implements TableCellRenderer {
        private JTextField text = new JTextField("TEMP");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(value + "");
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(this.text.getSelectionColor());
                label.setForeground(this.text.getSelectedTextColor());
            } else {
                label.setBackground(table.getBackground());
                label.setForeground(table.getForeground());
            }
            return label;
        }
    }
}

