/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlschema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.namespace.QName;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSWildcard;
import quadbase.common.util.dtd.elements.XSObjectWrapper;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.common.util.internal.XMLRootFinder;
import quadbase.datasourcemanager.manager.xmlschema.LoadNode;
import quadbase.datasourcemanager.manager.xmlschema.SchemaNode;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTreeCellRenderer;

public class XMLSchemaTree
extends JTree
implements TreeWillExpandListener {
    private Hashtable XSObjectHashtable = new Hashtable();
    private byte[] xsdFileBytes = null;
    private String systemId = null;
    private QName rootElementName = null;

    private XMLSchemaTree() {
    }

    public XMLSchemaTree(JTree _tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)_tree.getModel().getRoot();
        DefaultMutableTreeNode newroot = new DefaultMutableTreeNode(root.getUserObject());
        for (int i = 0; i < root.getChildCount(); ++i) {
            newroot.add(this.duplicateNode((DefaultMutableTreeNode)root.getChildAt(i)));
        }
        this.setModel(new DefaultTreeModel(newroot));
        this.addTreeListeners();
    }

    public XMLSchemaTree(String xsdFile, String xmlFile) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream in = readfile.getInputStream(xsdFile);
        this.xsdFileBytes = IOUtil.streamToByteArray(in);
        this.systemId = xsdFile;
        this.rootElementName = new XMLRootFinder().findRoot(xmlFile);
        this.createTree();
    }

    public XMLSchemaTree(InputStream xsdStream) throws Exception {
        this.xsdFileBytes = IOUtil.streamToByteArray(xsdStream);
        this.createTree();
    }

    private void addTreeListeners() {
        this.addTreeWillExpandListener(this);
        this.setCellRenderer(new XMLSchemaTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setRootVisible(false);
        this.expandAll();
    }

    private void createTree() throws Exception {
        XMLGrammarPreparser grammarPreparser = new XMLGrammarPreparser();
        grammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        XMLInputSource is = new XMLInputSource(null, this.systemId, null, (InputStream)new ByteArrayInputStream(this.xsdFileBytes), null);
        XSGrammar grammar = (XSGrammar)grammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", is);
        XSModel model = grammar.toXSModel();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        if (this.rootElementName == null) {
            XSNamedMap mapOfElements = model.getComponents((short)2);
            for (int i = 0; i < mapOfElements.getLength(); ++i) {
                XSObjectWrapper wrapper;
                root.add(new SchemaNode(wrapper, !(wrapper = this.getXSObjectWrapper(mapOfElements.item(i))).isLeaf()));
            }
        } else {
            XSObjectWrapper wrapper;
            XSElementDeclaration rootDeclaration = model.getElementDeclaration(this.rootElementName.getLocalPart(), this.rootElementName.getNamespaceURI());
            root.add(new SchemaNode(wrapper, !(wrapper = this.getXSObjectWrapper((XSObject)rootDeclaration)).isLeaf()));
        }
        this.setModel(new DefaultTreeModel(root));
        this.addTreeListeners();
    }

    private XSObjectWrapper getXSObjectWrapper(XSObject obj) throws Exception {
        if (this.XSObjectHashtable.containsKey(obj)) {
            return (XSObjectWrapper)this.XSObjectHashtable.get(obj);
        }
        XSObjectWrapper wrapper = new XSObjectWrapper(obj);
        this.XSObjectHashtable.put(obj, wrapper);
        return wrapper;
    }

    public static XMLSchemaTree load(String xstFile) throws Exception {
        XMLSchemaTree schemaTree = new XMLSchemaTree();
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream din = readfile.getInputStream(xstFile);
        int version = din.readInt();
        if (version >= 1) {
            schemaTree.systemId = IOUtil.readStr(din);
            if (din.readBoolean()) {
                String namespace = IOUtil.readStr(din);
                String localPart = IOUtil.readStr(din);
                schemaTree.rootElementName = new QName(namespace, localPart);
            }
        }
        int bytelength = din.readInt();
        schemaTree.xsdFileBytes = new byte[bytelength];
        din.readFully(schemaTree.xsdFileBytes);
        schemaTree.createTree();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        int count = din.readInt();
        for (int i = 0; i < count; ++i) {
            root.add(XMLSchemaTree.readNodeHelper(version, din));
        }
        XMLSchemaTree.copyNode(schemaTree, (DefaultMutableTreeNode)schemaTree.getModel().getRoot(), root);
        return schemaTree;
    }

    private static void copyNode(JTree tree, DefaultMutableTreeNode schemaNode, DefaultMutableTreeNode loadNode) {
        if (schemaNode == null || loadNode == null) {
            return;
        }
        if (loadNode.getChildCount() > 0 && schemaNode.getLevel() > 0) {
            Object[] objs = new Object[schemaNode.getLevel() + 1];
            TreeNode cur = schemaNode;
            for (int i = objs.length - 1; i >= 0; --i) {
                objs[i] = cur;
                cur = cur.getParent();
            }
            tree.expandPath(new TreePath(objs));
        }
        block1: for (int i = 0; i < schemaNode.getChildCount(); ++i) {
            SchemaNode childSchemaNode = (SchemaNode)schemaNode.getChildAt(i);
            XSObjectWrapper wrapper = (XSObjectWrapper)childSchemaNode.getUserObject();
            XSObject object = wrapper.getObject();
            for (int j = 0; j < loadNode.getChildCount(); ++j) {
                LoadNode childLoadNode = (LoadNode)loadNode.getChildAt(j);
                if ((!(object instanceof XSAttributeDeclaration) || !childLoadNode.isAttribute()) && (!(object instanceof XSElementDeclaration) || childLoadNode.isAttribute()) || !object.getName().equals(childLoadNode.getName()) || object.getNamespace() != childLoadNode.getNamespace() && (object.getNamespace() == null || !object.getNamespace().equals(childLoadNode.getNamespace()))) continue;
                wrapper.setDataType(childLoadNode.getDataType());
                wrapper.setDateFormatString(childLoadNode.getDateFormatString());
                XMLSchemaTree.copyNode(tree, childSchemaNode, childLoadNode);
                continue block1;
            }
        }
    }

    private static LoadNode readNodeHelper(int version, DataInputStream din) throws Exception {
        LoadNode node = new LoadNode();
        node.setIsAttribute(din.readBoolean());
        node.setNamespace(IOUtil.readStr(din));
        node.setName(IOUtil.readStr(din));
        node.setDataType(din.readInt());
        node.setDateFormatString(IOUtil.readStr(din));
        int count = din.readInt();
        for (int i = 0; i < count; ++i) {
            node.add(XMLSchemaTree.readNodeHelper(version, din));
        }
        return node;
    }

    public void save(String file, int version) throws Exception {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(5000);
        DataOutputStream dout = new DataOutputStream(outstream);
        dout.writeInt(version);
        IOUtil.writeStr(dout, this.systemId);
        if (this.rootElementName == null) {
            dout.writeBoolean(false);
        } else {
            dout.writeBoolean(true);
            IOUtil.writeStr(dout, this.rootElementName.getNamespaceURI());
            IOUtil.writeStr(dout, this.rootElementName.getLocalPart());
        }
        dout.writeInt(this.xsdFileBytes.length);
        dout.write(this.xsdFileBytes);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        dout.writeInt(root.getChildCount());
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.writeNodeHelper(dout, (SchemaNode)root.getChildAt(i));
        }
        dout.flush();
        WriteDataFile wdfile = new WriteDataFile();
        if (!file.toUpperCase().endsWith(".xst".toUpperCase())) {
            file = file + ".xst";
        }
        wdfile.output(outstream.toByteArray(), file);
    }

    private void writeNodeHelper(DataOutputStream dout, SchemaNode node) throws Exception {
        XSObjectWrapper wrapper = (XSObjectWrapper)node.getUserObject();
        XSObject object = wrapper.getObject();
        if (object instanceof XSAttributeDeclaration) {
            dout.writeBoolean(true);
        } else {
            dout.writeBoolean(false);
        }
        IOUtil.writeStr(dout, object.getNamespace());
        IOUtil.writeStr(dout, object.getName());
        dout.writeInt(wrapper.getDataType());
        IOUtil.writeStr(dout, wrapper.getDateFormatString());
        dout.writeInt(node.getChildCount());
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.writeNodeHelper(dout, (SchemaNode)node.getChildAt(i));
        }
    }

    private void expandAll() {
        this.expandEntireTree(this, (DefaultMutableTreeNode)this.getModel().getRoot());
    }

    private void expandEntireTree(JTree tree, DefaultMutableTreeNode tNode) {
        TreePath tp = new TreePath(tNode.getPath());
        tree.expandPath(tp);
        for (int i = 0; i < tNode.getChildCount(); ++i) {
            this.expandEntireTree(tree, (DefaultMutableTreeNode)tNode.getChildAt(i));
        }
    }

    private DefaultMutableTreeNode duplicateNode(DefaultMutableTreeNode node) {
        SchemaNode newnode = new SchemaNode(node.getUserObject(), !node.isLeaf());
        for (int i = 0; i < node.getChildCount(); ++i) {
            newnode.add(this.duplicateNode((DefaultMutableTreeNode)node.getChildAt(i)));
        }
        return newnode;
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        XSObjectWrapper object;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (!node.isLeaf() && node.getChildCount() == 0 && (object = (XSObjectWrapper)node.getUserObject()).getObject() instanceof XSElementDeclaration) {
            XSComplexTypeDefinition type = (XSComplexTypeDefinition)((XSElementDeclaration)object.getObject()).getTypeDefinition();
            XSParticle particle = type.getParticle();
            this.addChildElement(particle, node);
            XSObjectList attrList = type.getAttributeUses();
            for (int i = 0; i < attrList.getLength(); ++i) {
                XSAttributeDeclaration attr = ((XSAttributeUse)attrList.item(i)).getAttrDeclaration();
                try {
                    XSObjectWrapper wrapper = this.getXSObjectWrapper((XSObject)attr);
                    node.add(new SchemaNode(wrapper, !wrapper.isLeaf()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void addChildElement(XSParticle particle, DefaultMutableTreeNode parent) {
        if (particle == null || parent == null) {
            return;
        }
        XSTerm term = particle.getTerm();
        if (term instanceof XSElementDeclaration || term instanceof XSWildcard) {
            try {
                XSObjectWrapper wrapper = this.getXSObjectWrapper((XSObject)term);
                parent.add(new SchemaNode(wrapper, !wrapper.isLeaf()));
            }
            catch (Exception wrapper) {}
        } else if (term instanceof XSModelGroup) {
            XSObjectList list = ((XSModelGroup)term).getParticles();
            for (int i = 0; i < list.getLength(); ++i) {
                XSParticle childParticle = (XSParticle)list.item(i);
                this.addChildElement(childParticle, parent);
            }
        }
    }
}

