/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlschema;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.util.dtd.elements.XSObjectWrapper;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTree;

public class XMLSchemaTreeBuilderDialog
extends JDialog
implements TreeSelectionListener,
ActionListener {
    public static final int VERSION = 1;
    private JLabel dataTypeLabel = null;
    private JLabel dateFormatLabel = null;
    private JComboBox dataTypeComboBox = null;
    private JTextField dateFormatTextField = null;
    private JPanel dateFormatPanel = null;
    private String[] typeNames = new String[]{"string", "boolean", "byte", "short", "int", "long", "float", "double", "date", "time", "datetime"};
    private int[] typesMap = new int[]{7, 0, 11, 12, 2, 1, 3, 4, 8, 9, 10};
    private XMLSchemaTree xsdTree = null;
    private boolean modified = false;

    public XMLSchemaTreeBuilderDialog(JDialog parent, String xsdfile, String xmlFile, String xstSaveFilename) throws Exception {
        super(parent, LanguageEncoder.getText("Setup XML schema data types..."), true);
        this.xsdTree = new XMLSchemaTree(xsdfile, xmlFile);
        this.xsdTree.addTreeSelectionListener(this);
        this.init();
        this.xsdTree.save(xstSaveFilename, 1);
        this.setPosition();
    }

    public XMLSchemaTreeBuilderDialog(JDialog parent, InputStream stream, String xstSaveFilename) throws Exception {
        super(parent, LanguageEncoder.getText("Setup XML schema data types..."), true);
        this.xsdTree = new XMLSchemaTree(stream);
        this.xsdTree.addTreeSelectionListener(this);
        this.init();
        this.xsdTree.save(xstSaveFilename, 1);
        this.setPosition();
    }

    public XMLSchemaTreeBuilderDialog(JDialog parent, String xstSaveFilename) throws Exception {
        super(parent, LanguageEncoder.getText("Setup XML schema data types..."), true);
        this.xsdTree = XMLSchemaTree.load(xstSaveFilename);
        this.xsdTree.addTreeSelectionListener(this);
        this.init();
        this.setPosition();
    }

    public void save(String file) throws Exception {
        this.xsdTree.save(file, 1);
    }

    private void init() throws Exception {
        this.setBackground(Color.lightGray);
        JPanel contentPane = (JPanel)this.getContentPane();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.xsdTree);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        gbl.setConstraints(scrollPane, gbc);
        contentPane.add(scrollPane);
        gbc.weighty = 0.0;
        JPanel panel = this.getTypePanel();
        gbl.setConstraints(panel, gbc);
        contentPane.add(panel);
        this.dateFormatPanel = this.getFormatPanel();
        gbl.setConstraints(this.dateFormatPanel, gbc);
        contentPane.add(this.dateFormatPanel);
        this.xsdTree.setSelectionRow(0);
    }

    private JPanel getTypePanel() {
        JPanel panel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.dataTypeComboBox = new JComboBox<String>(this.typeNames);
        gbl.setConstraints(this.dataTypeComboBox, gbc);
        panel.add(this.dataTypeComboBox);
        this.dataTypeComboBox.addActionListener(this);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        JButton button = new JButton(LanguageEncoder.getText("OK"));
        button.setActionCommand("OK");
        button.addActionListener(this);
        gbl.setConstraints(button, gbc);
        panel.add(button);
        gbc.gridx = 3;
        button = new JButton(LanguageEncoder.getText("Cancel"));
        button.setActionCommand("Cancel");
        button.addActionListener(this);
        gbl.setConstraints(button, gbc);
        panel.add(button);
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 5, 0);
        this.dataTypeLabel = new JLabel(LanguageEncoder.getText("Data Type:"));
        gbl.setConstraints(this.dataTypeLabel, gbc);
        panel.add(this.dataTypeLabel);
        return panel;
    }

    private JPanel getFormatPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.dateFormatTextField = new JTextField();
        gbl.setConstraints(this.dateFormatTextField, gbc);
        panel.add(this.dateFormatTextField);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        JButton button = new JButton(LanguageEncoder.getText("Apply"));
        button.setActionCommand("Apply");
        gbl.setConstraints(button, gbc);
        panel.add(button);
        button.addActionListener(this);
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 5, 5, 0);
        this.dateFormatLabel = new JLabel(LanguageEncoder.getText("Date Format:"));
        gbl.setConstraints(this.dateFormatLabel, gbc);
        panel.add(this.dateFormatLabel);
        return panel;
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.dataTypeComboBox) {
            TreePath path = this.xsdTree.getSelectionPath();
            if (path != null) {
                XSObjectWrapper obj = (XSObjectWrapper)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                obj.setDataType(this.typesMap[this.dataTypeComboBox.getSelectedIndex()]);
                this.showFormatPanel(obj);
            }
        } else if ("Apply".equals(event.getActionCommand())) {
            this.doApply();
        } else if ("OK".equals(event.getActionCommand())) {
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        } else if ("Cancel".equals(event.getActionCommand())) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void doApply() {
        TreePath path = this.xsdTree.getSelectionPath();
        if (path != null) {
            XSObjectWrapper obj = (XSObjectWrapper)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            obj.setDateFormatString(this.dateFormatTextField.getText());
        }
    }

    private void showFormatPanel(XSObjectWrapper obj) {
        int dataType = -1;
        String dateformat = "";
        if (obj != null) {
            dataType = obj.getDataType();
            dateformat = obj.getDateFormatString();
        }
        if (dataType == 8) {
            this.dateFormatLabel.setText(LanguageEncoder.getText("Date Format:"));
            this.dateFormatTextField.setText(dateformat);
            this.dateFormatPanel.setVisible(true);
        } else if (dataType == 9) {
            this.dateFormatLabel.setText(LanguageEncoder.getText("Time Format:"));
            this.dateFormatTextField.setText(dateformat);
            this.dateFormatPanel.setVisible(true);
        } else if (dataType == 10) {
            this.dateFormatLabel.setText(LanguageEncoder.getText("Datetime Format:"));
            this.dateFormatTextField.setText(dateformat);
            this.dateFormatPanel.setVisible(true);
        } else {
            this.dateFormatPanel.setVisible(false);
        }
    }

    private static int mapQuadbaseTypeToIndex(int type) {
        if (type == 0) {
            return 1;
        }
        if (type == 11) {
            return 2;
        }
        if (type == 12) {
            return 3;
        }
        if (type == 2) {
            return 4;
        }
        if (type == 1) {
            return 5;
        }
        if (type == 3) {
            return 6;
        }
        if (type == 4) {
            return 7;
        }
        if (type == 8) {
            return 8;
        }
        if (type == 9) {
            return 9;
        }
        if (type == 10) {
            return 10;
        }
        return 0;
    }

    public boolean isModified() {
        return this.modified;
    }

    public JTree getTree() {
        return this.xsdTree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        XSObjectWrapper obj = (XSObjectWrapper)((DefaultMutableTreeNode)event.getPath().getLastPathComponent()).getUserObject();
        int dataType = -1;
        dataType = obj.getDataType();
        if (dataType >= 0) {
            this.dataTypeLabel.setEnabled(true);
            this.dataTypeComboBox.setEnabled(true);
            this.dataTypeComboBox.setSelectedIndex(XMLSchemaTreeBuilderDialog.mapQuadbaseTypeToIndex(dataType));
            this.showFormatPanel(obj);
        } else {
            this.dataTypeLabel.setEnabled(false);
            this.dataTypeComboBox.setEnabled(false);
            this.dateFormatPanel.setVisible(false);
        }
    }
}

