/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager.xmlschema;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSObject;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.dtd.elements.XSObjectWrapper;
import quadbase.common.util.internal.IOUtil;

public class XMLSchemaTreeCellRenderer
extends DefaultTreeCellRenderer {
    private String parentOpen = ServerMessage.reportImagesPath + "parentopen.gif";
    private String parentClosed = ServerMessage.reportImagesPath + "parentclosed.gif";
    private String leaf = ServerMessage.reportImagesPath + "leaf.gif";
    private String mixedLeaf = ServerMessage.reportImagesPath + "mixedleaf.gif";
    private String attribute = ServerMessage.reportImagesPath + "attribute.gif";
    private Icon parentOpenIcon = IOUtil.getImageIcon(this.parentOpen);
    private Icon parentClosedIcon = IOUtil.getImageIcon(this.parentClosed);
    private Icon leafIcon = IOUtil.getImageIcon(this.leaf);
    private Icon attributeIcon;
    private Icon mixedLeafIcon = IOUtil.getImageIcon(this.mixedLeaf);

    public XMLSchemaTreeCellRenderer() {
        this.attributeIcon = IOUtil.getImageIcon(this.attribute);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() instanceof XSObjectWrapper) {
            XSObjectWrapper wrapper = (XSObjectWrapper)((DefaultMutableTreeNode)value).getUserObject();
            XSObject object = wrapper.getObject();
            String text = null;
            if (object instanceof XSAttributeDeclaration) {
                this.setIcon(this.attributeIcon);
                text = "@" + object.getName();
            } else if (object instanceof XSElementDeclaration) {
                if (leaf) {
                    this.setIcon(this.leafIcon);
                } else if (wrapper.isSelectable()) {
                    this.setIcon(this.mixedLeafIcon);
                } else if (expanded) {
                    this.setIcon(this.parentOpenIcon);
                } else {
                    this.setIcon(this.parentClosedIcon);
                }
                text = object.getName();
            } else {
                text = "Wildcard - not supported";
            }
            this.setText(text);
        }
        return this;
    }
}

