/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.pak;

import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.pak.AbstractFilePacker;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.ReadXMLTable;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;

public class RegistryPacker
extends AbstractFilePacker {
    public static final String QUERY_PREFIX = "query-";
    public static final String DATAVIEW_PREFIX = "dataview-";
    public static final String DV_QUERY_PREFIX = "";
    public static final String DV_DATAVIEW_PREFIX = "dv_dataview-";
    public static final String TEXT_PREFIX = "text-";
    public static final String XML_PREFIX = "xml-";
    public static final String DTD_PREFIX = "dtd-";
    public static final String EXCEL_PREFIX = "excel-";

    public RegistryPacker(String regFilePath, String username) {
        super(regFilePath, username);
        this.PAK_TYPE = 3;
    }

    @Override
    protected void readAllPaths() throws Exception {
        DefaultMutableTreeNode root = RegistryPacker.getDataSources(this.mainFilePath);
        this.templatePaths = new Vector();
        this.templateNames = new Vector();
        this.otherFilePaths = new Vector();
        this.otherFileNames = new Vector();
        this.diskPathChangeAllowedList = new Vector();
        this.diskPathChangeAllowedMainFile = false;
        this.writeNode(root);
    }

    private void writeNode(DefaultMutableTreeNode node) throws Exception {
        String fileName;
        DefaultDataSourceNode tmpNode;
        if (node instanceof QueryNode) {
            tmpNode = (QueryNode)node;
            if (((QueryNode)tmpNode).getQueryFile() != null) {
                fileName = ((QueryNode)tmpNode).getQueryFile() + ".qry";
                if (!fileName.toLowerCase().replace('\\', '/').startsWith("queries/")) {
                    fileName = "queries/" + fileName;
                }
                this.otherFilePaths.add(fileName);
                this.otherFileNames.add(QbUtil.getFileNameForPak(QUERY_PREFIX + ((QueryNode)tmpNode).getQueryFile() + "_" + ((QueryNode)tmpNode).getName()));
                this.diskPathChangeAllowedList.add(Boolean.FALSE);
            }
        } else if (node instanceof DataViewNode) {
            tmpNode = (DataViewNode)node;
            if (((DataViewNode)tmpNode).getQueryFile() != null) {
                fileName = ((DataViewNode)tmpNode).getQueryFile() + ".dvw";
                if (!fileName.toLowerCase().replace('\\', '/').startsWith("queries/")) {
                    fileName = "queries/" + fileName;
                }
                this.otherFilePaths.add(fileName);
                this.otherFileNames.add(QbUtil.getFileNameForPak(DATAVIEW_PREFIX + ((DataViewNode)tmpNode).getQueryFile() + "_" + ((DataViewNode)tmpNode).getName()));
                this.diskPathChangeAllowedList.add(Boolean.FALSE);
            }
        } else if (node instanceof DataViewQueryNode) {
            tmpNode = (DataViewQueryNode)node;
            if (((DataViewQueryNode)tmpNode).getQueryFile() != null) {
                fileName = ((DataViewQueryNode)tmpNode).getQueryFile() + ".dvw";
                this.otherFilePaths.add(fileName);
                this.otherFileNames.add(QbUtil.getFileNameForPak(DV_QUERY_PREFIX + ((DataViewQueryNode)tmpNode).getQueryFile() + "_" + ((DataViewQueryNode)tmpNode).getName()));
                this.diskPathChangeAllowedList.add(Boolean.FALSE);
            }
            if (((DataViewQueryNode)tmpNode).getDataViewFile() != null) {
                fileName = ((DataViewQueryNode)tmpNode).getDataViewFile() + ".dvw";
                if (!fileName.toLowerCase().replace('\\', '/').startsWith("queries/")) {
                    fileName = "queries/" + fileName;
                }
                this.otherFilePaths.add(fileName);
                this.otherFileNames.add(QbUtil.getFileNameForPak(DV_DATAVIEW_PREFIX + ((DataViewQueryNode)tmpNode).getDataViewFile() + "_" + ((DataViewQueryNode)tmpNode).getName()));
                this.diskPathChangeAllowedList.add(Boolean.FALSE);
            }
        } else if (node instanceof TextFileNode) {
            tmpNode = (TextFileNode)node;
            this.otherFilePaths.add(((TextFileNode)tmpNode).getFile());
            this.otherFileNames.add(QbUtil.getFileNameForPak(((TextFileNode)tmpNode).getFile()));
            this.diskPathChangeAllowedList.add(Boolean.TRUE);
        } else if (!(node instanceof ClassFileNode)) {
            if (node instanceof XMLFileNode) {
                tmpNode = (XMLFileNode)node;
                this.otherFilePaths.add(((XMLFileNode)tmpNode).getFile());
                this.otherFileNames.add(QbUtil.getFileNameForPak(((XMLFileNode)tmpNode).getFile()));
                this.diskPathChangeAllowedList.add(Boolean.TRUE);
                if (((XMLFileNode)tmpNode).getDTD() != null) {
                    this.otherFilePaths.add(((XMLFileNode)tmpNode).getDTD());
                    this.otherFileNames.add(QbUtil.getFileNameForPak(((XMLFileNode)tmpNode).getDTD()));
                    this.diskPathChangeAllowedList.add(Boolean.TRUE);
                }
            } else if (!(node instanceof XMLQueryNode || node instanceof EJBNode || node instanceof SOAPViewNode || node instanceof SalesForceQueryNode || !(node instanceof ExcelFileNode))) {
                tmpNode = (ExcelFileNode)node;
                this.otherFilePaths.add(((ExcelFileNode)tmpNode).getFilename());
                this.otherFileNames.add(QbUtil.getFileNameForPak(((ExcelFileNode)tmpNode).getFilename()));
                this.diskPathChangeAllowedList.add(Boolean.TRUE);
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            try {
                this.writeNode((DefaultMutableTreeNode)node.getChildAt(i));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static DefaultMutableTreeNode getDataSources(String dataSourceLoc) throws Exception {
        DefaultMutableTreeNode root = null;
        ReadXMLTable readXML = new ReadXMLTable();
        root = readXML.getDataSources(dataSourceLoc);
        if (root == null) {
            root = ReadXMLTable.getDefaultDataSources();
        }
        return root;
    }
}

