/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.pak;

import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.pak.AbstractReferencesUpdater;
import quadbase.common.pak.PakEntry;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.WriteXMLDataSources;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.datasourcemanager.pak.RegistryPacker;

public class RegistryReferencesUpdater
extends AbstractReferencesUpdater {
    public RegistryReferencesUpdater(PakEntry mainPakEntry) {
        this.mainPakEntry = mainPakEntry;
    }

    @Override
    public void updateReferences(PakEntry[] originalPakEntries, PakEntry[] newPakEntries) throws Exception {
        String path = this.mainPakEntry.getFullDiskPath();
        DefaultMutableTreeNode root = RegistryPacker.getDataSources(path);
        this.readNode(root, newPakEntries);
        WriteXMLDataSources.writeDataSources(path, root);
    }

    private void readNode(DefaultMutableTreeNode node, PakEntry[] newPakEntries) throws Exception {
        PakEntry pakEntry;
        DefaultDataSourceNode tmpNode;
        String prefix = "";
        if (node instanceof QueryNode) {
            tmpNode = (QueryNode)node;
            if (((QueryNode)tmpNode).getQueryFile() != null) {
                pakEntry = this.getPakEntryByName(newPakEntries, "query-", ((QueryNode)tmpNode).getQueryFile() + "_" + ((QueryNode)tmpNode).getName());
                if (pakEntry.unpackFile) {
                    ((QueryNode)tmpNode).setQueryFile(this.getFileName(null, pakEntry.getFullDiskPath()));
                } else {
                    tmpNode.removeFromParent();
                }
            }
        } else if (node instanceof DataViewNode) {
            tmpNode = (DataViewNode)node;
            if (((DataViewNode)tmpNode).getQueryFile() != null) {
                pakEntry = this.getPakEntryByName(newPakEntries, "dataview-", ((DataViewNode)tmpNode).getQueryFile() + "_" + ((DataViewNode)tmpNode).getName());
                if (pakEntry.unpackFile) {
                    ((DataViewNode)tmpNode).setQueryFile(this.getFileName(null, pakEntry.getFullDiskPath()));
                } else {
                    tmpNode.removeFromParent();
                }
            }
        } else if (node instanceof DataViewQueryNode) {
            tmpNode = (DataViewQueryNode)node;
            if (((DataViewQueryNode)tmpNode).getQueryFile() != null) {
                pakEntry = this.getPakEntryByName(newPakEntries, "", ((DataViewQueryNode)tmpNode).getQueryFile() + "_" + ((DataViewQueryNode)tmpNode).getName());
                if (pakEntry.unpackFile) {
                    ((DataViewQueryNode)tmpNode).setQueryFile(this.getFileName("queries", pakEntry.getFullDiskPath()));
                } else {
                    tmpNode.removeFromParent();
                }
            }
            if (((DataViewQueryNode)tmpNode).getDataViewFile() != null) {
                pakEntry = this.getPakEntryByName(newPakEntries, "dv_dataview-", ((DataViewQueryNode)tmpNode).getDataViewFile() + "_" + ((DataViewQueryNode)tmpNode).getName());
                if (pakEntry.unpackFile) {
                    ((DataViewQueryNode)tmpNode).setDataViewFile(this.getFileName(null, pakEntry.getFullDiskPath()));
                } else {
                    tmpNode.removeFromParent();
                }
            }
        } else if (node instanceof TextFileNode) {
            tmpNode = (TextFileNode)node;
            pakEntry = this.getPakEntryByName(newPakEntries, prefix, ((TextFileNode)tmpNode).getFile());
            if (pakEntry.unpackFile) {
                ((TextFileNode)tmpNode).setFile(pakEntry.getFullDiskPath());
            } else {
                tmpNode.removeFromParent();
            }
        } else if (!(node instanceof ClassFileNode)) {
            if (node instanceof XMLFileNode) {
                tmpNode = (XMLFileNode)node;
                pakEntry = this.getPakEntryByName(newPakEntries, prefix, ((XMLFileNode)tmpNode).getFile());
                if (pakEntry.unpackFile) {
                    ((XMLFileNode)tmpNode).setFile(pakEntry.getFullDiskPath());
                    if (((XMLFileNode)tmpNode).getDTD() != null) {
                        pakEntry = this.getPakEntryByName(newPakEntries, prefix, ((XMLFileNode)tmpNode).getDTD());
                        ((XMLFileNode)tmpNode).setDTD(pakEntry.getFullDiskPath());
                    }
                } else {
                    tmpNode.removeFromParent();
                }
            } else if (!(node instanceof XMLQueryNode || node instanceof EJBNode || node instanceof SOAPViewNode || node instanceof SalesForceQueryNode || !(node instanceof ExcelFileNode))) {
                tmpNode = (ExcelFileNode)node;
                pakEntry = this.getPakEntryByName(newPakEntries, prefix, ((ExcelFileNode)tmpNode).getFilename());
                if (pakEntry.unpackFile) {
                    ((ExcelFileNode)tmpNode).setFilename(pakEntry.getFullDiskPath());
                } else {
                    tmpNode.removeFromParent();
                }
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.readNode((DefaultMutableTreeNode)node.getChildAt(i), newPakEntries);
        }
    }

    private String getFileName(String prefix, String path) {
        String nameForPak = QbUtil.getFileNameForPak(path);
        String tmp = nameForPak.toLowerCase();
        if (tmp.endsWith(".qry") || tmp.endsWith(".dvw")) {
            nameForPak = nameForPak.substring(0, tmp.length() - 4);
        }
        if (prefix != null) {
            nameForPak = prefix + "/" + nameForPak;
        }
        return nameForPak;
    }

    private PakEntry getPakEntryByName(PakEntry[] newPakEntries, String prefix, String path) throws Exception {
        String nameForPak = QbUtil.getFileNameForPak(path);
        PakEntry pakEntry = this.getPakEntryByName(newPakEntries, prefix + nameForPak);
        return pakEntry;
    }
}

