/*
 * Decompiled with CFR 0.152.
 */
package quadbase.internationalization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class CreateLanguageXMLFile
implements FilenameFilter {
    private static String root = "quadbase";
    private static String[] directory = new String[]{"datasourcemanager" + File.separator + "manager", "querybuilder" + File.separator + "designer", "common", "chart", "reportdesigner", "reportorganizer" + File.separator + "manager", "reportorganizer" + File.separator + "menu", "scheduler", "dashboard" + File.separator + "viewer"};
    private static String[] jspDirectory = new String[]{"..", "../qDesigner", "../qDesigner2", "../MapBuilder", "../Dashboard", "../DashboardBuilder", "../lib/javascript/DataSourceManager", "../DHTMLChartViewer", "../DHTMLViewer", "../MenuPage", "../build/eres", "../build/edab"};
    private static String[] jsfDirectory = new String[]{"../build/web-common/qDesigner2/report", "../build/web-common/resources/easyReportsComponents", "../build/web-common/resources/mapComponents"};
    private static String[] jsDirectory = new String[]{"../build/web-common/lib/javascript/DataSourceManager/js", "../build/web-common/lib/javascript", "../build/web-common/qDesigner2/chart/js", "../build/web-common/MapBuilder/js", "../build/web-common/DashboardBuilder", "../build/web-common/lib/javascript/openFileTree", "../build/web-common/Dashboard"};
    private static String[] product = new String[]{"DATASOURCEMANAGER", "QUERYBUILDER", "ESPRESSMANAGER", "CHARTDESIGNER", "REPORTDESIGNER", "ORGANIZER", "MENUPAGE", "SCHEDULER", "DASHBOARDVIEWER", "ERES", "QUICKDESIGNER", "QUICKDESIGNERCHART", "MAPS", "DASHBOARDVIEWER", "DASHBOARDBUILDER", "DATASOURCEMANAGER", "DHTMLCHARTVIEWER", "DHTMLVIEWER", "MENUPAGE", "ERESROOT", "EDABROOT", "QUICKDESIGNERREPORTS", "QUICKDESIGNERREPORTS", "QUICKDESIGNERREPORTS", "DATASOURCEMANAGER", "QDButton", "QDCHATDIALOG", "MAPBUILDER", "DASHBOARDBUILDER", "OPENFILETREE", "DASHBOARD"};
    private Hashtable languageTable = new Hashtable();
    private Hashtable menuTable;
    private static PrintWriter writer;
    private static final String JAVA_KEY = "LanguageEncoder.getText";
    private static final String LANGUAGE_ENCODER = "LanguageEncoder";
    private static final String GET_TEXT = ".getText";
    private static final String JSP_KEY = ".getEncodeText";
    private static final String JSF_KEY = ".translate";
    private static final String JS_KEY = ".translate";
    private static String key;
    private Vector toFile = new Vector();

    public static void main(String[] args) {
        File dir;
        int i;
        try {
            String fileNamePrefix = "";
            if (args.length == 0) {
                CreateLanguageXMLFile.printHelp();
                System.exit(0);
            }
            if (args.length == 1 && !args[0].equalsIgnoreCase("ER")) {
                if (args[0].equalsIgnoreCase("ERES")) {
                    CreateLanguageXMLFile.directory[6] = "../../eres-web/quadbase/reportorganizer/menu";
                    CreateLanguageXMLFile.directory[8] = "../../eres-web/quadbase/dashboard/viewer";
                    CreateLanguageXMLFile.jspDirectory[0] = "../../../build/web-common";
                    CreateLanguageXMLFile.jspDirectory[1] = "../../../build/web-common/qDesigner";
                    CreateLanguageXMLFile.jspDirectory[2] = "../../../build/web-common/qDesigner2/chart";
                    CreateLanguageXMLFile.jspDirectory[3] = "../../../build/web-common/MapBuilder";
                    CreateLanguageXMLFile.jspDirectory[4] = "../../../build/web-common/Dashboard";
                    CreateLanguageXMLFile.jspDirectory[5] = "../../../build/web-common/DashboardBuilder";
                    CreateLanguageXMLFile.jspDirectory[6] = "../../../build/web-common/lib/javascript/DataSourceManager";
                    CreateLanguageXMLFile.jspDirectory[7] = "../../../build/web-common/DHTMLChartViewer";
                    CreateLanguageXMLFile.jspDirectory[8] = "../../../build/web-common/DHTMLViewer";
                    CreateLanguageXMLFile.jspDirectory[9] = "../../../build/web-common/MenuPage";
                    CreateLanguageXMLFile.jspDirectory[10] = "../../../build/eres";
                    CreateLanguageXMLFile.jspDirectory[11] = "../../../build/edab";
                    CreateLanguageXMLFile.jsfDirectory[0] = "../../../build/web-common/qDesigner2/report";
                    CreateLanguageXMLFile.jsfDirectory[1] = "../../../build/web-common/resources/easyReportsComponents";
                    CreateLanguageXMLFile.jsfDirectory[2] = "../../../build/web-common/resources/mapComponents";
                    CreateLanguageXMLFile.jsDirectory[0] = "../../../build/web-common/lib/javascript/DataSourceManager/js";
                    CreateLanguageXMLFile.jsDirectory[1] = "../../../build/web-common/lib/javascript";
                    CreateLanguageXMLFile.jsDirectory[2] = "../../../build/web-common/qDesigner2/chart/js";
                    CreateLanguageXMLFile.jsDirectory[3] = "../../../build/web-common/MapBuilder/js";
                    CreateLanguageXMLFile.jsDirectory[4] = "../../../build/web-common/DashboardBuilder";
                    CreateLanguageXMLFile.jsDirectory[5] = "../../../build/web-common/javascript/openFileTree";
                    CreateLanguageXMLFile.jsDirectory[6] = "../../../build/web-common/Dashboard";
                    fileNamePrefix = "ERES_";
                } else {
                    CreateLanguageXMLFile.printHelp();
                    System.exit(0);
                }
            }
            String xmlFileName = fileNamePrefix + "Language.xml";
            writer = new PrintWriter(new File(xmlFileName));
        }
        catch (Exception e) {
            System.out.println("Error" + e);
        }
        key = JAVA_KEY;
        for (i = 0; i < directory.length; ++i) {
            writer.println("<Product name=\"" + product[i] + "\" dir=\"" + root + File.separator + directory[i] + "\">");
            dir = new File(root + File.separator + directory[i]);
            new CreateLanguageXMLFile().buildLanguageFile(dir, true);
            writer.println("</Product>");
        }
        writer.flush();
        key = JSP_KEY;
        for (i = 0; i < jspDirectory.length; ++i) {
            writer.println("<Product name=\"" + product[i + directory.length] + "\" dir=\"" + root + File.separator + jspDirectory[i] + "\">");
            dir = new File(root + File.separator + jspDirectory[i]);
            new CreateLanguageXMLFile().buildLanguageFile(dir, false);
            writer.println("</Product>");
        }
        writer.flush();
        key = ".translate";
        for (i = 0; i < jsfDirectory.length; ++i) {
            writer.println("<Product name=\"" + product[i + directory.length + jspDirectory.length] + "\" dir=\"" + root + File.separator + jsfDirectory[i] + "\">");
            dir = new File(root + File.separator + jsfDirectory[i]);
            new CreateLanguageXMLFile().buildLanguageFile(dir, false);
            writer.println("</Product>");
        }
        writer.flush();
        key = ".translate";
        for (i = 0; i < jsDirectory.length; ++i) {
            writer.println("<Product name=\"" + product[i + directory.length + jspDirectory.length + jsfDirectory.length] + "\" dir=\"" + root + File.separator + jsDirectory[i] + "\">");
            dir = new File(root + File.separator + jsDirectory[i]);
            new CreateLanguageXMLFile().buildLanguageFile(dir, false);
            writer.println("</Product>");
        }
        writer.flush();
        writer.close();
    }

    private String removeEntities(String s) {
        if (s.contains("&#47;")) {
            s = s.replace("&#47;", "/");
        }
        return s;
    }

    private boolean displayError(String name) {
        return !name.equalsIgnoreCase("OrganizerLogin.java") && !name.equalsIgnoreCase("ERESManagerLogin.java") && !name.equalsIgnoreCase("MenuRunArchive.java") && !name.equalsIgnoreCase("MenuRunArchiveCHT.java") && !name.equalsIgnoreCase("MenuRunChart.java") && !name.equalsIgnoreCase("MenuRunReport.java") && !name.equalsIgnoreCase("MenuRunSchedule.java") && !name.equalsIgnoreCase("MenuScheduleParam.java") && !name.equalsIgnoreCase("MenuMainPage.java");
    }

    private void buildLanguageFile(File file, boolean resc) {
        int quotes = 34;
        if (file.getName().endsWith(".xhtml") || file.getName().endsWith(".js")) {
            quotes = 39;
        }
        if (file.isDirectory()) {
            File[] children;
            for (File element : children = file.listFiles(this)) {
                if (!resc && element.isDirectory()) continue;
                this.buildLanguageFile(element, resc);
            }
        } else {
            try {
                if (file.getName().equals("OrganizerLogin.java") || file.getName().equals("ERESManagerLogin.java")) {
                    return;
                }
                this.menuTable = null;
                Integer count = 0;
                Integer countAll = 0;
                Integer lineNumber = -1;
                this.toFile.addElement(" <File name=\"" + file.getName() + "\">");
                if (file.getName().toUpperCase().endsWith("MENUBAR.JAVA") || file.getName().toUpperCase().endsWith("TOOLBAR.JAVA") || file.getName().toUpperCase().startsWith("POPUPMENUFOR")) {
                    this.menuTable = new Hashtable();
                }
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                Integer n = lineNumber;
                Integer n2 = lineNumber = Integer.valueOf(lineNumber + 1);
                while (line != null) {
                    String kkey;
                    Integer n3;
                    Integer n4;
                    int index = line.indexOf(key);
                    if (index == -1 && line.endsWith(LANGUAGE_ENCODER)) {
                        line = reader.readLine();
                        n4 = lineNumber;
                        n3 = lineNumber = Integer.valueOf(lineNumber + 1);
                        index = line.indexOf(GET_TEXT);
                        kkey = GET_TEXT;
                    } else {
                        kkey = JAVA_KEY;
                    }
                    while (index > 0) {
                        Integer n5;
                        Integer n6;
                        Object text;
                        Integer n7;
                        int start = line.indexOf(quotes, index + 1);
                        if (start < 0) {
                            if (this.displayError(file.getName())) {
                                System.out.println("Error: (" + file.getName() + ":" + lineNumber + ") ; - a string value is not found after " + kkey);
                            }
                            index = line.indexOf(kkey, index + 1);
                            continue;
                        }
                        int end = line.indexOf(quotes, start + 1);
                        while (line.charAt(end - 1) == '\\') {
                            StringBuffer buffer = new StringBuffer(line);
                            buffer.deleteCharAt(end - 1);
                            line = buffer.toString();
                            n7 = lineNumber;
                            Integer n8 = lineNumber = Integer.valueOf(lineNumber + 1);
                            end = line.indexOf(quotes, end);
                        }
                        int e = line.indexOf(41, end + 1);
                        if (e > 0) {
                            text = line.substring(start + 1, end);
                            int pluss = line.indexOf(43, end + 1);
                            while (pluss > 0 && pluss < e) {
                                start = line.indexOf(quotes, pluss + 1);
                                if (start == -1) {
                                    System.out.println("Error: (" + file.getName() + ":" + lineNumber + ") - White space in translation, line =" + line);
                                    break;
                                }
                                end = line.indexOf(quotes, start + 1);
                                while (line.charAt(end - 1) == '\\') {
                                    StringBuffer buffer = new StringBuffer(line);
                                    buffer.deleteCharAt(end - 1);
                                    line = buffer.toString();
                                    n6 = lineNumber;
                                    Integer n9 = lineNumber = Integer.valueOf(lineNumber + 1);
                                    end = line.indexOf(quotes, end);
                                }
                                text = (String)text + line.substring(start + 1, end);
                                pluss = line.indexOf(43, end + 1);
                            }
                            if (this.checkWhiteSpaceCharacters((String)text)) {
                                System.out.println("Error: (" + file.getName() + ":" + lineNumber + ") - White space in translation, line =" + line);
                            }
                            text = ((String)text).toUpperCase();
                            if (this.menuTable != null) {
                                if (!this.menuTable.containsKey(text)) {
                                    this.menuTable.put(text, text);
                                    this.toFile.addElement("  <CODE>" + this.removeEntities((String)text) + "</CODE>");
                                    this.toFile.addElement("  <TEXT>" + this.removeEntities((String)text) + "</TEXT>");
                                    n5 = count;
                                    n6 = count = Integer.valueOf(count + 1);
                                }
                            } else if (!this.languageTable.containsKey(text)) {
                                this.languageTable.put(text, text);
                                this.toFile.addElement("  <CODE>" + this.removeEntities((String)text) + "</CODE>");
                                this.toFile.addElement("  <TEXT>" + this.removeEntities((String)text) + "</TEXT>");
                                n5 = count;
                                n6 = count = Integer.valueOf(count + 1);
                            }
                            n5 = countAll;
                            n6 = countAll = Integer.valueOf(countAll + 1);
                        } else {
                            try {
                                text = new Vector<String>();
                                ((Vector)text).addElement(line.substring(start + 1, end).toUpperCase());
                                while (e < 0) {
                                    line = line + reader.readLine();
                                    start = line.indexOf(quotes, end + 1);
                                    end = line.indexOf(quotes, start + 1);
                                    while (line.charAt(end - 1) == '\\') {
                                        StringBuffer buffer = new StringBuffer(line);
                                        buffer.deleteCharAt(end - 1);
                                        line = buffer.toString();
                                        n5 = lineNumber;
                                        n6 = lineNumber = Integer.valueOf(lineNumber + 1);
                                        end = line.indexOf(quotes, end);
                                    }
                                    ((Vector)text).addElement(line.substring(start + 1, end).toUpperCase());
                                    e = line.indexOf(41, end + 1);
                                }
                                if (this.menuTable != null) {
                                    if (!this.menuTable.containsKey(text)) {
                                        this.menuTable.put(text, text);
                                        for (int i = 0; i < ((Vector)text).size(); ++i) {
                                            if (this.checkWhiteSpaceCharacters((String)((Vector)text).elementAt(i))) {
                                                System.out.println("Error: (" + file.getName() + ":" + lineNumber + ") - White space in translation, line =" + line);
                                            }
                                            this.toFile.addElement("  <CODE>" + this.removeEntities((String)((Vector)text).elementAt(i)) + "</CODE>");
                                            this.toFile.addElement("  <TEXT>" + this.removeEntities((String)((Vector)text).elementAt(i)) + "</TEXT>");
                                        }
                                    }
                                } else if (!this.languageTable.containsKey(text)) {
                                    this.languageTable.put(text, text);
                                    for (int i = 0; i < ((Vector)text).size(); ++i) {
                                        if (this.checkWhiteSpaceCharacters((String)((Vector)text).elementAt(i))) {
                                            System.out.println("Error: (" + file.getName() + ":" + lineNumber + ") - White space in translation, line =" + line);
                                        }
                                        this.toFile.addElement("  <CODE>" + this.removeEntities((String)((Vector)text).elementAt(i)) + "</CODE>");
                                        this.toFile.addElement("  <TEXT>" + (String)((Vector)text).elementAt(i) + "</TEXT>");
                                    }
                                }
                            }
                            catch (Exception ex) {
                                System.out.println("Error: (" + file.getName() + ":" + lineNumber + ") - failed to read multiline translation:" + e);
                            }
                        }
                        index = line.indexOf(kkey, end + 1);
                        if (index == -1) {
                            if (line.indexOf(LANGUAGE_ENCODER, end + 1) > -1 && line.endsWith(LANGUAGE_ENCODER)) {
                                kkey = GET_TEXT;
                                line = reader.readLine();
                                n7 = lineNumber;
                                Integer n10 = lineNumber = Integer.valueOf(lineNumber + 1);
                                index = line.indexOf(kkey);
                                continue;
                            }
                            kkey = JAVA_KEY;
                            continue;
                        }
                        if (!kkey.equals(GET_TEXT) || line.indexOf(JAVA_KEY, end + 1) <= -1) continue;
                        kkey = JAVA_KEY;
                        index = line.indexOf(JAVA_KEY, end + 1);
                    }
                    line = reader.readLine();
                    n4 = lineNumber;
                    n3 = lineNumber = Integer.valueOf(lineNumber + 1);
                }
                System.out.println(file.getName() + " Count added: " + count + " Count all: " + countAll);
                reader.close();
                this.toFile.addElement(" </File>");
                this.flashToFile();
            }
            catch (Exception e) {
                System.out.println("Error: " + file.getName() + " - " + e);
            }
        }
    }

    private void flashToFile() {
        if (this.toFile.size() > 2) {
            for (int i = 0; i < this.toFile.size(); ++i) {
                writer.println((String)this.toFile.elementAt(i));
            }
        }
        this.toFile.removeAllElements();
        this.toFile = new Vector();
    }

    @Override
    public boolean accept(File dir, String name) {
        if (key.equals(JAVA_KEY) && name.endsWith(".java")) {
            return true;
        }
        if (key.equals(JSP_KEY) && name.endsWith(".jsp")) {
            return true;
        }
        if (key.equals(".translate") && name.endsWith(".xhtml")) {
            return true;
        }
        if (key.equals(".translate") && name.endsWith(".js")) {
            return true;
        }
        return !key.equals(JSP_KEY) && new File(dir, name).isDirectory();
    }

    public static void printHelp() {
        System.out.println("This program is used to generate the XML file");
        System.out.println("for language encoding.");
        System.out.println("-- If you want to generate the file for ER or EC");
        System.out.println("    Please add argument \"ER\"");
        System.out.println("-- If you want to generate the file for ERES");
        System.out.println("    Please add arguemtn \"ERES\"");
        System.out.println("Calling without argument is regarded as \"ER\"");
    }

    private boolean checkWhiteSpaceCharacters(String string) {
        String beginingRegExp = "(^\\s+)(.*)(\\s*)";
        String endRegExp = ".*\\s$";
        return string.matches(beginingRegExp) || string.matches(endRegExp);
    }

    static {
        key = JAVA_KEY;
    }
}

