/*
 * Decompiled with CFR 0.152.
 */
package quadbase.internationalization;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.internationalization.JavaFile;
import quadbase.internationalization.Product;

public class TranslateWizard
extends JFrame
implements ActionListener,
TreeSelectionListener {
    private static final String[] TABLE_HEADERS = new String[]{"Original Text", "Translation"};
    private String filename = "Language.xml";
    private String enc = "Cp1252";
    private Hashtable translationTable;
    private Vector products;
    private boolean changeDetected = false;
    private JTree tree;
    private JButton saveButton;
    private JButton closeButton;
    private TranslationTable table;

    public static void main(String[] args) {
        try {
            QbUtil.setWindowsLAF();
            ServerMessage.useServer = false;
            String filename = null;
            String enc = null;
            for (String arg : args) {
                if (arg.startsWith("-file:")) {
                    filename = arg.substring(6);
                    continue;
                }
                if (arg.startsWith("-enc:")) {
                    enc = arg.substring(5);
                    continue;
                }
                if (!arg.startsWith("-serverOn:")) continue;
                ServerMessage.useServer = arg.substring(8).equalsIgnoreCase("true");
            }
            TranslateWizard wizard = new TranslateWizard(filename, enc);
            wizard.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TranslateWizard(String filename, String enc) {
        if (filename != null) {
            this.filename = filename;
        }
        if (enc != null) {
            this.enc = enc;
        }
        this.translationTable = new Hashtable();
        this.products = new Vector();
        try {
            LanguageEncoder.load(this.filename, this.enc, this.products, this.translationTable);
        }
        catch (Exception e) {
            System.err.println("Failed to load " + this.filename);
            e.printStackTrace();
            System.exit(1);
        }
        this.init();
    }

    private void init() {
        this.setTitle("Translate Wizard");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TranslateWizard.this.close();
            }
        });
        this.tree = this.createTree();
        JScrollPane treePane = new JScrollPane(this.tree);
        this.table = new TranslationTable();
        JScrollPane tablePane = new JScrollPane(this.table);
        JSplitPane mainPanel = new JSplitPane(1, treePane, tablePane);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add("Center", mainPanel);
        JPanel buttonPanel = new JPanel();
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(this);
        buttonPanel.add(this.saveButton);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        this.getContentPane().add("South", buttonPanel);
        Dimension screenSize = this.getToolkit().getScreenSize();
        int winHeight = (int)((double)screenSize.width * 0.7);
        int winWidth = (int)((double)screenSize.height * 0.7);
        this.setSize(winHeight, winWidth);
        treePane.setPreferredSize(new Dimension((int)((double)winWidth * 0.3), 0));
        tablePane.setPreferredSize(new Dimension((int)((double)winWidth * 0.7), winHeight));
        this.setLocationRelativeTo(this.getParent());
    }

    private JTree createTree() {
        Collections.sort(this.products);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (Product product : this.products) {
            if (product.files == null) continue;
            DefaultMutableTreeNode productNode = new DefaultMutableTreeNode(product);
            root.add(productNode);
            Collections.sort(product.files);
            for (JavaFile javaFile : product.files) {
                productNode.add(new DefaultMutableTreeNode(javaFile));
            }
        }
        JTree result = new JTree(root);
        result.setRootVisible(false);
        result.getSelectionModel().setSelectionMode(1);
        result.addTreeSelectionListener(this);
        return result;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object o = ((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).getUserObject();
        if (o instanceof JavaFile) {
            this.saveCurrentData();
            Object[][] data = this.getData((JavaFile)o);
            this.table.setData(data);
        } else if (o instanceof Product) {
            this.saveCurrentData();
            Object[][] data = this.getData((Product)o);
            this.table.setData(data);
        }
    }

    private void saveCurrentData() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Object key = this.table.getValueAt(i, 0);
            String newValue = (String)this.table.getValueAt(i, 1);
            String oldValue = (String)this.translationTable.get(key);
            if (oldValue != null && (newValue == null || newValue.length() == 0)) {
                this.translationTable.remove(key);
                this.changeDetected = true;
                continue;
            }
            if (oldValue == null && newValue != null && newValue.length() > 0) {
                this.translationTable.put(key, newValue);
                this.changeDetected = true;
                continue;
            }
            if (oldValue == null || oldValue.equals(newValue)) continue;
            this.translationTable.put(key, newValue);
            this.changeDetected = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveButton) {
            this.save();
        } else if (e.getSource() == this.closeButton) {
            this.close();
        }
    }

    private String[][] getData(JavaFile javaFile) {
        TreeSet set = new TreeSet(javaFile.getTexts());
        return this.getTranslationsForSet(set);
    }

    private String[][] getData(Product product) {
        TreeSet set = new TreeSet();
        Vector javaFiles = product.getFiles();
        for (JavaFile javaFile : javaFiles) {
            set.addAll(javaFile.getTexts());
        }
        return this.getTranslationsForSet(set);
    }

    private String[][] getTranslationsForSet(Set set) {
        String[][] data = new String[set.size()][2];
        int i = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            data[i][0] = (String)it.next();
            data[i][1] = (String)this.translationTable.get(data[i][0]);
            ++i;
        }
        return data;
    }

    private void close() {
        this.saveCurrentData();
        if (this.changeDetected) {
            JMessageDialog dialog = new JMessageDialog((Frame)this, "Save", "Would you like to save your changes?", 1);
            int response = dialog.getResponse();
            if (response == 4) {
                this.save();
            } else if (response != 5) {
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        this.saveCurrentData();
        try {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream(2048);
            PrintWriter writer = !ServerMessage.useServer ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), this.enc)) : new PrintWriter(new OutputStreamWriter((OutputStream)outstream, this.enc));
            for (int i = 0; i < this.products.size(); ++i) {
                Product product = (Product)this.products.elementAt(i);
                writer.println("<Product name=\"" + product.getName() + "\" dir=\"" + product.getDir() + "\">");
                if (product.getFiles() == null) continue;
                for (int j = 0; j < product.getFiles().size(); ++j) {
                    JavaFile file = (JavaFile)product.getFiles().elementAt(j);
                    writer.println(" <File name=\"" + file.getName() + "\">");
                    for (int k = 0; k < file.getTexts().size(); ++k) {
                        String original = (String)file.getTexts().elementAt(k);
                        String translation = (String)this.translationTable.get(original);
                        if (translation == null || translation.equals("")) {
                            translation = original;
                        }
                        writer.println("  <CODE>" + original + "</CODE>");
                        writer.println("  <TEXT>" + translation + "</TEXT>");
                    }
                    writer.println(" </File>");
                }
                writer.println("</Product>");
            }
            writer.flush();
            writer.close();
            if (ServerMessage.useServer) {
                WriteDataFile wdf = new WriteDataFile();
                wdf.output(outstream.toByteArray(), this.filename);
            }
            this.changeDetected = false;
            new JMessageDialog((Frame)this, "Info", "Save successful.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), "Error occured.\n" + ex.getLocalizedMessage());
        }
    }

    private class TranslationTable
    extends JTable {
        public TranslationTable() {
            super(new Object[0][0], TABLE_HEADERS);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            int colIndex = this.columnAtPoint(p);
            return (String)this.getValueAt(rowIndex, colIndex);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        public void setData(Object[][] data) {
            this.setModel(new DefaultTableModel(data, TABLE_HEADERS));
        }
    }
}

