/*
 * Decompiled with CFR 0.152.
 */
package quadbase.internationalization;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.internationalization.JavaFile;
import quadbase.internationalization.Product;

public class UpgradeLanguageXMLFile {
    static String oldFileName;
    static String newFileName;
    static String enc;
    static Vector products;
    static Hashtable translationTable;

    public static void main(String[] args) {
        ServerMessage.useServer = false;
        if (args.length >= 3) {
            for (String arg : args) {
                if (arg.startsWith("-from:")) {
                    oldFileName = arg.substring(6);
                    continue;
                }
                if (arg.startsWith("-to:")) {
                    newFileName = arg.substring(4);
                    continue;
                }
                if (arg.startsWith("-enc:")) {
                    enc = arg.substring(5);
                    continue;
                }
                if (!arg.startsWith("-serverOn:")) continue;
                ServerMessage.useServer = arg.substring(8).equalsIgnoreCase("true");
            }
            try {
                LanguageEncoder.load(oldFileName, enc, new Vector<Product>(), translationTable);
            }
            catch (Exception e) {
                System.err.println("Failed to load " + oldFileName);
                e.printStackTrace();
                System.exit(1);
            }
            try {
                LanguageEncoder.load(newFileName, enc, products, new Hashtable<String, String>());
            }
            catch (Exception e) {
                System.err.println("Failed to load " + newFileName);
                e.printStackTrace();
                System.exit(1);
            }
            UpgradeLanguageXMLFile.save();
        } else {
            System.out.println("Usage: MigrateLanguageXMLFile -from:<filename> -to:<filename> -enc:<encoding>");
        }
    }

    public static void save() {
        try {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream(2048);
            PrintWriter writer = !ServerMessage.useServer ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFileName), enc)) : new PrintWriter(new OutputStreamWriter((OutputStream)outstream, enc));
            for (int i = 0; i < products.size(); ++i) {
                Product product = (Product)products.elementAt(i);
                writer.println("<Product name=\"" + product.getName() + "\" dir=\"" + product.getDir() + "\">");
                if (product.getFiles() == null) continue;
                for (int j = 0; j < product.getFiles().size(); ++j) {
                    JavaFile file = (JavaFile)product.getFiles().elementAt(j);
                    writer.println(" <File name=\"" + file.getName() + "\">");
                    if (file.getTexts() != null) {
                        for (int k = 0; k < file.getTexts().size(); ++k) {
                            String original = (String)file.getTexts().elementAt(k);
                            String translation = (String)translationTable.get(original);
                            if (translation == null || translation.equals("")) {
                                translation = original;
                            }
                            writer.println("  <CODE>" + original + "</CODE>");
                            writer.println("  <TEXT>" + translation + "</TEXT>");
                        }
                    } else {
                        writer.println("  <CODE>Translation Error: bad translation source</CODE>");
                        writer.println("  <TEXT>Please contact Quadbase techsupport</TEXT>");
                    }
                    writer.println(" </File>");
                }
                writer.println("</Product>");
            }
            writer.flush();
            writer.close();
            if (ServerMessage.useServer) {
                WriteDataFile wdf = new WriteDataFile();
                wdf.output(outstream.toByteArray(), newFileName);
            }
            System.out.println("done! The resulting file is " + newFileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        products = new Vector();
        translationTable = new Hashtable();
    }
}

