/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapTitle {
    public static final short ALIGNMENT_LEFT = 0;
    public static final short ALIGNMENT_RIGHT = 1;
    public static final short ALIGNMENT_CENTER = 2;
    public static final short POSITION_TOP = 0;
    public static final short POSITION_BOTTOM = 1;
    protected short alignment = 0;
    protected short position = 0;
    protected String color = "rgb(0,0,0)";
    protected String font = "Arial";
    protected int fontStyle = 0;
    protected int fontSize = 25;
    protected String text = "";

    public MapTitle(String text, String font, int fontStyle, int fontSize, short alignment, short position, String color) {
        this.text = text;
        this.font = font;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize;
        this.alignment = alignment;
        this.position = position;
        this.color = color;
    }

    public MapTitle(MapTitle mapTitle) {
        this.text = mapTitle.text;
        this.font = mapTitle.font;
        this.fontStyle = mapTitle.fontStyle;
        this.fontSize = mapTitle.fontSize;
        this.alignment = mapTitle.alignment;
        this.position = mapTitle.position;
        this.color = mapTitle.color;
    }

    public static MapTitle readXML(Element element) throws Exception {
        NodeList list = element.getElementsByTagName("mapTitle");
        if (list == null || list.getLength() == 0) {
            return null;
        }
        Element e = (Element)list.item(0);
        short alignment = Short.parseShort(e.getAttribute("alignment"));
        short position = Short.parseShort(e.getAttribute("position"));
        String color = e.getAttribute("color");
        String font = e.getAttribute("font");
        int fontStyle = Integer.parseInt(e.getAttribute("fontStyle"));
        int fontSize = Integer.parseInt(e.getAttribute("fontSize"));
        String text = "";
        Node n = e.getFirstChild();
        if (n instanceof CDATASection) {
            text = ((CDATASection)n).getData();
        }
        return new MapTitle(text, font, fontStyle, fontSize, alignment, position, color);
    }

    public void writeXML(Element element) {
        Document doc = element.getOwnerDocument();
        Element e = doc.createElement("mapTitle");
        element.appendChild(e);
        e.setAttribute("alignment", this.alignment + "");
        e.setAttribute("position", this.position + "");
        e.setAttribute("color", this.color);
        e.setAttribute("font", this.font);
        e.setAttribute("fontStyle", this.fontStyle + "");
        e.setAttribute("fontSize", this.fontSize + "");
        e.appendChild(doc.createCDATASection(this.text));
    }

    public short getPosition() {
        return this.position;
    }

    public short getAlignment() {
        return this.alignment;
    }

    public String getColor() {
        return this.color;
    }

    public String getFont() {
        return this.font;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getText() {
        return this.text;
    }
}

