/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps;

import quadbase.common.client.ServerMessage;
import quadbase.common.util.IAlertable;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasource.DataSource;
import quadbase.maps.googlemaps.GoogleMap;
import quadbase.maps.svgmaps.SvgMap;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public abstract class QbMap
implements IAlertable {
    public static final String TYPE_GOOGLE = "google";
    public static final String TYPE_BITMAP = "bitmap";
    public static final String EVALUATION_MESSAGE = "Evaluation copy by Quadbase Systems Inc. Please contact sales@quadbase.com for purchasing information.";

    public static QbMap readMap(String filename) throws Exception {
        return QbMap.readMap(filename, true);
    }

    public static QbMap readMap(String filename, boolean useBackupData) throws Exception {
        String mapType = QbMap.getMapType(filename);
        if (mapType.equals(TYPE_GOOGLE)) {
            return new GoogleMap(filename, useBackupData);
        }
        if (mapType.equals(TYPE_BITMAP)) {
            return new SvgMap(filename, useBackupData);
        }
        throw new Exception("Unknown map type: " + mapType);
    }

    public static String getMapType(String filename) throws Exception {
        if (filename == null) {
            throw new NullPointerException("Filename cannot be null");
        }
        if ((filename = filename.toLowerCase()).endsWith(".sxml") || filename.endsWith(".spak")) {
            return TYPE_BITMAP;
        }
        if (filename.endsWith(".gxml") || filename.endsWith(".gpak")) {
            return TYPE_GOOGLE;
        }
        throw new Exception("Unknown map type: " + filename);
    }

    public static boolean hasMapExtension(String filename) {
        return (filename = filename.toLowerCase()).endsWith(".sxml") || filename.endsWith(".spak") || filename.endsWith(".gxml") || filename.endsWith(".gpak");
    }

    protected String setPakExtension(String fileName, String fileType) {
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return fileName;
        }
        String tmp = fileName.substring(0, idx);
        if (fileType.equalsIgnoreCase("report")) {
            return tmp + ".pak";
        }
        if (fileType.equalsIgnoreCase("map")) {
            if (fileName.toLowerCase().endsWith(".sxml")) {
                return tmp + ".spak";
            }
            if (fileName.toLowerCase().endsWith(".gxml")) {
                return tmp + ".gpak";
            }
        } else if (fileType.equalsIgnoreCase("chart") && !fileName.endsWith(".qch")) {
            return tmp + ".pac";
        }
        return fileName;
    }

    protected String createRelativePath(String absolutePath) {
        String relPath = QbUtil.createRelativePath(absolutePath, ServerMessage.getWorkingDirectory());
        if (relPath != null) {
            return relPath;
        }
        return absolutePath;
    }

    public abstract void refresh() throws Exception;

    public abstract DataSource getDataSource();

    public abstract void setDataSource(DataSource var1) throws Exception;

    public abstract void setDataSource(DataSource var1, boolean var2) throws Exception;

    public abstract DataSheet getDataSheet();

    public abstract int getMapWidth();

    public abstract int getMapHeight();

    public abstract void setMapDimensions(int var1, int var2);

    public abstract String getDefaultExtension();

    public abstract void save(String var1) throws Exception;
}

