/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.googlemaps;

import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.ChartAPI.QbChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.pak.PakFileReader;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterGrabber;
import quadbase.common.param.Parameters;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.datasource.DataSource;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.maps.MapTitle;
import quadbase.maps.QbMap;
import quadbase.maps.googlemaps.GoogleMapTitle;
import quadbase.maps.googlemaps.MapCoordinates;
import quadbase.maps.googlemaps.MapPoint;
import quadbase.maps.googlemaps.heatmaps.Heatmap;
import quadbase.maps.googlemaps.heatmaps.ThresholdHeatmap;
import quadbase.maps.googlemaps.heatmaps.TransitionHeatmap;
import quadbase.reportdesigner.ReportAPI.DataSheet;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.report.ColData;
import quadbase.util.IInputData;
import quadbase.util.IQueryInParam;
import quadbase.util.IZoomInfo;

public class GoogleMap
extends QbMap {
    public static final String EXTENSION = ".gxml";
    public static final String PAK_EXTENSION = ".gpak";
    public static final String MAP_CONTROL_LARGE = "large";
    public static final String MAP_CONTROL_SMALL = "small";
    public static final String MAP_CONTROL_ZOOM = "zoom";
    public static final String MAP_CONTROL_NONE = "none";
    public static final String MAP_TYPE_OSM = "osm";
    public static final String MAP_TYPE_GOOGLE_STREET = "googlestreet";
    public static final String MAP_TYPE_GOOGLE_SATELLITE = "googlesat";
    public static final String MAP_VIEW_NORMAL = "normal";
    public static final String MAP_VIEW_SATELLITE = "satellite";
    public static final String MAP_VIEW_HYBRID = "hybrid";
    public static final String FILE_TYPE_QDR = "easyReport";
    private Heatmap heatmap;
    private String pakFileName = null;
    private String mapVendorType = "osm";
    private String drilldownType = "report";
    private String drilldownUrl;
    protected HashMap drilldownParamMap = new HashMap();
    protected HashMap drilldownFixedValues = new HashMap();
    protected String tooltipType = "report";
    protected String tooltipUrl;
    protected String tooltipTemplateName;
    protected int tooltipOrgNodeID;
    protected int tooltipOrgItemID;
    public int tooltipWidth = 300;
    private int tooltipHeight = 200;
    protected HashMap tooltipColumnMap = new HashMap();
    private int mapWidth = 800;
    private int mapHeight = 600;
    private int minimalZoom = 1;
    private int maximalZoom = 17;
    private String mapControlType = "large";
    private boolean hasMapTypeControl = true;
    private boolean hasMapScaleControl = true;
    private String defaultMapView = "normal";
    private String coordinatesFilePath;
    protected DataSheet dataSheet;
    private DataSource mapDataSource;
    private MapCoordinates coordinates;
    private GoogleMapTitle title;
    private boolean isAdmin;

    public GoogleMap(String filename) throws Exception {
        this(filename, null);
    }

    public GoogleMap(String filename, boolean useBackupData) throws Exception {
        this(filename, null, useBackupData);
    }

    public GoogleMap(String filename, HashMap parameters) throws Exception {
        this(filename, parameters, false);
    }

    public GoogleMap(String filename, HashMap parameters, boolean useBackupData) throws Exception {
        this.readFromFile(filename);
        if (this.mapDataSource.isParameterized()) {
            ((ParameterizedDataSource)this.mapDataSource).setDefaultParameters();
            ((ParameterizedDataSource)this.mapDataSource).setParameters(parameters);
        }
        if (!useBackupData) {
            this.refresh();
        }
    }

    public GoogleMap(InputStream in) throws Exception {
        this(in, null, false);
    }

    public Heatmap getHeatmap() {
        return this.heatmap;
    }

    public void setHeatmap(Heatmap heatmap) {
        this.heatmap = heatmap;
    }

    public GoogleMap(InputStream in, boolean useBackupData) throws Exception {
        this(in, null, useBackupData);
    }

    public GoogleMap(InputStream in, HashMap parameters) throws Exception {
        this(in, parameters, false);
    }

    public GoogleMap(InputStream in, HashMap parameters, boolean useBackupData) throws Exception {
        this.readFromInputStream(in);
        if (this.mapDataSource.isParameterized()) {
            ((ParameterizedDataSource)this.mapDataSource).setDefaultParameters();
            ((ParameterizedDataSource)this.mapDataSource).setParameters(parameters);
        }
        if (!useBackupData) {
            this.refresh();
        }
    }

    public GoogleMap(DataSource dataSource, String coordinatesFilePath) throws Exception {
        this.mapDataSource = dataSource;
        this.coordinatesFilePath = coordinatesFilePath;
        this.coordinates = new MapCoordinates(coordinatesFilePath, false, this);
        this.coordinates.setAdmin(this.isAdmin);
        this.checkPoints();
        this.dataSheet = this.mapDataSource.getDataSheet(0, -1, this.isAdmin);
    }

    @Override
    public String getDefaultExtension() {
        return EXTENSION;
    }

    @Override
    public void refresh() throws Exception {
        this.dataSheet = this.mapDataSource.getDataSheet(0, -1, this.isAdmin);
        this.checkTooltipIndexes();
        this.refreshCoordinates();
    }

    public void refreshCoordinates() throws Exception {
        this.coordinates = new MapCoordinates(this.coordinatesFilePath, false, this);
        this.checkPoints();
        this.sortData();
    }

    public Vector getMapPoints() {
        return this.coordinates.getMapPoints();
    }

    public String[] getCoordinatesField() {
        String[] rtrn = this.coordinates.getFieldNames();
        return rtrn;
    }

    public MapCoordinates.DatasourceType getWktMode() {
        return this.coordinates.getDatasourceType();
    }

    public MapPoint getMapPoint(int index) {
        return this.coordinates.getMapPoint(index);
    }

    private void checkTooltipIndexes() throws Exception {
        if (this.dataSheet == null) {
            return;
        }
        Iterator it = this.tooltipColumnMap.keySet().iterator();
        while (it.hasNext()) {
            int i = (Integer)it.next();
            if (i >= 0 && i < this.dataSheet.getColumnCount()) continue;
            throw new Exception("Tooltip mapping: column index out of range " + i);
        }
    }

    public void sortData() throws Exception {
        if (this.dataSheet == null) {
            return;
        }
        for (int i = 0; i < this.dataSheet.getRowCount(); ++i) {
            Object[] row = this.dataSheet.getRow(i);
            HashMap mapping = this.getTooltipMapping(row);
            for (MapPoint point : this.getMapPoints()) {
                if (!point.matches(mapping)) continue;
                point.addRowIndex(i);
            }
        }
        Iterator it = this.getMapPoints().iterator();
        while (it.hasNext()) {
            MapPoint point = (MapPoint)it.next();
            if (point.hasAssociatedRow()) continue;
            it.remove();
        }
    }

    public boolean hasMatchingPoint() {
        if (this.dataSheet == null) {
            return false;
        }
        for (int i = 0; i < this.dataSheet.getRowCount(); ++i) {
            Object[] row = this.dataSheet.getRow(i);
            HashMap mapping = this.getTooltipMapping(row);
            for (MapPoint point : this.getMapPoints()) {
                if (!point.matches(mapping)) continue;
                return true;
            }
        }
        return false;
    }

    private HashMap getTooltipMapping(Object[] row) {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.tooltipColumnMap.entrySet()) {
            if ((Integer)entry.getKey() >= row.length) continue;
            Object object = row[(Integer)entry.getKey()];
            String string = object != null ? object.toString() : null;
            result.put(entry.getValue(), string);
        }
        return result;
    }

    private void checkPoints() throws Exception {
        Set<String> pointDataNames0 = this.getMapPoint((int)0).dataMap.keySet();
        for (MapPoint point : this.getMapPoints()) {
            Set<String> pointDataNames = point.dataMap.keySet();
            if (pointDataNames.equals(pointDataNames0)) continue;
            throw new Exception("All map points must contain the same set of IDs");
        }
        if (!pointDataNames0.containsAll(this.drilldownParamMap.values())) {
            throw new Exception("A drilldown parameter mapto not found in the point IDs");
        }
        if (!pointDataNames0.containsAll(this.tooltipColumnMap.values())) {
            throw new Exception("A tooltip parameter mapto not found in the point IDs");
        }
    }

    private void readFromFile(String filePath) throws Exception {
        InputStream in = new ReadDataFile().getInputStream(filePath);
        if (filePath.toLowerCase().endsWith(PAK_EXTENSION)) {
            in = PakFileReader.getMainInputStream(in);
            this.pakFileName = filePath;
        }
        this.readFromInputStream(in);
    }

    private void readFromInputStream(InputStream in) throws Exception {
        MapTitle mapTitle;
        NodeList tooltip;
        NodeList heatmapNode;
        Attr mt;
        Attr mv;
        Attr sc;
        Attr tc;
        Attr mc;
        Attr maxz;
        Attr minz;
        Attr h;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("mapReport")) {
            throw new Exception("Missing mapReport element");
        }
        Attr mf = root.getAttributeNode("coordinates");
        if (mf == null) {
            throw new Exception("Missing coordinates attribute in the mapReport element");
        }
        this.coordinatesFilePath = ServerMessage.getPath(mf.getNodeValue(), this.pakFileName, "coord-");
        Attr w = root.getAttributeNode("width");
        if (w != null) {
            this.setMapWidth(Integer.parseInt(w.getNodeValue()));
        }
        if ((h = root.getAttributeNode("height")) != null) {
            this.setMapHeight(Integer.parseInt(h.getNodeValue()));
        }
        if ((minz = root.getAttributeNode("minimalZoom")) != null) {
            this.setMinimalZoom(Integer.parseInt(minz.getNodeValue()));
        }
        if ((maxz = root.getAttributeNode("maximalZoom")) != null) {
            this.setMaximalZoom(Integer.parseInt(maxz.getNodeValue()));
        }
        if ((mc = root.getAttributeNode("mapControl")) != null) {
            String value = mc.getNodeValue();
            if (!(value.equals(MAP_CONTROL_LARGE) || value.equals(MAP_CONTROL_SMALL) || value.equals(MAP_CONTROL_ZOOM) || value.equals(MAP_CONTROL_NONE))) {
                throw new Exception("Unknown map control type: " + value);
            }
            if (value.equals(MAP_CONTROL_ZOOM)) {
                value = MAP_CONTROL_SMALL;
            }
            this.setMapControlType(value);
        }
        if ((tc = root.getAttributeNode("typeControl")) != null) {
            this.setMapTypeControl(Boolean.valueOf(tc.getNodeValue()));
        }
        if ((sc = root.getAttributeNode("scaleControl")) != null) {
            this.setMapScaleControl(Boolean.valueOf(sc.getNodeValue()));
        }
        if ((mv = root.getAttributeNode("defaultMapView")) != null) {
            String value = mv.getNodeValue();
            if (!(value.equals(MAP_VIEW_HYBRID) || value.equals(MAP_VIEW_NORMAL) || value.equals(MAP_VIEW_SATELLITE))) {
                throw new Exception("Unknown map view: " + value);
            }
            this.setDefaultMapView(value);
        }
        if ((mt = root.getAttributeNode("mapType")) != null) {
            String value = mt.getNodeValue();
            if (!(value.equals(MAP_TYPE_OSM) || value.equals(MAP_TYPE_GOOGLE_STREET) || value.equals(MAP_TYPE_GOOGLE_SATELLITE))) {
                throw new Exception("Unknown map type: " + value);
            }
            this.setMapVendorType(value);
        } else if (this.getDefaultMapView() != null) {
            if (this.getDefaultMapView().equals(MAP_VIEW_NORMAL)) {
                this.setMapVendorType(MAP_TYPE_GOOGLE_STREET);
            } else if (this.getDefaultMapView().equals(MAP_VIEW_SATELLITE)) {
                this.setMapVendorType(MAP_TYPE_GOOGLE_SATELLITE);
            } else if (this.getDefaultMapView().equals(MAP_VIEW_HYBRID)) {
                this.setMapVendorType(MAP_TYPE_GOOGLE_SATELLITE);
            }
        } else {
            this.setMapVendorType(MAP_TYPE_GOOGLE_STREET);
        }
        NodeList ds = doc.getElementsByTagName("datasource");
        if (ds.getLength() == 0) {
            throw new Exception("Missing datasource element");
        }
        this.mapDataSource = DataSource.readDataSource((Element)ds.item(0));
        NodeList drilldown = doc.getElementsByTagName("drilldown");
        if (drilldown.getLength() > 0) {
            this.loadDrilldown(drilldown.item(0));
        }
        if ((heatmapNode = doc.getElementsByTagName("heatmap")).getLength() > 0) {
            this.loadHeatmap(heatmapNode.item(0));
        }
        if ((tooltip = doc.getElementsByTagName("tooltip")).getLength() > 0) {
            this.loadTooltip(tooltip.item(0));
        }
        this.title = (mapTitle = MapTitle.readXML(root)) == null ? null : new GoogleMapTitle(mapTitle);
        in.close();
    }

    private void loadHeatmap(Node source) throws Exception {
        NodeList thresholds;
        Element el = (Element)source;
        NodeList transitions = el.getElementsByTagName("transitionHeatmap");
        if (transitions.getLength() != 0) {
            NamedNodeMap nodeAttr = transitions.item(0).getAttributes();
            Node tmpNode = nodeAttr.getNamedItem("col");
            String cn = tmpNode.getNodeValue();
            tmpNode = nodeAttr.getNamedItem("aggr");
            String agr = "first";
            if (tmpNode != null) {
                agr = tmpNode.getNodeValue();
            }
            tmpNode = nodeAttr.getNamedItem("min");
            Double miv = Double.valueOf(tmpNode.getNodeValue());
            tmpNode = nodeAttr.getNamedItem("max");
            Double mav = Double.valueOf(tmpNode.getNodeValue());
            tmpNode = nodeAttr.getNamedItem("type");
            TransitionHeatmap.TransitionType tt = TransitionHeatmap.TransitionType.valueOf(tmpNode.getNodeValue());
            this.heatmap = new TransitionHeatmap(tt, miv, mav, cn, agr);
        }
        if ((thresholds = el.getElementsByTagName("thresholdHeatmap")).getLength() != 0) {
            NodeList thrValues;
            NamedNodeMap nodeAttr = thresholds.item(0).getAttributes();
            Node tmpNode = nodeAttr.getNamedItem("col");
            String cn = tmpNode.getNodeValue();
            tmpNode = nodeAttr.getNamedItem("aggr");
            String agr = "first";
            if (tmpNode != null) {
                agr = tmpNode.getNodeValue();
            }
            if ((thrValues = ((Element)thresholds.item(0)).getElementsByTagName("values")).getLength() == 0) {
                throw new Exception("Missing values element in the thresholdHeatmap element");
            }
            NodeList thrValue = ((Element)thrValues.item(0)).getElementsByTagName("value");
            if (thrValue.getLength() == 0) {
                throw new Exception("Missing value element in the values element");
            }
            ArrayList<Double> vls = new ArrayList<Double>();
            for (int i = 0; i < thrValue.getLength(); ++i) {
                Node valueNode = thrValue.item(i);
                NamedNodeMap valueAttr = valueNode.getAttributes();
                tmpNode = valueAttr.getNamedItem("value");
                vls.add(Double.valueOf(tmpNode.getNodeValue()));
            }
            NodeList thrColors = ((Element)thresholds.item(0)).getElementsByTagName("colors");
            if (thrColors.getLength() == 0) {
                throw new Exception("Missing colors element in the thresholdHeatmap element");
            }
            NodeList thrColor = ((Element)thrColors.item(0)).getElementsByTagName("color");
            if (thrValue.getLength() == 0) {
                throw new Exception("Missing color element in the colors element");
            }
            ArrayList<String> clrs = new ArrayList<String>();
            for (int i = 0; i < thrColor.getLength(); ++i) {
                Node colorNode = thrColor.item(i);
                NamedNodeMap colorAttr = colorNode.getAttributes();
                tmpNode = colorAttr.getNamedItem("color");
                clrs.add(tmpNode.getNodeValue());
            }
            this.heatmap = new ThresholdHeatmap(cn, clrs, vls, agr);
        }
    }

    private void loadDrilldown(Node source) throws Exception {
        Element el;
        NodeList params;
        NamedNodeMap attr = source.getAttributes();
        Node tmpNode = attr.getNamedItem("type");
        if (tmpNode != null) {
            String tmpValue = tmpNode.getNodeValue();
            if (tmpValue.equals("report") || tmpValue.equals("chart") || tmpValue.equals("map") || tmpValue.equals("newmap") || tmpValue.equalsIgnoreCase(FILE_TYPE_QDR)) {
                this.setDrilldownType(tmpValue);
            } else {
                throw new Exception("Wrong drilldown type (" + tmpValue + ")");
            }
        }
        if ((tmpNode = attr.getNamedItem("url")) == null) {
            throw new Exception("Missing url attribute in the drilldown element");
        }
        this.drilldownUrl = ServerMessage.getPath(tmpNode.getNodeValue(), this.pakFileName, "drilldown-");
        if (this.pakFileName != null) {
            this.drilldownUrl = this.setPakExtension(this.drilldownUrl, this.drilldownType);
        }
        if ((params = (el = (Element)source).getElementsByTagName("drilldownMapping")).getLength() == 0) {
            throw new Exception("Missing drilldownMapping element in the drilldown element");
        }
        for (int i = 0; i < params.getLength(); ++i) {
            NamedNodeMap nodeAttr = params.item(i).getAttributes();
            tmpNode = nodeAttr.getNamedItem("parameter");
            if (tmpNode == null) {
                throw new Exception("Missing parameter attribute in the drilldownMapping element");
            }
            String name = tmpNode.getNodeValue();
            tmpNode = nodeAttr.getNamedItem("mapto");
            if (tmpNode == null) {
                throw new Exception("Missing mapto attribute in the drilldownMapping element");
            }
            String mapto = tmpNode.getNodeValue();
            this.drilldownParamMap.put(name, mapto);
        }
    }

    private void loadTooltip(Node source) throws Exception {
        Element el;
        NodeList params;
        NamedNodeMap attr = source.getAttributes();
        Node tmpNode = attr.getNamedItem("type");
        if (tmpNode != null) {
            String tmpValue = tmpNode.getNodeValue();
            if (tmpValue.equalsIgnoreCase("report") || tmpValue.equals(FILE_TYPE_QDR) || tmpValue.equalsIgnoreCase("chart")) {
                this.tooltipType = tmpValue;
            } else {
                throw new Exception("Wrong tooltip type (" + tmpValue + ")");
            }
        }
        if ((tmpNode = attr.getNamedItem("width")) != null) {
            this.setTooltipWidth(Integer.parseInt(tmpNode.getNodeValue()));
        }
        if ((tmpNode = attr.getNamedItem("height")) != null) {
            this.setTooltipHeight(Integer.parseInt(tmpNode.getNodeValue()));
        }
        if ((tmpNode = attr.getNamedItem("url")) != null) {
            this.tooltipUrl = ServerMessage.getPath(tmpNode.getNodeValue(), this.pakFileName, "tooltip-");
            if (this.pakFileName != null) {
                this.tooltipUrl = this.setPakExtension(this.tooltipUrl, this.tooltipType);
            }
        }
        if ((tmpNode = attr.getNamedItem("folder")) != null) {
            this.tooltipOrgNodeID = Integer.parseInt(tmpNode.getNodeValue());
        }
        if ((tmpNode = attr.getNamedItem("itemID")) != null) {
            this.tooltipOrgItemID = Integer.parseInt(tmpNode.getNodeValue());
        }
        if ((tmpNode = attr.getNamedItem("templateName")) != null) {
            this.tooltipTemplateName = tmpNode.getNodeValue();
        }
        if ((params = (el = (Element)source).getElementsByTagName("tooltipMapping")).getLength() == 0) {
            throw new Exception("Missing tooltipMapping element in the tooltip element");
        }
        for (int i = 0; i < params.getLength(); ++i) {
            NamedNodeMap nodeAttr = params.item(i).getAttributes();
            tmpNode = nodeAttr.getNamedItem("column");
            if (tmpNode == null) {
                throw new Exception("Missing column attribute in the tooltipMapping element");
            }
            Integer col = Integer.valueOf(tmpNode.getNodeValue());
            tmpNode = nodeAttr.getNamedItem("mapto");
            if (tmpNode == null) {
                throw new Exception("Missing mapto attribute in the tooltipMapping element");
            }
            String mapto = tmpNode.getNodeValue();
            this.tooltipColumnMap.put(col, mapto);
        }
    }

    @Override
    public void save(String filename) throws Exception {
        filename.replace('\\', '/');
        WriteDataFile writer = new WriteDataFile();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        this.save(bos);
        writer.output(bos.toByteArray(), filename);
    }

    public void save(OutputStream out) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("mapReport");
        doc.appendChild(root);
        this.coordinatesFilePath.replace('\\', '/');
        root.setAttribute("coordinates", this.createRelativePath(this.coordinatesFilePath));
        root.setAttribute("width", this.getMapWidth() + "");
        root.setAttribute("height", this.getMapHeight() + "");
        root.setAttribute("minimalZoom", this.getMinimalZoom() + "");
        root.setAttribute("maximalZoom", this.getMaximalZoom() + "");
        root.setAttribute("mapType", this.getMapVendorType() + "");
        root.setAttribute("mapControl", this.getMapControlType());
        root.setAttribute("typeControl", this.hasMapTypeControl() + "");
        root.setAttribute("scaleControl", this.hasMapScaleControl() + "");
        root.setAttribute("defaultMapView", this.getDefaultMapView());
        Element ds = doc.createElement("datasource");
        root.appendChild(ds);
        this.mapDataSource.writeXML(ds);
        if (this.drilldownUrl != null) {
            Element drilldown = doc.createElement("drilldown");
            root.appendChild(drilldown);
            this.drilldownUrl.replace('\\', '/');
            drilldown.setAttribute("url", this.createRelativePath(this.drilldownUrl));
            drilldown.setAttribute("type", this.getDrilldownType());
            for (Map.Entry entry : this.drilldownParamMap.entrySet()) {
                Element mapping = doc.createElement("drilldownMapping");
                drilldown.appendChild(mapping);
                mapping.setAttribute("parameter", (String)entry.getKey());
                mapping.setAttribute("mapto", (String)entry.getValue());
            }
        }
        Element heatmapNode = doc.createElement("heatmap");
        root.appendChild(heatmapNode);
        if (this.heatmap != null) {
            if (this.heatmap instanceof TransitionHeatmap) {
                Element transitionNode = doc.createElement("transitionHeatmap");
                heatmapNode.appendChild(transitionNode);
                TransitionHeatmap trhm = (TransitionHeatmap)this.heatmap;
                transitionNode.setAttribute("col", trhm.getColumn());
                transitionNode.setAttribute("aggr", trhm.getAggr());
                transitionNode.setAttribute("min", String.valueOf(trhm.getMinValue()));
                transitionNode.setAttribute("max", String.valueOf(trhm.getMaxValue()));
                transitionNode.setAttribute("type", trhm.getType().name());
            } else if (this.heatmap instanceof ThresholdHeatmap) {
                ThresholdHeatmap thhm = (ThresholdHeatmap)this.heatmap;
                Element thresholdNode = doc.createElement("thresholdHeatmap");
                heatmapNode.appendChild(thresholdNode);
                thresholdNode.setAttribute("col", thhm.getColumn());
                thresholdNode.setAttribute("aggr", thhm.getAggr());
                Element valuesNode = doc.createElement("values");
                thresholdNode.appendChild(valuesNode);
                for (Double d : thhm.getVals()) {
                    Element curVal = doc.createElement("value");
                    curVal.setAttribute("value", String.valueOf(d));
                    valuesNode.appendChild(curVal);
                }
                Element colorsNode = doc.createElement("colors");
                thresholdNode.appendChild(colorsNode);
                for (String s : thhm.getColors()) {
                    Element curColor = doc.createElement("color");
                    curColor.setAttribute("color", s);
                    colorsNode.appendChild(curColor);
                }
            }
        }
        Element tooltip = doc.createElement("tooltip");
        root.appendChild(tooltip);
        if (this.tooltipUrl != null) {
            this.tooltipUrl.replace('\\', '/');
            tooltip.setAttribute("url", this.createRelativePath(this.tooltipUrl));
            tooltip.setAttribute("type", this.tooltipType);
            tooltip.setAttribute("width", this.getTooltipWidth() + "");
            tooltip.setAttribute("height", this.getTooltipHeight() + "");
            tooltip.setAttribute("organizerNodeID", this.getTooltipOrgNodeID() + "");
            tooltip.setAttribute("organizerItemID", this.getTooltipOrgItemID() + "");
            tooltip.setAttribute("templateName", this.getTooltipTemplateName());
        }
        for (Map.Entry entry : this.tooltipColumnMap.entrySet()) {
            Element mapping = doc.createElement("tooltipMapping");
            tooltip.appendChild(mapping);
            mapping.setAttribute("column", entry.getKey().toString());
            mapping.setAttribute("mapto", (String)entry.getValue());
        }
        if (this.title != null) {
            this.title.writeXML(root);
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        xformer.transform(source, result);
    }

    public void removeCachedTooltips() {
        for (MapPoint point : this.getMapPoints()) {
            point.removeCachedTooltip();
        }
    }

    public static DataSource readDataSource(String file) throws Exception {
        DataInputStream in = new ReadDataFile().getInputStream(file);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("qbMap")) {
            throw new Exception("Missing mapReport element");
        }
        NodeList ds = doc.getElementsByTagName("datasource");
        if (ds.getLength() == 0) {
            throw new Exception("Missing datasource element");
        }
        return DataSource.readDataSource((Element)ds.item(0));
    }

    public boolean isMultiValueDrilldown() {
        try {
            if (this.drilldownUrl == null) {
                return false;
            }
            if (this.drilldownType.equals("report") || this.drilldownType.equals("easyreport")) {
                QbReport report = new QbReport(null, this.drilldownUrl, true, false, false, true, false);
                Parameters allPromptParams = ParameterGrabber.getParameters(report.getReportObj());
                for (int i = 0; i < allPromptParams.size(); ++i) {
                    Param param = allPromptParams.get(i);
                    if (!param.multiValue()) continue;
                    return true;
                }
            } else if (this.drilldownType.equals("chart")) {
                IQueryInParam[] queryParamSet;
                QbChart chart = new QbChart((Applet)null, this.drilldownUrl, true);
                IInputData inputData = chart.gethInputData();
                IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)inputData.getDatabaseInfo());
                if (queryInfo == null) {
                    return false;
                }
                for (IQueryInParam element : queryParamSet = quadbase.util.internal.QbUtil.getInParam(queryInfo)) {
                    if (!(element instanceof IQueryMultiValueInParam)) continue;
                    return true;
                }
            } else if (this.drilldownType.equals("map")) {
                quadbase.common.util.IQueryInParam[] queryParamSet;
                QbMap map = QbMap.readMap(this.drilldownUrl);
                if (!map.getDataSource().isParameterized()) {
                    return false;
                }
                ParameterizedDataSource ds = (ParameterizedDataSource)map.getDataSource();
                for (quadbase.common.util.IQueryInParam element : queryParamSet = ds.getInParam()) {
                    if (!(element instanceof IQueryMultiValueInParam)) continue;
                    return true;
                }
            } else if (this.drilldownType.equals("newmap")) {
                quadbase.common.util.IQueryInParam[] queryParamSet;
                DataSource ds = GoogleMap.readDataSource(this.drilldownUrl);
                if (!ds.isParameterized()) {
                    return false;
                }
                ParameterizedDataSource pds = (ParameterizedDataSource)ds;
                for (quadbase.common.util.IQueryInParam element : queryParamSet = pds.getInParam()) {
                    if (!(element instanceof IQueryMultiValueInParam)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setTooltipColumnMapping(int colIndex, String pointId) {
        this.tooltipColumnMap.put(colIndex, pointId);
    }

    public void resetTooltipColumnMapping() {
        this.tooltipColumnMap.clear();
    }

    public HashMap getTooltipColumnMap() {
        return this.tooltipColumnMap;
    }

    public void removeDrilldown() {
        this.drilldownParamMap = new HashMap();
        this.drilldownUrl = null;
    }

    public void removeHeatmap() {
        this.heatmap = null;
    }

    public void removeTooltip() {
        this.removeCachedTooltips();
        this.tooltipUrl = null;
    }

    public HashMap getDrilldownMapping() {
        return this.drilldownParamMap;
    }

    public void setDrilldownMapping(HashMap drilldownMapping) {
        this.drilldownParamMap = drilldownMapping;
    }

    public void setDrilldownFixedValues(HashMap drilldownFixedValues) {
        this.drilldownFixedValues = drilldownFixedValues;
    }

    public void setDrilldownUrl(String drilldownUrl) {
        this.drilldownUrl = drilldownUrl;
    }

    public String getDrilldownUrl() {
        return this.drilldownUrl;
    }

    public void setDrilldownType(String drilldownType) {
        this.drilldownType = drilldownType;
    }

    public String getDrilldownType() {
        return this.drilldownType;
    }

    public void setTooltipWidth(int tooltipWidth) {
        this.tooltipWidth = tooltipWidth;
    }

    public int getTooltipWidth() {
        return this.tooltipWidth;
    }

    public void setTooltipHeight(int tooltipHeight) {
        this.tooltipHeight = tooltipHeight;
    }

    public int getTooltipHeight() {
        return this.tooltipHeight;
    }

    public String getTooltipUrl() {
        return this.tooltipUrl;
    }

    public void setTooltipUrl(String tooltipUrl) {
        this.tooltipUrl = tooltipUrl;
    }

    public String getTooltipType() {
        return this.tooltipType;
    }

    public void setTooltipType(String tooltipType) {
        this.tooltipType = tooltipType;
    }

    public int getTooltipOrgNodeID() {
        return this.tooltipOrgNodeID;
    }

    public void setTooltipOrgNodeID(int tooltipOrgNodeID) {
        this.tooltipOrgNodeID = tooltipOrgNodeID;
    }

    public int getTooltipOrgItemID() {
        return this.tooltipOrgItemID;
    }

    public void setTooltipOrgItemID(int tooltipOrgItemID) {
        this.tooltipOrgItemID = tooltipOrgItemID;
    }

    public String getTooltipTemplateName() {
        return this.tooltipTemplateName;
    }

    public void setTooltipTemplateName(String tooltipTemplateName) {
        this.tooltipTemplateName = tooltipTemplateName;
    }

    public void setTooltipColumnMap(HashMap tooltipColumnMap) {
        this.tooltipColumnMap = tooltipColumnMap;
    }

    public void setMapWidth(int mapWidth) {
        this.mapWidth = mapWidth;
    }

    @Override
    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapHeight(int mapHeight) {
        this.mapHeight = mapHeight;
    }

    @Override
    public int getMapHeight() {
        return this.mapHeight;
    }

    @Override
    public void setMapDimensions(int width, int height) {
        this.setMapWidth(width);
        this.setMapHeight(height);
    }

    @Override
    public DataSource getDataSource() {
        return this.mapDataSource;
    }

    @Override
    public void setDataSource(DataSource newDataSource) throws Exception {
        this.mapDataSource = newDataSource;
        this.refresh();
    }

    @Override
    public void setDataSource(DataSource newDataSource, boolean refresh) throws Exception {
        this.mapDataSource = newDataSource;
        if (refresh) {
            this.refresh();
        }
    }

    public void setDataSourceNoSort(DataSource newDataSource) throws Exception {
        this.mapDataSource = newDataSource;
        this.dataSheet = this.mapDataSource.getDataSheet(0, -1, this.isAdmin);
        this.refreshCoordinates();
    }

    @Override
    public DataSheet getDataSheet() {
        return this.dataSheet;
    }

    public int getMinimalZoom() {
        return this.minimalZoom;
    }

    public void setMinimalZoom(int minimalZoom) {
        this.minimalZoom = minimalZoom;
    }

    public int getMaximalZoom() {
        return this.maximalZoom;
    }

    public void setMaximalZoom(int maximalZoom) {
        this.maximalZoom = maximalZoom;
    }

    public String getMapControlType() {
        return this.mapControlType;
    }

    public void setMapControlType(String mapControlType) {
        this.mapControlType = mapControlType;
    }

    public boolean hasMapTypeControl() {
        return this.hasMapTypeControl;
    }

    public void setMapTypeControl(boolean hasMapTypeControl) {
        this.hasMapTypeControl = hasMapTypeControl;
    }

    public boolean hasMapScaleControl() {
        return this.hasMapScaleControl;
    }

    public void setMapScaleControl(boolean hasMapScaleControl) {
        this.hasMapScaleControl = hasMapScaleControl;
    }

    public String getDefaultMapView() {
        return this.defaultMapView;
    }

    public void setDefaultMapView(String defaultMapView) {
        this.defaultMapView = defaultMapView;
    }

    public void setCoordinates(String coordinatesPath) throws Exception {
        this.coordinatesFilePath = coordinatesPath;
        this.refreshCoordinates();
    }

    public String getCoordinatesFilePath() {
        return this.coordinatesFilePath;
    }

    public void setTitle(MapTitle title) {
        this.title = title == null ? null : new GoogleMapTitle(title);
    }

    public MapTitle getTitle() {
        return this.title;
    }

    public String getMapVendorType() {
        return this.mapVendorType;
    }

    public void setMapVendorType(String mapVendorType) {
        this.mapVendorType = mapVendorType;
    }

    boolean isTooltipCompatible() {
        try {
            if (this.tooltipUrl == null) {
                return true;
            }
            ColData[] colData = this.getDataSheet().getColData();
            if (this.tooltipType.equalsIgnoreCase("report") || this.tooltipType.equalsIgnoreCase(FILE_TYPE_QDR)) {
                QbReport report = new QbReport(null, QbUtil.fixUrlString(this.tooltipUrl), false, false, false, true);
                if (report.report.colData.length != colData.length) {
                    return false;
                }
                for (int i = 0; i < colData.length; ++i) {
                    if (colData[i].getDataType() == report.report.colData[i].getDataType()) continue;
                    return false;
                }
            } else if (this.tooltipType.equalsIgnoreCase("chart")) {
                QbChart chart = new QbChart((Applet)null, this.tooltipUrl, true);
                if (chart.getChart().isTimeChart()) {
                    IZoomInfo czi = chart.gethZoomInfo();
                    czi.setZoomEnabled(false);
                    chart.refresh();
                    if (chart.getChart().colData.length != colData.length) {
                        return false;
                    }
                    for (int i = 0; i < colData.length; ++i) {
                        if (colData[i].getDataType() == chart.getChart().colData[i].getDataType()) continue;
                        return false;
                    }
                    czi.setZoomEnabled(true);
                    chart.refresh();
                    return true;
                }
                if (chart.getChart().colData.length != colData.length) {
                    return false;
                }
                for (int i = 0; i < colData.length; ++i) {
                    if (colData[i].getDataType() == chart.getChart().colData[i].getDataType()) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public String[] getAllAlertIds() {
        return null;
    }

    @Override
    public String[] getTriggeredAlertIds() {
        return null;
    }

    public Map getTriggeredAlertDetails() {
        return null;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }
}

