/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.googlemaps;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.datasource.DataSource;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.maps.googlemaps.GoogleMap;
import quadbase.maps.googlemaps.MapPoint;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class MapCoordinates {
    public static final String GOOGLE_TYPE = "google";
    public static final String BITMAP_TYPE = "bitmap";
    public static final String EXTENSION = ".cxml";
    public static final String[] GEOCODING_DATA_NAMES = new String[]{"street", "address2", "city", "zip", "state", "province", "country"};
    public static final String GEOCODING_TYPE = "geotype";
    private int[] geocodingColMapping = new int[GEOCODING_DATA_NAMES.length];
    private GeocodingType geocodingType;
    private DataSource dataSource;
    private DataSheet dataSheet = null;
    private String imageFile = null;
    private String type;
    private Vector<MapPoint> mapPoints;
    private GoogleMap parentMap = null;
    private int lngCol = -1;
    private int latCol = -1;
    private int wktCol = -1;
    private DatasourceType datasourceType = DatasourceType.WKT;
    private boolean isAdmin;

    public MapCoordinates(DataSource dataSource) {
        this.dataSource = dataSource;
        this.resetGeocodingMapping();
    }

    public MapCoordinates(String filename) throws Exception {
        this(filename, false);
    }

    public MapCoordinates(String filename, boolean readFromDataSource) throws Exception {
        this(filename, readFromDataSource, null);
    }

    public MapCoordinates(String filename, boolean readFromDataSource, GoogleMap parentMap) throws Exception {
        NodeList mp;
        this.parentMap = parentMap;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputStream in = null;
        if (OrgUtil.isMapData(filename)) {
            byte[] bytes = OrgUtil.getMapData(filename);
            in = new ByteArrayInputStream(bytes);
        } else {
            in = new ReadDataFile().getInputStream(filename);
        }
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("coordinates")) {
            throw new Exception("The root tag must be coordinates in " + filename);
        }
        Attr t = root.getAttributeNode("type");
        if (t == null) {
            throw new Exception("Missing type attribute in the coordinates tag");
        }
        this.type = t.getNodeValue();
        if (!this.type.equals(GOOGLE_TYPE) && !this.type.equals(BITMAP_TYPE)) {
            throw new Exception("Wrong coordinates type");
        }
        Attr m = root.getAttributeNode("mode");
        this.datasourceType = m == null ? DatasourceType.DUAL : DatasourceType.valueOf(m.getNodeValue());
        NodeList ds = root.getElementsByTagName("datasource");
        if (ds.getLength() == 0) {
            throw new Exception("Missing datasource tag in " + filename);
        }
        this.dataSource = DataSource.readDataSource((Element)ds.item(0));
        if (this.type.equals(GOOGLE_TYPE)) {
            NodeList cm = root.getElementsByTagName("coordinatesMapping");
            if (cm.getLength() > 0) {
                NamedNodeMap attr = cm.item(0).getAttributes();
                if (this.getDatasourceType().equals((Object)DatasourceType.DUAL)) {
                    Node tmpNode = attr.getNamedItem("lng");
                    if (tmpNode == null) {
                        throw new Exception("Missing lng attribute in the coordinatesMapping tag");
                    }
                    this.lngCol = Integer.parseInt(tmpNode.getNodeValue());
                    tmpNode = attr.getNamedItem("lat");
                    if (tmpNode == null) {
                        throw new Exception("Missing lat attribute in the coordinatesMapping tag");
                    }
                    this.latCol = Integer.parseInt(tmpNode.getNodeValue());
                } else {
                    Node tmpNode = attr.getNamedItem("wkt");
                    if (tmpNode == null) {
                        throw new Exception("Missing wkt attribute in the coordinatesMapping tag");
                    }
                    this.wktCol = Integer.parseInt(tmpNode.getNodeValue());
                }
                this.createPoints();
                return;
            }
            this.resetGeocodingMapping();
            NodeList gt = root.getElementsByTagName("geocodingType");
            if (gt.getLength() == 0) {
                this.geocodingType = GeocodingType.GOOGLE;
            } else {
                NamedNodeMap attr = gt.item(0).getAttributes();
                Node tmpNode = attr.getNamedItem("type");
                if (tmpNode != null) {
                    this.setGeocodingTypeStr(tmpNode.getNodeValue());
                }
            }
            NodeList gm = root.getElementsByTagName("geocodingMapping");
            if (gm.getLength() > 0) {
                NamedNodeMap attr = gm.item(0).getAttributes();
                for (int i = 0; i < GEOCODING_DATA_NAMES.length; ++i) {
                    Node tmpNode = attr.getNamedItem(GEOCODING_DATA_NAMES[i]);
                    if (tmpNode == null) continue;
                    this.geocodingColMapping[i] = Integer.parseInt(tmpNode.getNodeValue());
                }
            }
        } else {
            Attr b = root.getAttributeNode(BITMAP_TYPE);
            if (b == null) {
                throw new Exception("Missing bitmap attribute in the coordinates tag");
            }
            this.imageFile = b.getNodeValue();
        }
        if ((mp = root.getElementsByTagName("mappoints")).getLength() == 0) {
            throw new Exception("Missing mappoints tag in " + filename);
        }
        NodeList points = ((Element)mp.item(0)).getElementsByTagName("mappoint");
        if (readFromDataSource) {
            this.createPoints();
            for (int i = 0; i < points.getLength(); ++i) {
                MapPoint newPoint = new MapPoint(parentMap, (Element)points.item(i));
                boolean found = false;
                for (MapPoint element : this.mapPoints) {
                    MapPoint point = element;
                    if (!point.matches(newPoint.dataMap)) continue;
                    if (this.datasourceType.equals((Object)DatasourceType.DUAL)) {
                        point.setLongitude(newPoint.getLongitude());
                        point.setLatitude(newPoint.getLatitude());
                    } else {
                        point.setWkt(newPoint.getWkt());
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                this.mapPoints.add(newPoint);
            }
        } else {
            this.mapPoints = new Vector();
            for (int i = 0; i < points.getLength(); ++i) {
                this.mapPoints.add(new MapPoint(parentMap, (Element)points.item(i)));
            }
        }
        this.convertToWKT();
    }

    public void convertToWKT() {
        if (this.datasourceType.equals((Object)DatasourceType.DUAL) && this.isGoogleGeoCoding()) {
            this.datasourceType = DatasourceType.WKT;
            Vector<MapPoint> newMapPoints = new Vector<MapPoint>();
            for (MapPoint mp : this.mapPoints) {
                StringBuffer sb = new StringBuffer();
                sb.append("POINT(");
                sb.append(mp.getLongitude());
                sb.append(" ");
                sb.append(mp.getLatitude());
                sb.append(")");
                MapPoint nmp = new MapPoint(this.parentMap, mp.getDataMap(), sb.toString());
                newMapPoints.add(nmp);
            }
            this.mapPoints = newMapPoints;
        }
    }

    public void createPoints() throws Exception {
        this.getDataSheet();
        this.mapPoints = new Vector();
        String[] columnNames = this.dataSheet.getFieldNames();
        for (int i = 0; i < this.dataSheet.getRowCount(); ++i) {
            LinkedHashMap<String, String> ids = new LinkedHashMap<String, String>();
            double longitude = -1.0;
            double latitude = -1.0;
            String wkt = "-1";
            Object[] row = this.dataSheet.getRow(i);
            for (int j = 0; j < this.dataSheet.getColumnCount(); ++j) {
                if (this.datasourceType.equals((Object)DatasourceType.DUAL)) {
                    if (j == this.lngCol) {
                        longitude = Double.parseDouble(row[j].toString());
                        continue;
                    }
                    if (j == this.latCol) {
                        latitude = Double.parseDouble(row[j].toString());
                        continue;
                    }
                    ids.put(columnNames[j], row[j] == null ? "" : row[j].toString());
                    continue;
                }
                if (!this.datasourceType.equals((Object)DatasourceType.WKT)) continue;
                if (j == this.wktCol) {
                    wkt = row[j] == null ? "" : row[j].toString();
                    continue;
                }
                ids.put(columnNames[j], row[j] == null ? "" : row[j].toString());
            }
            MapPoint pnt = null;
            if (this.datasourceType.equals((Object)DatasourceType.DUAL)) {
                pnt = new MapPoint(this.parentMap, ids, longitude, latitude);
            } else if (wkt != "") {
                pnt = new MapPoint(this.parentMap, ids, wkt);
            }
            if (pnt == null) continue;
            this.mapPoints.add(pnt);
        }
    }

    public void setGeocodingMapping(String name, int colIndex) throws Exception {
        boolean found = false;
        for (int i = 0; i < GEOCODING_DATA_NAMES.length; ++i) {
            if (!GEOCODING_DATA_NAMES[i].equals(name)) continue;
            found = true;
            this.geocodingColMapping[i] = colIndex;
            break;
        }
        if (!found) {
            throw new Exception("Unknown geocoding mapping name!");
        }
    }

    public String[] getFieldNames() {
        String[] rtrn = new String[]{};
        try {
            rtrn = this.getDataSheet().getFieldNames();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rtrn == null) {
            return new String[0];
        }
        if (rtrn.length == 0) {
            return new String[0];
        }
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(rtrn));
        if (this.latCol != -1 && this.lngCol != -1) {
            if (this.latCol > this.lngCol) {
                tmp.remove(this.latCol);
                tmp.remove(this.lngCol);
            } else {
                tmp.remove(this.lngCol);
                tmp.remove(this.latCol);
            }
        } else if (this.wktCol != -1) {
            tmp.remove(this.wktCol);
        }
        return tmp.toArray(new String[0]);
    }

    public int getGeocodingMapping(String name) throws Exception {
        for (int i = 0; i < GEOCODING_DATA_NAMES.length; ++i) {
            if (!GEOCODING_DATA_NAMES[i].equals(name)) continue;
            return this.geocodingColMapping[i];
        }
        throw new Exception("Unknown geocoding mapping name!");
    }

    public void setCoordinatesMapping(int longitude, int latitude) {
        this.lngCol = longitude;
        this.latCol = latitude;
    }

    public int getLatCol() {
        return this.latCol;
    }

    public int getLngCol() {
        return this.lngCol;
    }

    public void resetGeocodingMapping() {
        Arrays.fill(this.geocodingColMapping, -1);
    }

    public void setType(String type) {
        this.type = type;
    }

    public Vector<MapPoint> getMapPoints() {
        return this.mapPoints;
    }

    public MapPoint getMapPoint(int index) {
        return this.mapPoints.get(index);
    }

    public DataSheet getDataSheet() throws Exception {
        if (this.dataSheet == null) {
            if (this.dataSource.isParameterized()) {
                ((ParameterizedDataSource)this.dataSource).setDefaultParameters();
            }
            this.dataSheet = this.dataSource.getDataSheet(0, -1, this.isAdmin);
        }
        return this.dataSheet;
    }

    public boolean isFromDataSource() {
        return this.lngCol != -1 && this.latCol != -1 || this.wktCol != -1;
    }

    public boolean isGoogleGeoCoding() {
        for (int element : this.geocodingColMapping) {
            if (element == -1 || this.geocodingType == null) continue;
            return this.geocodingType.equals((Object)GeocodingType.GOOGLE);
        }
        return false;
    }

    public boolean isFreeGeoCoding() {
        for (int element : this.geocodingColMapping) {
            if (element == -1 || this.geocodingType == null) continue;
            return this.geocodingType.equals((Object)GeocodingType.FREE);
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("type: " + this.type + "\ncoordinates mapping: lng=" + this.lngCol + " lat=" + this.latCol + "\n");
        result.append("geocoding mapping: ");
        for (int i = 0; i < GEOCODING_DATA_NAMES.length; ++i) {
            result.append(GEOCODING_DATA_NAMES[i]).append("=").append(this.geocodingColMapping[i]).append(" ");
        }
        result.append("\n points: \n");
        Iterator<MapPoint> iterator = this.mapPoints.iterator();
        while (iterator.hasNext()) {
            MapPoint element;
            MapPoint point = element = iterator.next();
            result.append(point.toString()).append("\n");
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void save(OutputStream out) throws Exception {
        Element gt;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("coordinates");
        doc.appendChild(root);
        root.setAttribute("type", this.type);
        root.setAttribute("mode", this.datasourceType.name());
        if (this.type.equals(BITMAP_TYPE)) {
            root.setAttribute(BITMAP_TYPE, this.imageFile);
        }
        Element ds = doc.createElement("datasource");
        this.dataSource.writeXML(ds);
        root.appendChild(ds);
        if (this.lngCol != -1 && this.latCol != -1 || this.wktCol != -1) {
            if (this.geocodingType != null) {
                gt = doc.createElement("geocodingType");
                gt.setAttribute("type", this.geocodingType.name());
                root.appendChild(gt);
            }
            Element cm = doc.createElement("coordinatesMapping");
            root.appendChild(cm);
            if (this.datasourceType.equals((Object)DatasourceType.DUAL)) {
                cm.setAttribute("lng", this.lngCol + "");
                cm.setAttribute("lat", this.latCol + "");
            } else {
                cm.setAttribute("wkt", this.wktCol + "");
            }
        } else {
            if (this.type.equals(GOOGLE_TYPE)) {
                void var8_9;
                gt = doc.createElement("geocodingType");
                if (this.geocodingType != null) {
                    gt.setAttribute("type", this.geocodingType.name());
                }
                root.appendChild(gt);
                Element gm = doc.createElement("geocodingMapping");
                boolean bl = false;
                while (var8_9 < GEOCODING_DATA_NAMES.length) {
                    gm.setAttribute(GEOCODING_DATA_NAMES[var8_9], this.geocodingColMapping[var8_9] + "");
                    ++var8_9;
                }
                root.appendChild(gm);
            }
            Element mp = doc.createElement("mappoints");
            root.appendChild(mp);
            for (Object e : this.mapPoints) {
                MapPoint point = (MapPoint)e;
                if (point.getLongitude() == -1.0 || point.getLatitude() == -1.0) continue;
                Element p = doc.createElement("mappoint");
                point.writeXML(p);
                mp.appendChild(p);
            }
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(source, result);
        out.flush();
    }

    public void save(String filename) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        this.save(bos);
        WriteDataFile writeFile = new WriteDataFile();
        writeFile.output(bos.toByteArray(), filename);
        bos.close();
    }

    public DatasourceType getDatasourceType() {
        return this.datasourceType;
    }

    public void setDatasourceType(DatasourceType datasourceType) {
        this.datasourceType = datasourceType;
    }

    public int getWktCol() {
        return this.wktCol;
    }

    public void setWktCol(int wktCol) {
        this.wktCol = wktCol;
    }

    public String getGeocodingTypeStr() {
        return this.geocodingType == null ? null : this.geocodingType.name();
    }

    public void setGeocodingTypeStr(String geocodingType) {
        this.setGeocodingType(GeocodingType.valueOf(geocodingType));
    }

    public GeocodingType getGeocodingType() {
        return this.geocodingType;
    }

    public void setGeocodingType(GeocodingType geocodingType) {
        this.geocodingType = geocodingType;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource newDataSource) throws Exception {
        this.dataSource = newDataSource;
    }

    public static enum GeocodingType {
        GOOGLE,
        FREE;

    }

    public static enum DatasourceType {
        DUAL,
        WKT;

    }
}

