/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.googlemaps;

import java.applet.Applet;
import java.awt.Color;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.ChartAPI.DbData;
import quadbase.ChartAPI.QbChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.JavaScriptUtil;
import quadbase.maps.googlemaps.GoogleMap;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.util.IZoomInfo;

public class MapPoint {
    private double longitude;
    private double latitude;
    private String wkt;
    protected LinkedHashMap<String, String> dataMap;
    private Vector associatedRows = new Vector();
    private QbReport report = null;
    private QbChart chart = null;
    private GoogleMap map;

    public MapPoint(GoogleMap map, Element el) throws Exception {
        this.map = map;
        this.readXML(el);
    }

    public MapPoint(GoogleMap parentMap, LinkedHashMap<String, String> dataMap, double longitude, double latitude) {
        this.map = parentMap;
        this.dataMap = dataMap;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public MapPoint(GoogleMap parentMap, LinkedHashMap<String, String> dataMap, String wkt) {
        this.map = parentMap;
        this.dataMap = dataMap;
        this.wkt = wkt;
    }

    private void readXML(Element el) throws Exception {
        String wkt = el.getAttribute("wkt");
        boolean iswkt = false;
        iswkt = wkt != null ? !wkt.equals("") : false;
        if (iswkt) {
            this.wkt = wkt;
        } else {
            String lat = el.getAttribute("lat");
            if (lat == null) {
                throw new Exception("Missing lat attribute in the mappoint element");
            }
            this.latitude = Double.parseDouble(lat);
            String lng = el.getAttribute("lng");
            if (lng == null) {
                throw new Exception("Missing lng attribute in the mappoint element");
            }
            this.longitude = Double.parseDouble(lng);
        }
        NodeList data = el.getElementsByTagName("id");
        if (data.getLength() == 0) {
            throw new Exception("Missing id element in the mappoint element");
        }
        this.dataMap = new LinkedHashMap();
        for (int i = 0; i < data.getLength(); ++i) {
            NamedNodeMap nodeAttr = data.item(i).getAttributes();
            Node tmpNode = nodeAttr.getNamedItem("name");
            if (tmpNode == null) {
                throw new Exception("Missing name attribute in the id element");
            }
            String name = tmpNode.getNodeValue();
            tmpNode = nodeAttr.getNamedItem("value");
            if (tmpNode == null) {
                throw new Exception("Missing value attribute in the id element");
            }
            String value = tmpNode.getNodeValue();
            this.dataMap.put(name, value);
        }
    }

    protected void writeXML(Element el) {
        Document doc = el.getOwnerDocument();
        if (this.wkt == null) {
            el.setAttribute("lat", this.latitude + "");
            el.setAttribute("lng", this.longitude + "");
        } else {
            el.setAttribute("wkt", this.wkt + "");
        }
        Iterator<Map.Entry<String, String>> iterator = this.dataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element;
            Map.Entry<String, String> entry = element = iterator.next();
            Element id = doc.createElement("id");
            el.appendChild(id);
            id.setAttribute("name", entry.getKey().toString());
            id.setAttribute("value", entry.getValue() == null ? "" : entry.getValue().toString());
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getWkt() {
        return this.wkt;
    }

    public void setWkt(String wkt) {
        this.wkt = wkt;
    }

    public boolean matches(HashMap mapping) {
        for (String name : mapping.keySet()) {
            if (!(mapping.get(name) == null ? !this.dataMap.get(name).equals("") : !mapping.get(name).equals(this.dataMap.get(name)))) continue;
            return false;
        }
        return true;
    }

    public void addRowIndex(int index) {
        this.associatedRows.add(index);
    }

    public boolean hasAssociatedRow() {
        return !this.associatedRows.isEmpty();
    }

    public int getAssociatedRowsCount() {
        return this.associatedRows.size();
    }

    public LinkedHashMap getDataMap() {
        return this.dataMap;
    }

    public String getDrilldownParams() {
        Map.Entry entry;
        StringBuffer result = new StringBuffer();
        result.append('{');
        Iterator it = this.map.drilldownParamMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            result.append('\"' + JavaScriptUtil.escapeString((String)entry.getKey()) + "\":\"" + JavaScriptUtil.escapeString(this.dataMap.get(entry.getValue())) + "\"");
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        if (result.length() > 1) {
            result.append(", ");
        }
        it = this.map.drilldownFixedValues.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            result.append('\"' + JavaScriptUtil.escapeString((String)entry.getKey()) + "\":\"" + JavaScriptUtil.escapeString((String)entry.getValue()) + "\"");
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append('}');
        return result.toString();
    }

    public void writeTooltipHTML(OutputStream out, String tooltipServletUrl, int pointIndex, int drillIndex) throws Exception {
        this.writeTooltipHTML(out, tooltipServletUrl, pointIndex, drillIndex, "");
    }

    public synchronized void writeTooltipHTML(OutputStream out, String tooltipServletUrl, int pointIndex, int drillIndex, String extraArgs) throws Exception {
        if (extraArgs == null) {
            extraArgs = "";
        }
        if (this.map.tooltipUrl == null) {
            throw new Exception("No tooltip defined");
        }
        if (!this.map.tooltipType.equals("easyReport")) {
            if (this.map.tooltipType.equalsIgnoreCase("report")) {
                this.getReport().export(4, out);
            } else {
                String html = "<img usemap=\"#ChartMap" + pointIndex + "\" height=\"" + this.map.getTooltipHeight() + "\" width=\"" + this.map.getTooltipWidth() + "\" src=\"" + tooltipServletUrl + "?action=getChart&chartIndex=" + pointIndex + "&drillLevel=" + drillIndex + extraArgs + "\" border=\"0\" />\n";
                out.write(html.getBytes("UTF-8"));
            }
        }
    }

    public quadbase.reportdesigner.ReportAPI.DbData getDbData() {
        int i;
        String[] names = new String[this.map.dataSheet.getColumnCount()];
        Object[][] values = new Object[this.associatedRows.size()][this.map.dataSheet.getColumnCount()];
        for (i = 0; i < this.map.dataSheet.getColumnCount(); ++i) {
            names[i] = this.map.dataSheet.getFieldNames()[i];
        }
        for (i = 0; i < this.associatedRows.size(); ++i) {
            for (int j = 0; j < this.map.dataSheet.getColumnCount(); ++j) {
                values[i][j] = this.map.dataSheet.getRow((Integer)this.associatedRows.get(i))[j];
            }
        }
        return new quadbase.reportdesigner.ReportAPI.DbData(names, values);
    }

    private synchronized QbReport getReport() throws Exception {
        if (this.report != null) {
            return this.report;
        }
        this.report = new QbReport(null, this.map.tooltipUrl, false, false, false, true);
        if (ServerMessage.protocol.startsWith("https")) {
            this.report.setHttpsDynamicExport(true, ServerMessage.serverHost, ServerMessage.portNumber);
        } else {
            this.report.setDynamicExport(true, ServerMessage.serverHost, ServerMessage.portNumber);
        }
        this.report.setServletDirectory(ServerMessage.getServletContext());
        this.report.setExportEncoding("UTF-8");
        this.report.getInputData().setData(this.getDbData());
        this.report.refresh();
        this.report.setBottomMargin(0.1);
        this.report.setTopMargin(0.1);
        this.report.setLeftMargin(0.1);
        this.report.setRightMargin(0.1);
        return this.report;
    }

    public synchronized QbChart getChart() throws Exception {
        int i;
        if (this.chart != null) {
            return this.chart;
        }
        String[] names = new String[this.map.dataSheet.getColumnCount()];
        Object[][] values = new Object[this.associatedRows.size()][this.map.dataSheet.getColumnCount()];
        for (i = 0; i < this.map.dataSheet.getColumnCount(); ++i) {
            names[i] = this.map.dataSheet.getFieldNames()[i];
        }
        for (i = 0; i < this.associatedRows.size(); ++i) {
            for (int j = 0; j < this.map.dataSheet.getColumnCount(); ++j) {
                values[i][j] = this.map.dataSheet.getRow((Integer)this.associatedRows.get(i))[j];
            }
        }
        QbChart.setForExportOnly(true);
        this.chart = new QbChart((Applet)null, this.map.tooltipUrl, true);
        Color[] colors = this.chart.gethDataPoints().getColors();
        DbData data = new DbData(names, values);
        this.chart.gethInputData().setData(data, false);
        if (this.chart.gethDataPoints().getColors().length <= colors.length) {
            this.chart.gethDataPoints().setColors(colors);
        }
        if (this.chart.getChart().isTimeChart()) {
            IZoomInfo czi = this.chart.gethZoomInfo();
            czi.setZoomEnabled(true);
            this.chart.refresh();
        }
        return this.chart;
    }

    public synchronized void writeChart(OutputStream out) throws Exception {
        this.getChart().export(10, out, this.map.getTooltipWidth(), this.map.getTooltipHeight(), 0);
    }

    public void removeCachedTooltip() {
        this.chart = null;
        this.report = null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator<Map.Entry<String, String>> iterator = this.dataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element;
            Map.Entry<String, String> entry = element = iterator.next();
            result.append(entry.getKey() + "=" + entry.getValue() + " ");
        }
        result.append("# lon=" + this.longitude + " lat=" + this.latitude);
        return result.toString();
    }
}

