/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.googlemaps.heatmaps;

import java.util.List;
import quadbase.maps.googlemaps.heatmaps.Heatmap;

public class ThresholdHeatmap
implements Heatmap {
    private String column;
    private List<String> colors;
    private List<Double> vals;
    private String aggr;

    public ThresholdHeatmap(String colName, List<String> colors, List<Double> vals, String aggr) {
        this.setColumn(colName);
        this.colors = colors;
        this.vals = vals;
        this.aggr = aggr;
    }

    @Override
    public void setColumn(String colName) {
        this.column = colName;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public String getAggr() {
        return this.aggr;
    }

    @Override
    public void setAggr(String aggr) {
        this.aggr = aggr;
    }

    @Override
    public String getColorForValue(Double value) {
        for (int i = 0; i < this.vals.size(); ++i) {
            if (this.vals.get(i) == null) continue;
            if (this.vals.get(i).compareTo(value) >= 0) {
                return this.colors.get(i);
            }
            if (i != this.vals.size() - 1) continue;
            return this.colors.get(this.colors.size() - 1);
        }
        if (this.colors.size() > 0) {
            return this.colors.get(this.colors.size() - 1);
        }
        return "000000";
    }

    public List<String> getColors() {
        return this.colors;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    public List<Double> getVals() {
        return this.vals;
    }

    public void setVals(List<Double> vals) {
        this.vals = vals;
    }

    @Override
    public Heatmap.HeatmapType getHeatmapType() {
        return Heatmap.HeatmapType.HEAT_THRESHOLD;
    }
}

