/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.googlemaps.heatmaps;

import java.awt.Color;
import quadbase.maps.googlemaps.heatmaps.Heatmap;
import quadbase.maps.util.ColorTransitions;

public class TransitionHeatmap
implements Heatmap {
    private TransitionType type;
    private Double minValue;
    private Double maxValue;
    private String column;
    private String aggr;

    public TransitionHeatmap(TransitionType type, Double minValue, Double maxValue, String colName, String aggr) {
        this.setType(type);
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
        this.setColumn(colName);
        this.setAggr(aggr);
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public TransitionType getType() {
        return this.type;
    }

    public void setType(TransitionType type) {
        this.type = type;
    }

    @Override
    public void setColumn(String colName) {
        this.column = colName;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public String getAggr() {
        return this.aggr;
    }

    @Override
    public void setAggr(String aggr) {
        this.aggr = aggr;
    }

    @Override
    public String getColorForValue(Double value) {
        double shade = value > this.maxValue ? 1.0 : (value < this.minValue ? 0.0 : (value - this.minValue) / (this.maxValue - this.minValue));
        Color c = Color.getHSBColor(0.0f, 0.0f, 0.0f);
        if (this.type.equals((Object)TransitionType.GREEN_TO_RED)) {
            c = TransitionHeatmap.getColorHSB(1.0 - shade);
        } else if (this.type.equals((Object)TransitionType.RED_TO_GREEN)) {
            c = TransitionHeatmap.getColorHSB(shade);
        } else if (this.type.equals((Object)TransitionType.WHITE_TO_BLACK)) {
            c = TransitionHeatmap.getColorBW(1.0 - shade);
        } else if (this.type.equals((Object)TransitionType.BLACK_TO_WHITE)) {
            c = TransitionHeatmap.getColorBW(shade);
        }
        String red = ColorTransitions.getHTMLHex(String.valueOf(Integer.toHexString(c.getRed())));
        String green = ColorTransitions.getHTMLHex(String.valueOf(Integer.toHexString(c.getGreen())));
        String blue = ColorTransitions.getHTMLHex(String.valueOf(Integer.toHexString(c.getBlue())));
        return red + green + blue;
    }

    private static Color getColorHSB(double color) {
        double H = color * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    private static Color getColorBW(double color) {
        float shade = (float)color;
        return new Color(shade, shade, shade);
    }

    @Override
    public Heatmap.HeatmapType getHeatmapType() {
        return Heatmap.HeatmapType.HEAT_TRANSITION;
    }

    public static enum TransitionType {
        BLACK_TO_WHITE,
        WHITE_TO_BLACK,
        GREEN_TO_RED,
        RED_TO_GREEN;

    }
}

