/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.pak;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import quadbase.common.pak.AbstractFilePacker;
import quadbase.common.util.internal.QbUtil;
import quadbase.maps.QbMap;
import quadbase.maps.googlemaps.GoogleMap;
import quadbase.maps.svgmaps.SvgMap;

public class MapPacker
extends AbstractFilePacker {
    public static final String DRILLDOWN_PREFIX = "drilldown-";
    public static final String TOOLTIP_PREFIX = "tooltip-";
    public static final String COORDINATES_PREFIX = "coord-";
    public static final String SVG_IMAGE_PREFIX = "svg-";

    public MapPacker(String mapFilePath, String username) {
        super(mapFilePath, username);
        this.PAK_TYPE = 2;
    }

    @Override
    protected void readAllPaths() throws Exception {
        QbMap map = QbMap.readMap(this.mainFilePath);
        this.templatePaths = new Vector();
        this.templateNames = new Vector();
        this.otherFilePaths = new Vector();
        this.otherFileNames = new Vector();
        if (map instanceof GoogleMap) {
            String ttUrl;
            GoogleMap googleMap = (GoogleMap)map;
            String ddUrl = googleMap.getDrilldownUrl();
            if (ddUrl != null) {
                this.templatePaths.add(ddUrl);
                this.templateNames.add(DRILLDOWN_PREFIX + QbUtil.getFileNameForPak(ddUrl));
            }
            if ((ttUrl = googleMap.getTooltipUrl()) != null) {
                this.templatePaths.add(ttUrl);
                this.templateNames.add(TOOLTIP_PREFIX + QbUtil.getFileNameForPak(ttUrl));
            }
            String coordUrl = googleMap.getCoordinatesFilePath();
            this.otherFilePaths.add(coordUrl);
            this.otherFileNames.add(COORDINATES_PREFIX + QbUtil.getFileNameForPak(coordUrl));
        } else if (map instanceof SvgMap) {
            SvgMap svgMap = (SvgMap)map;
            String ddUrl = svgMap.getDrilldownUrl();
            if (ddUrl != null) {
                this.templatePaths.add(ddUrl);
                this.templateNames.add(DRILLDOWN_PREFIX + QbUtil.getFileNameForPak(ddUrl));
            }
            this.addImagePathsForSvgMap(svgMap);
        }
    }

    private void addImagePathsForSvgMap(SvgMap svgMap) {
        String imagePath = svgMap.getImagePath();
        this.otherFilePaths.add(imagePath);
        this.otherFileNames.add(SVG_IMAGE_PREFIX + QbUtil.getFileNameForPak(imagePath));
        if (svgMap.getMapImageIdParameterName() != null) {
            File[] imageFiles;
            File mainImageFile = new File(imagePath);
            final String imageFilenamePrefix = this.getImageFilenamePrefix(mainImageFile.getName());
            File imageDirectory = mainImageFile.getParentFile();
            for (File imageFile : imageFiles = imageDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(imageFilenamePrefix);
                }
            })) {
                this.otherFilePaths.add(imageFile.getAbsolutePath());
                this.otherFileNames.add(SVG_IMAGE_PREFIX + QbUtil.getFileNameForPak(imageFile.getAbsolutePath()));
            }
        }
    }

    private String getImageFilenamePrefix(String name) {
        String nameWithoutExtension = QbUtil.getFileNameWithoutExtension(name);
        int idx = nameWithoutExtension.lastIndexOf(95);
        if (idx < 0) {
            return nameWithoutExtension;
        }
        return nameWithoutExtension.substring(0, idx + 1);
    }
}

