/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.pak;

import quadbase.common.pak.AbstractReferencesUpdater;
import quadbase.common.pak.PakEntry;
import quadbase.common.util.internal.QbUtil;
import quadbase.maps.QbMap;
import quadbase.maps.googlemaps.GoogleMap;
import quadbase.maps.svgmaps.SvgMap;

public class MapReferencesUpdater
extends AbstractReferencesUpdater {
    public MapReferencesUpdater(PakEntry mainPakEntry) {
        this.mainPakEntry = mainPakEntry;
    }

    @Override
    public void updateReferences(PakEntry[] originalPakEntries, PakEntry[] newPakEntries) throws Exception {
        String path = this.mainPakEntry.getFullDiskPath();
        QbMap map = QbMap.readMap(path, true);
        if (map instanceof GoogleMap) {
            String ttUrl;
            GoogleMap googleMap = (GoogleMap)map;
            String ddUrl = googleMap.getDrilldownUrl();
            if (ddUrl != null) {
                PakEntry pakEntry = this.getPakEntryByName(newPakEntries, "drilldown-", ddUrl);
                googleMap.setDrilldownUrl(pakEntry.getFullDiskPath());
            }
            if ((ttUrl = googleMap.getTooltipUrl()) != null) {
                PakEntry pakEntry = this.getPakEntryByName(newPakEntries, "tooltip-", ttUrl);
                googleMap.setTooltipUrl(QbUtil.fixUrlString(pakEntry.getFullDiskPath()));
            }
            String coordUrl = googleMap.getCoordinatesFilePath();
            PakEntry pakEntry = this.getPakEntryByName(newPakEntries, "coord-", coordUrl);
            googleMap.setCoordinates(pakEntry.getFullDiskPath());
        } else if (map instanceof SvgMap) {
            SvgMap svgMap = (SvgMap)map;
            String ddUrl = svgMap.getDrilldownUrl();
            if (ddUrl != null) {
                PakEntry pakEntry = this.getPakEntryByName(newPakEntries, "drilldown-", ddUrl);
                svgMap.setDrilldownUrl(pakEntry.getFullDiskPath());
            }
            String imageUrl = svgMap.getImagePath();
            PakEntry pakEntry = this.getPakEntryByName(newPakEntries, "svg-", imageUrl);
            svgMap.setImagePath(pakEntry.getFullDiskPath());
        }
        map.save(path);
    }

    private PakEntry getPakEntryByName(PakEntry[] newPakEntries, String prefix, String path) throws Exception {
        String nameForPak = QbUtil.getFileNameForPak(path);
        nameForPak = QbUtil.getFileNameWithoutExtension(nameForPak);
        return this.getPakEntryByName(newPakEntries, prefix + nameForPak);
    }
}

