/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.svgmaps;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.dom.svg.SVGGraphicsElement;
import org.apache.batik.gvt.GVTTreeWalker;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGElement;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import quadbase.maps.svgmaps.SvgMap;

public class ImageMapTranscoder
extends SVGAbstractTranscoder {
    private static final Logger LOGGER = Logger.getLogger(ImageMapTranscoder.class.getName());
    private static final String XHTML_URI = "http://www.w3.org/1999/xhtml";
    private static final String CDATA = "CDATA";
    private static final String AREA_TAG = "area";
    private static final String MAP_TAG = "map";
    private static final String TITLE_ATTR = "title";
    private static final String ALT_ATTR = "alt";
    private static final String AREA_TAG_SHAPE_ATTR = "shape";
    private static final String AREA_TAG_SHAPE_ATTR_POLY = "poly";
    private static final String AREA_TAG_COORDS_ATTR = "coords";
    private static final String AREA_TAG_ONMOUSEOVER_ATTR = "onmouseover";
    private static final String AREA_TAG_ONMOUSEOUT_ATTR = "onmouseout";
    private static final String AREA_TAG_ONCLICK_ATTR = "onclick";
    private static final String AREA_TAG_HREF_ATTR = "href";
    private static final String AREA_TAG_TARGET_ATTR = "target";
    private String mapName;
    private SvgMap svgMap;
    private Set areaObjects;
    private double docWidth = -1.0;
    private double docHeight = -1.0;
    private double mapImageWidth = -1.0;
    private double mapImageHeight = -1.0;

    public ImageMapTranscoder(String mapName, SvgMap svgMap, Set drilldownObjects) {
        this.mapName = mapName;
        this.svgMap = svgMap;
        this.areaObjects = drilldownObjects;
    }

    public double getWidth() {
        return this.docWidth;
    }

    public double getHeight() {
        return this.docHeight;
    }

    public double getMapImageWidth() {
        return this.mapImageWidth;
    }

    public double getMapImageHeight() {
        return this.mapImageHeight;
    }

    private SAXTransformerFactory getTransformerHandlerFactory() {
        return (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    }

    private TransformerHandler getTransformerHandler(TranscoderOutput output) throws TransformerConfigurationException {
        SAXTransformerFactory tfactory = this.getTransformerHandlerFactory();
        if (tfactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tfactory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
            TransformerHandler ch = tfactory.newTransformerHandler();
            ch.setResult(new StreamResult(output.getOutputStream()));
            return ch;
        }
        return null;
    }

    private void configureTransformer(Transformer t) {
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("media-type", "text/xml");
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.setOutputProperty("method", "xml");
    }

    private void setTitle(SVGElement element, AttributesImpl att) {
        String s = element.getId();
        if (s != null && !s.equals("")) {
            att.addAttribute("", TITLE_ATTR, TITLE_ATTR, CDATA, s.replaceAll("_", " "));
        }
    }

    private void setAlt(SVGElement element, AttributesImpl att) {
        String s = element.getId();
        if (s == null) {
            s = "";
        }
        att.addAttribute("", ALT_ATTR, ALT_ATTR, CDATA, s.replaceAll("_", " "));
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        GraphicsNode gn;
        TransformerHandler filter;
        long start = System.currentTimeMillis();
        super.transcode(document, uri, output);
        this.docWidth = this.ctx.getDocumentSize().getWidth();
        this.docHeight = this.ctx.getDocumentSize().getHeight();
        this.curTxf.preConcatenate(this.svgMap.getAdditionalTransform((float)(this.docWidth / this.docHeight)));
        Rectangle2D.Float boundingBox = new Rectangle2D.Float(0.0f, 0.0f, (float)this.docWidth, (float)this.docHeight);
        Shape transformedShape = this.curTxf.createTransformedShape(boundingBox);
        Rectangle2D bounds = transformedShape.getBounds2D();
        this.mapImageWidth = bounds.getWidth();
        this.mapImageHeight = bounds.getHeight();
        try {
            filter = this.getTransformerHandler(output);
        }
        catch (TransformerConfigurationException ex) {
            throw new TranscoderException((Exception)ex);
        }
        this.configureTransformer(filter.getTransformer());
        AttributesImpl myatt = new AttributesImpl();
        if (this.mapName != null) {
            myatt.addAttribute("", "name", "name", CDATA, this.mapName);
            myatt.addAttribute("", "id", "id", CDATA, this.mapName);
        }
        try {
            filter.startDocument();
            filter.startElement(XHTML_URI, MAP_TAG, MAP_TAG, myatt);
        }
        catch (SAXException ex) {
            throw new TranscoderException((Exception)ex);
        }
        this.ctx.setDynamic(true);
        GVTTreeWalker walker = new GVTTreeWalker(this.builder.build(this.ctx, document.getDocumentElement()));
        while ((gn = walker.nextGraphicsNode()) != null) {
            SVGElement tmpE = (SVGElement)this.ctx.getElement(gn);
            if (!(tmpE instanceof SVGGraphicsElement)) continue;
            String linkAttribute = tmpE.getAttributeNS("http://www.w3.org/1999/xlink", AREA_TAG_HREF_ATTR);
            if (tmpE.getLocalName().equals("image") || "".equals(linkAttribute)) {
                linkAttribute = null;
            }
            SVGGraphicsElement e = (SVGGraphicsElement)tmpE;
            if (linkAttribute == null && !this.areaObjects.contains(e)) continue;
            Area area = new Area(gn.getOutline());
            AffineTransform transform = gn.getGlobalTransform();
            transform.preConcatenate(this.curTxf);
            String coords = "";
            int[] lastpoints = null;
            PathIterator path = area.getPathIterator(transform, 1.0);
            while (!path.isDone()) {
                block24: {
                    float[] points = new float[6];
                    int seg = path.currentSegment(points);
                    int[] newpoints = new int[]{Math.round(points[0]), Math.round(points[1])};
                    switch (seg) {
                        case 4: {
                            if (coords.equals("")) break;
                            AttributesImpl att = new AttributesImpl();
                            att.addAttribute("", AREA_TAG_SHAPE_ATTR, AREA_TAG_SHAPE_ATTR, CDATA, AREA_TAG_SHAPE_ATTR_POLY);
                            att.addAttribute("", AREA_TAG_COORDS_ATTR, AREA_TAG_COORDS_ATTR, CDATA, coords);
                            if (this.areaObjects.contains(e)) {
                                att.addAttribute("", AREA_TAG_ONMOUSEOVER_ATTR, AREA_TAG_ONMOUSEOVER_ATTR, CDATA, "if (drilldownUrl != null) this.href='javascript:void(0)'");
                                att.addAttribute("", AREA_TAG_ONMOUSEOUT_ATTR, AREA_TAG_ONMOUSEOUT_ATTR, CDATA, "this.removeAttribute('href')");
                                att.addAttribute("", AREA_TAG_ONCLICK_ATTR, AREA_TAG_ONCLICK_ATTR, CDATA, "drilldown(\"" + e.getId() + "\"); return false");
                                this.setTitle((SVGElement)e, att);
                                this.setAlt((SVGElement)e, att);
                            } else if (linkAttribute != null) {
                                att.addAttribute("", AREA_TAG_HREF_ATTR, AREA_TAG_HREF_ATTR, CDATA, linkAttribute);
                                att.addAttribute("", AREA_TAG_TARGET_ATTR, AREA_TAG_TARGET_ATTR, CDATA, "_blank");
                            }
                            try {
                                filter.startElement(XHTML_URI, AREA_TAG, AREA_TAG, att);
                                filter.endElement(XHTML_URI, AREA_TAG, AREA_TAG);
                            }
                            catch (SAXException ex) {
                                throw new TranscoderException((Exception)ex);
                            }
                            coords = "";
                            lastpoints = null;
                            break;
                        }
                        case 3: {
                            throw new TranscoderException("Cubic segment not allowed in flattened path");
                        }
                        case 2: {
                            throw new TranscoderException("Quad segment not allowed in flattened path");
                        }
                        case 1: {
                            if (coords.equals("")) {
                                throw new TranscoderException("Line segment not allowed at begin of path");
                            }
                            if (newpoints.equals(lastpoints)) break;
                            coords = coords + "," + newpoints[0] + "," + newpoints[1];
                            break;
                        }
                        case 0: {
                            if (coords.equals("")) {
                                coords = newpoints[0] + "," + newpoints[1];
                                break;
                            }
                            break block24;
                        }
                        default: {
                            throw new TranscoderException("Unknown segment with type number " + seg);
                        }
                    }
                    lastpoints = newpoints;
                }
                path.next();
            }
        }
        try {
            filter.endElement(XHTML_URI, MAP_TAG, MAP_TAG);
            filter.endDocument();
        }
        catch (SAXException ex) {
            throw new TranscoderException((Exception)ex);
        }
        LOGGER.finer("ImageMapTranscoder.transcode took " + (System.currentTimeMillis() - start) + " ms");
    }
}

