/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.svgmaps;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.png.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.png.PNGImageEncoder;
import org.apache.batik.ext.awt.image.rendered.IndexImage;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.PaintKey;
import org.w3c.dom.Document;
import quadbase.maps.svgmaps.SvgMap;

public class PNGTranscoderWithLegend
extends SVGAbstractTranscoder {
    private static final Logger LOGGER = Logger.getLogger(PNGTranscoderWithLegend.class.getName());
    private SvgMap svgMap;
    public static final TranscodingHints.Key KEY_GAMMA = new FloatKey();
    public static final TranscodingHints.Key KEY_INDEXED = new BooleanKey();
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR = new PaintKey();
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();

    public PNGTranscoderWithLegend(SvgMap svgMap) {
        this.hints.put((Object)ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE, (Object)Boolean.FALSE);
        this.svgMap = svgMap;
    }

    public BufferedImage createImage(int i, int j) {
        return new BufferedImage(i, j, 2);
    }

    public void writeImage(BufferedImage bufferedimage, TranscoderOutput transcoderoutput) throws TranscoderException {
        PNGEncodeParam pngencodeparam;
        OutputStream outputstream = transcoderoutput.getOutputStream();
        if (outputstream == null) {
            throw new TranscoderException(Messages.formatMessage((String)"png.badoutput", null));
        }
        boolean flag = false;
        if (this.hints.containsKey((Object)ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
            flag = (Boolean)this.hints.get((Object)ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (flag) {
            int i = bufferedimage.getWidth();
            int j = bufferedimage.getHeight();
            DataBufferInt databufferint = (DataBufferInt)bufferedimage.getRaster().getDataBuffer();
            int l = ((SinglePixelPackedSampleModel)bufferedimage.getSampleModel()).getScanlineStride();
            int i1 = databufferint.getOffset();
            int[] ai = databufferint.getBankData()[0];
            int j1 = i1;
            int k1 = l - i;
            for (int i3 = 0; i3 < j; ++i3) {
                for (int j3 = 0; j3 < i; ++j3) {
                    int l2 = ai[j1];
                    int l1 = l2 >> 24 & 0xFF;
                    int i2 = l2 >> 16 & 0xFF;
                    int j2 = l2 >> 8 & 0xFF;
                    int k2 = l2 & 0xFF;
                    i2 = (255 * (255 - l1) + l1 * i2) / 255;
                    j2 = (255 * (255 - l1) + l1 * j2) / 255;
                    k2 = (255 * (255 - l1) + l1 * k2) / 255;
                    ai[j1++] = l1 << 24 & 0xFF000000 | i2 << 16 & 0xFF0000 | j2 << 8 & 0xFF00 | k2 & 0xFF;
                }
                j1 += k1;
            }
        }
        if (this.hints.containsKey((Object)KEY_INDEXED) && ((Boolean)this.hints.get((Object)KEY_INDEXED)).booleanValue()) {
            bufferedimage = IndexImage.getIndexedImage((BufferedImage)bufferedimage, (int)256);
        }
        if ((pngencodeparam = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)bufferedimage)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)pngencodeparam).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (this.hints.containsKey((Object)KEY_GAMMA)) {
            pngencodeparam.setGamma(((Float)this.hints.get((Object)KEY_GAMMA)).floatValue());
        }
        pngencodeparam.setSRGBIntent(0);
        float f = this.userAgent.getPixelUnitToMillimeter();
        int k = (int)((double)(1000.0f / f) + 0.5);
        pngencodeparam.setPhysicalDimension(k, k, 1);
        try {
            PNGImageEncoder pngimageencoder = new PNGImageEncoder(outputstream, pngencodeparam);
            pngimageencoder.encode((RenderedImage)bufferedimage);
            outputstream.close();
        }
        catch (IOException ioexception) {
            throw new TranscoderException((Exception)ioexception);
        }
    }

    protected void transcode(Document document, String s, TranscoderOutput transcoderoutput) throws TranscoderException {
        long start = System.currentTimeMillis();
        super.transcode(document, s, transcoderoutput);
        int i = (int)((double)this.width + 0.5);
        int j = (int)((double)this.height + 0.5);
        ConcreteImageRendererFactory concreteimagerendererfactory = new ConcreteImageRendererFactory();
        ImageRenderer imagerenderer = concreteimagerendererfactory.createStaticImageRenderer();
        imagerenderer.updateOffScreen(i, j);
        double docWidth = this.ctx.getDocumentSize().getWidth();
        double docHeight = this.ctx.getDocumentSize().getHeight();
        this.curTxf.preConcatenate(this.svgMap.getAdditionalTransform((float)(docWidth / docHeight)));
        imagerenderer.setTransform(this.curTxf);
        imagerenderer.setTree(this.root);
        this.root = null;
        try {
            Rectangle2D.Float float1 = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            imagerenderer.repaint(this.curTxf.createInverse().createTransformedShape(float1));
            BufferedImage bufferedimage = imagerenderer.getOffScreen();
            BufferedImage bufferedimage1 = this.createImage(i, j);
            Graphics2D graphics2d = GraphicsUtil.createGraphics((BufferedImage)bufferedimage1);
            if (this.hints.containsKey((Object)KEY_BACKGROUND_COLOR)) {
                Paint paint = (Paint)this.hints.get((Object)KEY_BACKGROUND_COLOR);
                graphics2d.setComposite(AlphaComposite.SrcOver);
                graphics2d.setPaint(paint);
                graphics2d.fillRect(0, 0, i, j);
            }
            this.svgMap.drawAdditionalGraphics(graphics2d);
            if (bufferedimage != null) {
                graphics2d.drawRenderedImage(bufferedimage, new AffineTransform());
            }
            this.writeImage(bufferedimage1, transcoderoutput);
            graphics2d.dispose();
        }
        catch (Exception exception) {
            throw new TranscoderException(exception);
        }
        LOGGER.finer("PNGTranscoderWithLegend.transcode took " + (System.currentTimeMillis() - start) + " ms");
    }
}

