/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.svgmaps;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.w3c.dom.Document;
import quadbase.common.util.internal.DoNothingOutputStream;
import quadbase.maps.svgmaps.ImageMapTranscoder;
import quadbase.maps.svgmaps.SvgMap;

public class SVGSizeGetter
extends SVGAbstractTranscoder {
    private static final Logger LOGGER = Logger.getLogger(SVGSizeGetter.class.getName());
    private double docWidth = -1.0;
    private double docHeight = -1.0;
    private double mapImageWidth = -1.0;
    private double mapImageHeight = -1.0;

    public SVGSizeGetter(SvgMap svgMap) throws TranscoderException {
        if (svgMap.getMapHeight() != -1) {
            this.addTranscodingHint(ImageMapTranscoder.KEY_HEIGHT, Float.valueOf(svgMap.getMapHeight()));
        }
        if (svgMap.getMapWidth() != -1) {
            this.addTranscodingHint(ImageMapTranscoder.KEY_WIDTH, Float.valueOf(svgMap.getMapWidth()));
        }
        this.addTranscodingHint(ImageMapTranscoder.KEY_MAINTAIN_ASPECT_RATIO, Boolean.FALSE);
        this.transcode(new TranscoderInput(svgMap.svgDoc), new TranscoderOutput((OutputStream)new DoNothingOutputStream()));
    }

    public double getWidth() {
        return this.docWidth;
    }

    public double getHeight() {
        return this.docHeight;
    }

    public double getMapImageWidth() {
        return this.mapImageWidth;
    }

    public double getMapImageHeight() {
        return this.mapImageHeight;
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        long start = System.currentTimeMillis();
        super.transcode(document, uri, output);
        this.docWidth = this.ctx.getDocumentSize().getWidth();
        this.docHeight = this.ctx.getDocumentSize().getHeight();
        Rectangle2D.Float boundingBox = new Rectangle2D.Float(0.0f, 0.0f, (float)this.docWidth, (float)this.docHeight);
        Shape transformedShape = this.curTxf.createTransformedShape(boundingBox);
        Rectangle2D bounds = transformedShape.getBounds2D();
        this.mapImageWidth = bounds.getWidth();
        this.mapImageHeight = bounds.getHeight();
        LOGGER.finer("SVGSizeGetter.transcode took " + (System.currentTimeMillis() - start) + " ms");
    }
}

