/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.svgmaps;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.maps.svgmaps.SvgMap;
import quadbase.maps.svgmaps.SvgResizableCanvas;

public class SvgLegend {
    private final SvgMap svgMap;
    public static final short LAYOUT_HORIZONTAL = 0;
    public static final short LAYOUT_VERTICAL = 1;
    public static final short POSITION_LEFT = 0;
    public static final short POSITION_RIGHT = 1;
    public static final short POSITION_TOP = 2;
    public static final short POSITION_BOTTOM = 3;
    static final float GAP = 10.0f;
    static final float PADDING = 10.0f;
    private Font font = new Font("Arial", 0, 12);
    private Color fontColor = Color.black;
    private Color borderColor = new Color(0, 0, 1);
    private short layout = 1;
    private short position = 1;
    private String[] text;
    protected float width;
    protected float height;
    protected float x;
    protected float y;
    private SvgResizableCanvas resizableCanvas = new SvgResizableCanvas();
    private int rows;
    private int columns;
    private int[] colWidths;

    public SvgLegend(SvgMap svgMap, String[] text, short layout, short position) {
        this.svgMap = svgMap;
        this.text = text;
        this.layout = layout;
        this.position = position;
    }

    public static SvgLegend readXML(SvgMap svgMap, Element element) throws Exception {
        NodeList list = element.getElementsByTagName("legend");
        if (list == null || list.getLength() == 0) {
            return null;
        }
        Element e = (Element)list.item(0);
        short layout = Short.parseShort(e.getAttribute("layout"));
        short position = Short.parseShort(e.getAttribute("position"));
        NodeList textList = e.getElementsByTagName("text");
        String[] texts = new String[textList.getLength()];
        for (int i = 0; i < textList.getLength(); ++i) {
            Node n = ((Element)textList.item(i)).getFirstChild();
            texts[i] = n instanceof CDATASection ? ((CDATASection)n).getData() : "";
        }
        return new SvgLegend(svgMap, texts, layout, position);
    }

    public void writeXML(Element element) {
        Document doc = element.getOwnerDocument();
        Element e = doc.createElement("legend");
        element.appendChild(e);
        e.setAttribute("layout", this.layout + "");
        e.setAttribute("position", this.position + "");
        for (String element2 : this.text) {
            Element t = doc.createElement("text");
            e.appendChild(t);
            CDATASection data = doc.createCDATASection(element2);
            t.appendChild(data);
        }
    }

    public void drawLegend(Graphics2D g2d) {
        if (!this.canDisplay()) {
            return;
        }
        AffineTransform originalTransform = g2d.getTransform();
        g2d.translate(this.x, this.y);
        g2d.setPaint(this.borderColor);
        g2d.draw(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height));
        g2d.setFont(this.font);
        FontMetrics fm = g2d.getFontMetrics(this.font);
        int squareSize = fm.getAscent();
        g2d.translate(10.0, 10.0);
        if (this.layout == 1) {
            float shiftY = 1.5f * (float)squareSize;
            float currentX = 0.0f;
            int i = 0;
            for (int col = 0; col < this.columns; ++col) {
                for (int row = 0; row < this.rows && i < Math.min(this.text.length, this.svgMap.color.length); ++row, ++i) {
                    Rectangle2D.Double square = new Rectangle2D.Double(currentX, (float)row * shiftY, squareSize, squareSize);
                    g2d.setPaint(this.svgMap.color[i]);
                    g2d.fill(square);
                    g2d.setPaint(this.fontColor);
                    g2d.draw(square);
                    g2d.drawString(this.text[i], currentX + 10.0f + (float)squareSize, (float)((double)((float)row * shiftY) + (double)squareSize * 0.9));
                }
                currentX += 20.0f + (float)squareSize + (float)this.colWidths[col];
            }
        } else {
            float shiftY = 1.5f * (float)squareSize;
            int i = 0;
            for (int row = 0; row < this.rows; ++row) {
                float currentX = 0.0f;
                for (int col = 0; col < this.columns && i < this.text.length; ++col, ++i) {
                    Rectangle2D.Double square = new Rectangle2D.Double(currentX, (float)row * shiftY, squareSize, squareSize);
                    g2d.setPaint(this.svgMap.color[i]);
                    g2d.fill(square);
                    g2d.setPaint(this.fontColor);
                    g2d.draw(square);
                    g2d.drawString(this.text[i], currentX + 10.0f + (float)squareSize, (float)((double)((float)row * shiftY) + (double)squareSize * 0.9));
                    currentX += 20.0f + (float)squareSize + (float)this.colWidths[col];
                }
            }
        }
        g2d.setTransform(originalTransform);
    }

    public boolean computePosition() {
        SVGGraphics2D g = new SVGGraphics2D(this.svgMap.svgDoc);
        FontMetrics fm = g.getFontMetrics(this.font);
        int squareSize = fm.getAscent();
        if (this.svgMap.getMapHeight() == -1 || this.svgMap.getMapWidth() == -1) {
            return true;
        }
        if (this.layout == 1) {
            float shiftY = 1.5f * (float)squareSize;
            int mapHeight = this.svgMap.getMapImageHeight();
            if (mapHeight <= 0) {
                mapHeight = this.svgMap.getMapHeight();
            }
            this.rows = this.position == 0 || this.position == 1 ? mapHeight / (int)(30.0f + shiftY) : mapHeight / 2 / (int)(30.0f + shiftY);
            if (this.rows < 1) {
                return false;
            }
            this.columns = (int)Math.ceil((float)this.text.length / (float)this.rows);
            this.rows = (int)Math.ceil((float)this.text.length / (float)this.columns);
            this.width = 10.0f;
            this.height = 10.0f;
            int i = 0;
            this.colWidths = new int[this.columns];
            for (int col = 0; col < this.columns; ++col) {
                this.colWidths[col] = 0;
                for (int row = 0; row < this.rows && i < this.text.length; ++row, ++i) {
                    int w;
                    if (col == 0) {
                        this.height += shiftY;
                    }
                    if ((w = fm.stringWidth(this.text[i])) <= this.colWidths[col]) continue;
                    this.colWidths[col] = w;
                }
                this.width += 20.0f + (float)squareSize + (float)this.colWidths[col];
            }
        } else {
            int maxWidth = 0;
            int[] widths = new int[this.text.length];
            for (int i = 0; i < this.text.length; ++i) {
                widths[i] = fm.stringWidth(this.text[i]);
                if (widths[i] <= maxWidth) continue;
                maxWidth = widths[i];
            }
            this.columns = this.position == 3 || this.position == 2 ? this.svgMap.getMapImageWidth() / (int)(20.0f + (float)squareSize + (float)maxWidth) : this.svgMap.getMapImageWidth() / 2 / (int)(20.0f + (float)squareSize + (float)maxWidth);
            this.rows = (int)Math.ceil((float)this.text.length / (float)this.columns);
            this.columns = (int)Math.ceil((float)this.text.length / (float)this.rows);
            this.colWidths = new int[this.columns];
            for (int col = 0; col < this.columns; ++col) {
                this.colWidths[col] = 0;
                for (int row = 0; row < this.rows; ++row) {
                    if (row * this.columns + col >= this.text.length || widths[row * this.columns + col] <= this.colWidths[col]) continue;
                    this.colWidths[col] = widths[row * this.columns + col];
                }
            }
            this.width = 10.0f;
            for (int colWidth : this.colWidths) {
                this.width += (float)squareSize + 20.0f + (float)colWidth;
            }
            this.height = 10.0f + (float)this.rows * 1.5f * (float)squareSize;
        }
        if (!this.willFit(this.width, this.height)) {
            this.width = -1.0f;
            this.height = -1.0f;
            this.x = -1.0f;
            this.y = -1.0f;
            this.resizableCanvas.setResize(0.0f, 0.0f, 0.0f, 0.0f);
            return false;
        }
        if (this.position == 1) {
            this.x = (float)this.svgMap.getMapImageWidth() + 10.0f;
            this.y = ((float)this.svgMap.getMapImageHeight() - this.height) / 2.0f;
            this.resizableCanvas.setResize(0.0f, 20.0f + this.width, 0.0f, 0.0f);
        } else if (this.position == 0) {
            this.x = 10.0f;
            this.y = ((float)this.svgMap.getMapImageHeight() - this.height) / 2.0f;
            this.resizableCanvas.setResize(20.0f + this.width, 0.0f, 0.0f, 0.0f);
        } else if (this.position == 3) {
            this.x = ((float)this.svgMap.getMapImageWidth() - this.width) / 2.0f;
            this.y = (float)this.svgMap.getMapImageHeight() + 10.0f;
            this.resizableCanvas.setResize(0.0f, 0.0f, 0.0f, 20.0f + this.height);
        } else {
            this.x = ((float)this.svgMap.getMapImageWidth() - this.width) / 2.0f;
            this.y = 10.0f;
            this.resizableCanvas.setResize(0.0f, 0.0f, 20.0f + this.height, 0.0f);
        }
        return true;
    }

    private boolean willFit(float w, float h) {
        return !(this.position == 2 || this.position == 3 ? w > (float)this.svgMap.getMapImageWidth() - 20.0f || h > (float)(this.svgMap.getMapImageHeight() / 2) : w > (float)(this.svgMap.getMapImageWidth() / 2) || h > (float)this.svgMap.getMapImageHeight() - 20.0f);
    }

    public SvgResizableCanvas getResizableCanvas() {
        return this.resizableCanvas;
    }

    protected boolean canDisplay() {
        return this.x != -1.0f && this.y != -1.0f && this.width != -1.0f && this.height != -1.0f;
    }

    public short getLayout() {
        return this.layout;
    }

    public short getPosition() {
        return this.position;
    }

    public String[] getText() {
        return this.text;
    }
}

