/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.svgmaps;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGGraphicsElement;
import org.apache.batik.dom.svg.SVGOMCircleElement;
import org.apache.batik.dom.svg.SVGOMEllipseElement;
import org.apache.batik.dom.svg.SVGOMGElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import quadbase.ChartAPI.QbChart;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.pak.PakFileReader;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterGrabber;
import quadbase.common.param.Parameters;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.internal.CssUtil;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.datasource.DataSource;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.maps.MapTitle;
import quadbase.maps.QbMap;
import quadbase.maps.svgmaps.ImageMapTranscoder;
import quadbase.maps.svgmaps.PNGTranscoderWithLegend;
import quadbase.maps.svgmaps.SVGSizeGetter;
import quadbase.maps.svgmaps.SvgLegend;
import quadbase.maps.svgmaps.SvgMapTitle;
import quadbase.maps.svgmaps.SvgResizableCanvas;
import quadbase.reportdesigner.ReportAPI.DataSheet;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.report.ColData;
import quadbase.util.IInputData;
import quadbase.util.IQueryInParam;

public class SvgMap
extends QbMap {
    private static final Logger LOGGER = Logger.getLogger(SvgMap.class.getName());
    public static final String EXTENSION = ".sxml";
    public static final String PAK_EXTENSION = ".spak";
    private static final String MAP_NAME = "map";
    public static final String TAG = SvgMap.class.getSimpleName();
    private Double maxVal;
    private ThresholdMode thresholdMode;
    private String pakFileName = null;
    private DataSource datasource;
    private String mapImagePath;
    private int idColumn;
    private Comparable[] threshold = null;
    Color[] color = null;
    private HashMap triggeredAlertDetails;
    private int thresholdColumn = -1;
    private int width = -1;
    private int height = -1;
    private int mapImageWidth = -1;
    private int mapImageHeight = -1;
    private String drilldownType = "report";
    private String drilldownUrl;
    Document svgDoc;
    private String imageMap = "<map id=\" + MAP_NAME + \" name = \"map\"></map>";
    private DataSheet dataSheet;
    private HashMap originalColors = new HashMap();
    private HashSet drilldownObjects = new HashSet();
    private SvgLegend legend = null;
    private SvgMapTitle title = null;
    private String mapImageIdParameterName;
    private int[] tooltipColumnIndexes;
    private boolean isAdmin;

    public SvgMap(DataSource datasource, String mapImagePath, String mapImageIdParameterName) throws Exception {
        this.setMapImageIdParameterName(mapImageIdParameterName);
        this.datasource = datasource;
        this.mapImagePath = mapImagePath;
        this.dataSheet = datasource.getDataSheet(0, -1, this.isAdmin);
        this.loadDocument();
    }

    public SvgMap(DataSource datasource, String mapImagePath, int idColumn) throws Exception {
        this.datasource = datasource;
        this.mapImagePath = mapImagePath;
        this.idColumn = idColumn;
        this.loadDocument();
        this.dataSheet = datasource.getDataSheet(0, -1, this.isAdmin);
        if (idColumn < 0 || idColumn > this.dataSheet.getColumnCount()) {
            throw new IllegalArgumentException("Column with given index does not exists in datasource [" + idColumn + "]");
        }
    }

    public SvgMap(String filepath) throws Exception {
        this(filepath, null);
    }

    @Override
    public String getDefaultExtension() {
        return EXTENSION;
    }

    public SvgMap(String filepath, HashMap parameters) throws Exception {
        this(filepath, parameters, false);
    }

    public SvgMap(String filepath, boolean useBackupData) throws Exception {
        this(filepath, null, useBackupData);
    }

    public SvgMap(String filepath, HashMap parameters, boolean useBackupData) throws Exception {
        this.readFromFile(filepath);
        this.loadDocument();
        if (this.datasource.isParameterized()) {
            ((ParameterizedDataSource)this.datasource).setDefaultParameters();
            ((ParameterizedDataSource)this.datasource).setParameters(parameters);
        }
        if (!useBackupData) {
            this.dataSheet = this.datasource.getDataSheet(0, -1, this.isAdmin);
            this.setColors();
        }
    }

    public SvgMap(InputStream in) throws Exception {
        this(in, null);
    }

    public SvgMap(InputStream in, HashMap parameters) throws Exception {
        this(in, parameters, false);
    }

    public SvgMap(InputStream in, boolean useBackupData) throws Exception {
        this(in, null, useBackupData);
    }

    public SvgMap(InputStream in, HashMap parameters, boolean useBackupData) throws Exception {
        this.readFromInputStream(in);
        this.loadDocument();
        if (this.datasource.isParameterized()) {
            ((ParameterizedDataSource)this.datasource).setDefaultParameters();
            ((ParameterizedDataSource)this.datasource).setParameters(parameters);
        }
        if (!useBackupData) {
            this.dataSheet = this.datasource.getDataSheet(0, -1, this.isAdmin);
            this.setColors();
        }
    }

    public void setColorThresholds(int columnIndex, Comparable[] thresholds, Color[] areaColors, ThresholdMode thresholdMode) {
        if (this.dataSheet == null || areaColors.length == 0) {
            this.threshold = thresholds;
            this.color = areaColors;
            this.setColors();
            try {
                this.refresh();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (columnIndex < 0 || columnIndex > this.dataSheet.getColumnCount()) {
            throw new IllegalArgumentException("Column with given index does not exists in datasource [" + columnIndex + "]");
        }
        if (thresholds.length + 1 != areaColors.length) {
            throw new IllegalArgumentException("areaColors array length has to be thresholds array length + 1");
        }
        for (int i = 0; i < thresholds.length; ++i) {
            if (DataType.match(this.dataSheet.getOriginalDataTypes()[columnIndex], thresholds[i])) continue;
            throw new IllegalArgumentException("Threshold data type does not match the selected data source column");
        }
        this.thresholdColumn = columnIndex;
        this.threshold = thresholds;
        this.color = areaColors;
        this.thresholdMode = thresholdMode;
        this.setColors();
    }

    public Double getMaxForCol(Integer col) {
        if (col == null) {
            LOGGER.finest("Get max value for column: null column number");
            return null;
        }
        if (col == -1) {
            LOGGER.finest("Get max value for column: indefined column (-1)");
            return null;
        }
        try {
            if (col != -1 & this.datasource != null) {
                DataSheet ds = this.datasource.getDataSheet(0, -1, this.isAdmin);
                ColData cd = ds.getColData()[col];
                if (!cd.isNumeric()) {
                    this.maxVal = null;
                }
                if (cd.getSize() > 1) {
                    Comparable maxVal = null;
                    for (int i = 0; i < cd.getSize(); ++i) {
                        if (cd.getData(i) == null) continue;
                        if (maxVal == null) {
                            maxVal = (Comparable)cd.getData(i);
                            continue;
                        }
                        if (maxVal.compareTo(cd.getData(i)) >= 0) continue;
                        maxVal = (Comparable)cd.getData(i);
                    }
                    return ((Number)((Object)maxVal)).doubleValue();
                }
                if (cd.getSize() == 1) {
                    return ((Number)cd.getData(0)).doubleValue();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Cannot get max value for column", e);
        }
        return null;
    }

    public void removeColorThresholds() {
        this.thresholdColumn = -1;
        this.threshold = null;
        this.color = null;
        this.legend = null;
        this.thresholdMode = null;
        this.setColors();
    }

    public void writeImage(OutputStream out) throws Exception {
        SvgLegend lgnd = null;
        if (this.legend != null && !this.legend.computePosition()) {
            lgnd = this.getLegend();
            this.setLegend(null);
        }
        PNGTranscoderWithLegend t = new PNGTranscoderWithLegend(this);
        t.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, Float.valueOf(this.height));
        t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, Float.valueOf(this.width));
        t.addTranscodingHint(ImageMapTranscoder.KEY_MAINTAIN_ASPECT_RATIO, Boolean.FALSE);
        TranscoderInput input = new TranscoderInput(this.svgDoc);
        TranscoderOutput output = new TranscoderOutput(out);
        t.transcode(input, output);
        if (lgnd != null) {
            this.setLegend(lgnd);
        }
    }

    public synchronized String getImageMap() {
        if (this.imageMap == null) {
            this.imageMap = this.createImageMap();
        }
        return this.imageMap;
    }

    public String[] getAllColors() {
        Node n;
        HashSet<String> allColors = new HashSet<String>();
        NodeIterator i = ((DocumentTraversal)((Object)this.svgDoc)).createNodeIterator(this.svgDoc, 1, null, true);
        while ((n = i.nextNode()) != null) {
            String fill;
            if (!(n instanceof SVGOMPathElement) && !(n instanceof SVGOMRectElement) && !(n instanceof SVGOMCircleElement) && !(n instanceof SVGOMEllipseElement) || (fill = CssUtil.getFill((SVGGraphicsElement)n)) == null) continue;
            allColors.add(fill);
        }
        return allColors.toArray(new String[0]);
    }

    public boolean hasMatchingArea() {
        if (this.dataSheet == null) {
            return false;
        }
        if (this.idColumn >= this.dataSheet.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < this.dataSheet.getRowCount(); ++i) {
            Object o = this.dataSheet.getRow(i)[this.idColumn];
            if (o == null || this.svgDoc.getElementById(o.toString()) == null) continue;
            return true;
        }
        return false;
    }

    private void readFromFile(String filePath) throws Exception {
        InputStream in = new ReadDataFile().getInputStream(filePath);
        if (filePath.toLowerCase().endsWith(PAK_EXTENSION)) {
            in = PakFileReader.getMainInputStream(in);
            this.pakFileName = filePath;
        }
        this.readFromInputStream(in);
    }

    private void readFromInputStream(InputStream in) throws Exception {
        NodeList tooltip;
        NodeList ds;
        Attr id;
        Attr h;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("mapReport")) {
            throw new Exception("Missing mapReport element");
        }
        Attr t = root.getAttributeNode("type");
        if (t == null) {
            throw new Exception("Missing type attribute in the mapReport element");
        }
        if (!t.getNodeValue().equals("bitmap")) {
            throw new Exception("Wrong map type: " + t.getNodeValue());
        }
        Attr im = root.getAttributeNode("imageFile");
        if (im == null) {
            throw new Exception("Missing imageFile attribute in the mapReport element");
        }
        this.mapImagePath = ServerMessage.getPath(im.getNodeValue(), this.pakFileName, "svg-");
        Attr w = root.getAttributeNode("width");
        if (w != null) {
            this.width = Integer.parseInt(w.getNodeValue());
        }
        if ((h = root.getAttributeNode("height")) != null) {
            this.height = Integer.parseInt(h.getNodeValue());
        }
        if ((id = root.getAttributeNode("idColumn")) == null) {
            throw new Exception("Missing idColumn attribute in the mapReport element");
        }
        this.idColumn = Integer.parseInt(id.getNodeValue());
        Attr mapImageIdParameterNameNode = root.getAttributeNode("mapImageIdParameterName");
        if (mapImageIdParameterNameNode != null && !QbUtil.isNullOrEmpty(mapImageIdParameterNameNode.getNodeValue())) {
            this.mapImageIdParameterName = mapImageIdParameterNameNode.getNodeValue();
        }
        if ((ds = doc.getElementsByTagName("datasource")).getLength() == 0) {
            throw new Exception("Missing datasource element");
        }
        this.datasource = DataSource.readDataSource((Element)ds.item(0));
        if (this.datasource.isParameterized()) {
            ((ParameterizedDataSource)this.datasource).setDefaultParameters();
        }
        this.dataSheet = this.datasource.getDataSheet(0, -1, this.isAdmin);
        NodeList drilldown = doc.getElementsByTagName("drilldown");
        if (drilldown.getLength() > 0) {
            Element drill = (Element)drilldown.item(0);
            Attr tmpNode = drill.getAttributeNode("type");
            if (tmpNode != null) {
                String tmpValue = tmpNode.getNodeValue();
                if (tmpValue.equals("report") || tmpValue.equals("chart") || tmpValue.equals(MAP_NAME) || tmpValue.equals("easyreport")) {
                    this.drilldownType = tmpValue;
                } else {
                    throw new Exception("Wrong drilldown type (" + tmpValue + ")");
                }
            }
            if ((tmpNode = drill.getAttributeNode("url")) == null) {
                throw new Exception("Missing url attribute in the drilldown element");
            }
            this.drilldownUrl = ServerMessage.getPath(tmpNode.getNodeValue(), this.pakFileName, "drilldown-");
            if (this.pakFileName != null) {
                this.drilldownUrl = this.setPakExtension(this.drilldownUrl, this.drilldownType);
            }
        }
        if ((tooltip = doc.getElementsByTagName("tooltip")).getLength() == 0) {
            this.tooltipColumnIndexes = null;
        } else {
            Element tt = (Element)tooltip.item(0);
            NodeList indexes = tt.getElementsByTagName("index");
            if (indexes.getLength() > 0) {
                this.tooltipColumnIndexes = new int[indexes.getLength()];
                for (int i = 0; i < indexes.getLength(); ++i) {
                    this.tooltipColumnIndexes[i] = Integer.parseInt(indexes.item(i).getFirstChild().getNodeValue());
                }
            }
        }
        NodeList thresh = doc.getElementsByTagName("thresholds");
        if (thresh.getLength() != 0) {
            Element th = (Element)thresh.item(0);
            Attr dt = th.getAttributeNode("dataType");
            if (dt == null) {
                throw new Exception("Missing dataType attribute in the thresholds element.");
            }
            int thresholdDataType = Integer.parseInt(dt.getNodeValue());
            Attr tc = th.getAttributeNode("thresholdColumn");
            if (tc == null) {
                throw new Exception("Missing thresholdColumn attribute in the thresholds element.");
            }
            this.thresholdColumn = Integer.parseInt(tc.getNodeValue());
            Attr tm = th.getAttributeNode("thresholdMode");
            this.thresholdMode = tm == null ? ThresholdMode.abs : SvgMap.getThresholdModeFromStr(tm.getNodeValue());
            NodeList elements = th.getElementsByTagName("threshold");
            if (elements.getLength() > 0) {
                this.threshold = new Comparable[elements.getLength() - 1];
                this.color = new Color[elements.getLength()];
                for (int i = 0; i < elements.getLength(); ++i) {
                    Element e = (Element)elements.item(i);
                    Attr c = e.getAttributeNode("color");
                    if (c == null) {
                        throw new Exception("Missing color attribute in the threshold element");
                    }
                    this.color[i] = new Color(Integer.parseInt(c.getNodeValue()));
                    if (i >= elements.getLength() - 1) continue;
                    Attr val = e.getAttributeNode("value");
                    if (val == null) {
                        throw new Exception("All but last threshold elements must contain value attribute");
                    }
                    this.threshold[i] = (Comparable)DataType.createObject(val.getNodeValue(), thresholdDataType);
                }
            }
        }
        this.legend = SvgLegend.readXML(this, root);
        MapTitle mapTitle = MapTitle.readXML(root);
        this.title = mapTitle == null ? null : new SvgMapTitle(this, mapTitle);
        in.close();
    }

    @Override
    public void save(String filename) throws Exception {
        filename = filename.replace('\\', '/');
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        this.save(bos);
        WriteDataFile writer = new WriteDataFile();
        writer.output(bos.toByteArray(), filename);
        bos.flush();
        bos.close();
    }

    public void save(OutputStream out) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("mapReport");
        doc.appendChild(root);
        root.setAttribute("type", "bitmap");
        root.setAttribute("width", this.width + "");
        root.setAttribute("height", this.height + "");
        root.setAttribute("idColumn", this.idColumn + "");
        if (this.mapImageIdParameterName != null) {
            root.setAttribute("mapImageIdParameterName", this.mapImageIdParameterName);
        }
        root.setAttribute("imageFile", this.createRelativePath(this.mapImagePath));
        Element ds = doc.createElement("datasource");
        this.datasource.writeXML(ds);
        root.appendChild(ds);
        if (this.drilldownUrl != null) {
            Element drilldown = doc.createElement("drilldown");
            root.appendChild(drilldown);
            drilldown.setAttribute("type", this.drilldownType);
            this.drilldownUrl = this.drilldownUrl.replace('\\', '/');
            drilldown.setAttribute("url", this.createRelativePath(this.drilldownUrl));
        }
        if (this.tooltipColumnIndexes != null) {
            Element tooltip = doc.createElement("tooltip");
            root.appendChild(tooltip);
            for (int index : this.tooltipColumnIndexes) {
                Element indexEl = doc.createElement("index");
                indexEl.appendChild(doc.createTextNode(Integer.toString(index)));
                tooltip.appendChild(indexEl);
            }
        }
        if (this.threshold != null) {
            Element thresh = doc.createElement("thresholds");
            root.appendChild(thresh);
            thresh.setAttribute("thresholdColumn", this.thresholdColumn + "");
            thresh.setAttribute("thresholdMode", this.thresholdMode.name());
            thresh.setAttribute("dataType", (this.threshold.length > 0 ? DataType.mapType(DataType.findType(this.threshold[0])) : -1) + "");
            if (this.threshold.length > 0) {
                for (int i = 0; i < this.color.length; ++i) {
                    Element t = doc.createElement("threshold");
                    t.setAttribute("color", this.color[i].getRGB() + "");
                    if (i < this.color.length - 1) {
                        t.setAttribute("value", this.threshold[i].toString());
                    }
                    thresh.appendChild(t);
                }
            }
        }
        if (this.legend != null) {
            this.legend.writeXML(root);
        }
        if (this.title != null) {
            this.title.writeXML(root);
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        xformer.transform(source, result);
    }

    @Override
    public synchronized void refresh() throws Exception {
        this.refresh(false);
    }

    private synchronized void refresh(boolean initializeThresholdColumn) throws Exception {
        String oldThresholdColName = null;
        int origColumnCount = -1;
        this.loadDocument();
        this.dataSheet = this.datasource.getDataSheet(0, -1, this.isAdmin);
        if (this.thresholdColumn != -1 && this.dataSheet != null) {
            oldThresholdColName = this.dataSheet.getFieldNames()[this.thresholdColumn];
            origColumnCount = this.dataSheet.getColumnCount();
        }
        if (initializeThresholdColumn && oldThresholdColName != null && origColumnCount != -1) {
            this.findThresholdColumnInNewData(oldThresholdColName, origColumnCount);
        }
        this.setColors();
        this.setTooltipColumnIndexes(this.getTooltipColumnIndexes());
    }

    public String[] getDrilldownParameterNames() {
        if (this.drilldownUrl == null) {
            return null;
        }
        String[] result = null;
        try {
            if (this.drilldownType.equals("report") || this.drilldownType.equals("easyreport")) {
                QbReport report = new QbReport(null, this.drilldownUrl, true, false, false, true, false);
                Parameters allPromptParams = ParameterGrabber.getParameters(report.getReportObj());
                result = new String[allPromptParams.size()];
                for (int i = 0; i < allPromptParams.size(); ++i) {
                    Param param = allPromptParams.get(i);
                    result[i] = param.name();
                }
            } else if (this.drilldownType.equals("chart")) {
                QbChart chart = new QbChart((Applet)null, this.drilldownUrl, true);
                IInputData inputData = chart.gethInputData();
                IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)inputData.getDatabaseInfo());
                if (queryInfo == null) {
                    return null;
                }
                IQueryInParam[] queryParamSet = quadbase.util.internal.QbUtil.getInParam(queryInfo);
                result = new String[queryParamSet.length];
                for (int i = 0; i < queryParamSet.length; ++i) {
                    result[i] = queryParamSet[i].getParamName();
                }
            } else if (this.drilldownType.equals(MAP_NAME)) {
                QbMap map = QbMap.readMap(this.drilldownUrl);
                if (!map.getDataSource().isParameterized()) {
                    return null;
                }
                ParameterizedDataSource ds = (ParameterizedDataSource)map.getDataSource();
                quadbase.common.util.IQueryInParam[] queryParamSet = ds.getInParam();
                result = new String[queryParamSet.length];
                for (int i = 0; i < queryParamSet.length; ++i) {
                    result[i] = queryParamSet[i].getParamName();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getIdColumn() {
        return this.idColumn;
    }

    public void setIdColumn(int idColumn) {
        this.idColumn = idColumn;
        this.setColors();
    }

    public String getIdColumnName() {
        if (this.dataSheet == null || this.dataSheet.getColumnCount() == 0) {
            return null;
        }
        return this.dataSheet.getFieldNames()[this.idColumn];
    }

    @Override
    public DataSheet getDataSheet() {
        return this.dataSheet;
    }

    @Override
    public DataSource getDataSource() {
        return this.datasource;
    }

    @Override
    public void setDataSource(DataSource newDataSource) throws Exception {
        this.datasource = newDataSource;
        if (this.dataSheet == null) {
            try {
                this.dataSheet = this.datasource.getDataSheet();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.refresh(true);
    }

    @Override
    public void setDataSource(DataSource newDataSource, boolean refresh) throws Exception {
        this.datasource = newDataSource;
        if (refresh) {
            this.refresh(true);
        }
    }

    private void findThresholdColumnInNewData(String oldThresholdColName, int originalColumnCount) {
        if (this.thresholdColumn != -1) {
            int sameNameIndex = -1;
            int firstNumerical = -1;
            for (int i = 0; i < this.dataSheet.getColumnCount(); ++i) {
                if (!DataType.isNumeric(this.dataSheet.getColData()[i].getDataType())) continue;
                if (this.dataSheet.getFieldNames()[i].equals(oldThresholdColName)) {
                    sameNameIndex = i;
                    break;
                }
                if (firstNumerical != -1) continue;
                firstNumerical = i;
            }
            if (sameNameIndex != -1) {
                this.thresholdColumn = sameNameIndex;
            } else if (firstNumerical != -1) {
                this.thresholdColumn = firstNumerical;
            } else {
                this.thresholdColumn = -1;
                this.threshold = null;
                this.setLegend(null);
            }
            if (originalColumnCount > this.dataSheet.getColumnCount()) {
                this.tooltipColumnIndexes = null;
            }
        }
    }

    @Override
    public int getMapWidth() {
        return this.width;
    }

    @Override
    public int getMapHeight() {
        return this.height;
    }

    int getMapImageWidth() {
        return this.mapImageWidth;
    }

    int getMapImageHeight() {
        return this.mapImageHeight;
    }

    public String getDrilldownType() {
        return this.drilldownType;
    }

    public void setDrilldownType(String drilldownType) {
        this.drilldownType = drilldownType;
    }

    public String getDrilldownUrl() {
        return this.drilldownUrl;
    }

    public void setDrilldownUrl(String drilldownUrl) {
        this.drilldownUrl = drilldownUrl;
        this.resetImageMap();
        this.setTooltipColumnIndexes(this.getTooltipColumnIndexes());
    }

    public void removeDrilldown() {
        this.drilldownUrl = null;
    }

    public int getThresholdColumn() {
        return this.thresholdColumn;
    }

    public Color[] getColors() {
        return this.color;
    }

    public Comparable[] getThresholds() {
        return this.threshold;
    }

    public void setImagePath(String imagePath) throws Exception {
        this.mapImagePath = imagePath;
    }

    public String getImagePath() {
        return this.mapImagePath;
    }

    public void resetMapDimensions() {
        this.setMapDimensions(-1, -1);
    }

    @Override
    public void setMapDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.resetImageMap();
    }

    public synchronized void resetColors() {
        for (Map.Entry entry : this.originalColors.entrySet()) {
            SVGGraphicsElement e = (SVGGraphicsElement)entry.getKey();
            String originalColor = (String)entry.getValue();
            if (originalColor == null) {
                CssUtil.removeFill(e);
                continue;
            }
            CssUtil.setFill(e, originalColor);
        }
        this.originalColors.clear();
        this.drilldownObjects.clear();
    }

    private synchronized void setColors() {
        if (this.dataSheet == null) {
            return;
        }
        this.resetColors();
        this.maxVal = this.getMaxForCol(this.thresholdColumn);
        if (this.threshold != null && this.idColumn < this.dataSheet.getColumnCount()) {
            this.triggeredAlertDetails = new HashMap(this.threshold.length + 1);
            for (int i = 0; i < this.dataSheet.getRowCount(); ++i) {
                Object[] row = this.dataSheet.getRow(i);
                if (row.length <= this.thresholdColumn) continue;
                if (this.thresholdMode.equals((Object)ThresholdMode.abs)) {
                    this.setColorForAreaAbs(row[this.idColumn].toString(), (Comparable)row[this.thresholdColumn]);
                } else if (this.thresholdMode.equals((Object)ThresholdMode.per)) {
                    this.setColorForAreaPer(row[this.idColumn].toString(), (Comparable)row[this.thresholdColumn]);
                }
                try {
                    this.setAlertDetails(row);
                    continue;
                }
                catch (ClassCastException e) {
                    LOGGER.log(Level.FINEST, TAG, e);
                    this.threshold = null;
                    this.color = null;
                    this.setLegend(null);
                    break;
                }
            }
        }
        this.resetImageMap();
    }

    private void setColorForAreaAbs(String id, Comparable value) {
        this.setDrillDownAndColorForArea(id, value, this.threshold);
    }

    private void setDrillDownAndColorForArea(String id, Comparable value, Comparable[] threshold) {
        int i;
        if (value == null) {
            return;
        }
        Element tmpE = this.svgDoc.getElementById(id = id.replaceAll(" ", "_"));
        if (tmpE == null || !(tmpE instanceof SVGGraphicsElement)) {
            return;
        }
        SVGGraphicsElement e = (SVGGraphicsElement)tmpE;
        this.drilldownObjects.add(e);
        try {
            for (i = 0; i < threshold.length && threshold[i].compareTo(value) < 0; ++i) {
            }
        }
        catch (ClassCastException e1) {
            LOGGER.log(Level.FINEST, TAG, e1);
            return;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, TAG, ex);
            return;
        }
        if (this.color != null && i < this.color.length) {
            this.setColorForAllChildren(e, this.color[i]);
        }
    }

    private void setColorForAreaPer(String id, Comparable value) {
        Comparable[] thresholdsAbs = new Comparable[this.threshold.length];
        for (int i = 0; i < this.threshold.length; ++i) {
            if (!(this.threshold[i] instanceof Number)) continue;
            BigDecimal currentVal = new BigDecimal(((Number)((Object)this.threshold[i])).doubleValue());
            thresholdsAbs[i] = new BigDecimal(this.maxVal).divide(new BigDecimal(100)).multiply(currentVal);
        }
        this.setDrillDownAndColorForArea(id, new BigDecimal(((Number)((Object)value)).doubleValue()), thresholdsAbs);
    }

    private void setAlertDetails(Object[] row) {
        int i;
        BigDecimal[] curThr;
        BigDecimal value = new BigDecimal(row[this.thresholdColumn].toString());
        if (this.thresholdMode == ThresholdMode.per) {
            BigDecimal[] thresholdsAbs = new BigDecimal[this.threshold.length];
            for (int i2 = 0; i2 < this.threshold.length; ++i2) {
                if (!(this.threshold[i2] instanceof Number)) continue;
                BigDecimal currentVal = new BigDecimal(((Number)((Object)this.threshold[i2])).doubleValue());
                thresholdsAbs[i2] = new BigDecimal(this.maxVal).divide(new BigDecimal(100)).multiply(currentVal);
            }
            curThr = thresholdsAbs;
        } else {
            curThr = new BigDecimal[this.threshold.length];
            for (int i3 = 0; i3 < this.threshold.length; ++i3) {
                curThr[i3] = new BigDecimal(this.threshold[i3].toString());
            }
        }
        for (i = 0; i < curThr.length && curThr[i].compareTo(value) < 0; ++i) {
        }
        String alertId = this.getAlertId(i);
        if (alertId == null) {
            return;
        }
        if (!this.triggeredAlertDetails.containsKey(alertId)) {
            this.triggeredAlertDetails.put(alertId, new Vector());
        }
        Vector v = (Vector)this.triggeredAlertDetails.get(alertId);
        String[] fieldNames = this.dataSheet.getFieldNames();
        StringBuffer details = new StringBuffer();
        for (int j = 0; j < fieldNames.length; ++j) {
            details.append("(" + fieldNames[j] + ") " + row[j]);
            if (j == fieldNames.length - 1) continue;
            details.append(" ");
        }
        v.add(details.toString());
    }

    private void setColorForAllChildren(SVGGraphicsElement e, Color c) {
        if (e instanceof SVGOMGElement) {
            NodeList children = e.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (!(n instanceof SVGGraphicsElement)) continue;
                this.setColorForAllChildren((SVGGraphicsElement)n, c);
            }
        } else {
            if (!this.originalColors.containsKey(e)) {
                this.originalColors.put(e, CssUtil.getFill(e));
            }
            CssUtil.setFill(e, CssUtil.toCssColor(c));
        }
    }

    private void readMapSize() {
        if (this.height == -1 || this.width == -1 || this.mapImageHeight == -1 || this.mapImageWidth == -1) {
            try {
                SVGSizeGetter sizeGetter = new SVGSizeGetter(this);
                if (this.height == -1) {
                    this.height = (int)sizeGetter.getHeight();
                }
                if (this.width == -1) {
                    this.width = (int)sizeGetter.getWidth();
                }
                this.checkMaxSize();
                this.mapImageHeight = (int)sizeGetter.getMapImageHeight();
                this.mapImageWidth = (int)sizeGetter.getMapImageWidth();
            }
            catch (TranscoderException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkMaxSize() {
        if (this.height > 1000 || this.width > 1000) {
            double ratio = 1000.0 / (double)Math.max(this.height, this.width);
            this.height = (int)Math.floor((double)this.height * ratio);
            this.width = (int)Math.floor((double)this.width * ratio);
        }
    }

    private void resetImageMap() {
        this.imageMap = null;
        this.readMapSize();
    }

    private String createImageMap() {
        ImageMapTranscoder transcoder = new ImageMapTranscoder(MAP_NAME, this, this.drilldownObjects);
        if (this.height != -1) {
            transcoder.addTranscodingHint(ImageMapTranscoder.KEY_HEIGHT, Float.valueOf(this.height));
        }
        if (this.width != -1) {
            transcoder.addTranscodingHint(ImageMapTranscoder.KEY_WIDTH, Float.valueOf(this.width));
        }
        transcoder.addTranscodingHint(ImageMapTranscoder.KEY_MAINTAIN_ASPECT_RATIO, Boolean.FALSE);
        TranscoderInput input = new TranscoderInput(this.svgDoc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)os);
        try {
            transcoder.transcode(input, output);
            int newMapImageHeight = (int)transcoder.getMapImageHeight();
            int newMapImageWidth = (int)transcoder.getMapImageWidth();
            if (newMapImageHeight != this.mapImageHeight || newMapImageWidth != this.mapImageWidth) {
                this.mapImageHeight = newMapImageHeight;
                this.mapImageWidth = newMapImageWidth;
                os = new ByteArrayOutputStream();
                output = new TranscoderOutput((OutputStream)os);
                transcoder.transcode(input, output);
                this.mapImageHeight = (int)transcoder.getMapImageHeight();
                this.mapImageWidth = (int)transcoder.getMapImageWidth();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return os.toString();
    }

    private void loadDocument() throws Exception {
        try {
            Class.forName("org.apache.batik.dom.svg.SAXSVGDocumentFactory");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        String imagePath = this.createImagePath();
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        String uri = new File(imagePath).toURI().toString();
        this.svgDoc = f.createDocument(uri, (InputStream)new ReadDataFile().getInputStream(imagePath));
        SVGSVGElement re = ((SVGDocument)this.svgDoc).getRootElement();
        re.setAttribute("preserveAspectRatio", "none");
        if (LCKey.isDownload()) {
            float y;
            SVGLength h = re.getHeight().getBaseVal();
            try {
                h.convertToSpecifiedUnits((short)5);
                y = h.getValue() - 10.0f;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, "Failed to get map height, using 0.", e);
                y = 0.0f;
            }
            SVGOMTextElement eval = new SVGOMTextElement(null, (AbstractDocument)this.svgDoc);
            String randomColor = CssUtil.toCssColor(new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)));
            eval.setAttribute("style", "font-size:16px;font-weight:bold;fill:" + randomColor);
            eval.setAttribute("x", "10");
            eval.setAttribute("y", y + "");
            eval.appendChild((Node)this.svgDoc.createTextNode("Evaluation copy by Quadbase Systems Inc. Please contact sales@quadbase.com for purchasing information."));
            re.appendChild((Node)eval);
        }
    }

    private String createImagePath() {
        quadbase.common.util.IQueryInParam[] inParams;
        if (!this.datasource.isParameterized() || this.mapImageIdParameterName == null) {
            return this.mapImagePath;
        }
        ParameterizedDataSource parameterizedDataSource = (ParameterizedDataSource)this.datasource;
        for (quadbase.common.util.IQueryInParam inParam : inParams = parameterizedDataSource.getInParam()) {
            if (!inParam.getParamName().equals(this.mapImageIdParameterName)) continue;
            String filePathWithoutExtension = QbUtil.getFilePathWithoutExtension(this.mapImagePath);
            int idx = filePathWithoutExtension.lastIndexOf(95);
            if (idx > 0 && QbUtil.getFileNameWithoutExtension(this.mapImagePath).contains("_")) {
                filePathWithoutExtension = filePathWithoutExtension.substring(0, idx);
            }
            String imagePath = filePathWithoutExtension + "_" + inParam.getValue() + "." + QbUtil.getExtension(this.mapImagePath);
            try {
                if (!new FileInfo(imagePath).exists()) continue;
                return imagePath;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "File exist check failed", e);
            }
        }
        return this.mapImagePath;
    }

    protected AffineTransform getAdditionalTransform(float aspectRatio) {
        SvgResizableCanvas rc = new SvgResizableCanvas();
        if (this.legend != null) {
            this.legend.computePosition();
            rc.add(this.legend.getResizableCanvas());
        }
        if (this.title != null) {
            this.title.computePosition();
            rc.add(this.title.getResizableCanvas());
        }
        return rc.getTransform(this.width, this.height, aspectRatio);
    }

    protected void drawAdditionalGraphics(Graphics2D graphics2d) {
        if (this.legend != null && this.legend.canDisplay() && this.title != null && this.title.canDisplay()) {
            if (this.legend.getPosition() == 0) {
                this.title.x += this.legend.width + 10.0f + 10.0f;
            } else if (this.legend.getPosition() == 2 || this.legend.getPosition() == 3) {
                if (this.title.getPosition() == 0) {
                    this.legend.y += this.title.height + 20.0f;
                } else {
                    this.title.y += this.legend.height + 20.0f;
                }
            }
        }
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.title != null) {
            this.title.drawTitle(graphics2d);
        }
        if (this.legend != null) {
            this.legend.drawLegend(graphics2d);
        }
    }

    public void setLegend(SvgLegend legend) {
        this.legend = legend;
        this.resetImageMap();
    }

    public SvgLegend getLegend() {
        return this.legend;
    }

    public void setTitle(MapTitle title) {
        this.title = title == null ? null : new SvgMapTitle(this, title);
        this.resetImageMap();
    }

    public MapTitle getTitle() {
        return this.title;
    }

    @Override
    public String[] getAllAlertIds() {
        if (this.threshold == null || this.threshold.length == 0) {
            return null;
        }
        String[] result = new String[this.threshold.length + 1];
        result[0] = "<" + this.threshold[0];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getAlertId(i);
        }
        return result;
    }

    @Override
    public String[] getTriggeredAlertIds() {
        if (this.triggeredAlertDetails == null || this.triggeredAlertDetails.size() == 0) {
            return null;
        }
        Set objs = this.triggeredAlertDetails.keySet();
        return objs.toArray(new String[objs.size()]);
    }

    public Map getTriggeredAlertDetails() {
        return this.triggeredAlertDetails;
    }

    private String getAlertId(int index) {
        if (this.threshold.length == 0) {
            return null;
        }
        if (index == 0) {
            return "<" + this.threshold[0];
        }
        if (index == this.threshold.length) {
            return ">" + this.threshold[this.threshold.length - 1];
        }
        return this.threshold[index - 1] + "-" + this.threshold[index];
    }

    public void setTooltipColumnIndexes(int[] indexes) {
        this.tooltipColumnIndexes = indexes;
        if (this.dataSheet != null && this.idColumn != -1 && this.drilldownObjects.isEmpty()) {
            Object[] row;
            for (int i = 0; i < this.dataSheet.getRowCount() && this.idColumn < (row = this.dataSheet.getRow(i)).length; ++i) {
                String id = row[this.idColumn].toString();
                Element tmpE = this.svgDoc.getElementById(id = id.replaceAll(" ", "_"));
                if (tmpE == null || !(tmpE instanceof SVGGraphicsElement)) continue;
                SVGGraphicsElement e = (SVGGraphicsElement)tmpE;
                this.drilldownObjects.add(e);
            }
        }
        this.createImageMap();
    }

    public int[] getTooltipColumnIndexes() {
        return this.tooltipColumnIndexes;
    }

    public ThresholdMode getThresholdMode() {
        return this.thresholdMode;
    }

    public void setThresholdMode(ThresholdMode thresholdMode) {
        this.thresholdMode = thresholdMode;
    }

    public static ThresholdMode getThresholdModeFromStr(String thresholdMode) {
        if (thresholdMode == null) {
            return ThresholdMode.abs;
        }
        if (thresholdMode.equals("")) {
            return ThresholdMode.abs;
        }
        return ThresholdMode.valueOf(thresholdMode);
    }

    public String getThresholdModeStr() {
        return this.thresholdMode == null ? null : this.thresholdMode.name();
    }

    public String getMapImageIdParameterName() {
        return this.mapImageIdParameterName;
    }

    public void setMapImageIdParameterName(String mapImageIdParameterName) {
        this.mapImageIdParameterName = mapImageIdParameterName;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public static enum ThresholdMode {
        abs,
        per;

    }
}

