/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.svgmaps;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import org.apache.batik.svggen.SVGGraphics2D;
import quadbase.common.util.internal.CssUtil;
import quadbase.maps.MapTitle;
import quadbase.maps.svgmaps.SvgMap;
import quadbase.maps.svgmaps.SvgResizableCanvas;

public class SvgMapTitle
extends MapTitle {
    protected static final float PADDING = 10.0f;
    private SvgMap svgMap;
    private Font titleFont;
    private SvgResizableCanvas resizableCanvas = new SvgResizableCanvas();
    protected float x = -1.0f;
    protected float y = -1.0f;
    protected float width = -1.0f;
    protected float height = -1.0f;

    public SvgMapTitle(SvgMap svgMap, String text, String font, int fontStyle, int fontSize, short alignment, short position, String color) {
        super(text, font, fontStyle, fontSize, alignment, position, color);
        this.titleFont = this.createFont();
        this.svgMap = svgMap;
    }

    public SvgMapTitle(SvgMap svgMap, MapTitle mapTitle) {
        super(mapTitle);
        this.titleFont = this.createFont();
        this.svgMap = svgMap;
    }

    public void drawTitle(Graphics2D g2d) {
        if (!this.canDisplay()) {
            return;
        }
        g2d.setFont(this.titleFont);
        g2d.setPaint(CssUtil.toAwtColor(this.color));
        g2d.drawString(this.text, this.x, this.y);
    }

    public boolean computePosition() {
        SVGGraphics2D g = new SVGGraphics2D(this.svgMap.svgDoc);
        FontMetrics fm = g.getFontMetrics(this.titleFont);
        this.width = fm.stringWidth(this.text);
        this.height = fm.getMaxAscent() + fm.getMaxDescent();
        if (!this.willFit(this.width, this.height)) {
            this.width = -1.0f;
            this.height = -1.0f;
            this.x = -1.0f;
            this.y = -1.0f;
            this.resizableCanvas.setResize(0.0f, 0.0f, 0.0f, 0.0f);
            return false;
        }
        this.x = this.alignment == 0 ? 10.0f : (this.alignment == 1 ? ((float)this.svgMap.getMapImageWidth() > this.width + 10.0f ? (float)this.svgMap.getMapImageWidth() - 10.0f - this.width : 10.0f) : ((float)this.svgMap.getMapImageWidth() > this.width ? ((float)this.svgMap.getMapImageWidth() - this.width) / 2.0f : 10.0f));
        if (this.position == 1) {
            this.y = (float)this.svgMap.getMapImageHeight() + 10.0f + (float)fm.getMaxAscent();
            this.resizableCanvas.setResize(0.0f, 0.0f, 0.0f, 20.0f + this.height);
        } else {
            this.y = 10.0f + (float)fm.getMaxAscent();
            this.resizableCanvas.setResize(0.0f, 0.0f, 20.0f + this.height, 0.0f);
        }
        return true;
    }

    private boolean willFit(float w, float h) {
        return !(w > (float)this.svgMap.getMapWidth() - 20.0f) && !(h > (float)(this.svgMap.getMapHeight() / 3));
    }

    public SvgResizableCanvas getResizableCanvas() {
        return this.resizableCanvas;
    }

    protected boolean canDisplay() {
        return this.x != -1.0f && this.y != -1.0f && this.height != -1.0f && this.width != -1.0f;
    }

    private Font createFont() {
        return new Font(this.font, this.fontStyle, this.fontSize);
    }
}

